/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.IDRef;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.TimeCondition;
import com.sun.perseus.model.TimedElementNode;
import org.w3c.dom.DOMException;

public class Discard
extends TimedElementNode
implements IDRef {
    protected ElementNode targetElement;
    protected String idRef;

    public Discard(DocumentNode doc) {
        super(doc, "discard");
        if (!this.ownerDocument.loaded) {
            this.ownerDocument.timedElementNodes.addElement(this);
        }
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Discard(doc);
    }

    public String getIdRef() {
        return this.idRef;
    }

    public void resolveTo(ElementNode ref) {
        this.targetElement = ref;
    }

    public void setIdRef(String idRef) {
        this.idRef = idRef;
        this.ownerDocument.resolveIDRef(this, idRef);
    }

    boolean supportsTrait(String traitName) {
        if ("begin" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("begin" == name) {
            if (this.timedElementSupport.beginConditions.size() == 0) {
                return "0s";
            }
            return TimeCondition.toStringTrait(this.timedElementSupport.beginConditions);
        }
        return super.getTraitImpl(name);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("begin" == name) {
            this.checkWriteLoading(name);
            this.timedElementSupport.beginConditions.removeAllElements();
            this.parseTimeConditionsTrait(name, value, true);
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public String getTraitNSImpl(String namespaceURI, String name) throws DOMException {
        if ("http://www.w3.org/1999/xlink".equals(namespaceURI) && "href".equals(name)) {
            if (this.idRef == null) {
                return "";
            }
            return "#" + this.idRef;
        }
        return super.getTraitNSImpl(namespaceURI, name);
    }

    public void setTraitNSImpl(String namespaceURI, String name, String value) throws DOMException {
        if ("http://www.w3.org/1999/xlink".equals(namespaceURI) && "href".equals(name)) {
            if (value == null || !value.startsWith("#")) {
                throw this.illegalTraitValue(name, value);
            }
            this.setIdRef(value.substring(1));
        } else {
            super.setTraitNSImpl(namespaceURI, name, value);
        }
    }

    protected boolean supportsTraitNS(String namespaceURI, String traitName) {
        if ("http://www.w3.org/1999/xlink".equals(namespaceURI) && "href".equals(traitName)) {
            return true;
        }
        return super.supportsTraitNS(namespaceURI, traitName);
    }

    void validate() throws DOMException {
        if (this.targetElement == null) {
            this.targetElement = (ElementNode)this.parent;
        }
    }

    final void nodeHookedInDocumentTree() {
        super.nodeHookedInDocumentTree();
        if (this.ownerDocument.loaded) {
            this.validate();
        }
    }

    final void nodeUnhookedFromDocumentTree() {
        super.nodeUnhookedFromDocumentTree();
        if (!this.ownerDocument.applyAnimationsCalled) {
            this.ownerDocument.elementsToDiscard.remove(this.targetElement);
            this.ownerDocument.elementsToDiscard.remove(this);
        }
    }

    public void dispatchEvent(ModelEvent evt) {
        super.dispatchEvent(evt);
        if (this.targetElement != null && ("beginEvent".equals(evt.getType()) || "seekBeginEvent".equals(evt.getType()))) {
            this.ownerDocument.elementsToDiscard.addElement(this.targetElement);
        }
        this.ownerDocument.elementsToDiscard.addElement(this);
    }
}

