/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.Segment;
import com.sun.perseus.model.StringSegment;

public class StringRefValues
implements RefValues {
    StringSegment[] segments;
    float[] length;

    public Segment getSegment(int i) {
        return this.segments[i];
    }

    public int getSegments() {
        return this.segments.length;
    }

    public int getComponents() {
        return this.segments[0].start.length;
    }

    public Object[] compute(int si, float p) {
        return this.segments[si].compute(p);
    }

    public void makeDiscrete() {
        StringSegment[] tmpSegments = new StringSegment[this.segments.length + 1];
        System.arraycopy(this.segments, 0, tmpSegments, 0, this.segments.length);
        StringSegment lastSeg = this.segments[this.segments.length - 1];
        StringSegment newSeg = new StringSegment();
        newSeg.start = lastSeg.end;
        newSeg.end = lastSeg.end;
        tmpSegments[tmpSegments.length - 1] = newSeg;
        this.segments = tmpSegments;
    }

    public float getLength() {
        return this.segments.length;
    }

    public float getLength(int si) {
        return 1.0f;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StringRefValues[" + this.getSegments() + "]\n");
        for (int si = 0; si < this.getSegments(); ++si) {
            Segment seg = this.getSegment(si);
            sb.append("seg[" + si + "] : " + seg.toString() + "\n");
        }
        return sb.toString();
    }

    public void initialize() {
        int ns = this.segments.length;
        this.length = new float[this.segments[0].start.length];
        for (int ci = 0; ci < this.length.length; ++ci) {
            this.length[ci] = this.segments.length;
        }
    }
}

