/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.GradientColorMap;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class RadialGradientPaintContext
implements PaintContext {
    ColorModel cm = ColorModel.getRGBdefault();
    WritableRaster raster;
    AffineTransform transform;
    AffineTransform inverse;
    float cx;
    float cy;
    float fx;
    float fy;
    float r;
    float rsq;
    GradientColorMap map;

    public RadialGradientPaintContext(float f, float f2, float f3, float f4, float f5, GradientColorMap gradientColorMap, AffineTransform affineTransform) {
        this.cx = f;
        this.cy = f2;
        this.fx = f3;
        this.fy = f4;
        this.r = f5;
        this.rsq = f5 * f5;
        this.map = gradientColorMap;
        float f6 = this.fx - this.cx;
        float f7 = this.fy - this.cy;
        float f8 = (float)Math.sqrt(f6 * f6 + f7 * f7);
        if (f8 > f5 * 0.97f) {
            float f9 = f5 * 0.97f / f8;
            this.fx = this.cx + f9 * f6;
            this.fy = this.cy + f9 * f7;
        }
        this.transform = affineTransform;
        try {
            this.inverse = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.inverse = new AffineTransform();
        }
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        Object object;
        n3 = Math.max(n3, 1);
        n4 = Math.max(n4, 1);
        if (this.raster == null || this.raster.getWidth() < n3 || this.raster.getHeight() < n4) {
            object = new BufferedImage(n3, n4, 2);
            this.raster = ((BufferedImage)object).getRaster();
        }
        object = (DataBufferInt)this.raster.getDataBuffer();
        int[] nArray = ((DataBufferInt)object).getBankData()[0];
        int n5 = ((DataBuffer)object).getOffset();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.raster.getSampleModel();
        int n6 = singlePixelPackedSampleModel.getScanlineStride();
        float f = (float)this.inverse.getScaleX();
        float f2 = (float)this.inverse.getShearX();
        float f3 = (float)this.inverse.getTranslateX();
        float f4 = (float)this.inverse.getShearY();
        float f5 = (float)this.inverse.getScaleY();
        float f6 = (float)this.inverse.getTranslateY();
        for (int i = 0; i < n4; ++i) {
            double d = (float)n * f + (float)(n2 + i) * f2 + f3;
            double d2 = (float)n * f4 + (float)(n2 + i) * f5 + f6;
            double d3 = (double)this.fx - d;
            double d4 = (double)this.fy - d2;
            double d5 = d3 * d3 + d4 * d4;
            double d6 = this.cx - this.fx;
            double d7 = this.cy - this.fy;
            double d8 = 2.0 * (d6 * d3 + d7 * d4);
            double d9 = d6 * d6 + d7 * d7 - (double)this.rsq;
            double d10 = d9 * d9;
            double d11 = -d8 / (2.0 * d9);
            double d12 = ((double)f * d6 + (double)f4 * d7) / d9;
            double d13 = (d8 * d8 - 4.0 * d5 * d9) / (4.0 * d10);
            double d14 = ((double)(2.0f * f * f4) * d6 * d7 + (double)f * ((double)f * (d6 * d6 - d9) - d8 * d6 + 2.0 * d9 * d3) + (double)f4 * ((double)f4 * (d7 * d7 - d9) - d8 * d7 + 2.0 * d9 * d4)) / d10;
            double d15 = (double)f4 * d6 - (double)f * d7;
            double d16 = 2.0 * ((double)((f * f + f4 * f4) * this.rsq) - d15 * d15) / d10;
            int n7 = n5 + i * n6;
            for (int j = 0; j < n3; ++j) {
                double d17 = d11 + Math.sqrt(d13);
                d11 += d12;
                d13 += d14;
                d14 += d16;
                nArray[n7++] = this.map.getColor((int)(d17 * 65536.0));
            }
        }
        return this.raster.createChild(0, 0, n3, n4, n, n2, null);
    }
}

