/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DetailPanel
implements WizardDescriptor.Panel {
    private boolean valid;
    private EventListenerList listenerList;
    private DatabaseConnection connection;
    private String masterTable;
    private List masterColumns;
    private ImageIcon fieldsIcon;
    private ImageIcon tableIcon;
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableLabel;
    private JList availableList;
    private JScrollPane availablePane;
    private ButtonGroup buttonGroup;
    private JLabel detailLabel;
    private JButton downButton;
    private JRadioButton fieldsChoice;
    private JLabel includeLabel;
    private JList includeList;
    private JScrollPane includePane;
    private JPanel masterPanel;
    private JLabel previewLabel;
    private JButton removeAllButton;
    private JButton removeButton;
    private JRadioButton tableChoice;
    private JComboBox tableCombo;
    private JButton upButton;
    private boolean defaultPreselect = true;

    private void initGUI() {
        this.initComponents();
        this.initLists();
        this.fieldsIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/md_fields.gif"));
        this.tableIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/md_table.gif"));
        this.previewLabel.setIcon(this.fieldsIcon);
    }

    private void initLists() {
        this.availableList.setModel(new DefaultListModel());
        this.includeList.setModel(new DefaultListModel());
        ListDataListener listDataListener = new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                this.contentsChanged(listDataEvent);
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.contentsChanged(listDataEvent);
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                Object object = listDataEvent.getSource();
                if (object == DetailPanel.this.availableList.getModel()) {
                    DetailPanel.this.addAllButton.setEnabled(DetailPanel.this.availableList.getModel().getSize() != 0);
                } else if (object == DetailPanel.this.includeList.getModel()) {
                    boolean bl = DetailPanel.this.includeList.getModel().getSize() == 0;
                    DetailPanel.this.removeAllButton.setEnabled(!bl);
                    DetailPanel.this.setValid(!bl);
                }
            }
        };
        this.availableList.getModel().addListDataListener(listDataListener);
        this.includeList.getModel().addListDataListener(listDataListener);
    }

    private void fillTableCombo() {
        boolean bl;
        Connection connection = this.connection.getJDBCConnection();
        try {
            DefaultComboBoxModel<ForeignKey> defaultComboBoxModel = new DefaultComboBoxModel<ForeignKey>();
            ResultSet resultSet = connection.getMetaData().getExportedKeys(connection.getCatalog(), this.connection.getSchema(), this.masterTable);
            while (resultSet.next()) {
                String string = resultSet.getString("FKTABLE_NAME");
                boolean bl2 = J2EEUtils.hasPrimaryKey(this.connection, string);
                ForeignKey foreignKey = new ForeignKey(resultSet.getString("PKTABLE_NAME"), resultSet.getString("PKCOLUMN_NAME"), string, resultSet.getString("FKCOLUMN_NAME"), bl2);
                defaultComboBoxModel.addElement(foreignKey);
            }
            this.tableCombo.setModel(defaultComboBoxModel);
            resultSet.close();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
        }
        boolean bl3 = bl = this.tableCombo.getModel().getSize() == 0;
        if (bl) {
            this.fieldsChoice.setSelected(true);
            this.tableCombo.setEnabled(false);
            this.availableLabel.setText(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailableFields"));
            this.includeLabel.setText(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailFieldsToInclude"));
            this.previewLabel.setIcon(this.fieldsIcon);
        }
        this.tableChoice.setEnabled(!bl);
        this.refreshLists();
    }

    private void refreshLists() {
        if (this.tableChoice.isSelected()) {
            this.tableCombo.setSelectedItem(this.tableCombo.getSelectedItem());
        } else {
            this.fillLists(this.masterTable);
        }
    }

    private void initComponents() {
        this.masterPanel = new JPanel();
        this.availableLabel = new JLabel();
        this.availablePane = new JScrollPane();
        this.availableList = new JList();
        this.addAllButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.includePane = new JScrollPane();
        this.includeList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.includeLabel = new JLabel();
        this.detailLabel = new JLabel();
        this.fieldsChoice = new JRadioButton();
        this.tableChoice = new JRadioButton();
        this.tableCombo = new JComboBox();
        this.previewLabel = new JLabel();
        this.buttonGroup = new ButtonGroup();
        FormListener formListener = new FormListener();
        this.masterPanel.setName(NbBundle.getMessage(DetailPanel.class, (String)"TITLE_DetailPanel"));
        this.availableLabel.setLabelFor(this.availableList);
        Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailableFields"));
        this.availableList.addListSelectionListener(formListener);
        this.availablePane.setViewportView(this.availableList);
        this.availableList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailable_ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAddAll"));
        this.addAllButton.setEnabled(false);
        this.addAllButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAdd"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailRemove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailRemoveAll"));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(formListener);
        this.includeList.addListSelectionListener(formListener);
        this.includePane.setViewportView(this.includeList);
        this.includeList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailToInclude_ACSD"));
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/up.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailUp"));
        this.upButton.setEnabled(false);
        this.upButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.upButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.upButton.addActionListener(formListener);
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/down.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailDown"));
        this.downButton.setEnabled(false);
        this.downButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.downButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.downButton.addActionListener(formListener);
        this.includeLabel.setLabelFor(this.includeList);
        Mnemonics.setLocalizedText((JLabel)this.includeLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailFieldsToInclude"));
        Mnemonics.setLocalizedText((JLabel)this.detailLabel, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailType"));
        this.buttonGroup.add(this.fieldsChoice);
        this.fieldsChoice.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.fieldsChoice, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTextfields"));
        this.fieldsChoice.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fieldsChoice.setMargin(new Insets(0, 0, 0, 0));
        this.fieldsChoice.addActionListener(formListener);
        this.buttonGroup.add(this.tableChoice);
        Mnemonics.setLocalizedText((AbstractButton)this.tableChoice, (String)NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTable"));
        this.tableChoice.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableChoice.setMargin(new Insets(0, 0, 0, 0));
        this.tableChoice.addActionListener(formListener);
        this.tableCombo.setEnabled(false);
        this.tableCombo.setRenderer(new ForeignKeyRenderer());
        this.tableCombo.addActionListener(formListener);
        GroupLayout groupLayout = new GroupLayout((Container)this.masterPanel);
        this.masterPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.availablePane, -1, 170, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.addButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeAllButton, -1, -1, Short.MAX_VALUE).add((Component)this.addAllButton, -1, -1, Short.MAX_VALUE))).add((Component)this.availableLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.includeLabel).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.includePane, -1, 170, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.upButton, -1, -1, Short.MAX_VALUE).add((Component)this.downButton, -1, -1, Short.MAX_VALUE))))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.detailLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tableChoice).addPreferredGap(0).add((Component)this.tableCombo, 0, 311, Short.MAX_VALUE)).add((Component)this.fieldsChoice)))).add(10, 10, 10).add((Component)this.previewLabel, -2, 80, -2))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addAllButton, this.addButton, this.downButton, this.removeAllButton, this.removeButton, this.upButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.detailLabel).addPreferredGap(0).add((Component)this.fieldsChoice).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tableChoice).add((Component)this.tableCombo, -2, -1, -2))).add((Component)this.previewLabel, -2, 60, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.availableLabel).add((Component)this.includeLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.includePane, 0, 0, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, 18, Short.MAX_VALUE).add((Component)this.addButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.addAllButton).add((Component)this.upButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.removeButton).add((Component)this.downButton)).addPreferredGap(0).add((Component)this.removeAllButton).addPreferredGap(0, 19, Short.MAX_VALUE)).add((Component)this.availablePane, -1, 147, Short.MAX_VALUE)).addContainerGap()));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAddAll_ACSD"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAdd_ACSD"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailRemove_ACSD"));
        this.removeAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailRemoveAll_ACSD"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailUp_ACSD"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailDown_ACSD"));
        this.fieldsChoice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTextfields_ACSD"));
        this.tableChoice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTable_ACSD"));
        this.tableCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTable_ACSN"));
        this.tableCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailTable_ACSD"));
        this.masterPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetailPanel.class, (String)"TITLE_DetailPanel"));
    }

    private void tableComboActionPerformed(ActionEvent actionEvent) {
        ForeignKey foreignKey = this.getForeignKey();
        this.fillLists(foreignKey.isValid() ? this.getForeignKey().getFKTable() : null);
    }

    private void tableChoiceActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.tableChoice.isSelected();
        this.tableCombo.setEnabled(bl);
        if (bl) {
            this.availableLabel.setText(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailableColumns"));
            this.includeLabel.setText(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailColumnsToInclude"));
            ForeignKey foreignKey = this.getForeignKey();
            this.fillLists(foreignKey.isValid() ? this.getForeignKey().getFKTable() : null);
            this.previewLabel.setIcon(this.tableIcon);
        }
    }

    private void fieldsChoiceActionPerformed(ActionEvent actionEvent) {
        if (this.fieldsChoice.isSelected()) {
            this.tableCombo.setEnabled(false);
            this.availableLabel.setText(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailAvailableFields"));
            this.includeLabel.setText(NbBundle.getMessage(DetailPanel.class, (String)"LBL_DetailFieldsToInclude"));
            this.fillLists(this.masterTable);
            this.previewLabel.setIcon(this.fieldsIcon);
        }
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.includeList.getModel();
        int n = this.includeList.getSelectedIndex();
        Object e = defaultListModel.remove(n);
        defaultListModel.add(n + 1, e);
        this.includeList.setSelectedIndex(n + 1);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.includeList.getModel();
        int n = this.includeList.getSelectedIndex();
        Object e = defaultListModel.remove(n);
        defaultListModel.add(n - 1, e);
        this.includeList.setSelectedIndex(n - 1);
    }

    private void removeAllButtonActionPerformed(ActionEvent actionEvent) {
        DetailPanel.moveListItems(this.includeList, this.availableList, false);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        DetailPanel.moveListItems(this.includeList, this.availableList, true);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        DetailPanel.moveListItems(this.availableList, this.includeList, true);
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        DetailPanel.moveListItems(this.availableList, this.includeList, false);
    }

    private void includeListValueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.includeList.getSelectedIndices();
        boolean bl = nArray.length == 1;
        this.upButton.setEnabled(bl && nArray[0] != 0);
        this.downButton.setEnabled(bl && nArray[0] != this.includeList.getModel().getSize() - 1);
        boolean bl2 = nArray.length > 0;
        this.removeButton.setEnabled(bl2);
        if (bl2) {
            this.availableList.clearSelection();
        }
    }

    private void availableListValueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.availableList.getSelectedIndex() != -1;
        this.addButton.setEnabled(bl);
        if (bl) {
            this.includeList.clearSelection();
        }
    }

    private void fillLists(String string) {
        Connection connection = this.connection.getJDBCConnection();
        try {
            DefaultListModel defaultListModel = (DefaultListModel)this.availableList.getModel();
            defaultListModel.clear();
            defaultListModel = (DefaultListModel)this.includeList.getModel();
            defaultListModel.clear();
            if (string != null) {
                Object object;
                ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), this.connection.getSchema(), string, "%");
                while (resultSet.next()) {
                    object = resultSet.getString("COLUMN_NAME");
                    defaultListModel.addElement(object);
                }
                resultSet.close();
                if (this.defaultPreselect) {
                    if (this.masterTable.equals(string)) {
                        this.preSelectColumns(this.masterColumns);
                    } else {
                        object = this.getForeignKey();
                        if (object != null) {
                            this.includeList.setSelectedValue(((ForeignKey)object).getFKColumn(), false);
                            DetailPanel.moveListItems(this.includeList, this.availableList, true);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
        }
    }

    private void preSelectColumns(List list) {
        DefaultListModel defaultListModel = (DefaultListModel)this.availableList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.includeList.getModel();
        for (int i = defaultListModel2.getSize() - 1; i >= 0; --i) {
            String string = (String)defaultListModel2.getElementAt(i);
            if (list.contains(string)) continue;
            defaultListModel2.removeElementAt(i);
            defaultListModel.add(0, string);
        }
    }

    private ForeignKey getForeignKey() {
        return this.tableChoice.isSelected() ? (ForeignKey)this.tableCombo.getSelectedItem() : null;
    }

    private List getSelectedColumns() {
        DefaultListModel defaultListModel = (DefaultListModel)this.includeList.getModel();
        return Arrays.asList(defaultListModel.toArray());
    }

    private static void moveListItems(JList jList, JList jList2, boolean bl) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)jList2.getModel();
        if (bl) {
            int n;
            int[] nArray = jList.getSelectedIndices();
            for (n = 0; n < nArray.length; ++n) {
                Object e = defaultListModel.getElementAt(nArray[n]);
                defaultListModel2.addElement(e);
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                defaultListModel.removeElementAt(nArray[n]);
            }
        } else {
            Enumeration enumeration = defaultListModel.elements();
            while (enumeration.hasMoreElements()) {
                defaultListModel2.addElement(enumeration.nextElement());
            }
            defaultListModel.clear();
        }
    }

    public Component getComponent() {
        if (this.masterPanel == null) {
            this.initGUI();
        }
        return this.masterPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.form.j2ee.wizard.DetailPanel");
    }

    public void readSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        this.connection = (DatabaseConnection)wizardDescriptor.getProperty("connection");
        this.masterTable = (String)wizardDescriptor.getProperty("master");
        this.masterColumns = (List)wizardDescriptor.getProperty("masterColumns");
        ForeignKey foreignKey = this.getForeignKey();
        List list = (List)wizardDescriptor.getProperty("detailColumns");
        if (foreignKey == null) {
            String string = (String)wizardDescriptor.getProperty("detailTable");
            if (this.masterTable.equals(string) && list != null) {
                this.defaultPreselect = false;
            }
        } else {
            String string = (String)wizardDescriptor.getProperty("detailPKTable");
            String string2 = (String)wizardDescriptor.getProperty("detailPKColumn");
            String string3 = (String)wizardDescriptor.getProperty("detailFKTable");
            String string4 = (String)wizardDescriptor.getProperty("detailFKColumn");
            if (foreignKey.getPKTable().equals(string) && foreignKey.getPKColumn().equals(string2) && foreignKey.getFKTable().equals(string3) && foreignKey.getFKColumn().equals(string4)) {
                this.defaultPreselect = false;
            }
        }
        this.fillTableCombo();
        if (!this.defaultPreselect) {
            this.preSelectColumns(list);
            this.defaultPreselect = true;
        }
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        ForeignKey foreignKey = this.getForeignKey();
        wizardDescriptor.putProperty("detailTable", (Object)(foreignKey == null ? this.masterTable : null));
        wizardDescriptor.putProperty("detailPKTable", (Object)(foreignKey == null ? null : foreignKey.getPKTable()));
        wizardDescriptor.putProperty("detailPKColumn", (Object)(foreignKey == null ? null : foreignKey.getPKColumn()));
        wizardDescriptor.putProperty("detailFKTable", (Object)(foreignKey == null ? null : foreignKey.getFKTable()));
        wizardDescriptor.putProperty("detailFKColumn", (Object)(foreignKey == null ? null : foreignKey.getFKColumn()));
        wizardDescriptor.putProperty("detailColumns", (Object)this.getSelectedColumns());
    }

    public boolean isValid() {
        return this.valid;
    }

    void setValid(boolean bl) {
        if (bl == this.valid) {
            return;
        }
        this.valid = bl;
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }
    }

    private void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        ChangeListener[] changeListenerArray = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = changeListenerArray.length - 1; i >= 0; --i) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            changeListenerArray[i].stateChanged(changeEvent);
        }
    }

    static class ForeignKeyRenderer
    extends DefaultListCellRenderer {
        private final String FORMAT = NbBundle.getMessage(ForeignKeyRenderer.class, (String)"FMT_ForeignKey");
        private final String NO_PK = NbBundle.getMessage(ForeignKeyRenderer.class, (String)"FMT_NoPrimaryKey");

        ForeignKeyRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ForeignKey) {
                ForeignKey foreignKey = (ForeignKey)object;
                String string = foreignKey.isValid() ? "" : this.NO_PK;
                String string2 = MessageFormat.format(this.FORMAT, foreignKey.getPKTable(), foreignKey.getPKColumn(), foreignKey.getFKTable(), foreignKey.getFKColumn(), string);
                this.setText(string2);
                this.setEnabled(foreignKey.isValid());
            }
            return this;
        }
    }

    static class ForeignKey {
        private String pkTable;
        private String pkColumn;
        private String fkTable;
        private String fkColumn;
        private boolean valid;

        ForeignKey(String string, String string2, String string3, String string4, boolean bl) {
            this.pkTable = string;
            this.pkColumn = string2;
            this.fkTable = string3;
            this.fkColumn = string4;
            this.valid = bl;
        }

        String getPKTable() {
            return this.pkTable;
        }

        String getPKColumn() {
            return this.pkColumn;
        }

        String getFKTable() {
            return this.fkTable;
        }

        String getFKColumn() {
            return this.fkColumn;
        }

        boolean isValid() {
            return this.valid;
        }
    }

    private class FormListener
    implements ActionListener,
    ListSelectionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DetailPanel.this.addAllButton) {
                DetailPanel.this.addAllButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DetailPanel.this.addButton) {
                DetailPanel.this.addButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DetailPanel.this.removeButton) {
                DetailPanel.this.removeButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DetailPanel.this.removeAllButton) {
                DetailPanel.this.removeAllButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DetailPanel.this.upButton) {
                DetailPanel.this.upButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DetailPanel.this.downButton) {
                DetailPanel.this.downButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DetailPanel.this.fieldsChoice) {
                DetailPanel.this.fieldsChoiceActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DetailPanel.this.tableChoice) {
                DetailPanel.this.tableChoiceActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DetailPanel.this.tableCombo) {
                DetailPanel.this.tableComboActionPerformed(actionEvent);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == DetailPanel.this.availableList) {
                DetailPanel.this.availableListValueChanged(listSelectionEvent);
            } else if (listSelectionEvent.getSource() == DetailPanel.this.includeList) {
                DetailPanel.this.includeListValueChanged(listSelectionEvent);
            }
        }
    }
}

