/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Alarm;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.model.Indicator;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"dir", "lang", "style", "onBlur", "onClick", "onDblClick", "onFocus", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove"};

    @Override
    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (!(component instanceof Alarm)) {
            throw new IllegalArgumentException("AlarmRenderer can only render Alarm components.");
        }
        Alarm alarm = (Alarm)component;
        Theme theme = this.getTheme();
        String severity = alarm.getSeverity();
        String url = alarm.getUrl();
        JSONObject json = new JSONObject();
        json.put("text", (Object)alarm.getText()).put("textPosition", (Object)alarm.getTextPosition()).put("visible", alarm.isVisible()).put("type", (Object)severity).put("className", (Object)alarm.getStyleClass());
        int height = alarm.getHeight();
        int width = alarm.getWidth();
        int border = alarm.getBorder();
        int hspace = alarm.getHspace();
        int vspace = alarm.getVspace();
        String align = alarm.getAlign();
        String alt = alarm.getAlt();
        String longDesc = alarm.getLongDesc();
        String toolTip = alarm.getToolTip();
        String icon = alarm.getIcon();
        String ignoreType = null;
        ImageComponent alarmImage = null;
        if (icon != null && url == null) {
            ignoreType = severity;
            alarmImage = ThemeUtilities.getIcon(theme, icon);
            this.initAlarmImage(alarm, severity, null, icon, height, width, hspace, vspace, align, alt, longDesc, toolTip, border, alarmImage);
        } else if (url != null && url.length() > 0) {
            ignoreType = severity;
            alarmImage = new ImageComponent();
            this.initAlarmImage(alarm, severity, url, null, height, width, hspace, vspace, align, alt, longDesc, toolTip, border, alarmImage);
        }
        JSONObject jsonIcon = new JSONObject();
        if (alarmImage != null) {
            jsonIcon.put("type", (Object)severity);
            jsonIcon.put("image", (Object)WidgetUtilities.renderComponent(context, (UIComponent)alarmImage));
        }
        if (alarm.getIndicators() != null) {
            List<Indicator> indicators = alarm.getIndicators();
            Iterator<Indicator> iterator = indicators.iterator();
            JSONArray jArray = this.getAndEditIndicators(context, iterator, ignoreType, theme, alarm, severity, height, width, hspace, vspace, border, toolTip, longDesc, alt, align);
            if (alarmImage != null) {
                jArray.put((Object)jsonIcon);
            }
            json.put("indicators", (Object)jArray);
        } else if (alarmImage != null) {
            JSONArray jsonFacetArr = new JSONArray();
            jsonFacetArr.put((Object)jsonIcon);
            json.put("indicators", (Object)jsonFacetArr);
        }
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        return json;
    }

    @Override
    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.alarm");
    }

    private JSONArray getAndEditIndicators(FacesContext context, Iterator<Indicator> indicators, String ignoreType, Theme theme, Alarm parent, String editTextType, int height, int width, int hspace, int vspace, int border, String toolTip, String longDesc, String alt, String align) throws IOException, JSONException {
        Object img = null;
        if (indicators == null) {
            return null;
        }
        JSONArray jArray = new JSONArray();
        while (indicators.hasNext()) {
            Indicator indicator = indicators.next();
            String type = indicator.getType();
            if (type.equals(ignoreType)) continue;
            Object comp = indicator.getImageComponent(theme);
            if (indicator.getImageKey() != null && comp != null) {
                this.editImage((UIComponent)comp, type.equals(editTextType), height, width, hspace, vspace, border, toolTip, longDesc, alt, align);
            }
            if (comp == null) {
                comp = ThemeUtilities.getIcon(theme, "DOT");
                continue;
            }
            if (comp.getId() == null) {
                comp.setId(type);
            }
            if (comp.getParent() == null) {
                comp.setParent((UIComponent)parent);
            }
            JSONObject jsonIcon = new JSONObject();
            jsonIcon.put("type", (Object)type);
            jsonIcon.put("image", (Object)WidgetUtilities.renderComponent(context, comp));
            jArray.put((Object)jsonIcon);
        }
        return jArray;
    }

    private void editImage(UIComponent alarmImage, boolean editText, int height, int width, int hspace, int vspace, int border, String toolTip, String longDesc, String alt, String align) {
        Map attributes = alarmImage.getAttributes();
        if (height >= 0) {
            attributes.put("height", height);
        }
        if (width >= 0) {
            attributes.put("width", width);
        }
        if (hspace >= 0) {
            attributes.put("hspace", hspace);
        }
        if (vspace >= 0) {
            attributes.put("vspace", vspace);
        }
        if (border >= 0) {
            attributes.put("border", border);
        }
        if (align != null && align.length() != 0) {
            attributes.put("align", align);
        }
        if (editText) {
            if (toolTip != null && toolTip.length() != 0) {
                attributes.put("toolTip", toolTip);
            }
            if (alt != null && alt.length() != 0) {
                attributes.put("alt", alt);
            }
            if (longDesc != null && longDesc.length() != 0) {
                attributes.put("longDesc", longDesc);
            }
        }
    }

    private void initAlarmImage(Alarm alarm, String id, String url, String icon, int height, int width, int hspace, int vspace, String align, String alt, String longDesc, String toolTip, int border, ImageComponent alarmImage) {
        if (height >= 0) {
            alarmImage.setHeight(height);
        }
        if (width >= 0) {
            alarmImage.setWidth(width);
        }
        if (hspace >= 0) {
            alarmImage.setHspace(hspace);
        }
        if (vspace >= 0) {
            alarmImage.setVspace(vspace);
        }
        if (border >= 0) {
            alarmImage.setBorder(border);
        }
        if (align != null && align.length() != 0) {
            alarmImage.setAlign(align);
        }
        if (toolTip != null && toolTip.length() != 0) {
            alarmImage.setToolTip(toolTip);
        }
        if (alt != null && alt.length() != 0) {
            alarmImage.setAlt(alt);
        }
        if (longDesc != null && longDesc.length() != 0) {
            alarmImage.setLongDesc(longDesc);
        }
        if (url != null && url.length() != 0) {
            alarmImage.setUrl(url);
        }
        if (icon != null && icon.length() != 0) {
            alarmImage.setIcon(icon);
        }
    }
}

