/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;
import org.netbeans.core.windows.options.WinSysOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

final class WinSysPanel
extends JPanel {
    private final WinSysOptionsPanelController controller;
    private final Preferences prefs = NbPreferences.forModule(WinSysPanel.class);
    private JCheckBox isAlphaFloating;
    private JCheckBox isDragImage;
    private JCheckBox isDragImageAlpha;
    private JCheckBox isSnapScreenEdges;
    private JCheckBox isSnapping;

    WinSysPanel(WinSysOptionsPanelController winSysOptionsPanelController) {
        this.controller = winSysOptionsPanelController;
        this.initComponents();
    }

    private void initComponents() {
        this.isDragImage = new JCheckBox();
        this.isAlphaFloating = new JCheckBox();
        this.isSnapping = new JCheckBox();
        this.isDragImageAlpha = new JCheckBox();
        this.isSnapScreenEdges = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.isDragImage, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_DragWindowImage"));
        this.isDragImage.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsDragWindowTooltip"));
        this.isDragImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WinSysPanel.this.isDragImageActionPerformed(actionEvent);
            }
        });
        this.isDragImage.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                WinSysPanel.this.isDragImageStateChanged(changeEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.isDragImage, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isAlphaFloating, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_TransparentFloatingWindows"));
        this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaFloatingTooltip"));
        this.isAlphaFloating.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WinSysPanel.this.isAlphaFloatingActionPerformed(actionEvent);
            }
        });
        this.isAlphaFloating.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                WinSysPanel.this.isAlphaFloatingStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 12, 0, 0);
        this.add((Component)this.isAlphaFloating, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isSnapping, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_SnapFloatingWindows"));
        this.isSnapping.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsSnappingTooltip"));
        this.isSnapping.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                WinSysPanel.this.isSnappingStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 25, 0, 0);
        this.add((Component)this.isSnapping, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isDragImageAlpha, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_TransparentDragWindow"));
        this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaDragTooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.isDragImageAlpha, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isSnapScreenEdges, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_SnapToScreenEdges"));
        this.isSnapScreenEdges.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsSnapScreenEdgesTooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)this.isSnapScreenEdges, gridBagConstraints);
    }

    private void isDragImageActionPerformed(ActionEvent actionEvent) {
    }

    private void isDragImageStateChanged(ChangeEvent changeEvent) {
        this.updateDragSection();
        this.controller.changed();
    }

    private void isSnappingStateChanged(ChangeEvent changeEvent) {
        this.updateSnapSection();
        this.controller.changed();
    }

    private void isAlphaFloatingActionPerformed(ActionEvent actionEvent) {
    }

    private void isAlphaFloatingStateChanged(ChangeEvent changeEvent) {
        this.controller.changed();
    }

    void load() {
        boolean bl = Utilities.getOperatingSystem() != 8;
        this.isDragImage.setSelected(this.prefs.getBoolean("dnd.dragimage", bl));
        this.isDragImageAlpha.setSelected(this.prefs.getBoolean("transparency.dragimage", bl));
        this.isAlphaFloating.setSelected(this.prefs.getBoolean("transparency.floating", true));
        this.isSnapping.setSelected(this.prefs.getBoolean("snapping", true));
        this.isSnapScreenEdges.setSelected(this.prefs.getBoolean("snapping.screenedges", true));
        this.updateDragSection();
        this.updateSnapSection();
        this.updateFloatingSection();
    }

    void store() {
        this.prefs.putBoolean("dnd.dragimage", this.isDragImage.isSelected());
        this.prefs.putBoolean("transparency.dragimage", this.isDragImageAlpha.isSelected());
        this.prefs.putBoolean("transparency.floating", this.isAlphaFloating.isSelected());
        this.prefs.putBoolean("snapping", this.isSnapping.isSelected());
        this.prefs.putBoolean("snapping.screenedges", this.isSnapScreenEdges.isSelected());
    }

    boolean valid() {
        return true;
    }

    private void updateDragSection() {
        boolean bl = NativeWindowSystem.getDefault().isWindowAlphaSupported();
        boolean bl2 = this.isDragImage.isSelected();
        this.isDragImageAlpha.setEnabled(bl && bl2);
        if (bl) {
            this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaDragTooltip"));
        } else {
            this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"NoAlphaSupport"));
        }
    }

    private void updateSnapSection() {
        this.isSnapScreenEdges.setEnabled(this.isSnapping.isSelected());
    }

    private void updateFloatingSection() {
        boolean bl = NativeWindowSystem.getDefault().isWindowAlphaSupported();
        this.isAlphaFloating.setEnabled(bl);
        if (bl) {
            this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaFloatingTooltip"));
        } else {
            this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"NoAlphaSupport"));
        }
    }
}

