/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.dynamics.CombinedFragment;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteraction;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteractionFragment;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.openide.util.NbBundle;

public class InteractionData
extends ElementDataObject {
    private IInteraction element;

    public void setElement(IElement iElement) {
        if (iElement instanceof IInteraction) {
            this.element = (IInteraction)iElement;
        }
    }

    public IInteraction getElement() {
        return this.element;
    }

    private String getSummaryTable(ETList eTList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < eTList.size(); ++i) {
            String string;
            INamedElement iNamedElement = (INamedElement)eTList.get(i);
            stringBuilder.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
            String string2 = this.getBriefDocumentation(iNamedElement.getDocumentation());
            if (string2 == null || string2.trim().equals("")) {
                string2 = "&nbsp;";
            }
            if ((string = iNamedElement.getName()) == null || string.equals("")) {
                string = NbBundle.getMessage(InteractionData.class, (String)"unnamed");
            }
            stringBuilder.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
            stringBuilder.append("<TD WIDTH=\"15%\"><B><A HREF=\"" + this.getLinkTo((IElement)iNamedElement) + "\" title=\"" + iNamedElement.getElementType() + " in " + iNamedElement.getName() + "\">" + string + "</A></B></TD>\r\n");
            stringBuilder.append("<TD>" + string2 + "</TD>\r\n");
            stringBuilder.append("</TR>\r\n");
        }
        stringBuilder.append("</TABLE>\r\n&nbsp;\r\n");
        return stringBuilder.toString();
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        ETList eTList = this.getElement().getLifelines();
        boolean bl = false;
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getDiagramSummary());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            if (eTList != null && eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== LIFELINE SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("lifeline_summary", NbBundle.getMessage(InteractionData.class, (String)"Lifeline_Summary")));
                outputStreamWriter.write(this.getSummaryTable(eTList));
            }
            ETList eTList2 = this.getElement().getFragments();
            ArrayList<IInteractionFragment> arrayList = new ArrayList<IInteractionFragment>();
            for (n = 0; n < eTList2.size(); ++n) {
                IInteractionFragment iInteractionFragment = (IInteractionFragment)eTList2.get(n);
                if (iInteractionFragment instanceof CombinedFragment) continue;
                arrayList.add(iInteractionFragment);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                eTList2.removeItem(arrayList.get(n));
            }
            if (eTList2.size() > 0) {
                outputStreamWriter.write("<!-- =========== FRAGMENT SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("combined_fragment_summary", NbBundle.getMessage(InteractionData.class, (String)"Combined_Fragment_Summary")));
                outputStreamWriter.write(this.getSummaryTable(eTList2));
            }
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

