/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.common.commonactivities.IInvocationNode;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConstraint;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationNodeData
extends ElementDataObject {
    IInvocationNode element;

    @Override
    public void setElement(IElement iElement) {
        if (iElement instanceof IInvocationNode) {
            this.element = (IInvocationNode)iElement;
        }
    }

    public IInvocationNode getElement() {
        return this.element;
    }

    @Override
    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility, Property_Final, Property_Multiple_Invocation, Property_Synchronous};
    }

    @Override
    protected Object[] getPropertyValues() {
        Boolean bl = new Boolean(this.getElement().getIsFinal());
        Boolean bl2 = new Boolean(this.getElement().getIsMultipleInvocation());
        Boolean bl3 = new Boolean(this.getElement().getIsSynchronous());
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement()), bl, bl2, bl3};
    }

    public String getConditionsSummary(String string, ETList<IConstraint> eTList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (eTList.size() > 0) {
            stringBuilder.append("<!-- =========== CONDITION SUMMARY =========== -->\r\n\r\n");
            stringBuilder.append(this.getSummaryHeader("constraint_summary", string));
            for (int i = 0; i < eTList.size(); ++i) {
                IConstraint iConstraint = (IConstraint)eTList.get(i);
                stringBuilder.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                stringBuilder.append("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\r\n");
                stringBuilder.append("<CODE>" + iConstraint.getName() + "</CODE></FONT></TD>\r\n");
                stringBuilder.append("<TD><CODE>" + iConstraint.getExpression() + "</CODE>\r\n");
                stringBuilder.append("</TD>\r\n</TR>\r\n");
            }
            stringBuilder.append("</TABLE>\r\n&nbsp;\r\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        ETList eTList = this.getElement().getLocalPreconditions();
        ETList eTList2 = this.getElement().getLocalPostConditions();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            outputStreamWriter.write(this.getConditionsSummary(NbBundle.getMessage(InvocationNodeData.class, (String)"Pre_Condition_Summary"), (ETList<IConstraint>)eTList));
            outputStreamWriter.write(this.getConditionsSummary(NbBundle.getMessage(InvocationNodeData.class, (String)"Post_Condition_Summary"), (ETList<IConstraint>)eTList2));
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

