/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.ReportTask;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.netbeans.modules.uml.resources.images.ImageUtil;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeItem;
import org.openide.util.NbBundle;

public class PackageData
extends ElementDataObject {
    private IPackage pkg;
    private String htmlFilePath;
    private DisplayNameComparator comparator = new DisplayNameComparator();
    private String[] elementTypes = new String[]{"Interface", "Class", "DerivationClassifier", "AssociationClass", "DataType", "AliasedType", "Enumeration", "Stereotype", "Activity", "Actor", "Node", "DeploymentSpecification", "Component", "SourcFileArtifact", "UseCase", "ActivityGroup", "FinalNode", "FinalState", "ForkNode", "InitialNode", "InvocationNode", "PartFacade", "Comment", "Collaboration", "Artifact", "Lifeline", "Interaction", "StateMachine", "Package"};

    public PackageData() {
    }

    public PackageData(IPackage iPackage) {
        this.pkg = iPackage;
    }

    public void setElement(IElement iElement) {
        if (iElement instanceof IPackage) {
            this.pkg = (IPackage)iElement;
        }
    }

    public IPackage getElement() {
        return this.pkg;
    }

    public INamedElement[] getElementByType(String string) {
        if (this.getElement() == null) {
            return null;
        }
        ArrayList<INamedElement> arrayList = new ArrayList<INamedElement>();
        ETList eTList = this.getElement().getOwnedElements();
        for (int i = 0; i < eTList.getCount(); ++i) {
            INamedElement iNamedElement = (INamedElement)eTList.get(i);
            if (!iNamedElement.getElementType().equals(string)) continue;
            arrayList.add(iNamedElement);
        }
        INamedElement[] iNamedElementArray = new INamedElement[arrayList.size()];
        arrayList.toArray(iNamedElementArray);
        Arrays.sort(iNamedElementArray, this.comparator);
        return iNamedElementArray;
    }

    public String getElementName() {
        return this.getElement().getName();
    }

    public String getHTMLFilePath() {
        return this.htmlFilePath;
    }

    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility};
    }

    protected Object[] getPropertyValues() {
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement())};
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        this.htmlFilePath = file.getAbsolutePath();
        int n = this.htmlFilePath.indexOf(ReportTask.HTML_EXT);
        String string = file.getAbsolutePath().substring(0, n) + ReportTask.FRAME + ReportTask.HTML_EXT;
        File file2 = new File(string);
        bl = this.generatePackageFrameHTML(file2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n<H2>\r\n");
            if (this.getElement().getElementType().equals("Project")) {
                outputStreamWriter.write(NbBundle.getMessage(PackageData.class, (String)"package") + " &lt;" + NbBundle.getMessage(ReportTask.class, (String)"default_package") + ">\r\n");
            } else {
                outputStreamWriter.write(this.getElementType() + " " + this.getElement().getFullyQualifiedName(false) + "\r\n");
            }
            outputStreamWriter.write("</H2>\r\n");
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation() + "\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            for (int i = 0; i < this.elementTypes.length; ++i) {
                String string2 = this.elementTypes[i];
                INamedElement[] iNamedElementArray = this.getElementByType(string2);
                if (iNamedElementArray.length <= 0) continue;
                outputStreamWriter.write("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\"> \r\n");
                outputStreamWriter.write("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\r\n");
                outputStreamWriter.write("<TH ALIGN=\"left\" COLSPAN=\"2\"><FONT SIZE=\"+2\">\r\n");
                outputStreamWriter.write("<B>" + NbBundle.getMessage(PackageData.class, (String)("ElementType_" + string2)) + " " + NbBundle.getMessage(PackageData.class, (String)"Header_Summary") + "</B></FONT></TH>\r\n");
                outputStreamWriter.write("</TR>\r\n");
                for (int j = 0; j < iNamedElementArray.length; ++j) {
                    INamedElement iNamedElement = iNamedElementArray[j];
                    String string3 = this.getBriefDocumentation(iNamedElement.getDocumentation());
                    String string4 = iNamedElement.getName();
                    if (string4 == null || string4.equals("")) {
                        string4 = NbBundle.getMessage(PackageData.class, (String)"unnamed");
                    }
                    if (string3 == null || string3.trim().equals("")) {
                        string3 = "&nbsp;";
                    }
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><B><A HREF=\"" + this.getLinkTo((IElement)iNamedElement) + "\" title=\"" + string2 + " in " + string4 + "\">" + string4 + "</A></B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + string3 + "</TD>\r\n");
                    outputStreamWriter.write("</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n<P>\r\n");
            }
            outputStreamWriter.write(this.getDiagramSummary());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = bl;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }

    public boolean generatePackageFrameHTML(File file) {
        boolean bl = false;
        try {
            String string;
            Object object;
            String string2;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">");
            outputStreamWriter.write("<img src=\"" + ReportTask.getPathToReportRoot((IElement)this.getElement()) + "images/package.png" + "\" border=n>&nbsp");
            outputStreamWriter.write("<FONT size=\"+1\" CLASS=\"FrameTitleFont\">");
            if (this.getElement().getElementType().equals("Project")) {
                outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)this.getElement()) + "\" target=\"elementframe\">" + "&lt;" + NbBundle.getMessage(ReportTask.class, (String)"default_package") + ">" + "</A></FONT>\r\n");
            } else {
                outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)this.getElement()) + "\" target=\"elementframe\">" + this.pkg.getFullyQualifiedName(false) + "</A></FONT>\r\n");
            }
            for (int i = 0; i < this.elementTypes.length; ++i) {
                string2 = this.elementTypes[i];
                INamedElement[] iNamedElementArray = this.getElementByType(string2);
                if (iNamedElementArray.length <= 0) continue;
                object = NbBundle.getMessage(PackageData.class, (String)("Category_" + this.elementTypes[i]));
                outputStreamWriter.write("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
                outputStreamWriter.write("<TR>\r\n");
                string = CommonResourceManager.instance().getIconDetailsForElementType(string2);
                if (string.lastIndexOf("/") > -1) {
                    string = string.substring(string.lastIndexOf("/") + 1);
                }
                ReportTask.addToImageList(string);
                outputStreamWriter.write("<TD NOWRAP><img src=\"" + ReportTask.getPathToReportRoot((IElement)this.getElement()) + "images/" + string + "\" border=n>&nbsp;<FONT size=\"+1\" CLASS=\"FrameHeadingFont\">" + (String)object + "</FONT>&nbsp;<FONT CLASS=\"FrameItemFont\">\r\n");
                for (int j = 0; j < iNamedElementArray.length; ++j) {
                    INamedElement iNamedElement = iNamedElementArray[j];
                    String string3 = iNamedElement.getName();
                    if (string3 == null || string3.equals("")) {
                        string3 = NbBundle.getMessage(PackageData.class, (String)"unnamed");
                    }
                    outputStreamWriter.write("<BR>\r\n");
                    outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)iNamedElement) + "\" title=\"" + (String)object + " in " + this.getElementName() + "\" target=\"elementframe\">" + string3 + "</A>\r\n");
                }
                outputStreamWriter.write("</FONT></TD>\r\n");
                outputStreamWriter.write("</TR>\r\n</TABLE>\r\n\r\n<BR>\r\n");
            }
            ITreeItem[] iTreeItemArray = this.getDiagrams();
            string2 = NbBundle.getMessage(PackageData.class, (String)"Category_Diagram");
            if (iTreeItemArray.length > 0) {
                outputStreamWriter.write("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
                outputStreamWriter.write("<TR>\r\n");
                outputStreamWriter.write("<TD NOWRAP><FONT size=\"+1\" CLASS=\"FrameHeadingFont\">" + string2 + "</FONT>&nbsp;<FONT CLASS=\"FrameItemFont\">\r\n");
            }
            for (int i = 0; i < iTreeItemArray.length; ++i) {
                object = iTreeItemArray[i].getData().getDiagram().getDiagram();
                if (object == null) {
                    object = ReportTask.loadDiagram(iTreeItemArray[i].getData().getDiagram().getFilename());
                }
                if (object == null) continue;
                outputStreamWriter.write("<BR>\r\n");
                string = ImageUtil.instance().getDiagramTypeImageName(object.getDiagramKind());
                if (string.lastIndexOf("/") > -1) {
                    string = string.substring(string.lastIndexOf("/") + 1);
                }
                ReportTask.addToImageList(string);
                outputStreamWriter.write("<img src=\"" + ReportTask.getPathToReportRoot((IElement)this.getElement()) + "images/" + string + "\" border=n>&nbsp;<A HREF=\"" + this.getLinkToDiagram(iTreeItemArray[i].getData().getDiagram()) + "\" title=\"" + string2 + " in " + this.getElementName() + "\" target=\"elementframe\">" + object.getName() + "</A>\r\n");
            }
            outputStreamWriter.write("</FONT></TD>\r\n");
            outputStreamWriter.write("</TR>\r\n</TABLE>\r\n\r\n");
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }

    private class DisplayNameComparator
    implements Comparator {
        private Comparator COLLATOR = Collator.getInstance();

        private DisplayNameComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof INamedElement)) {
                return 1;
            }
            if (!(object2 instanceof INamedElement)) {
                return -1;
            }
            INamedElement iNamedElement = (INamedElement)object;
            INamedElement iNamedElement2 = (INamedElement)object2;
            return this.COLLATOR.compare(iNamedElement.getName(), iNamedElement2.getName());
        }
    }
}

