/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartHandler {
    private static final int DEFAULT_MAX_UPLOAD_SIZE = 0x100000;
    protected Hashtable<String, Vector<String>> formFields = new Hashtable();
    Hashtable<String, OneUpload> uploadFiles = new Hashtable();
    private RequestFacade req;
    private InputFacade in;
    private String boundary;
    private byte[] buf = new byte[8192];
    private File uploadDir;
    private String fieldEncoding = "ISO-8859-1";

    public MultiPartHandler(RequestFacade requestFacade, String string) throws IOException {
        this(requestFacade, string, 0x100000, "ISO-8859-1");
    }

    public MultiPartHandler(RequestFacade requestFacade, String string, int n) throws IOException {
        this(requestFacade, string, n, "ISO-8859-1");
    }

    public MultiPartHandler(RequestFacade requestFacade, String string, int n, String string2) throws IOException {
        if (requestFacade == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("tmp Dir is null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Max size is < 0");
        }
        this.uploadDir = new File(string);
        if (!this.uploadDir.isDirectory()) {
            throw new IllegalArgumentException("Not a Directory");
        }
        if (!this.uploadDir.canWrite()) {
            throw new IllegalArgumentException("write protected");
        }
        String string3 = requestFacade.getContentType();
        if (string3 == null || !string3.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("type null");
        }
        this.fieldEncoding = string2;
        this.req = requestFacade;
    }

    public void parseMultipartUpload() throws IOException {
        this.startMultipartParse();
        HashMap hashMap = this.parsePartHeaders();
        while (hashMap != null) {
            Object object;
            String string = (String)hashMap.get("fieldName");
            String string2 = (String)hashMap.get("fileName");
            if (string2 != null) {
                if (string2.equals("")) {
                    string2 = null;
                }
                if (string2 != null) {
                    object = (String)hashMap.get("content-type");
                    string2 = this.saveUploadFile(string2, (String)object);
                    this.uploadFiles.put(string, new OneUpload(this.uploadDir.toString(), string2, (String)object));
                } else {
                    this.uploadFiles.put(string, new OneUpload(null, null, null));
                }
            } else {
                object = this.parseFormFieldBytes();
                String string3 = new String((byte[])object, this.fieldEncoding);
                Vector<String> vector = this.formFields.get(string);
                if (vector == null) {
                    vector = new Vector();
                    this.formFields.put(string, vector);
                }
                vector.addElement(string3);
            }
            hashMap.clear();
            hashMap = this.parsePartHeaders();
        }
    }

    private void startMultipartParse() throws IOException {
        String string = this.parseBoundary(this.req.getContentType());
        if (string == null) {
            throw new IOException("boundary is nul");
        }
        this.in = this.req.getInput();
        this.boundary = string;
        String string2 = this.readLine();
        if (string2 == null) {
            throw new IOException("line is null");
        }
        if (!string2.startsWith(string)) {
            throw new IOException("not start with boundary");
        }
    }

    private HashMap parsePartHeaders() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Vector<String> vector = new Vector<String>();
        String string = this.readLine();
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        vector.addElement(string);
        while ((string = this.readLine()) != null && string.length() > 0) {
            vector.addElement(string);
        }
        if (string == null) {
            return null;
        }
        hashMap.put("content-type", "text/plain");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.toLowerCase().startsWith("content-disposition:")) {
                this.parseContentDisposition(string2, hashMap);
                continue;
            }
            if (!string2.toLowerCase().startsWith("content-type:")) continue;
            this.parseContentType(string2, hashMap);
        }
        return hashMap;
    }

    private String parseBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        if (string2.charAt(0) == '\"') {
            n = string2.lastIndexOf(34);
            string2 = string2.substring(1, n);
        }
        string2 = "--" + string2;
        return string2;
    }

    private void parseContentDisposition(String string, HashMap<String, String> hashMap) throws IOException {
        String string2 = string;
        string = string2.toLowerCase();
        int n = string.indexOf("content-disposition: ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            throw new IOException("end reached");
        }
        String string3 = string.substring(n + 21, n2);
        if (!string3.equals("form-data")) {
            throw new IOException("fome-data not match");
        }
        n = string.indexOf("name=\"", n2);
        n2 = string.indexOf("\"", n + 7);
        if (n == -1 || n2 == -1) {
            throw new IOException("data corrupt");
        }
        String string4 = string2.substring(n + 6, n2);
        String string5 = null;
        String string6 = null;
        n = string.indexOf("filename=\"", n2 + 2);
        n2 = string.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string6 = string5 = string2.substring(n + 10, n2);
            int n3 = Math.max(string5.lastIndexOf(47), string5.lastIndexOf(92));
            if (n3 > -1) {
                string5 = string5.substring(n3 + 1);
            }
        }
        hashMap.put("disposition", string3);
        hashMap.put("fieldName", string4);
        hashMap.put("fileName", string5);
        hashMap.put("filePath", string6);
    }

    private void parseContentType(String string, HashMap<String, String> hashMap) throws IOException {
        String string2 = null;
        String string3 = string;
        if ((string = string3.toLowerCase()).startsWith("content-type")) {
            int n = string.indexOf(" ");
            if (n == -1) {
                throw new IOException("no start");
            }
            string2 = string.substring(n + 1);
            hashMap.put("content-type", string2);
        } else if (string.length() != 0) {
            throw new IOException("length 0");
        }
    }

    private byte[] parseFormFieldBytes() throws IOException {
        int n;
        MultipartInputStream multipartInputStream = new MultipartInputStream(this.in, this.boundary);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        byte[] byArray = new byte[128];
        while ((n = multipartInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        multipartInputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            stringBuffer.append(new String(this.buf, 0, n, "ISO-8859-1"));
        } while (n == this.buf.length);
        if (stringBuffer.length() == 0) {
            return null;
        }
        int n2 = stringBuffer.length();
        if (n2 >= 2 && stringBuffer.charAt(n2 - 2) == '\r') {
            stringBuffer.setLength(n2 - 2);
        } else {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveUploadFile(String string, String string2) throws IOException {
        long l = 0L;
        OutputStream outputStream = null;
        try {
            File file = new File(this.uploadDir, string);
            int n = 0;
            while (file.exists() && file.exists()) {
                file = new File(this.uploadDir, string + "." + n);
                ++n;
            }
            string = file.getName();
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[8192];
            InputStream inputStream = string2.equals("x-application/gzip") ? this.in.getInputStream() : new MultipartInputStream(this.in, this.boundary);
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                l += (long)n;
            }
            inputStream.close();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return string;
    }

    public Enumeration getParameterNames() {
        return this.formFields.keys();
    }

    public Enumeration getFileNames() {
        return this.uploadFiles.keys();
    }

    public String getParameter(String string) {
        try {
            Vector<String> vector = this.formFields.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            String string2 = vector.elementAt(vector.size() - 1);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getParameterValues(String string) {
        try {
            Vector<String> vector = this.formFields.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFileName(String string) {
        try {
            OneUpload oneUpload = this.uploadFiles.get(string);
            return oneUpload.getFileName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFileType(String string) {
        try {
            OneUpload oneUpload = this.uploadFiles.get(string);
            return oneUpload.getFileType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String string) {
        try {
            OneUpload oneUpload = this.uploadFiles.get(string);
            return oneUpload.getFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void close() throws IOException {
        this.req = null;
        this.in = null;
        this.boundary = null;
        this.buf = null;
        this.uploadDir = null;
    }

    private static class MultipartInputStream
    extends FilterInputStream {
        private String boundary;
        private byte[] buf = new byte[65536];
        private int count;
        private int pos;
        private boolean eof;
        private InputFacade facade;

        MultipartInputStream(InputFacade inputFacade, String string) throws IOException {
            super(inputFacade.getInputStream());
            this.boundary = string;
            this.facade = inputFacade;
        }

        private void fill() throws IOException {
            if (this.eof) {
                return;
            }
            if (this.count > 0) {
                if (this.count - this.pos == 2) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
                    this.count -= this.pos;
                    this.pos = 0;
                } else {
                    throw new IllegalStateException("should never happen");
                }
            }
            int n = 0;
            int n2 = this.buf.length - this.boundary.length();
            while (this.count < n2) {
                n = this.facade.readLine(this.buf, this.count, this.buf.length - this.count);
                if (n == -1) {
                    throw new IOException("read is -1");
                }
                if (n >= this.boundary.length()) {
                    this.eof = true;
                    for (int i = 0; i < this.boundary.length(); ++i) {
                        if (this.boundary.charAt(i) == this.buf[this.count + i]) continue;
                        this.eof = false;
                        break;
                    }
                    if (this.eof) break;
                }
                this.count += n;
            }
        }

        public int read() throws IOException {
            if (this.count - this.pos <= 2) {
                this.fill();
                if (this.count - this.pos <= 2) {
                    return -1;
                }
            }
            return this.buf[this.pos++] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (n2 == 0) {
                return 0;
            }
            int n4 = this.count - this.pos - 2;
            if (n4 <= 0) {
                this.fill();
                n4 = this.count - this.pos - 2;
                if (n4 <= 0) {
                    return -1;
                }
            }
            int n5 = Math.min(n2, n4);
            System.arraycopy(this.buf, this.pos, byArray, n, n5);
            this.pos += n5;
            n3 += n5;
            while (n3 < n2) {
                this.fill();
                n4 = this.count - this.pos - 2;
                if (n4 <= 0) {
                    return n3;
                }
                n5 = Math.min(n2 - n3, n4);
                System.arraycopy(this.buf, this.pos, byArray, n + n3, n5);
                this.pos += n5;
                n3 += n5;
            }
            return n3;
        }

        public int available() throws IOException {
            int n = this.count - this.pos - 2 + this.in.available();
            return n < 0 ? 0 : n;
        }

        public void close() throws IOException {
            if (!this.eof) {
                while (this.read(this.buf, 0, this.buf.length) != -1) {
                }
            }
        }
    }

    private static class OneUpload {
        private String dir;
        private String filename;
        private String type;

        OneUpload(String string, String string2, String string3) {
            this.dir = string;
            this.filename = string2;
            this.type = string3;
        }

        public String getFileType() {
            return this.type;
        }

        public String getFileName() {
            return this.filename;
        }

        public File getFile() {
            if (this.dir == null || this.filename == null) {
                return null;
            }
            return new File(this.dir + File.separator + this.filename);
        }
    }

    public static interface RequestFacade {
        public int getContentLength();

        public String getContentType();

        public InputFacade getInput() throws IOException;
    }

    public static interface InputFacade {
        public int readLine(byte[] var1, int var2, int var3) throws IOException;

        public InputStream getInputStream();
    }
}

