/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.debug.Context;
import org.netbeans.modules.web.debug.JspBreakpointAnnotationListener;
import org.netbeans.modules.web.debug.breakpoints.JspLineBreakpoint;
import org.netbeans.modules.web.debug.util.Utils;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JspToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;
    private JspBreakpointAnnotationListener jspBreakpointAnnotationListener;

    public JspToggleBreakpointActionProvider() {
        Context.addPropertyChangeListener(this);
    }

    public JspToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        Context.addPropertyChangeListener(this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        Context.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = Context.getCurrentURL();
        FileObject fileObject = Utils.getFileObjectFromUrl(string);
        WebModule webModule = null;
        if (fileObject != null) {
            webModule = WebModule.getWebModule((FileObject)fileObject);
        }
        boolean bl = Utils.isJsp(fileObject) || Utils.isTag(fileObject);
        String string2 = null;
        if (webModule != null && webModule.getDocumentBase() != null) {
            string2 = FileUtil.getRelativePath((FileObject)webModule.getDocumentBase(), (FileObject)fileObject);
        }
        String string3 = Utils.getTargetServerID(fileObject);
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, webModule != null && string2 != null && bl && !"WebLogic9".equals(string3));
        if (this.debugger != null) {
            if (this.debugger.getState() == 4) {
                this.destroy();
            }
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = Context.getCurrentLineNumber();
        String string = Context.getCurrentURL();
        if (string == null) {
            return;
        }
        JspLineBreakpoint jspLineBreakpoint = this.getJspBreakpointAnnotationListener().findBreakpoint(string, n);
        if (jspLineBreakpoint != null) {
            debuggerManager.removeBreakpoint((Breakpoint)jspLineBreakpoint);
            return;
        }
        jspLineBreakpoint = JspLineBreakpoint.create(string, n);
        debuggerManager.addBreakpoint((Breakpoint)jspLineBreakpoint);
    }

    private JspBreakpointAnnotationListener getJspBreakpointAnnotationListener() {
        if (this.jspBreakpointAnnotationListener == null) {
            this.jspBreakpointAnnotationListener = (JspBreakpointAnnotationListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, JspBreakpointAnnotationListener.class));
        }
        return this.jspBreakpointAnnotationListener;
    }
}

