/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StorageImpl<K, V> {
    private static final Logger LOG = Logger.getLogger(StorageImpl.class.getName());
    private final StorageDescription<K, V> storageDescription;
    private final FileSystem sfs;
    private final FileObject baseFolder;
    private final Object lock = new String("StorageImpl.lock");
    private final Map<MimePath, Map<CacheKey, Map<K, V>>> profilesCache = new WeakHashMap<MimePath, Map<CacheKey, Map<K, V>>>();

    public StorageImpl(StorageDescription<K, V> storageDescription) {
        this.storageDescription = storageDescription;
        this.sfs = Repository.getDefault().getDefaultFileSystem();
        this.baseFolder = this.sfs.findResource("Editors");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> load(MimePath mimePath, String string, boolean bl) throws IOException {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        if (this.storageDescription.isUsingProfiles()) {
            assert (string != null) : "The parameter profile must not be null";
        } else assert (string == null) : "The '" + this.storageDescription.getId() + "' settings type does not use profiles.";
        Object object = this.lock;
        synchronized (object) {
            Map<K, V> map;
            Map<CacheKey, Map<CacheKey, Map<K, V>>> map2 = this.profilesCache.get(mimePath);
            CacheKey cacheKey = StorageImpl.cacheKey(string, bl);
            if (map2 == null) {
                map = null;
                map2 = new HashMap<CacheKey, Map<K, V>>();
                this.profilesCache.put(mimePath, map2);
            } else {
                map = map2.get(cacheKey);
            }
            if (map == null) {
                map = this._load(mimePath, string, bl);
                map2.put(cacheKey, map);
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(MimePath mimePath, String string, boolean bl, Map<K, V> map) throws IOException {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        if (this.storageDescription.isUsingProfiles()) {
            assert (string != null) : "The parameter profile must not be null";
        } else assert (string == null) : "The '" + this.storageDescription.getId() + "' settings type does not use profiles.";
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            Map<CacheKey, Map<CacheKey, Map<K, V>>> map2 = this.profilesCache.get(mimePath);
            if (map2 == null) {
                map2 = new HashMap<CacheKey, Map<K, V>>();
                this.profilesCache.put(mimePath, map2);
            }
            if (!(bl2 = this._save(mimePath, string, bl, map))) {
                map2.put(StorageImpl.cacheKey(string, bl), map);
            } else {
                map2.remove(StorageImpl.cacheKey(string, bl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(MimePath mimePath, String string, boolean bl) throws IOException {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        if (this.storageDescription.isUsingProfiles()) {
            assert (string != null) : "The parameter profile must not be null";
        } else assert (string == null) : "The '" + this.storageDescription.getId() + "' settings type does not use profiles.";
        Object object = this.lock;
        synchronized (object) {
            Map<CacheKey, Map<K, V>> map = this.profilesCache.get(mimePath);
            if (map != null) {
                map.remove(StorageImpl.cacheKey(string, bl));
            }
            this._delete(mimePath, string, bl);
        }
    }

    private List<Object[]> scan(MimePath mimePath, String string, boolean bl, boolean bl2) {
        HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
        SettingsType.getLocator(this.storageDescription).scan(this.baseFolder, mimePath.getPath(), string, true, bl, bl2, mimePath.size() > 1, hashMap);
        assert (hashMap.size() <= 1) : "Too many results in the scan";
        return (List)hashMap.get(string);
    }

    private Map<K, V> _load(MimePath mimePath, String string, boolean bl) throws IOException {
        if (this.storageDescription instanceof Operations) {
            Operations operations = (Operations)((Object)this.storageDescription);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Forwarding loading of '" + this.storageDescription.getId() + "' to: " + operations);
            }
            return operations.load(mimePath, string, bl);
        }
        List<Object[]> list = this.scan(mimePath, string, true, !bl);
        HashMap hashMap = new HashMap();
        if (list != null) {
            for (Object[] objectArray : list) {
                Map map;
                MimePath mimePath2;
                assert (objectArray.length == 5);
                FileObject fileObject = (FileObject)objectArray[0];
                FileObject fileObject2 = (FileObject)objectArray[1];
                boolean bl2 = (Boolean)objectArray[2];
                FileObject fileObject3 = (FileObject)objectArray[3];
                boolean bl3 = (Boolean)objectArray[4];
                if (fileObject3 != null) {
                    mimePath2 = MimePath.parse((String)fileObject3.getPath().substring(this.baseFolder.getPath().length() + 1));
                    assert (mimePath2 != mimePath) : "linkedMimePath should not be the same as the original one";
                    if (mimePath2.size() == 1) {
                        map = this.load(mimePath2, string, bl);
                        hashMap.putAll(map);
                        LOG.fine("Adding linked '" + this.storageDescription.getId() + "' from: '" + mimePath2.getPath() + "'");
                        continue;
                    }
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning("Linking to other than top level mime types is prohibited. Ignoring editor settings link from '" + mimePath.getPath() + "' to '" + mimePath2.getPath() + "'");
                    continue;
                }
                mimePath2 = this.storageDescription.createReader(fileObject2, mimePath.getPath());
                Utils.load(fileObject2, (StorageReader)mimePath2, !bl3);
                map = mimePath2.getAdded();
                Set set = mimePath2.getRemoved();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Loading '" + this.storageDescription.getId() + "' from: '" + fileObject2.getPath() + "'");
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("--- Removing '" + this.storageDescription.getId() + "': " + set);
                }
                for (Object k : set) {
                    hashMap.remove(k);
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("--- Adding '" + this.storageDescription.getId() + "': " + map);
                }
                for (Object k : map.keySet()) {
                    Object v = map.get(k);
                    Object v2 = hashMap.put(k, v);
                    if (!LOG.isLoggable(Level.FINEST) || v2 == null || v2.equals(v)) continue;
                    LOG.finest("--- Replacing old entry for '" + k + "', orig value = '" + v2 + "', new value = '" + v + "'");
                }
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest("-------------------------------------");
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private boolean _save(MimePath mimePath, String string, boolean bl, Map<K, V> map) throws IOException {
        Map<K, V> map2 = this.load(mimePath, string, true);
        if (this.storageDescription instanceof Operations) {
            Operations operations = (Operations)((Object)this.storageDescription);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Forwarding saving of '" + this.storageDescription.getId() + "' to: " + operations);
            }
            return operations.save(mimePath, string, bl, map, map2);
        }
        final HashMap hashMap = new HashMap();
        final HashMap hashMap2 = new HashMap();
        Utils.diff(map2, map, hashMap, hashMap2);
        final String string2 = mimePath.getPath();
        final String string3 = SettingsType.getLocator(this.storageDescription).getWritableFileName(string2, string, null, bl);
        this.sfs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                if (hashMap.size() > 0 || hashMap2.size() > 0) {
                    FileObject fileObject = FileUtil.createData((FileObject)StorageImpl.this.baseFolder, (String)string3);
                    StorageWriter storageWriter = StorageImpl.this.storageDescription.createWriter(fileObject, string2);
                    storageWriter.setAdded(hashMap);
                    storageWriter.setRemoved(hashMap2.keySet());
                    Utils.save(fileObject, storageWriter);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Saving '" + StorageImpl.this.storageDescription.getId() + "' to: '" + fileObject.getPath() + "'");
                    }
                } else {
                    FileObject fileObject = StorageImpl.this.baseFolder.getFileObject(string3);
                    if (fileObject != null) {
                        fileObject.delete();
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Saving '" + StorageImpl.this.storageDescription.getId() + "', no changes from defaults therefore deleting: '" + fileObject.getPath() + "'");
                        }
                    }
                }
            }
        });
        return false;
    }

    private void _delete(MimePath mimePath, String string, boolean bl) throws IOException {
        if (this.storageDescription instanceof Operations) {
            Operations operations = (Operations)((Object)this.storageDescription);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Forwarding deletion of '" + this.storageDescription.getId() + "' to: " + operations);
            }
            operations.delete(mimePath, string, bl);
        } else {
            final List<Object[]> list = this.scan(mimePath, string, bl, !bl);
            if (list != null) {
                this.sfs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        for (Object[] objectArray : list) {
                            assert (objectArray.length == 5);
                            FileObject fileObject = (FileObject)objectArray[0];
                            FileObject fileObject2 = (FileObject)objectArray[1];
                            boolean bl = (Boolean)objectArray[2];
                            fileObject2.delete();
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine("Deleting '" + StorageImpl.this.storageDescription.getId() + "' file: '" + fileObject2.getPath() + "'");
                        }
                    }
                });
            }
        }
    }

    private static CacheKey cacheKey(String string, boolean bl) {
        return new CacheKey(string, bl);
    }

    private static final class CacheKey {
        private final String profile;
        private final boolean defaults;

        public CacheKey(String string, boolean bl) {
            this.profile = string;
            this.defaults = bl;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.profile == null && cacheKey.profile != null || this.profile != null && cacheKey.profile == null || this.profile != null && !this.profile.equals(cacheKey.profile)) {
                return false;
            }
            return this.defaults == cacheKey.defaults;
        }

        public int hashCode() {
            return this.profile != null ? this.profile.hashCode() : 7;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operations<K, V> {
        public Map<K, V> load(MimePath var1, String var2, boolean var3) throws IOException;

        public boolean save(MimePath var1, String var2, boolean var3, Map<K, V> var4, Map<K, V> var5) throws IOException;

        public void delete(MimePath var1, String var2, boolean var3) throws IOException;
    }
}

