/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.StorageImpl;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorSettingsStorage<K, V> {
    private static final Map<StorageDescription<?, ?>, EditorSettingsStorage> cache = new HashMap();
    private final StorageImpl<K, V> storageImpl;

    public static <K, V> EditorSettingsStorage<K, V> get(String string) {
        EditorSettingsStorage<K, V> editorSettingsStorage = EditorSettingsStorage.find(string);
        assert (editorSettingsStorage != null) : "Invalid settings type Id: '" + string + "'";
        return editorSettingsStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> EditorSettingsStorage<K, V> find(String string) {
        Map<StorageDescription<?, ?>, EditorSettingsStorage> map = cache;
        synchronized (map) {
            EditorSettingsStorage editorSettingsStorage = null;
            StorageDescription storageDescription = SettingsType.find(string);
            if (storageDescription != null && (editorSettingsStorage = cache.get(storageDescription)) == null) {
                editorSettingsStorage = new EditorSettingsStorage(new StorageImpl(storageDescription));
                cache.put(storageDescription, editorSettingsStorage);
            }
            return editorSettingsStorage;
        }
    }

    public Map<K, V> load(MimePath mimePath, String string, boolean bl) throws IOException {
        return this.storageImpl.load(mimePath, string, bl);
    }

    public void save(MimePath mimePath, String string, boolean bl, Map<K, V> map) throws IOException {
        this.storageImpl.save(mimePath, string, bl, map);
    }

    public void delete(MimePath mimePath, String string, boolean bl) throws IOException {
        this.storageImpl.delete(mimePath, string, bl);
    }

    private EditorSettingsStorage(StorageImpl<K, V> storageImpl) {
        this.storageImpl = storageImpl;
    }
}

