/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.preferences;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreferencesImpl
extends AbstractPreferences
implements PreferenceChangeListener {
    private static final String JAVATYPE_KEY_PREFIX = "nbeditor-javaType-for-legacy-setting_";
    private static final Logger LOG = Logger.getLogger(PreferencesImpl.class.getName());
    private static final Map<MimePath, PreferencesImpl> INSTANCES = new WeakHashMap<MimePath, PreferencesImpl>();
    private static final String SLASH = "/";
    private static final String EMPTY = "";
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final RequestProcessor RP = new RequestProcessor();
    private final RequestProcessor.Task flushTask = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = PreferencesImpl.this.lock;
            synchronized (object) {
                try {
                    PreferencesImpl.this.flushSpi();
                }
                catch (BackingStoreException backingStoreException) {
                    LOG.log(Level.WARNING, null, backingStoreException);
                }
            }
        }
    }, true);
    private final ThreadLocal<String> refiringChangeKey = new ThreadLocal();
    private final ThreadLocal<String> putValueJavaType = new ThreadLocal();
    private final String mimePath;
    private Map<String, TypedValue> local = null;
    private Preferences inherited = null;

    public static synchronized PreferencesImpl get(MimePath mimePath) {
        PreferencesImpl preferencesImpl = INSTANCES.get(mimePath);
        if (preferencesImpl == null) {
            preferencesImpl = new PreferencesImpl(mimePath.getPath());
            INSTANCES.put(mimePath, preferencesImpl);
        }
        return preferencesImpl;
    }

    @Override
    public String absolutePath() {
        return SLASH;
    }

    @Override
    public String[] childrenNames() throws BackingStoreException {
        return EMPTY_ARRAY;
    }

    @Override
    public boolean isUserNode() {
        return true;
    }

    @Override
    public String name() {
        return EMPTY;
    }

    @Override
    public Preferences node(String string) {
        if (string.length() == 0 || string.equals(SLASH)) {
            return this;
        }
        throw new IllegalStateException("Editor Preferences does not support children nodes.");
    }

    @Override
    public boolean nodeExists(String string) throws BackingStoreException {
        return string.length() == 0 || string.equals(SLASH);
    }

    @Override
    public Preferences parent() {
        return null;
    }

    @Override
    public void removeNode() throws BackingStoreException {
        throw new IllegalStateException("Can't remove the root!");
    }

    @Override
    public final void sync() throws BackingStoreException {
        this.flushTask.waitFinished();
        super.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String string, String string2) {
        if (this.putValueJavaType.get() == null) {
            this.putValueJavaType.set(String.class.getName());
        }
        try {
            super.put(string, string2);
        }
        finally {
            if (this.putValueJavaType.get().equals(String.class.getName())) {
                this.putValueJavaType.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putInt(String string, int n) {
        this.putValueJavaType.set(Integer.class.getName());
        try {
            super.putInt(string, n);
        }
        finally {
            this.putValueJavaType.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLong(String string, long l) {
        this.putValueJavaType.set(Long.class.getName());
        try {
            super.putLong(string, l);
        }
        finally {
            this.putValueJavaType.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putBoolean(String string, boolean bl) {
        this.putValueJavaType.set(Boolean.class.getName());
        try {
            super.putBoolean(string, bl);
        }
        finally {
            this.putValueJavaType.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFloat(String string, float f) {
        this.putValueJavaType.set(Float.class.getName());
        try {
            super.putFloat(string, f);
        }
        finally {
            this.putValueJavaType.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putDouble(String string, double d) {
        this.putValueJavaType.set(Double.class.getName());
        try {
            super.putDouble(string, d);
        }
        finally {
            this.putValueJavaType.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByteArray(String string, byte[] byArray) {
        this.putValueJavaType.set(byArray.getClass().getName());
        try {
            super.putByteArray(string, byArray);
        }
        finally {
            this.putValueJavaType.remove();
        }
    }

    @Override
    protected AbstractPreferences getChild(String string) throws BackingStoreException {
        throw new IllegalStateException("Should never be called.");
    }

    @Override
    protected boolean isRemoved() {
        boolean bl = super.isRemoved();
        assert (!bl) : "super.isRemoved() should always == false";
        return bl;
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        throw new IllegalStateException("Should never be called.");
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        throw new IllegalStateException("Should never be called.");
    }

    @Override
    protected AbstractPreferences childSpi(String string) {
        throw new IllegalStateException("Should never be called.");
    }

    @Override
    protected void putSpi(String string, String string2) {
        if (this.refiringChangeKey.get() != string) {
            if (!string.startsWith(JAVATYPE_KEY_PREFIX)) {
                this.getLocal().put(string, new TypedValue(string2, this.putValueJavaType.get()));
                this.asyncInvocationOfFlushSpi();
            } else {
                String string3 = string.substring(JAVATYPE_KEY_PREFIX.length());
                if (this.getLocal().containsKey(string3)) {
                    this.getLocal().get(string3).setJavaType(string2);
                    this.asyncInvocationOfFlushSpi();
                } else {
                    this.getInherited().put(string, string2);
                }
            }
        }
    }

    @Override
    protected String getSpi(String string) {
        boolean bl;
        String string2;
        if (string.startsWith(JAVATYPE_KEY_PREFIX)) {
            string2 = string.substring(JAVATYPE_KEY_PREFIX.length());
            bl = false;
        } else {
            string2 = string;
            bl = true;
        }
        if (this.getLocal().containsKey(string2)) {
            TypedValue typedValue = this.getLocal().get(string2);
            return bl ? typedValue.getValue() : typedValue.getJavaType();
        }
        return this.getInherited().get(string, null);
    }

    @Override
    protected void removeSpi(String string) {
        boolean bl;
        String string2;
        if (string.startsWith(JAVATYPE_KEY_PREFIX)) {
            string2 = string.substring(JAVATYPE_KEY_PREFIX.length());
            bl = false;
        } else {
            string2 = string;
            bl = true;
        }
        if (this.getLocal().containsKey(string2)) {
            if (bl) {
                this.getLocal().remove(string2);
            } else {
                this.getLocal().get(string2).setJavaType(null);
            }
            this.asyncInvocationOfFlushSpi();
        }
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        Set<Object> set;
        Preferences preferences = this.getInherited();
        if (preferences != null) {
            set = new HashSet();
            set.addAll(Arrays.asList(preferences.keys()));
            set.addAll(this.getLocal().keySet());
        } else {
            set = this.getLocal().keySet();
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        this.local = null;
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        if (this.local != null) {
            EditorSettingsStorage<String, TypedValue> editorSettingsStorage = EditorSettingsStorage.get("Preferences");
            try {
                editorSettingsStorage.save(MimePath.parse((String)this.mimePath), null, false, this.local);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't save editor preferences for '" + this.mimePath + "'", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.local != null && this.local.containsKey(preferenceChangeEvent.getKey())) {
                return;
            }
        }
        this.firePreferenceChange(preferenceChangeEvent.getKey(), preferenceChangeEvent.getNewValue());
    }

    private PreferencesImpl(String string) {
        super(null, EMPTY);
        this.mimePath = string;
    }

    private Map<String, TypedValue> getLocal() {
        if (this.local == null) {
            EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get("Preferences");
            try {
                this.local = new HashMap<String, TypedValue>(editorSettingsStorage.load(MimePath.parse((String)this.mimePath), null, false));
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't load editor preferences for '" + this.mimePath + "'", iOException);
                this.local = new HashMap<String, TypedValue>();
            }
        }
        return this.local;
    }

    private Preferences getInherited() {
        if (this.inherited == null && this.mimePath.length() > 0) {
            List list = null;
            try {
                List list2;
                Method method = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
                method.setAccessible(true);
                list = list2 = (List)method.invoke((Object)MimePath.parse((String)this.mimePath), new Object[]{null, null});
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", exception);
            }
            if (list != null) {
                assert (list.size() > 1) : "Wrong getInheritedPaths result size: " + list.size();
                this.inherited = PreferencesImpl.get(MimePath.parse((String)((String)list.get(1))));
            } else {
                this.inherited = PreferencesImpl.get(MimePath.EMPTY);
            }
            this.inherited.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.inherited));
        }
        return this.inherited;
    }

    private void asyncInvocationOfFlushSpi() {
        this.flushTask.schedule(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePreferenceChange(String string, String string2) {
        this.refiringChangeKey.set(string);
        try {
            this.put(string, string2);
        }
        finally {
            this.refiringChangeKey.remove();
        }
    }

    public static final class TypedValue {
        private final String value;
        private String javaType;

        public TypedValue(String string, String string2) {
            this.value = string;
            this.javaType = string2;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String string) {
            this.javaType = string;
        }

        public String getValue() {
            return this.value;
        }
    }
}

