/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.ToolsAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DefaultOpenFileImpl
implements OpenFileImpl,
Runnable {
    static final String JAVA_EXT = ".JAVA";
    static final String TXT_EXT = ".TXT";
    private static final int OPEN_EDITOR_WAIT_PERIOD_MS = 100;
    private static final int OPEN_EDITOR_TOTAL_TIMEOUT_MS = 1000;
    private final FileObject fileObject;
    private final int line;

    private DefaultOpenFileImpl(FileObject fileObject, int n) {
        this.fileObject = fileObject;
        this.line = n;
    }

    public DefaultOpenFileImpl() {
        this.fileObject = null;
        this.line = -1;
    }

    protected final void setStatusLine(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    protected void notifyCannotOpen(String string) {
        assert (EventQueue.isDispatchThread());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_cannotOpenWillClose", (Object)string)));
    }

    private boolean openEditor(EditorCookie editorCookie, int n) {
        StyledDocument styledDocument;
        assert (EventQueue.isDispatchThread());
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray != null) {
            if (n >= 0) {
                int n2 = this.getCursorOffset(editorCookie.getDocument(), n);
                jEditorPaneArray[0].setCaretPosition(n2);
            }
            Container container = SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPaneArray[0]);
            assert (container != null);
            final TopComponent topComponent = (TopComponent)container;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    topComponent.requestActive();
                }
            });
            return true;
        }
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_cannotOpenWillClose");
            ErrorManager.getDefault().notify(4096, ErrorManager.getDefault().annotate((Throwable)iOException, string));
            return false;
        }
        if (n < 0) {
            editorCookie.open();
        } else {
            this.openDocAtLine(editorCookie, styledDocument, n);
        }
        return true;
    }

    private void openDocAtLine(final EditorCookie editorCookie, StyledDocument styledDocument, int n) {
        assert (EventQueue.isDispatchThread());
        assert (n >= 0);
        assert (editorCookie.getDocument() == styledDocument);
        final int n2 = this.getCursorOffset(styledDocument, n);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SetCursorTask
        implements Runnable {
            private boolean completed = false;
            private PropertyChangeListener listenerToUnregister;

            SetCursorTask() {
            }

            private boolean perform() {
                if (EventQueue.isDispatchThread()) {
                    this.run();
                } else {
                    try {
                        EventQueue.invokeAndWait(this);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                        this.completed = true;
                    }
                }
                return this.completed;
            }

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                if (this.completed) {
                    return;
                }
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                if (jEditorPaneArray != null) {
                    jEditorPaneArray[0].setCaretPosition(n2);
                    if (this.listenerToUnregister != null) {
                        ((EditorCookie.Observable)editorCookie).removePropertyChangeListener(this.listenerToUnregister);
                    }
                    this.completed = true;
                }
            }

            private void setListenerToUnregister(PropertyChangeListener propertyChangeListener) {
                this.listenerToUnregister = propertyChangeListener;
            }
        }
        final SetCursorTask setCursorTask = new SetCursorTask();
        editorCookie.open();
        if (setCursorTask.perform()) {
            return;
        }
        if (editorCookie instanceof EditorCookie.Observable) {
            if (!setCursorTask.perform()) {
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
                    {
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("openedPanes".equals(propertyChangeEvent.getPropertyName())) {
                            setCursorTask.perform();
                        }
                    }
                };
                setCursorTask.setListenerToUnregister(propertyChangeListener);
                ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(propertyChangeListener);
                setCursorTask.perform();
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)interruptedException);
                }
                if (setCursorTask.perform()) break;
            }
            if (!setCursorTask.completed) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_couldNotOpenAt"));
            }
        }
    }

    private int getCursorOffset(StyledDocument styledDocument, int n) {
        assert (EventQueue.isDispatchThread());
        assert (n >= 0);
        try {
            return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
            int n2 = element.getElementCount();
            if (n >= n2) {
                return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n2 - 1));
            }
            throw indexOutOfBoundsException;
        }
    }

    protected boolean openByCookie(Node.Cookie cookie, Class clazz, int n) {
        assert (EventQueue.isDispatchThread());
        if (clazz == EditorCookie.Observable.class || clazz == EditorCookie.Observable.class) {
            return this.openEditor((EditorCookie)cookie, n);
        }
        if (clazz == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (clazz == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (clazz == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private final boolean openDataObjectByCookie(DataObject dataObject, int n) {
        block3: {
            Node.Cookie cookie;
            Class<OpenCookie> clazz;
            block2: {
                clazz = OpenCookie.class;
                cookie = dataObject.getCookie(OpenCookie.class);
                if (cookie != null) break block2;
                clazz = EditCookie.class;
                cookie = dataObject.getCookie(EditCookie.class);
                if (cookie != null) break block2;
                clazz = ViewCookie.class;
                cookie = dataObject.getCookie(ViewCookie.class);
                if (cookie == null) break block3;
            }
            return this.openByCookie(cookie, clazz, n);
        }
        return false;
    }

    public void run() {
        assert (EventQueue.isDispatchThread());
        this.open(this.fileObject, this.line);
    }

    public boolean open(FileObject fileObject, int n) {
        Node node;
        Action action;
        DataObject dataObject;
        String string;
        block11: {
            Node.Cookie cookie;
            Class<EditorCookie.Observable> clazz;
            block12: {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(new DefaultOpenFileImpl(fileObject, n));
                    return true;
                }
                assert (EventQueue.isDispatchThread());
                string = fileObject.getNameExt();
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                    return false;
                }
                if (n == -1) break block11;
                clazz = EditorCookie.Observable.class;
                cookie = dataObject.getCookie(EditorCookie.Observable.class);
                if (cookie != null) break block12;
                clazz = EditorCookie.class;
                cookie = dataObject.getCookie(EditorCookie.class);
                if (cookie == null) break block11;
            }
            boolean bl = this.openByCookie(cookie, clazz, n);
            return bl;
        }
        if ((action = (node = dataObject.getNodeDelegate()).getPreferredAction()) != null && !(action instanceof FileSystemAction) && !(action instanceof ToolsAction)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    action.actionPerformed(new ActionEvent(node, 0, null));
                }
            });
            return true;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_opening", (Object)string));
        boolean bl = this.openDataObjectByCookie(dataObject, n);
        if (bl) {
            return true;
        }
        if (fileObject.isFolder() || FileUtil.isArchiveFile((FileObject)fileObject)) {
            Node node2 = dataObject.getNodeDelegate();
            if (node2 != null) {
                NodeOperation.getDefault().explore(node2);
                return true;
            }
            return false;
        }
        return false;
    }
}

