/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;

public class HyperlinkLabel
extends JLabel {
    private static final long serialVersionUID = -483941387931729295L;
    boolean mouseIn = false;
    HyperlinkClickHandler hyperlinkClickHandler;

    public HyperlinkLabel() {
        this.initialize();
    }

    private void initialize() {
        this.initMouseListener();
    }

    private void initMouseListener() {
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (HyperlinkLabel.this.hyperlinkClickHandler != null) {
                    HyperlinkLabel.this.hyperlinkClickHandler.handleClick();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (HyperlinkLabel.this.hyperlinkClickHandler != null) {
                    HyperlinkLabel.this.mouseIn = true;
                    HyperlinkLabel.this.setCursor(new Cursor(12));
                    HyperlinkLabel.this.repaint();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (HyperlinkLabel.this.hyperlinkClickHandler != null) {
                    HyperlinkLabel.this.mouseIn = false;
                    HyperlinkLabel.this.setCursor(new Cursor(0));
                    HyperlinkLabel.this.repaint();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    protected void paintComponent(Graphics graphics) {
        if (this.mouseIn) {
            Color color = this.getForeground();
            Font font = this.getFont();
            Rectangle rectangle = graphics.getClipBounds();
            Color color2 = this.getForeground();
            this.setForeground(Color.BLUE);
            Color color3 = graphics.getColor();
            graphics.setColor(Color.blue);
            super.paintComponent(graphics);
            int n = rectangle.width;
            graphics.drawLine(rectangle.x + 5, rectangle.y + rectangle.height - 1, rectangle.x + 5 + n - 5, rectangle.y + rectangle.height - 1);
            this.setForeground(color2);
            graphics.setColor(color3);
        } else {
            super.paintComponent(graphics);
        }
    }

    public void setHyperlinkClickHandler(HyperlinkClickHandler hyperlinkClickHandler) {
        this.hyperlinkClickHandler = hyperlinkClickHandler;
    }

    public static interface HyperlinkClickHandler {
        public void handleClick();
    }
}

