/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.schema.abe.nodes.AXINodeVisitor;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.SchemaModelCookie;
import org.netbeans.modules.xml.text.navigator.base.AbstractXMLNavigatorContent;
import org.netbeans.modules.xml.xam.Model;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class NavigatorContent
extends AbstractXMLNavigatorContent {
    private static final long serialVersionUID = 1L;

    public NavigatorContent() {
        this.setLayout(new BorderLayout());
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public void navigate(final DataObject dataObject) {
        this.showWaitPanel();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AXIModel aXIModel = NavigatorContent.this.getAXIModel(dataObject);
                if (aXIModel == null || aXIModel.getState() != Model.State.VALID) {
                    NavigatorContent.this.showError(AbstractXMLNavigatorContent.ERROR_NO_DATA_AVAILABLE);
                } else {
                    NavigatorContent.this.show((AXIComponent)aXIModel.getRoot());
                }
            }
        });
    }

    private void redraw() {
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)((Object)this));
        if (topComponent != null) {
            topComponent.revalidate();
            topComponent.repaint();
        }
    }

    private void show(final AXIComponent aXIComponent) {
        this.removeAll();
        if (!this.treeView.isShowing()) {
            this.add((Component)this.treeView, "Center");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NavigatorContent.this.treeView.setRootVisible(false);
                AXINodeVisitor aXINodeVisitor = new AXINodeVisitor();
                Node node = aXINodeVisitor.getNode(aXIComponent);
                NavigatorContent.this.getExplorerManager().setRootContext(node);
                NavigatorContent.this.redraw();
            }
        });
    }

    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("state".equals(string)) {
            this.onModelStateChanged(propertyChangeEvent);
            return;
        }
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)((Object)this));
        if ("selectedNodes".equals(string)) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray != null && nodeArray.length >= 1 && topComponent != null) {
                topComponent.setActivatedNodes(nodeArray);
            }
        } else if (topComponent != null && this.getExplorerManager() != null) {
            TopComponent.getRegistry();
            if ("activated".equals(string) && topComponent == TopComponent.getRegistry().getActivated()) {
                topComponent.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
            }
        }
    }

    public void onModelStateChanged(PropertyChangeEvent propertyChangeEvent) {
        Model.State state = (Model.State)propertyChangeEvent.getNewValue();
        if (state != Model.State.VALID) {
            this.showError(AbstractXMLNavigatorContent.ERROR_NO_DATA_AVAILABLE);
            return;
        }
        AXIModel aXIModel = (AXIModel)propertyChangeEvent.getSource();
        this.show((AXIComponent)aXIModel.getRoot());
    }

    private AXIModel getAXIModel(DataObject dataObject) {
        try {
            SchemaModelCookie schemaModelCookie = (SchemaModelCookie)dataObject.getCookie(SchemaModelCookie.class);
            if (schemaModelCookie == null) {
                return null;
            }
            AXIModel aXIModel = AXIModelFactory.getDefault().getModel((SchemaModel)schemaModelCookie.getModel());
            if (aXIModel != null) {
                aXIModel.removePropertyChangeListener((PropertyChangeListener)((Object)this));
                aXIModel.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            return aXIModel;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.redraw();
    }
}

