/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import javax.swing.Action;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.ConnectAction;
import org.netbeans.modules.db.mysql.DatabaseModel;
import org.netbeans.modules.db.mysql.ServerInstance;
import org.netbeans.modules.db.mysql.Utils;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class DatabaseNode
extends AbstractNode
implements Comparable {
    private static final String ICON_BASE = "org/netbeans/modules/db/mysql/resources/database.gif";
    private final DatabaseModel model;

    public DatabaseNode(DatabaseModel databaseModel) {
        super(Children.LEAF);
        this.model = databaseModel;
        this.setDisplayName(databaseModel.getDisplayName());
        this.setShortDescription(databaseModel.getShortDescription());
        this.setIconBaseWithExtension(ICON_BASE);
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return super.getActions(bl);
        }
        return new SystemAction[]{SystemAction.get(ConnectAction.class), SystemAction.get(DeleteAction.class)};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        ServerInstance serverInstance = this.model.getServer();
        String string = this.model.getDbName();
        try {
            serverInstance.dropDatabase(string);
        }
        catch (DatabaseException databaseException) {
            String string2 = NbBundle.getMessage(DatabaseNode.class, (String)"MSG_ErrorDeletingDatabase", (Object)this.model.getDbName());
            Utils.displayError(string2, (Exception)((Object)databaseException));
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == DatabaseModel.class) {
            return this.model;
        }
        return super.getCookie(clazz);
    }

    public int compareTo(Object object) {
        Node node = (Node)object;
        return this.getDisplayName().compareTo(node.getDisplayName());
    }
}

