/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class DriverClassLoader
extends URLClassLoader {
    private static Logger LOGGER = Logger.getLogger(DriverClassLoader.class.getName());

    public DriverClassLoader(JDBCDriver jDBCDriver) {
        super(new URL[0]);
        URL[] uRLArray;
        for (URL uRL : uRLArray = jDBCDriver.getURLs()) {
            if ("nbinst".equals(uRL.getProtocol())) {
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                if (fileObject == null) {
                    LOGGER.log(Level.WARNING, "Unable to find file object for driver url " + uRL);
                    continue;
                }
                URL uRL2 = URLMapper.findURL((FileObject)fileObject, (int)1);
                if (uRL2 == null) {
                    LOGGER.log(Level.WARNING, "Unable to get file url for nbinst url " + uRL);
                    continue;
                }
                super.addURL(uRL2);
                continue;
            }
            super.addURL(uRL);
        }
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        permissions.setReadOnly();
        return permissions;
    }

    public String toString() {
        return "DbURLClassLoader[urls=" + Arrays.asList(this.getURLs()) + "]";
    }
}

