/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteCookie;
import org.netbeans.modules.db.mysql.DatabaseModel;
import org.netbeans.modules.db.mysql.DatabaseUser;
import org.netbeans.modules.db.mysql.DatabaseUtils;
import org.netbeans.modules.db.mysql.ExecSupport;
import org.netbeans.modules.db.mysql.MySQLOptions;
import org.netbeans.modules.db.mysql.Utils;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInstance
implements Node.Cookie {
    private State state = State.DISCONNECTED;
    private String displayName;
    private RequestProcessor.Task refreshTask;
    private static final Logger LOGGER = Logger.getLogger(ServerInstance.class.getName());
    private static ServerInstance DEFAULT;
    private static final MySQLOptions OPTIONS;
    private static final String GET_DATABASES_SQL = "SHOW DATABASES";
    private static final String GET_USERS_SQL = "SELECT DISTINCT user, host FROM mysql.user";
    private static final String CREATE_DATABASE_SQL = "CREATE DATABASE ";
    private static final String DROP_DATABASE_SQL = "DROP DATABASE ";
    private static final String GRANT_ALL_SQL_1 = "GRANT ALL ON ";
    private static final String GRANT_ALL_SQL_2 = ".* TO ?@?";
    private static final String MODULE_JAR_FILE = "modules/org-netbeans-modules-db-mysql.jar";
    private static final String RESOURCE_DIR_PATH = "org/netbeans/modules/db/mysql/resources";
    final AdminConnection adminConn = new AdminConnection();
    final ArrayList<ChangeListener> listeners = new ArrayList();
    private String adminPassword;
    HashMap<String, DatabaseModel> databases = new HashMap();

    public static synchronized ServerInstance getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new ServerInstance();
        }
        return DEFAULT;
    }

    private ServerInstance() {
        this.updateDisplayName();
    }

    private synchronized void startRefreshTask() {
        final long l = OPTIONS.getRefreshThreadSleepInterval();
        this.refreshTask = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Thread.currentThread().setName("MySQL Server Refresh Thread");
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(l);
                            if (!OPTIONS.isProviderRegistered() || !ServerInstance.this.isConnected()) continue;
                            ServerInstance.this.refreshDatabaseList();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    catch (DatabaseException databaseException) {
                        LOGGER.log(Level.INFO, null, databaseException);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    private synchronized void stopRefreshTask() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
    }

    public static boolean isSampleName(String string) {
        SampleName[] sampleNameArray;
        for (SampleName sampleName : sampleNameArray = SampleName.values()) {
            if (!sampleName.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void createSample(String string, DatabaseConnection databaseConnection) throws DatabaseException {
        if (!ServerInstance.isSampleName(string)) {
            throw new DatabaseException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_NoSuchSample", (Object)string));
        }
        DataObject dataObject = this.getSQLDataObject(string);
        try {
            if (!DatabaseUtils.ensureConnected(databaseConnection)) {
                return;
            }
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            openCookie.open();
            SQLExecuteCookie sQLExecuteCookie = (SQLExecuteCookie)dataObject.getCookie(SQLExecuteCookie.class);
            sQLExecuteCookie.setDatabaseConnection(databaseConnection);
            sQLExecuteCookie.execute();
        }
        catch (Exception exception) {
            DatabaseException databaseException = new DatabaseException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_ErrorExecutingSampleSQL", (Object)string, (Object)exception.getMessage()));
            databaseException.initCause((Throwable)exception);
            throw databaseException;
        }
        finally {
            CloseCookie closeCookie;
            if (dataObject != null && (closeCookie = (CloseCookie)dataObject.getCookie(CloseCookie.class)) != null) {
                closeCookie.close();
            }
        }
    }

    private DataObject getSQLDataObject(String string) throws DatabaseException {
        Object var2_2 = null;
        try {
            File file = InstalledFileLocator.getDefault().locate(MODULE_JAR_FILE, null, false);
            JarFileSystem jarFileSystem = new JarFileSystem();
            jarFileSystem.setJarFile(file);
            String string2 = "/create-" + string + ".sql";
            FileObject fileObject = jarFileSystem.findResource(RESOURCE_DIR_PATH + string2);
            return DataObject.find((FileObject)fileObject);
        }
        catch (Exception exception) {
            DatabaseException databaseException = new DatabaseException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_ErrorLoadingSampleSQL", (Object)string, (Object)exception.getMessage()));
            databaseException.initCause((Throwable)exception);
            throw databaseException;
        }
    }

    public String getHost() {
        return Utils.isEmpty(OPTIONS.getHost()) ? MySQLOptions.getDefaultHost() : OPTIONS.getHost();
    }

    public void setHost(String string) {
        OPTIONS.setHost(string);
    }

    public String getPort() {
        return OPTIONS.getPort();
    }

    public void setPort(String string) {
        OPTIONS.setPort(string);
    }

    public String getUser() {
        return OPTIONS.getAdminUser();
    }

    public void setUser(String string) {
        OPTIONS.setAdminUser(string);
    }

    public synchronized String getPassword() {
        if (this.adminPassword != null) {
            return this.adminPassword;
        }
        return OPTIONS.getAdminPassword();
    }

    public synchronized void setPassword(String string) {
        String string2 = this.adminPassword = string == null ? "" : string;
        if (this.isSavePassword()) {
            OPTIONS.setAdminPassword(string);
        }
    }

    public boolean isSavePassword() {
        return OPTIONS.isSavePassword();
    }

    public void setSavePassword(boolean bl) {
        OPTIONS.setSavePassword(bl);
        OPTIONS.setAdminPassword(this.getPassword());
    }

    public String getAdminPath() {
        return OPTIONS.getAdminPath();
    }

    public void setAdminPath(String string) {
        OPTIONS.setAdminPath(string);
    }

    public String getStartPath() {
        return OPTIONS.getStartPath();
    }

    public void setStartPath(String string) {
        OPTIONS.setStartPath(string);
    }

    public String getStopPath() {
        return OPTIONS.getStopPath();
    }

    public void setStopPath(String string) {
        OPTIONS.setStopPath(string);
    }

    public String getStopArgs() {
        return OPTIONS.getStopArgs();
    }

    public void setStopArgs(String string) {
        OPTIONS.setStopArgs(string);
    }

    public String getStartArgs() {
        return OPTIONS.getStartArgs();
    }

    public void setStartArgs(String string) {
        OPTIONS.setStartArgs(string);
    }

    public String getAdminArgs() {
        return OPTIONS.getAdminArgs();
    }

    public void setAdminArgs(String string) {
        OPTIONS.setAdminArgs(string);
    }

    public boolean isAdminCommandsConfirmed() {
        return OPTIONS.isAdminCommandsConfirmed();
    }

    public void setAdminCommandsConfirmed(boolean bl) {
        OPTIONS.setAdminCommandsConfirmed(bl);
    }

    public boolean isConnected() {
        return this.getState().equals((Object)State.CONNECTED);
    }

    public synchronized String getDisplayName() {
        return this.displayName;
    }

    private synchronized void setDisplayName(String string) {
        this.displayName = string;
    }

    private synchronized void updateDisplayName() {
        String string = this.state == State.CONNECTED ? "LBL_ServerDisplayName" : (this.state == State.DISCONNECTED ? "LBL_ServerNotConnectedDisplayName" : "LBL_ServerConnectingDisplayName");
        this.setDisplayName(NbBundle.getMessage(ServerInstance.class, (String)string, (Object)this.getHostPort(), (Object)this.getUser()));
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ServerInstance.class, (String)"LBL_ServerShortDescription", (Object)this.getHostPort(), (Object)this.getUser());
    }

    private String getHostPort() {
        String string = this.getPort();
        string = Utils.isEmpty(string) ? "" : ":" + string;
        return this.getHost() + string;
    }

    public String getURL() {
        return DatabaseUtils.getURL(this.getHost(), this.getPort());
    }

    public String getURL(String string) {
        return DatabaseUtils.getURL(this.getHost(), this.getPort(), string);
    }

    private synchronized void setState(State state) {
        this.state = state;
        this.updateDisplayName();
        if (state == State.CONNECTED) {
            this.startRefreshTask();
        } else if (state == State.DISCONNECTED) {
            this.stopRefreshTask();
        }
        this.notifyChange();
    }

    public synchronized State getState() {
        return this.state;
    }

    private void notifyChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDatabaseList() throws DatabaseException {
        try {
            ServerInstance serverInstance = this;
            synchronized (serverInstance) {
                this.databases = new HashMap();
                if (this.isConnected()) {
                    ResultSet resultSet = this.adminConn.getConnection().prepareStatement(GET_DATABASES_SQL).executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        this.databases.put(string, new DatabaseModel(this, string));
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
        finally {
            this.notifyChange();
        }
    }

    public synchronized Collection<DatabaseModel> getDatabases() throws DatabaseException {
        if (this.databases == null) {
            this.refreshDatabaseList();
        }
        return this.databases.values();
    }

    public synchronized void connect() throws DatabaseException {
        this.setState(State.CONNECTING);
        try {
            this.adminConn.reconnect();
            this.setState(State.CONNECTED);
        }
        catch (DatabaseException databaseException) {
            this.setState(State.DISCONNECTED);
            throw databaseException;
        }
        finally {
            this.refreshDatabaseList();
        }
    }

    public synchronized void disconnect() {
        this.adminConn.disconnect();
        this.setState(State.DISCONNECTED);
        try {
            this.refreshDatabaseList();
        }
        catch (DatabaseException databaseException) {
            LOGGER.log(Level.FINE, null, databaseException);
        }
    }

    public synchronized void reconnect() throws DatabaseException {
        this.disconnect();
        this.connect();
    }

    public void connectAsync() {
        this.connectAsync(false);
    }

    public synchronized void connectAsync(boolean bl) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DatabaseUtils.class, (String)"MSG_ConnectingToServer"));
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        this.postConnect(progressHandle, bl);
    }

    private void postConnect(final ProgressHandle progressHandle, final boolean bl) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    ServerInstance.this.connect();
                    progressHandle.finish();
                }
                catch (DatabaseException databaseException) {
                    String string = NbBundle.getMessage(DatabaseUtils.class, (String)"MSG_UnableToConnect");
                    if (!bl) {
                        ServerInstance.this.postPropertiesDialog(progressHandle, string, databaseException);
                    } else {
                        LOGGER.log(Level.INFO, string);
                        progressHandle.finish();
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, null, throwable);
                    progressHandle.finish();
                }
            }
        });
    }

    private void postPropertiesDialog(final ProgressHandle progressHandle, final String string, final DatabaseException databaseException) {
        final ServerInstance serverInstance = this;
        Mutex.EVENT.postReadRequest(new Runnable(){

            public void run() {
                Utils.displayError(string, (Exception)((Object)databaseException));
                PropertiesDialog propertiesDialog = new PropertiesDialog(serverInstance);
                if (propertiesDialog.displayDialog()) {
                    ServerInstance.this.postConnect(progressHandle, false);
                } else {
                    progressHandle.finish();
                }
            }
        });
    }

    public boolean databaseExists(String string) throws DatabaseException {
        this.refreshDatabaseList();
        return this.databases.containsKey(string);
    }

    public void createDatabase(String string) throws DatabaseException {
        try {
            this.adminConn.getConnection().prepareStatement(CREATE_DATABASE_SQL + string).executeUpdate();
            this.refreshDatabaseList();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
    }

    public void dropDatabase(String string) throws DatabaseException {
        try {
            this.adminConn.getConnection().prepareStatement(DROP_DATABASE_SQL + string).executeUpdate();
            this.deleteConnections(string);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
        finally {
            this.refreshDatabaseList();
        }
    }

    private void deleteConnections(String string) throws DatabaseException {
        List<DatabaseConnection> list = DatabaseUtils.findDatabaseConnections(this.getURL(string));
        for (DatabaseConnection databaseConnection : list) {
            ConnectionManager.getDefault().removeConnection(databaseConnection);
        }
    }

    public List<DatabaseUser> getUsers() throws DatabaseException {
        ArrayList<DatabaseUser> arrayList = new ArrayList<DatabaseUser>();
        Connection connection = this.adminConn.getConnection();
        if (connection == null) {
            return arrayList;
        }
        try {
            ResultSet resultSet = connection.prepareStatement(GET_USERS_SQL).executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1).trim();
                String string2 = resultSet.getString(2).trim();
                arrayList.add(new DatabaseUser(string, string2));
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
        return arrayList;
    }

    public void grantFullDatabaseRights(String string, DatabaseUser databaseUser) throws DatabaseException {
        try {
            PreparedStatement preparedStatement = this.adminConn.getConnection().prepareStatement(GRANT_ALL_SQL_1 + string + GRANT_ALL_SQL_2);
            preparedStatement.setString(1, databaseUser.getUser());
            preparedStatement.setString(2, databaseUser.getHost());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
    }

    public void start() throws DatabaseException {
        if (!Utils.isValidExecutable(this.getStopPath(), false)) {
            throw new DatabaseException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_InvalidStartCommand"));
        }
        try {
            this.runProcess(this.getStartPath(), this.getStartArgs(), true, NbBundle.getMessage(ServerInstance.class, (String)"LBL_StartOutputTab"));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    long l = 300000L;
                    for (long i = 0L; i < l; i += 1000L) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        try {
                            ServerInstance.this.reconnect();
                            return;
                        }
                        catch (DatabaseException databaseException) {
                            continue;
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
    }

    public void stop() throws DatabaseException {
        if (!Utils.isValidExecutable(this.getStopPath(), false)) {
            throw new DatabaseException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_InvalidStopCommand"));
        }
        try {
            this.runProcess(this.getStopPath(), this.getStopArgs(), true, NbBundle.getMessage(ServerInstance.class, (String)"LBL_AdminOutputTab"));
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
        this.disconnect();
    }

    public void startAdmin() throws DatabaseException {
        String string = this.getAdminPath();
        if (string == null || string.length() == 0) {
            throw new DatabaseException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_AdminCommandNotSet"));
        }
        if (Utils.isValidURL(string, false)) {
            this.launchBrowser(string);
        } else if (Utils.isValidExecutable(string, false)) {
            this.runProcess(string, this.getAdminArgs(), true, NbBundle.getMessage(ServerInstance.class, (String)"LBL_AdminOutputTab"));
        } else {
            throw new DatabaseException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_InvalidAdminCommand", (Object)string));
        }
    }

    private void runProcess(String string, String string2, boolean bl, String string3) throws DatabaseException {
        if (Utilities.isMac() && string.endsWith(".app")) {
            string2 = "\"" + string + "\" " + string2;
            string = "/usr/bin/open";
        }
        try {
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string, string2);
            Process process = nbProcessDescriptor.exec();
            if (bl) {
                new ExecSupport().displayProcessOutputs(process, string3);
            }
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
    }

    private void launchBrowser(String string) throws DatabaseException {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(string));
        }
        catch (Exception exception) {
            throw new DatabaseException((Throwable)exception);
        }
    }

    void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    static {
        OPTIONS = MySQLOptions.getDefault();
    }

    class AdminConnection {
        private Connection conn;

        private AdminConnection() {
        }

        synchronized Connection getConnection() throws DatabaseException {
            try {
                if (this.conn == null || this.conn.isClosed()) {
                    this.reconnect();
                }
            }
            catch (SQLException sQLException) {
                throw new DatabaseException((Throwable)sQLException);
            }
            return this.conn;
        }

        synchronized void disconnect() {
            DatabaseUtils.closeConnection(this.conn);
            this.conn = null;
        }

        synchronized void reconnect() throws DatabaseException {
            this.conn = null;
            this.conn = DatabaseUtils.connect(ServerInstance.this.getURL(), ServerInstance.this.getUser(), ServerInstance.this.getPassword());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SampleName {
        sample,
        vir,
        travel;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CONNECTED,
        CONNECTING,
        DISCONNECTED;

    }
}

