/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.db.api.explorer.NodeProvider;
import org.netbeans.modules.db.mysql.MySQLOptions;
import org.netbeans.modules.db.mysql.ServerInstance;
import org.netbeans.modules.db.mysql.ServerNode;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNodeProvider
implements NodeProvider {
    private static final ServerNodeProvider DEFAULT = new ServerNodeProvider();
    private static final MySQLOptions options = MySQLOptions.getDefault();
    private final ArrayList<Node> nodes = new ArrayList();
    private static final ArrayList<Node> emptyNodeList = new ArrayList();
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

    public static ServerNodeProvider getDefault() {
        return DEFAULT;
    }

    private ServerNodeProvider() {
        this.nodes.add((Node)ServerNode.create(ServerInstance.getDefault()));
    }

    public List<Node> getNodes() {
        if (options.isProviderRegistered()) {
            ServerInstance.getDefault().connectAsync(true);
            return this.nodes;
        }
        return emptyNodeList;
    }

    public synchronized void setRegistered(boolean bl) {
        boolean bl2 = this.isRegistered();
        if (bl != bl2) {
            ServerInstance serverInstance = ServerInstance.getDefault();
            options.setProviderRegistered(bl);
            if (!bl) {
                serverInstance.disconnect();
            } else {
                serverInstance.connectAsync(true);
            }
            this.notifyChange();
        }
    }

    public synchronized boolean isRegistered() {
        return options.isProviderRegistered();
    }

    void notifyChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

