/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.db.mysql.MySQLOptions;
import org.netbeans.modules.db.mysql.ServerInstance;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BasePropertiesPanel
extends JPanel {
    MySQLOptions options = MySQLOptions.getDefault();
    DialogDescriptor descriptor;
    private Color nbErrorForeground;
    private DocumentListener docListener = new DocumentListener(){

        public void removeUpdate(DocumentEvent documentEvent) {
            BasePropertiesPanel.this.validatePanel();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BasePropertiesPanel.this.validatePanel();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BasePropertiesPanel.this.validatePanel();
        }
    };
    private JCheckBox chkSavePassword;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel messageLabel;
    private JTextField txtHost;
    private JPasswordField txtPassword;
    private JTextField txtPort;
    private JTextField txtUser;

    public void validatePanel() {
        if (this.descriptor == null) {
            return;
        }
        String string = null;
        if (this.getHost() == null || this.getHost().equals("")) {
            string = NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.MSG_SpecifyHost");
        }
        if (this.getUser() == null || this.getUser().equals("")) {
            string = NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.MSG_SpecifyUser");
        }
        if (string != null) {
            this.messageLabel.setText(string);
            this.descriptor.setValid(false);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    public BasePropertiesPanel(ServerInstance serverInstance) {
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.txtUser.getDocument().addDocumentListener(this.docListener);
        this.txtHost.getDocument().addDocumentListener(this.docListener);
        String string = serverInstance.getUser();
        if (string == null || string.equals("")) {
            string = MySQLOptions.getDefaultAdminUser();
        }
        this.txtUser.setText(string);
        String string2 = serverInstance.getHost();
        if (string2 == null || string2.equals("")) {
            string2 = MySQLOptions.getDefaultHost();
        }
        this.txtHost.setText(string2);
        String string3 = serverInstance.getPort();
        if (string3 == null || string3.equals("")) {
            string3 = MySQLOptions.getDefaultPort();
        }
        this.txtPort.setText(string3);
        this.txtPassword.setText(serverInstance.getPassword());
        this.chkSavePassword.setSelected(serverInstance.isSavePassword());
    }

    String getHost() {
        return this.txtHost.getText().trim();
    }

    String getPassword() {
        return new String(this.txtPassword.getPassword()).trim();
    }

    String getPort() {
        return this.txtPort.getText().trim();
    }

    String getUser() {
        return this.txtUser.getText().trim();
    }

    boolean getSavePassword() {
        return this.chkSavePassword.isSelected();
    }

    void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        this.validatePanel();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.chkSavePassword = new JCheckBox();
        this.txtHost = new JTextField();
        this.txtPort = new JTextField();
        this.txtUser = new JTextField();
        this.txtPassword = new JPasswordField();
        this.messageLabel = new JLabel();
        this.setAutoscrolls(true);
        this.jLabel1.setLabelFor(this.txtHost);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.txtPort);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.jLabel2.text"));
        this.jLabel3.setLabelFor(this.txtUser);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.jLabel3.text"));
        this.jLabel4.setLabelFor(this.txtPassword);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkSavePassword, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.chkSavePassword.text"));
        this.chkSavePassword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasePropertiesPanel.this.chkSavePasswordActionPerformed(actionEvent);
            }
        });
        this.txtHost.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtHost.text"));
        this.txtHost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasePropertiesPanel.this.txtHostActionPerformed(actionEvent);
            }
        });
        this.txtPort.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPort.text"));
        this.txtUser.setText(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtUser.text"));
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.messageLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(52, 52, 52).add((Component)this.chkSavePassword)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.txtPassword, -1, 216, Short.MAX_VALUE).add((Component)this.txtHost, -1, 216, Short.MAX_VALUE).add((Component)this.txtPort, -1, 216, Short.MAX_VALUE).add((Component)this.txtUser, -1, 216, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.messageLabel, -1, 386, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jLabel2).add(11, 11, 11).add((Component)this.jLabel3)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.txtHost, -2, -1, -2).addPreferredGap(0).add((Component)this.txtPort, -2, -1, -2).addPreferredGap(0).add((Component)this.txtUser, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.txtPassword, -2, -1, -2)).addPreferredGap(1).add((Component)this.chkSavePassword).addPreferredGap(1).add((Component)this.messageLabel).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4, this.txtHost, this.txtPort, this.txtUser}, 2);
        this.chkSavePassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.chkSavePassword.AccessibleContext.accessibleDescription"));
        this.txtHost.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtHost.AccessibleContext.accessibleDescription"));
        this.txtPort.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPort.AccessibleContext.accessibleDescription"));
        this.txtUser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtUser.AccessibleContext.accessibleDescription"));
        this.txtPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasePropertiesPanel.class, (String)"BasePropertiesPanel.txtPassword.AccessibleContext.accessibleDescription"));
    }

    private void txtHostActionPerformed(ActionEvent actionEvent) {
    }

    private void chkSavePasswordActionPerformed(ActionEvent actionEvent) {
    }
}

