/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.model;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JAXBGenSourceClassPathProvider
implements ClassPathProvider {
    private static final String JAXB_GEN_SRC_ROOT = "build/generated/addons/jaxb";
    private Project project;
    private ClassPath sourceCP;
    private ClassPath compileCP;
    private ClassPath bootCP;

    JAXBGenSourceClassPathProvider(Project project) {
        this.project = project;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        FileObject fileObject2 = this.project.getProjectDirectory().getFileObject(JAXB_GEN_SRC_ROOT);
        if (fileObject2 != null && (fileObject.equals(fileObject2) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            if ("classpath/source".equals(string)) {
                if (this.sourceCP == null) {
                    this.sourceCP = this.getClassPath("classpath/source");
                }
                return this.sourceCP;
            }
            if ("classpath/compile".equals(string)) {
                if (this.compileCP == null) {
                    this.compileCP = this.getClassPath("classpath/compile");
                }
                return this.compileCP;
            }
            if ("classpath/boot".equals(string)) {
                if (this.bootCP == null) {
                    this.bootCP = this.getClassPath("classpath/boot");
                }
                return this.bootCP;
            }
        }
        return null;
    }

    private ClassPath getClassPath(String string) {
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray.length > 0) {
            return ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)string);
        }
        return null;
    }
}

