/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.explorer;

import java.awt.Image;
import java.io.CharConversionException;
import java.util.EventListener;
import javax.swing.Action;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.BrokenDataSourceSupport;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.DataSourceResolver;
import org.netbeans.modules.visualweb.dataconnectivity.explorer.ProjectDataSourceNodeChildren;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourceTracker;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourcesChangeEvent;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourcesListener;
import org.netbeans.modules.visualweb.dataconnectivity.utils.ImportDataSource;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;

public class ProjectDataSourceNode
extends AbstractNode
implements Node.Cookie,
ProjectDataSourcesListener,
ConnectionListener {
    Project nbProject = null;
    private static Image brokenDsReferenceBadge = Utilities.loadImage((String)"org/netbeans/modules/visualweb/dataconnectivity/resources/disconnected.png");
    private static Image dSContainerImage = Utilities.loadImage((String)"org/netbeans/modules/visualweb/dataconnectivity/resources/datasource_container.png");

    public ProjectDataSourceNode(Project project) {
        super((Children)new ProjectDataSourceNodeChildren(project));
        this.nbProject = project;
        ConnectionManager.getDefault().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)((Object)this), (Object)ConnectionManager.getDefault()));
        this.initPuppy();
    }

    protected void addListener() {
        ProjectDataSourceTracker.addListener(this.nbProject, this);
    }

    protected void removeListener() {
        ProjectDataSourceTracker.refreshDataSources(this.nbProject);
        ProjectDataSourceTracker.removeListener(this.nbProject, this);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == ProjectDataSourceNode.class) {
            return this;
        }
        return super.getCookie(clazz);
    }

    private void initPuppy() {
        this.setIconBaseWithExtension("org/netbeans/modules/visualweb/dataconnectivity/resources/datasource_container.png");
        this.setName(NbBundle.getMessage(ProjectDataSourceNode.class, (String)"PROJECT_DATA_SOURCES"));
        this.setDisplayName(NbBundle.getMessage(ProjectDataSourceNode.class, (String)"PROJECT_DATA_SOURCES"));
        this.setShortDescription(NbBundle.getMessage(ProjectDataSourceNode.class, (String)"PROJECT_DATA_SOURCES"));
        this.setValue("propertiesHelpID", "projrave_ui_elements_project_nav_node_prop_sheets_data_source_node_props");
        this.addListener();
    }

    public Action[] getActions(boolean bl) {
        return new Action[0];
    }

    public Project getNbProject() {
        return this.nbProject;
    }

    public Image getIcon(int n) {
        String string = super.getDisplayName();
        try {
            string = XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        if (ImportDataSource.isLegacyProject(this.nbProject) && JsfProjectUtils.getProjectProperty((Project)this.nbProject, (String)"migrated").equals("")) {
            DataSourceResolver.getInstance().modelProjectForDataSources(this.nbProject);
        }
        boolean bl = false;
        if (this.getChildren().getNodes().length > 0) {
            bl = BrokenDataSourceSupport.isBroken(this.nbProject);
        }
        if (bl) {
            Image image = Utilities.mergeImages((Image)dSContainerImage, (Image)brokenDsReferenceBadge, (int)8, (int)0);
            if (ImportDataSource.isLegacyProject(this.nbProject)) {
                ImportDataSource.showAlert();
            }
            return image;
        }
        return dSContainerImage;
    }

    public String getHtmlDisplayName() {
        String string = super.getDisplayName();
        try {
            string = XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        boolean bl = false;
        if (this.getChildren().getNodes().length > 0) {
            bl = BrokenDataSourceSupport.isBroken(this.nbProject);
        }
        return bl ? "<font color=\"#A40000\">" + string + "</font>" : null;
    }

    public void dataSourcesChange(ProjectDataSourcesChangeEvent projectDataSourcesChangeEvent) {
        this.fireIconChange();
        this.fireDisplayNameChange(null, null);
    }

    public void connectionsChanged() {
        this.fireIconChange();
        this.fireDisplayNameChange(null, null);
    }
}

