/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedJdbcResource;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedResource;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.CurrentProject;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.DataSourceResolver;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfo;
import org.netbeans.modules.visualweb.dataconnectivity.model.ProjectDataSourceManager;
import org.netbeans.modules.visualweb.dataconnectivity.naming.DatabaseSettingsImporter;
import org.netbeans.modules.visualweb.dataconnectivity.project.datasource.ProjectDataSourceTracker;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DataSourceExport;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DataSourceImport;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSource;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSourceAlias;
import org.netbeans.modules.visualweb.dataconnectivity.utils.ImportDataSource;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.services.DesignTimeDataSourceService;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class DesignTimeDataSourceHelper {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.modules.visualweb.dataconnectivity.sql.Bundle", Locale.getDefault());
    private volatile boolean firstTimeShowAlert = false;
    private static final String DS_SUBCTX = "java:comp/env/jdbc";
    private static final String ROOT_TAG = "dataSources";
    private static final String ATTR_MAJ_VER = "majVer";
    private static final String ATTR_MIN_VER = "minVer";
    private static final String DATASOURCE_TAG = "dataSource";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DRIVER = "driverClassName";
    private static final String ATTR_URL = "url";
    private static final String ATTR_USERNAME = "username";
    private static final String ATTR_PASSWORD = "password";
    private static final String ATTR_QUERY = "validationQuery";
    private static final String ATTR_REFERENCES = "references";
    private DesignTimeDataSource[] dataSources = null;
    private String[] dataSourceNames = null;
    private boolean isDataSourceAdded = false;
    private Context ctx = new InitialContext();

    public DataSourceExport[] getDataSourceExports() throws NamingException {
        this.getDataSources();
        ArrayList<DataSourceExport> arrayList = new ArrayList<DataSourceExport>();
        for (int i = 0; i < this.dataSources.length; ++i) {
            DataSourceExport dataSourceExport;
            DesignTimeDataSource designTimeDataSource = this.dataSources[i];
            if (!(designTimeDataSource instanceof DesignTimeDataSourceAlias)) {
                dataSourceExport = new DataSourceExport(this.dataSourceNames[i], designTimeDataSource.getDriverClassName(), designTimeDataSource.getUrl(), designTimeDataSource.getUsername(), designTimeDataSource.getPassword(), designTimeDataSource.getValidationQuery());
                arrayList.add(dataSourceExport);
                continue;
            }
            dataSourceExport = new DataSourceExport(this.dataSourceNames[i], ((DesignTimeDataSourceAlias)designTimeDataSource).getAlias());
            arrayList.add(dataSourceExport);
        }
        return arrayList.toArray(new DataSourceExport[0]);
    }

    public static void writeExportDocument(OutputStream outputStream, DataSourceExport[] dataSourceExportArray) throws IOException {
        outputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes("UTF-8"));
        outputStream.write("<dataSources majVer=\"1\" minVer=\"0\">\n".getBytes("UTF-8"));
        for (int i = 0; i < dataSourceExportArray.length; ++i) {
            DataSourceExport dataSourceExport = dataSourceExportArray[i];
            if (!dataSourceExport.isExportable()) continue;
            outputStream.write(("    <dataSource name=\"" + DesignTimeDataSource.escapeXML(dataSourceExport.getName()) + "\"\n").getBytes("UTF-8"));
            if (dataSourceExport.isAlias()) {
                outputStream.write(("        references=\"" + DesignTimeDataSource.escapeXML(dataSourceExport.getAlias()) + "\"\n").getBytes("UTF-8"));
            } else {
                if (dataSourceExport.getDriverClassName() != null) {
                    outputStream.write(("        driverClassName=\"" + dataSourceExport.getDriverClassName() + "\"\n").getBytes("UTF-8"));
                }
                if (dataSourceExport.getUrl() != null) {
                    outputStream.write(("        url=\"" + DesignTimeDataSource.escapeXML(dataSourceExport.getUrl()) + "\"\n").getBytes("UTF-8"));
                }
                if (dataSourceExport.getValidationQuery() != null) {
                    outputStream.write(("        validationQuery=\"" + DesignTimeDataSource.escapeXML(dataSourceExport.getValidationQuery()) + "\"\n").getBytes("UTF-8"));
                }
                if (dataSourceExport.isUsernameExportable()) {
                    if (dataSourceExport.getUsername() != null) {
                        outputStream.write(("        username=\"" + dataSourceExport.getUsername() + "\"\n").getBytes("UTF-8"));
                    }
                    if (dataSourceExport.isPasswordExportable() && dataSourceExport.getPassword() != null) {
                        outputStream.write(("        password=\"" + DesignTimeDataSource.encryptPassword(dataSourceExport.getPassword()) + "\"\n").getBytes("UTF-8"));
                    }
                }
            }
            outputStream.write("    />\n".getBytes("UTF-8"));
        }
        outputStream.write("</dataSources>\n".getBytes("UTF-8"));
    }

    public static DataSourceImport[] getDataSourceImports(InputStream inputStream) throws IOException, SAXException {
        final ArrayList arrayList = new ArrayList();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, new DefaultHandler(){

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    if (string3.equals(DesignTimeDataSourceHelper.ROOT_TAG)) {
                        String string4 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_MAJ_VER);
                        String string5 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_MIN_VER);
                        if (string4 == null || string5 == null || !string4.equals("1") || !string5.equals("0")) {
                            throw new SAXException(MessageFormat.format(rb.getString("ONLY_VER_MAJ_MIN"), "1", "0"));
                        }
                    } else if (string3.equals(DesignTimeDataSourceHelper.DATASOURCE_TAG)) {
                        String string6 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_REFERENCES);
                        String string7 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_NAME);
                        if (string6 == null) {
                            String string8 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_DRIVER);
                            String string9 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_URL);
                            String string10 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_USERNAME);
                            String string11 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_PASSWORD);
                            if (string11 != null) {
                                string11 = DesignTimeDataSource.decryptPassword(string11);
                            }
                            String string12 = attributes.getValue(DesignTimeDataSourceHelper.ATTR_QUERY);
                            if (string7 == null) {
                                throw new SAXException(rb.getString("MISSING_NAME_ATTRIBUTE"));
                            }
                            if (string8 == null) {
                                throw new SAXException(rb.getString("MISSING_DRIVER_CLASS_NAME_ATTRIBUTE"));
                            }
                            if (string9 == null) {
                                throw new SAXException(rb.getString("MISSING_URL_ATTRIBUTE"));
                            }
                            try {
                                arrayList.add(new DataSourceImport(DesignTimeDataSourceHelper.makeUnique(string7), string8, string9, string10, string11, string12));
                            }
                            catch (NamingException namingException) {
                                throw new SAXException(namingException);
                            }
                        } else {
                            arrayList.add(new DataSourceImport(string7, string6));
                        }
                    } else {
                        throw new SAXNotRecognizedException(string3);
                    }
                }

                public void endElement(String string, String string2, String string3) throws SAXException {
                    if (!string3.equals(DesignTimeDataSourceHelper.ROOT_TAG) && !string3.equals(DesignTimeDataSourceHelper.DATASOURCE_TAG)) {
                        throw new SAXNotRecognizedException(string3);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList.toArray(new DataSourceImport[0]);
    }

    private static String makeUnique(String string) throws NamingException {
        String string2 = string;
        int n = 0;
        try {
            while (true) {
                new InitialContext().lookup(string2);
                string2 = string + ++n;
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            return string2;
        }
    }

    public int importDataSources(DataSourceImport[] dataSourceImportArray) throws NamingException {
        int n = 0;
        for (int i = 0; i < dataSourceImportArray.length; ++i) {
            DataSourceImport dataSourceImport = dataSourceImportArray[i];
            if (!dataSourceImport.isImportable()) continue;
            this.addFullNameDataSource(dataSourceImport.getName(), dataSourceImport.getDriverClassName(), dataSourceImport.getUrl(), dataSourceImport.getValidationQuery(), dataSourceImport.getUsername(), dataSourceImport.getPassword());
            ++n;
        }
        this.refresh();
        return n;
    }

    public String[] getDataSourceNames() throws NamingException {
        if (this.dataSourceNames == null) {
            this.getDataSources();
        }
        return this.dataSourceNames;
    }

    public DesignTimeDataSource[] getDataSources() throws NamingException {
        if (this.dataSources == null) {
            ArrayList arrayList = this.getAllDataSourceBindings();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(((Binding)arrayList.get(i)).getObject());
                arrayList3.add(((Binding)arrayList.get(i)).getName());
            }
            this.dataSources = arrayList2.toArray(new DesignTimeDataSource[0]);
            this.dataSourceNames = arrayList3.toArray(new String[0]);
        }
        return this.dataSources;
    }

    public ArrayList getAllDataSourceBindings() throws NamingException {
        return this.getNamesAndDataSources(this.ctx, DS_SUBCTX, "");
    }

    public ArrayList getNamesAndDataSources(Context context, String string, String string2) throws NamingException {
        String string3 = null;
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        NamingEnumeration<Binding> namingEnumeration = context.listBindings(string);
        while (namingEnumeration.hasMore()) {
            Binding binding = namingEnumeration.next();
            String string4 = binding.getName();
            if (binding.isRelative()) {
                string4 = string + "/" + string4;
            }
            string3 = string4.substring(string4.lastIndexOf("/") + 1);
            if (binding.getObject() instanceof DesignTimeDataSource) {
                String string5 = ("".equals(string2) ? "" : string2 + "/") + string3;
                arrayList.add(new Binding(string5, (DesignTimeDataSource)binding.getObject()));
                continue;
            }
            if (!(binding.getObject() instanceof Context)) continue;
            arrayList.addAll(this.getNamesAndDataSources((Context)binding.getObject(), "", string2 + ("".equals(string2) ? "" : "/") + string3));
        }
        namingEnumeration.close();
        return arrayList;
    }

    public DesignTimeDataSource getDataSource(String string) throws NamingException {
        return this.getDataSourceFromFullName("java:comp/env/jdbc/" + string);
    }

    public DesignTimeDataSource getDataSourceFromFullName(String string) throws NamingException {
        Object object = this.ctx.lookup(string);
        if (object instanceof DesignTimeDataSource) {
            return (DesignTimeDataSource)object;
        }
        throw new NamingException(MessageFormat.format(rb.getString("NOT_A_DATASOURCE"), string));
    }

    public DesignTimeDataSource addDataSource(String string, String string2, String string3, String string4, String string5, String string6) throws NamingException {
        this.isDataSourceAdded = true;
        return this.addFullNameDataSource("java:comp/env/jdbc/" + string, string2, string3, string4, string5, string6);
    }

    public DesignTimeDataSource addFullNameDataSource(String string, String string2, String string3, String string4, String string5, String string6) throws NamingException {
        DesignTimeDataSource designTimeDataSource = new DesignTimeDataSource(null, false, string2, string3, string4, string5, string6);
        return this.addFullNameDataSource(string, designTimeDataSource);
    }

    public DesignTimeDataSource addFullNameDataSource(String string, DesignTimeDataSource designTimeDataSource) throws NamingException {
        try {
            this.ctx.bind(string, (Object)designTimeDataSource);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw nameAlreadyBoundException;
        }
        catch (NamingException namingException) {
            CompositeName compositeName = new CompositeName(string);
            String string2 = "";
            for (int i = 0; i < compositeName.size() - 1; ++i) {
                string2 = string2 + compositeName.get(i);
                try {
                    this.ctx.createSubcontext(string2);
                }
                catch (NameAlreadyBoundException nameAlreadyBoundException) {
                    // empty catch block
                }
                string2 = string2 + "/";
            }
            this.ctx.bind(string, (Object)designTimeDataSource);
        }
        this.refresh();
        return designTimeDataSource;
    }

    public void deleteDataSource(String string) throws NamingException {
        String string2 = "java:comp/env/jdbc/" + string;
        this.ctx.unbind(string2);
        String[] stringArray = string.split("/");
        if (stringArray.length > 1) {
            int n;
            ArrayList arrayList;
            for (int i = stringArray.length - 2; i >= 0 && (arrayList = this.getNamesAndDataSources(this.ctx, string2 = string2.substring(0, n = string2.lastIndexOf("/")), "")).size() <= 0; --i) {
                this.ctx.unbind(string2);
            }
        }
        this.refresh();
    }

    public boolean nameInUseInContext(String string) {
        String string2 = "java:comp/env/jdbc/" + string;
        try {
            Object object = this.ctx.lookup(string2);
            return true;
        }
        catch (NamingException namingException) {
            if (!(namingException instanceof NameNotFoundException)) {
                return true;
            }
            String[] stringArray = string.split("/");
            for (int i = stringArray.length - 2; i >= 0; --i) {
                int n = string2.lastIndexOf("/");
                string2 = string2.substring(0, n);
                try {
                    Object object = this.ctx.lookup(string2);
                    if (object instanceof Context) continue;
                    return true;
                }
                catch (NamingException namingException2) {
                    if (namingException2 instanceof NameNotFoundException) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public void save() throws NamingException {
        this.ctx.addToEnvironment("save-context", "true");
    }

    public void refresh() {
        this.dataSources = null;
        this.dataSourceNames = null;
    }

    public Map updateDataSource(Project project) throws NamingException {
        HashMap<String, DesignTimeDataSource> hashMap;
        block10: {
            Object object;
            if (ImportDataSource.isLegacyProject(project) && JsfProjectUtils.getProjectProperty((Project)project, (String)"migrated").equals("")) {
                DataSourceResolver.getInstance().updateSettings();
                JsfProjectUtils.createProjectProperty((Project)project, (String)"migrated", (String)"true");
            }
            String[] stringArray = ProjectDataSourceTracker.getDynamicDataSources(project);
            String[] stringArray2 = ProjectDataSourceTracker.getHardcodedDataSources(project);
            ArrayList<RequestedResource> arrayList = new ArrayList<RequestedResource>();
            RequestedJdbcResource requestedJdbcResource = null;
            Object var6_6 = null;
            hashMap = new HashMap<String, DesignTimeDataSource>();
            ProjectDataSourceManager projectDataSourceManager = new ProjectDataSourceManager(project);
            if (stringArray.length <= 0 && stringArray2.length <= 0) break block10;
            for (String object2 : stringArray) {
                requestedJdbcResource = projectDataSourceManager.getDataSourceWithName(object2.substring(object2.lastIndexOf("/") + 1));
                if (requestedJdbcResource == null) continue;
                arrayList.add((RequestedResource)requestedJdbcResource);
            }
            for (String string : stringArray2) {
                requestedJdbcResource = projectDataSourceManager.getDataSourceWithName(string.substring(string.lastIndexOf("/") + 1));
                if (requestedJdbcResource == null) continue;
                arrayList.add((RequestedResource)requestedJdbcResource);
            }
            DatabaseSettingsImporter.getInstance().updateWebXml(project, arrayList);
            if (requestedJdbcResource == null) {
                object = null;
                DataSourceInfo dataSourceInfo22 = null;
                DesignTimeDataSourceService designTimeDataSourceService = null;
                for (String string : stringArray) {
                    List<DataSourceInfo> list = DatabaseSettingsImporter.getInstance().getDataSourcesInfo();
                    for (DataSourceInfo dataSourceInfo22 : list) {
                        if (string.equals("java:comp/env/jdbc/VIR") && dataSourceInfo22.getUrl().equals("jdbc:derby://localhost:1527/sample")) {
                            hashMap.put(string, new DesignTimeDataSource(null, false, dataSourceInfo22.getDriverClassName(), "jdbc:derby://localhost:1527/vir", null, dataSourceInfo22.getUsername(), dataSourceInfo22.getPassword()));
                            designTimeDataSourceService = (DesignTimeDataSourceService)Lookup.getDefault().lookup(DesignTimeDataSourceService.class);
                            designTimeDataSourceService.updateProjectDataSource(project, new RequestedJdbcResource("jdbc/VIR", dataSourceInfo22.getDriverClassName(), "jdbc:derby://localhost:1527/vir", dataSourceInfo22.getUsername(), dataSourceInfo22.getPassword()));
                            continue;
                        }
                        if (!string.equals("java:comp/env/jdbc/" + dataSourceInfo22.getName())) continue;
                        hashMap.put(string, new DesignTimeDataSource(null, false, dataSourceInfo22.getDriverClassName(), dataSourceInfo22.getUrl(), null, dataSourceInfo22.getUsername(), dataSourceInfo22.getPassword()));
                        designTimeDataSourceService = (DesignTimeDataSourceService)Lookup.getDefault().lookup(DesignTimeDataSourceService.class);
                        designTimeDataSourceService.updateProjectDataSource(project, new RequestedJdbcResource("jdbc/" + dataSourceInfo22.getName(), dataSourceInfo22.getDriverClassName(), dataSourceInfo22.getUrl(), dataSourceInfo22.getUsername(), dataSourceInfo22.getPassword()));
                    }
                }
            } else {
                object = arrayList.iterator();
                int n = 0;
                while (object.hasNext()) {
                    requestedJdbcResource = (RequestedJdbcResource)object.next();
                    String string = requestedJdbcResource.getResourceName();
                    string = string.substring(string.indexOf("/") + 1);
                    n = 0;
                    if (string.equals("java:comp/env/jdbc/VIR") && requestedJdbcResource.getUrl().equals("jdbc:derby://localhost:1527/sample")) {
                        hashMap.put(string, new DesignTimeDataSource(null, false, requestedJdbcResource.getDriverClassName(), "jdbc:derby://localhost:1527/vir", null, requestedJdbcResource.getUsername(), requestedJdbcResource.getPassword()));
                        continue;
                    }
                    if (n != 0) continue;
                    hashMap.put("java:comp/env/jdbc/" + string, new DesignTimeDataSource(null, false, requestedJdbcResource.getDriverClassName(), requestedJdbcResource.getUrl(), null, requestedJdbcResource.getUsername(), requestedJdbcResource.getPassword()));
                }
            }
        }
        return hashMap;
    }

    public boolean dataSourceAdded() {
        return this.isDataSourceAdded;
    }

    public void updateCtxBindings(Map map) {
        Iterator iterator = map.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.ctx.bind(string, map.get(string));
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
    }

    public boolean datasourcesInProject(Project project) {
        String[] stringArray = ProjectDataSourceTracker.getDynamicDataSources(project);
        String[] stringArray2 = ProjectDataSourceTracker.getHardcodedDataSources(project);
        return stringArray.length > 0 || stringArray2.length > 0;
    }

    public static DataSourceInfo getDsInfo(String string) {
        ProjectDataSourceManager projectDataSourceManager = new ProjectDataSourceManager(CurrentProject.getInstance().getOpenedProject());
        RequestedJdbcResource requestedJdbcResource = null;
        try {
            requestedJdbcResource = projectDataSourceManager.getDataSourceWithName(string);
        }
        catch (NamingException namingException) {
            Exceptions.printStackTrace((Throwable)namingException);
        }
        return new DataSourceInfo(string, requestedJdbcResource.getDriverClassName(), requestedJdbcResource.getUrl(), null, requestedJdbcResource.getUsername(), requestedJdbcResource.getPassword());
    }

    public static boolean isFound(DataSourceInfo dataSourceInfo) {
        boolean bl = false;
        if (dataSourceInfo != null) {
            String string = dataSourceInfo.getUrl();
            String string2 = dataSourceInfo.getUsername();
            DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
            for (int i = 0; i < databaseConnectionArray.length; ++i) {
                DatabaseConnection databaseConnection = databaseConnectionArray[i];
                String string3 = databaseConnection.getDatabaseURL();
                String string4 = databaseConnection.getUser();
                if (!DesignTimeDataSourceHelper.matchURL(string, string3, true) || !Utilities.compareObjects((Object)string2, (Object)string4)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isFound(DesignTimeDataSource designTimeDataSource) {
        boolean bl = false;
        if (designTimeDataSource != null) {
            String string = designTimeDataSource.getUrl();
            String string2 = designTimeDataSource.getUsername();
            DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
            for (int i = 0; i < databaseConnectionArray.length; ++i) {
                DatabaseConnection databaseConnection = databaseConnectionArray[i];
                String string3 = databaseConnection.getDatabaseURL();
                String string4 = databaseConnection.getUser();
                if (!DesignTimeDataSourceHelper.matchURL(string, string3, true) || !Utilities.compareObjects((Object)string2, (Object)string4)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private static boolean matchURL(String string, String string2, boolean bl) {
        String string3;
        if (bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.contains("derby") && (string3 = string.substring(0, string.lastIndexOf(":")) + string.substring(string.lastIndexOf("/"))).equals(string2)) {
            return true;
        }
        int n = 0;
        if (string != null && string2 != null) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = string2.toCharArray();
            for (int i = 0; i < cArray.length - 1; ++i) {
                if (cArray[i] != cArray2[i] && cArray[i] == ':') {
                    n = 1;
                    continue;
                }
                if (cArray[i + n] == cArray2[i]) continue;
                return false;
            }
        }
        return true;
    }
}

