/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.nodes;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.visualweb.api.designerapi.DesignerServiceHack;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedEjbResource;
import org.netbeans.modules.visualweb.ejb.EjbRefMaintainer;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.util.Util;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbLibReferenceHelper {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String TIMESTAMP_ATTR = "Generated-time-in-millies";
    private static final String EJB_REFS_XML = "ejb-refs.xml";

    public static Project getActiveProject() {
        FileObject fileObject = DesignerServiceHack.getDefault().getCurrentFile();
        if (fileObject == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public static void updateEjbGroupForProjects(Project[] projectArray, EjbGroup ejbGroup) throws IOException, ConfigurationException {
        for (int i = 0; i < projectArray.length; ++i) {
            Project project = projectArray[i];
            if (!JsfProjectUtils.isJsfProject((Project)project)) continue;
            EjbLibReferenceHelper.updateEjbGroupForProject(ejbGroup, project);
        }
    }

    public static void syncArchiveRefs(Project[] projectArray) {
        for (int i = 0; i < projectArray.length; ++i) {
            if (!JsfProjectUtils.isJsfProject((Project)projectArray[i])) continue;
            try {
                FileObject fileObject = projectArray[i].getProjectDirectory().getFileObject("lib/ejb-sources");
                if (fileObject == null) continue;
                String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
                EjbRefMaintainer ejbRefMaintainer = new EjbRefMaintainer(string + File.separator + EJB_REFS_XML);
                Collection collection = ejbRefMaintainer.getRefferedEjbGroups();
                if (collection == null) {
                    return;
                }
                Iterator iterator = collection.iterator();
                while (iterator != null && iterator.hasNext()) {
                    EjbGroup ejbGroup = (EjbGroup)iterator.next();
                    EjbGroup ejbGroup2 = EjbDataModel.getInstance().findEjbGroupForClientWrapperJar(Util.getFileName(ejbGroup.getClientWrapperBeanJar()));
                    if (ejbGroup2 == null) continue;
                    EjbLibReferenceHelper.updateEjbGroupForProjects(new Project[]{projectArray[i]}, ejbGroup2);
                }
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                iOException.printStackTrace();
                continue;
            }
            catch (ConfigurationException configurationException) {
                ErrorManager.getDefault().notify((Throwable)configurationException);
                configurationException.printStackTrace();
            }
        }
    }

    private static FileObject getProjectEjbDataDir(Project project) throws IOException {
        FileObject fileObject = JsfProjectUtils.getProjectLibraryDirectory((Project)project);
        FileObject fileObject2 = fileObject.getFileObject("ejb-sources");
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder("ejb-sources");
        }
        return fileObject2;
    }

    private static void addRefsToProject(Project project, String string, List<FileObject> list, String ... stringArray) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>(stringArray.length);
        for (String string2 : stringArray) {
            FileObject fileObject = EjbLibReferenceHelper.findFileObject(list, string2);
            if (fileObject == null) continue;
            arrayList.add(new URL(fileObject.getURL().toExternalForm() + "/"));
        }
        Object[] objectArray = arrayList.toArray(new URL[arrayList.size()]);
        if (string != null) {
            JsfProjectUtils.addRootReferences((Project)project, (URL[])objectArray, (String)string);
        } else {
            JsfProjectUtils.addRootReferences((Project)project, (URL[])objectArray);
        }
    }

    private static FileObject findFileObject(List<FileObject> list, String string) {
        String string2 = new File(string).getName();
        for (FileObject fileObject : list) {
            if (!fileObject.getNameExt().equals(string2)) continue;
            return fileObject;
        }
        return null;
    }

    private static ArrayList<FileObject> addUpdateJarsForProject(Project project, final ArrayList<String> arrayList) throws IOException {
        final FileObject fileObject = EjbLibReferenceHelper.getProjectEjbDataDir(project);
        final ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>(arrayList.size());
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                for (String string : arrayList) {
                    FileObject fileObject4;
                    String string2;
                    FileObject fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
                    if (fileObject2 == null) continue;
                    String string3 = fileObject2.getName();
                    FileObject fileObject3 = fileObject.getFileObject(string3, string2 = fileObject2.getExt());
                    if (fileObject3 == null) {
                        fileObject4 = FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject, (String)string3);
                        arrayList2.add(fileObject4);
                        continue;
                    }
                    if (!EjbLibReferenceHelper.isJarUpToDate(fileObject3, fileObject2)) {
                        fileObject3.delete();
                        fileObject4 = FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject, (String)string3);
                        arrayList2.add(fileObject4);
                        continue;
                    }
                    arrayList2.add(fileObject3);
                }
            }
        });
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isJarUpToDate(FileObject fileObject, FileObject fileObject2) {
        if (fileObject.getSize() != fileObject2.getSize()) {
            return false;
        }
        ZipFile zipFile = null;
        ZipFile zipFile2 = null;
        try {
            File file = FileUtil.toFile((FileObject)fileObject);
            File file2 = FileUtil.toFile((FileObject)fileObject2);
            zipFile = new JarFile(file, false);
            zipFile2 = new JarFile(file2, false);
            ZipEntry zipEntry = ((JarFile)zipFile).getEntry(MANIFEST_PATH);
            ZipEntry zipEntry2 = ((JarFile)zipFile2).getEntry(MANIFEST_PATH);
            if (zipEntry == null && zipEntry2 == null) {
                boolean bl = true;
                return bl;
            }
            if (zipEntry == null || zipEntry2 == null) {
                boolean bl = false;
                return bl;
            }
            Manifest manifest = new Manifest(((JarFile)zipFile).getInputStream(zipEntry));
            Manifest manifest2 = new Manifest(((JarFile)zipFile2).getInputStream(zipEntry2));
            String string = manifest.getMainAttributes().getValue(TIMESTAMP_ATTR);
            String string2 = manifest2.getMainAttributes().getValue(TIMESTAMP_ATTR);
            if (string == null && string2 == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = string != null && string2 != null && string.equals(string2);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    Util.getLogger().log(Level.WARNING, "Unable to close jar file: " + zipFile.getName(), iOException);
                }
            }
            if (zipFile2 != null) {
                try {
                    zipFile2.close();
                }
                catch (IOException iOException) {
                    Util.getLogger().log(Level.WARNING, "Unable to close jar file: " + zipFile2.getName(), iOException);
                }
            }
        }
    }

    public static void addToEjbRefXmlToProject(Project project, EjbGroup ejbGroup) {
        try {
            FileObject fileObject = JsfProjectUtils.getProjectLibraryDirectory((Project)project);
            FileObject fileObject2 = fileObject.getFileObject("ejb-sources");
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder("ejb-sources");
            }
            String string = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
            EjbGroup ejbGroup2 = (EjbGroup)ejbGroup.clone();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : ejbGroup.getClientJarFiles()) {
                arrayList.add(string + "/" + new File(string2).getName());
            }
            ejbGroup2.setClientJarFiles(arrayList);
            ejbGroup2.setClientWrapperBeanJar(string + "/" + new File(ejbGroup.getClientWrapperBeanJar()).getName());
            ejbGroup2.setDesignInfoJar(string + "/" + new File(ejbGroup.getDesignInfoJar()).getName());
            EjbRefMaintainer ejbRefMaintainer = new EjbRefMaintainer(string + File.separator + EJB_REFS_XML);
            ejbRefMaintainer.addToEjbRefXml(ejbGroup2);
        }
        catch (IOException iOException) {
            Util.getLogger().log(Level.WARNING, "Failed to save ejb refs", iOException);
        }
    }

    private static void addToDeploymentDescriptors(Project project, EjbGroup ejbGroup) throws IOException, ConfigurationException {
        SunAppServerHack sunAppServerHack = SunAppServerHack.getInstance(project);
        for (EjbInfo ejbInfo : ejbGroup.getSessionBeans()) {
            SunWebApp sunWebApp;
            String string = ejbInfo.getWebEjbRef();
            String string2 = ejbInfo.getBeanTypeName();
            String string3 = ejbInfo.getHomeInterfaceName();
            String string4 = "corbaname:iiop:" + ejbGroup.getServerHost() + ":" + ejbGroup.getIIOPPort() + "#" + ejbInfo.getJNDIName();
            if (ejbGroup.isWebsphereAppServer()) {
                string4 = "corbaname:iiop:" + ejbGroup.getServerHost() + ":" + ejbGroup.getIIOPPort() + "/NameServiceServerRoot#" + ejbInfo.getJNDIName();
            }
            String string5 = ejbInfo.getCompInterfaceName();
            RequestedEjbResource requestedEjbResource = new RequestedEjbResource(string, string4, string2, string3, string5);
            JsfProjectUtils.setEjbReference((Project)project, (RequestedEjbResource)requestedEjbResource);
            if (sunAppServerHack != null) {
                sunWebApp = sunAppServerHack.getSunWebApp();
                EjbRef ejbRef = EjbLibReferenceHelper.findEjbRefByName(sunWebApp, string);
                if (ejbRef != null) {
                    ejbRef.setJndiName(string4);
                    continue;
                }
                ejbRef = sunWebApp.newEjbRef();
                ejbRef.setEjbRefName(string);
                ejbRef.setJndiName(string4);
                sunWebApp.addEjbRef(ejbRef);
                continue;
            }
            sunWebApp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            sunWebApp.getConfigSupport().bindEjbReference(string, string4);
        }
        if (sunAppServerHack != null) {
            sunAppServerHack.finish();
        }
    }

    public static void addEjbGroupToActiveProject(EjbGroup ejbGroup) throws IOException, ConfigurationException {
        Project project = EjbLibReferenceHelper.getActiveProject();
        if (project == null) {
            return;
        }
        EjbLibReferenceHelper.addEjbGroupJarsToProject(ejbGroup, project);
        EjbLibReferenceHelper.addToEjbRefXmlToProject(project, ejbGroup);
        EjbLibReferenceHelper.addToDeploymentDescriptors(project, ejbGroup);
    }

    private static void addEjbGroupJarsToProject(EjbGroup ejbGroup, Project project) throws IOException {
        String string = ejbGroup.getClientWrapperBeanJar();
        String string2 = ejbGroup.getDesignInfoJar();
        ArrayList arrayList = ejbGroup.getClientJarFiles();
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size() + 2);
        arrayList2.add(string);
        arrayList2.add(string2);
        arrayList2.addAll(arrayList);
        ArrayList<FileObject> arrayList3 = EjbLibReferenceHelper.addUpdateJarsForProject(project, arrayList2);
        EjbLibReferenceHelper.addRefsToProject(project, null, arrayList3, string);
        EjbLibReferenceHelper.addRefsToProject(project, "classpath/compile", arrayList3, string2);
        if (arrayList.size() > 0) {
            EjbLibReferenceHelper.addRefsToProject(project, null, arrayList3, arrayList.toArray(new String[arrayList.size()]));
        }
    }

    private static void updateEjbGroupForProject(EjbGroup ejbGroup, Project project) throws IOException, ConfigurationException {
        String string = ejbGroup.getClientWrapperBeanJar();
        String string2 = ejbGroup.getDesignInfoJar();
        ArrayList arrayList = ejbGroup.getClientJarFiles();
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size() + 2);
        arrayList2.add(string);
        arrayList2.add(string2);
        arrayList2.addAll(arrayList);
        EjbLibReferenceHelper.addUpdateJarsForProject(project, arrayList2);
        EjbLibReferenceHelper.addToDeploymentDescriptors(project, ejbGroup);
    }

    private static EjbRef findEjbRefByName(SunWebApp sunWebApp, String string) {
        EjbRef[] ejbRefArray;
        for (EjbRef ejbRef : ejbRefArray = sunWebApp.getEjbRef()) {
            if (!ejbRef.getEjbRefName().equals(string)) continue;
            return ejbRef;
        }
        return null;
    }

    private static class SunAppServerHack {
        private FileObject sunWebXml;
        private SunWebApp sunWebApp;

        private SunAppServerHack(FileObject fileObject) throws IOException {
            this.sunWebXml = fileObject;
            RootInterface rootInterface = DDProvider.getDefault().getDDRoot(fileObject);
            if (!(rootInterface instanceof SunWebApp)) {
                throw new IllegalStateException("Cannot process sun-web.xml");
            }
            this.sunWebApp = (SunWebApp)rootInterface;
        }

        public static SunAppServerHack getInstance(Project project) throws IOException {
            FileObject fileObject = SunAppServerHack.getSunWebXml(project);
            if (fileObject == null) {
                return null;
            }
            return new SunAppServerHack(fileObject);
        }

        private static FileObject getSunWebXml(Project project) {
            FileObject[] fileObjectArray;
            Lookup lookup = project.getLookup();
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
            for (FileObject fileObject : fileObjectArray = j2eeModuleProvider.getConfigurationFiles()) {
                if (!fileObject.getNameExt().equals("sun-web.xml")) continue;
                return fileObject;
            }
            return null;
        }

        public SunWebApp getSunWebApp() {
            return this.sunWebApp;
        }

        public void finish() throws IOException {
            this.sunWebApp.write(this.sunWebXml);
        }
    }
}

