/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.nodes;

import com.sun.rave.designtime.DisplayItem;
import com.sun.rave.designtime.impl.BasicBeanCreateInfo;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.nodes.EjbGroupNode;
import org.netbeans.modules.visualweb.ejb.nodes.EjbLibReferenceHelper;
import org.netbeans.modules.visualweb.ejb.nodes.SessionBeanNodeChildren;
import org.netbeans.modules.visualweb.ejb.util.Util;
import org.openide.ErrorManager;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class SessionBeanNode
extends AbstractNode
implements Node.Cookie {
    private EjbGroup ejbGroup;
    private EjbInfo ejbInfo;
    private static final DataFlavor FLAVOR_EJB_DISPLAY_ITEM = new DataFlavor("application/x-java-jvm-local-objectref; class=" + DisplayItem.class.getName(), "Ejb Display Item");

    public SessionBeanNode(EjbGroup ejbGroup, EjbInfo ejbInfo) {
        super((Children)new SessionBeanNodeChildren(ejbGroup, ejbInfo));
        this.ejbGroup = ejbGroup;
        this.ejbInfo = ejbInfo;
        this.setName(ejbInfo.getJNDIName());
        this.setDisplayName(ejbInfo.getJNDIName());
        this.setShortDescription(ejbInfo.getCompInterfaceName());
    }

    public Image getIcon(int n) {
        return Utilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/session_bean.png");
    }

    public Image getOpenedIcon(int n) {
        return Utilities.loadImage((String)"org/netbeans/modules/visualweb/ejb/resources/session_bean.png");
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(PropertiesAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_server_nav_ejb_node");
    }

    protected SessionBeanNodeChildren getSessionBeanNodeChildren() {
        return (SessionBeanNodeChildren)this.getChildren();
    }

    public EjbInfo getEjbInfo() {
        return this.ejbInfo;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("ejbInfo");
        if (set == null) {
            set = new Sheet.Set();
            set.setName("ejbInfo");
            set.setDisplayName(NbBundle.getMessage(SessionBeanNode.class, (String)"SESSION_BEAN_INFORMATION"));
            set.setShortDescription(NbBundle.getMessage(SessionBeanNode.class, (String)"SESSION_BEAN_INFORMATION"));
            sheet.put(set);
        }
        set.put((Node.Property)new PropertySupport.ReadOnly("beanType", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"EJB_TYPE"), NbBundle.getMessage(EjbGroupNode.class, (String)"EJB_TYPE")){

            public Object getValue() {
                switch (SessionBeanNode.this.ejbInfo.getBeanType()) {
                    case 2: {
                        return NbBundle.getMessage(EjbGroupNode.class, (String)"STATEFUL_EJB");
                    }
                    case 1: {
                        return NbBundle.getMessage(EjbGroupNode.class, (String)"STATELESS_EJB");
                    }
                }
                return NbBundle.getMessage(EjbGroupNode.class, (String)"STATELESS_EJB");
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("jndiName", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"JNDI_NAME"), NbBundle.getMessage(EjbGroupNode.class, (String)"JNDI_NAME")){

            public Object getValue() {
                return SessionBeanNode.this.ejbInfo.getJNDIName();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("webEjbRef", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"WEB_EJB_REF_NAME"), NbBundle.getMessage(EjbGroupNode.class, (String)"WEB_EJB_REF_NAME")){

            public Object getValue() {
                return SessionBeanNode.this.ejbInfo.getWebEjbRef();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("homeInterface", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"HOME_INTERFACE"), NbBundle.getMessage(EjbGroupNode.class, (String)"HOME_INTERFACE")){

            public Object getValue() {
                return SessionBeanNode.this.ejbInfo.getHomeInterfaceName();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("remoteInterface", String.class, NbBundle.getMessage(EjbGroupNode.class, (String)"REMOTE_INTERFACE"), NbBundle.getMessage(EjbGroupNode.class, (String)"REMOTE_INTERFACE")){

            public Object getValue() {
                return SessionBeanNode.this.ejbInfo.getCompInterfaceName();
            }
        });
        return sheet;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public Transferable clipboardCopy() {
        if (this.ejbGroup == null || this.ejbInfo == null) {
            try {
                return super.clipboardCopy();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        try {
            ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
            exTransferable.put(new ExTransferable.Single(FLAVOR_EJB_DISPLAY_ITEM){

                protected Object getData() {
                    return new EjbBeanCreateInfo(SessionBeanNode.this.ejbGroup, SessionBeanNode.this.ejbInfo);
                }
            });
            return exTransferable;
        }
        catch (Exception exception) {
            Util.getLogger().log(Level.SEVERE, "SessionBeanNode.clipboardCopy: Error", exception);
            return null;
        }
    }

    private static class EjbBeanCreateInfo
    extends BasicBeanCreateInfo {
        private final EjbGroup ejbGroup;
        private final EjbInfo ejbInfo;

        public EjbBeanCreateInfo(EjbGroup ejbGroup, EjbInfo ejbInfo) {
            this.ejbGroup = ejbGroup;
            this.ejbInfo = ejbInfo;
        }

        public String getBeanClassName() {
            try {
                EjbLibReferenceHelper.addEjbGroupToActiveProject(this.ejbGroup);
            }
            catch (Exception exception) {
                Util.getLogger().log(Level.SEVERE, "Unable to add EJB Set to Project", exception);
            }
            return this.ejbInfo.getBeanWrapperName();
        }

        public String getDisplayName() {
            return this.ejbInfo.getCompInterfaceName();
        }
    }
}

