/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.ui.ImportEjbDataSourcesHelper;
import org.netbeans.modules.visualweb.ejb.ui.ImportEjbDataSourcesPanel;
import org.netbeans.modules.visualweb.ejb.ui.ImportExportFileChooser;
import org.netbeans.modules.visualweb.ejb.ui.PortableEjbDataSource;
import org.netbeans.modules.visualweb.ejb.util.Util;
import org.netbeans.modules.visualweb.extension.openide.io.RaveFileCopy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ImportEjbDataSourcesDialog
implements ActionListener {
    private Dialog dialog;
    private JButton okButton;
    private JButton cancelButton;
    private ImportEjbDataSourcesPanel importPanel = new ImportEjbDataSourcesPanel();

    public ImportEjbDataSourcesDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.importPanel, NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"IMPORT_EJB_DATASOURCES"), true, (ActionListener)this);
        this.okButton = new JButton(NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"OK_BUTTON_LABEL"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("OK_BUTTON_DESC"));
        this.okButton.setMnemonic(NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"OK_BUTTON_MNEMONIC").charAt(0));
        this.cancelButton = new JButton(NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"CANCEL_BUTTON_LABEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("CANCEL_BUTTON_DESC"));
        this.cancelButton.setMnemonic(NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"CANCEL_BUTTON_MNEMONIC").charAt(0));
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setClosingOptions(new Object[]{this.cancelButton});
        dialogDescriptor.setHelpCtx(new HelpCtx("projrave_ui_elements_server_nav_import_ejb_db"));
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.setResizable(true);
    }

    public void showDialog() {
        ImportExportFileChooser importExportFileChooser = new ImportExportFileChooser(this.importPanel);
        String string = importExportFileChooser.getImportFile();
        if (string != null) {
            if (!new File(string).exists()) {
                String string2 = NbBundle.getMessage(ImportEjbDataSourcesPanel.class, (String)"IMPORT_FILE_NOT_FOUND", (Object)string);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            ImportExportFileChooser.setCurrentFilePath(string);
            this.importPanel.setImportFilePath(string);
            PortableEjbDataSource[] portableEjbDataSourceArray = ImportEjbDataSourcesHelper.readDataSourceImports(this.importPanel.getImportFilePath());
            if (portableEjbDataSourceArray == null || portableEjbDataSourceArray.length == 0) {
                String string3 = NbBundle.getMessage(ImportEjbDataSourcesPanel.class, (String)"NO_EJB_SET_FOR_IMPORT", (Object)string);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.importPanel.setEjbDataSources(portableEjbDataSourceArray);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            if (!this.importPanel.saveChange()) {
                return;
            }
            PortableEjbDataSource[] portableEjbDataSourceArray = this.importPanel.getEjbDataSources();
            boolean bl = true;
            for (int i = 0; i < portableEjbDataSourceArray.length; ++i) {
                if (!portableEjbDataSourceArray[i].isPortable()) continue;
                this.copyJars(portableEjbDataSourceArray[i].getEjbGroup());
                EjbDataModel.getInstance().addEjbGroup(portableEjbDataSourceArray[i].getEjbGroup());
                bl = false;
            }
            if (bl) {
                String string = NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"NO_IMPORT_SELECTION");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.dialog.dispose();
        }
    }

    private void copyJars(EjbGroup ejbGroup) {
        try {
            String string;
            String string22;
            String string3 = Util.getEjbStateDir().getAbsolutePath() + File.separator + "ejb-datasource";
            for (String string22 : ejbGroup.getClientJarFiles()) {
                string = Util.getFileName(string22);
                RaveFileCopy.fileCopy((File)new File(string22), (File)new File(string3, string));
            }
            String string4 = ejbGroup.getClientWrapperBeanJar();
            string22 = Util.getFileName(string4);
            RaveFileCopy.fileCopy((File)new File(string4), (File)new File(string3, string22));
            string = ejbGroup.getDesignInfoJar();
            String string5 = Util.getFileName(string);
            RaveFileCopy.fileCopy((File)new File(string), (File)new File(string3, string5));
            ejbGroup.fixJarDir(string3);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }
}

