/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.openide.ErrorManager;

public class JarExploder {
    private boolean classOnly = false;

    public JarExploder() {
        this(false);
    }

    public JarExploder(boolean bl) {
        this.classOnly = bl;
    }

    public static ArrayList getAllClasses(String string) throws FileNotFoundException, IOException {
        try {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            ZipFile zipFile = new ZipFile(string);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                hashMap.put(((ZipEntry)object).getName(), new Integer((int)((ZipEntry)object).getSize()));
            }
            zipFile.close();
            object = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            Object var8_12 = null;
            Object var9_13 = null;
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                int n = (int)zipEntry.getSize();
                if (n == -1) {
                    n = (Integer)hashMap.get(zipEntry.getName());
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                    n2 += n3;
                }
                if (!zipEntry.getName().endsWith(".class")) continue;
                int n4 = zipEntry.getName().indexOf(46);
                arrayList.add(zipEntry.getName().substring(0, n4).replace('/', '.'));
            }
            return arrayList;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = "Error occurred when trying to explode jar file. Cannot find file " + string;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.util.JarExploder").log(65536, string2);
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            String string3 = "Error occurred when trying to explode jar file. Cannot read file " + string;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.util.JarExploder").log(65536, string3);
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public void explodeJar(String string, String string2) throws FileNotFoundException, IOException {
        try {
            Object object;
            ZipFile zipFile = new ZipFile(string2);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                hashMap.put(((ZipEntry)object).getName(), new Integer((int)((ZipEntry)object).getSize()));
            }
            zipFile.close();
            object = new FileInputStream(string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            Object var9_13 = null;
            Object var10_14 = null;
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                int n = (int)zipEntry.getSize();
                if (n == -1) {
                    n = (Integer)hashMap.get(zipEntry.getName());
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                    n2 += n3;
                }
                if (this.classOnly && (!this.classOnly || !zipEntry.getName().endsWith(".class"))) continue;
                this.saveFile(string, zipEntry.getName(), byArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "Error occurred when trying to explode jar file. Cannot find file " + string2;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.util.JarExploder").log(65536, string3);
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            String string4 = "Error occurred when trying to explode jar file. Cannot read file " + string2;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.util.JarExploder").log(65536, string4);
            iOException.printStackTrace();
            throw iOException;
        }
    }

    private String saveFile(String string, String string2, byte[] byArray) throws FileNotFoundException, IOException {
        File file = new File(string, string2);
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            fileOutputStream.close();
            return file.getAbsolutePath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "Error occurred when trying to save file. Cannot find file " + file.getAbsolutePath();
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.DeploymentDescriptorExtractor").log(65536, string3);
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            String string4 = "Error occurred when trying to save file. Cannot write to file " + file.getAbsolutePath();
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.DeploymentDescriptorExtractor").log(65536, string4);
            iOException.printStackTrace();
            throw iOException;
        }
    }
}

