/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectConfigurations;
import org.netbeans.modules.javawebstart.ui.customizer.JWSCustomizerPanel;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JWSCompositeCategoryProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String CAT_WEBSTART = "WebStart";
    private String catName = null;
    private static JWSProjectProperties jwsProps = null;

    public JWSCompositeCategoryProvider(String string) {
        this.catName = string;
    }

    public ProjectCustomizer.Category createCategory(Lookup lookup) {
        ResourceBundle resourceBundle = NbBundle.getBundle(JWSCompositeCategoryProvider.class);
        ProjectCustomizer.Category category = null;
        if (CAT_WEBSTART.equals(this.catName)) {
            category = ProjectCustomizer.Category.create((String)CAT_WEBSTART, (String)resourceBundle.getString("LBL_Category_WebStart"), null, null);
        }
        return category;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
        String string = category.getName();
        JWSCustomizerPanel jWSCustomizerPanel = null;
        if (CAT_WEBSTART.equals(string)) {
            jwsProps = new JWSProjectProperties(lookup);
            category.setStoreListener((ActionListener)new SavePropsListener(jwsProps, (Project)lookup.lookup(Project.class)));
            jWSCustomizerPanel = new JWSCustomizerPanel(jwsProps);
        }
        return jWSCustomizerPanel;
    }

    public static JWSCompositeCategoryProvider createWebStart() {
        return new JWSCompositeCategoryProvider(CAT_WEBSTART);
    }

    private static class SavePropsListener
    implements ActionListener {
        private JWSProjectProperties jwsProps;
        private Project j2seProject;

        public SavePropsListener(JWSProjectProperties jWSProjectProperties, Project project) {
            this.jwsProps = jWSProjectProperties;
            this.j2seProject = project;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.jwsProps.store();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            ProjectConfigurationProvider projectConfigurationProvider = (ProjectConfigurationProvider)this.j2seProject.getLookup().lookup(ProjectConfigurationProvider.class);
            try {
                if (this.jwsProps.isJWSEnabled()) {
                    J2SEProjectConfigurations.createConfigurationFiles((Project)this.j2seProject, (String)"JWS_generated", (Properties)this.prepareSharedProps(), null);
                    this.setActiveConfig(projectConfigurationProvider, NbBundle.getBundle(JWSCompositeCategoryProvider.class).getString("LBL_Category_WebStart"));
                    this.copyTemplate(this.j2seProject);
                    this.modifyBuildXml(this.j2seProject);
                } else {
                    this.setActiveConfig(projectConfigurationProvider, NbBundle.getBundle(JWSCompositeCategoryProvider.class).getString("LBL_Category_Default"));
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        private void setActiveConfig(final ProjectConfigurationProvider projectConfigurationProvider, String string) throws IOException {
            Collection collection = projectConfigurationProvider.getConfigurations();
            for (final ProjectConfiguration projectConfiguration : collection) {
                if (!string.equals(projectConfiguration.getDisplayName())) continue;
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            projectConfigurationProvider.setActiveConfiguration(projectConfiguration);
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    throw (IOException)mutexException.getException();
                }
            }
        }

        private void copyTemplate(Project project) throws IOException {
            FileSystem fileSystem;
            FileObject fileObject;
            FileObject fileObject2 = project.getProjectDirectory();
            FileObject fileObject3 = fileObject2.getFileObject("nbproject/jnlp-impl.xml");
            if (fileObject3 == null && (fileObject = (fileSystem = Repository.getDefault().getDefaultFileSystem()).findResource("Templates/JWS/jnlp-impl.xml")) != null) {
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2.getFileObject("nbproject"), (String)"jnlp-impl");
            }
        }

        private void modifyBuildXml(Project project) throws IOException {
            Object object;
            int n;
            Element element;
            FileObject fileObject = project.getProjectDirectory();
            final FileObject fileObject2 = fileObject.getFileObject("build.xml");
            File file = FileUtil.toFile((FileObject)fileObject2);
            Document document = null;
            try {
                document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
            FileObject fileObject3 = fileObject.getFileObject("nbproject/jnlp-impl.xml");
            AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
            if (antBuildExtender != null) {
                assert (fileObject3 != null);
                if (antBuildExtender.getExtension("jws") == null) {
                    element = antBuildExtender.addExtension("jws", fileObject3);
                    element.addDependency("jar", "jnlp");
                }
                ProjectManager.getDefault().saveProject(project);
            } else {
                Logger.getLogger(JWSCompositeCategoryProvider.class.getName()).log(Level.INFO, "Trying to include JWS build snippet in project type that doesn't support AntBuildExtender API contract.");
            }
            element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("target");
            Element element2 = null;
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = (Element)nodeList.item(n);
                if (object.getAttribute("name") == null || !"-post-jar".equals(object.getAttribute("name"))) continue;
                element2 = object;
                break;
            }
            n = 0;
            if (element2 != null && element2.getAttribute("depends") != null && element2.getAttribute("depends").contains("jnlp")) {
                object = element2.getAttribute("depends");
                object = ((String)object).replaceAll("jnlp", "");
                object = ((String)object).replaceAll(",[\\s]*$", "");
                object = ((String)object).replaceAll("^[\\s]*,", "");
                object = ((String)object).replaceAll(",[\\s]*,", ",");
                if (((String)(object = ((String)object).trim())).length() == 0) {
                    element2.removeAttribute("depends");
                } else {
                    element2.setAttribute("depends", (String)object);
                }
                n = 1;
            }
            nodeList = element.getElementsByTagName("import");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                if (element3.getAttribute("file") == null || !"nbproject/jnlp-impl.xml".equals(element3.getAttribute("file"))) continue;
                element3.getParentNode().removeChild(element3);
                n = 1;
                break;
            }
            if (n != 0) {
                final Document document2 = document;
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Void run() throws Exception {
                            FileLock fileLock = fileObject2.lock();
                            try {
                                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                                try {
                                    XMLUtil.write((Document)document2, (OutputStream)outputStream, (String)"UTF-8");
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            finally {
                                fileLock.releaseLock();
                            }
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    throw (IOException)mutexException.getException();
                }
            }
        }

        private Properties prepareSharedProps() {
            Properties properties = new Properties();
            properties.setProperty("$label", NbBundle.getBundle(JWSCompositeCategoryProvider.class).getString("LBL_Category_WebStart"));
            properties.setProperty("$target.run", "jws-run");
            properties.setProperty("$target.debug", "jws-debug");
            return properties;
        }
    }
}

