/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.gdb.EditorContext;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.DebuggerBreakpointAnnotation;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.loaders.CppEditorSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class EditorContextImpl
extends EditorContext {
    private static String fronting = System.getProperty("netbeans.debugger.fronting");
    private PropertyChangeSupport pcs;
    private ChangeListener changedFilesListener;
    private Map timeStampToRegistry = new HashMap();
    private Set modifiedDataObjects;
    private PropertyChangeListener editorObservableListener;
    private Lookup.Result resDataObject;
    private Lookup.Result resEditorCookie;
    private Lookup.Result resNode;
    private Object currentLock = new Object();
    private String currentURL = null;
    private EditorCookie currentEditorCookie = null;
    private Logger log = Logger.getLogger("gdb.logger");

    public EditorContextImpl() {
        this.pcs = new PropertyChangeSupport(this);
        this.resDataObject = Utilities.actionsGlobalContext().lookup(new Lookup.Template(DataObject.class));
        this.resDataObject.addLookupListener((LookupListener)new EditorLookupListener(DataObject.class));
        this.resEditorCookie = Utilities.actionsGlobalContext().lookup(new Lookup.Template(EditorCookie.class));
        this.resEditorCookie.addLookupListener((LookupListener)new EditorLookupListener(EditorCookie.class));
        this.resNode = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Node.class));
        this.resNode.addLookupListener((LookupListener)new EditorLookupListener(Node.class));
    }

    public boolean showSource(String string, int n, Object object) {
        return this.showSource(EditorContextImpl.getDataObject(string), n, object);
    }

    public boolean showSource(DataObject dataObject, int n, Object object) {
        Line line = this.getLine(dataObject, n, object);
        if (line == null) {
            return false;
        }
        if (fronting != null) {
            if (fronting.equals("true")) {
                line.show(3);
            } else {
                line.show(2);
            }
            return true;
        }
        if (Utilities.isWindows()) {
            line.show(3);
        } else {
            line.show(2);
        }
        return true;
    }

    public void createTimeStamp(Object object) {
        this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        Registry registry = new Registry();
        this.timeStampToRegistry.put(object, registry);
        Iterator iterator = this.modifiedDataObjects.iterator();
        while (iterator.hasNext()) {
            registry.register((DataObject)iterator.next());
        }
        if (this.changedFilesListener == null) {
            this.changedFilesListener = new ChangedFilesListener();
            DataObject.getRegistry().addChangeListener(this.changedFilesListener);
        }
    }

    public void disposeTimeStamp(Object object) {
        this.timeStampToRegistry.remove(object);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
    }

    public Object annotate(String string, int n, String string2, Object object) {
        return this.annotate(EditorContextImpl.getDataObject(string), n, string2, object);
    }

    public Object annotate(DataObject dataObject, int n, String string, Object object) {
        Line line;
        GdbBreakpoint gdbBreakpoint = null;
        if (object instanceof GdbBreakpoint) {
            gdbBreakpoint = (GdbBreakpoint)((Object)object);
            object = null;
        }
        if ((line = this.getLine(dataObject, n, object)) == null) {
            return null;
        }
        Object object2 = gdbBreakpoint == null ? new DebuggerAnnotation(string, line) : new DebuggerBreakpointAnnotation(string, line, gdbBreakpoint);
        return object2;
    }

    public void removeAnnotation(Object object) {
        DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)object);
        debuggerAnnotation.detach();
    }

    public int getLineNumber(Object object, Object object2) {
        DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)object);
        if (object2 == null) {
            return debuggerAnnotation.getLine().getLineNumber() + 1;
        }
        DataObject dataObject = (DataObject)debuggerAnnotation.getLine().getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            Line.Set set = this.getLineSet(dataObject, object2);
            return set.getOriginalLineNumber(debuggerAnnotation.getLine()) + 1;
        }
        return -1;
    }

    public void updateTimeStamp(Object object, String string) {
        Registry registry = (Registry)this.timeStampToRegistry.get(object);
        registry.register(EditorContextImpl.getDataObject(string));
    }

    public int getCurrentLineNumber() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        return n + 1;
    }

    public int getMostRecentLineNumber() {
        EditorCookie editorCookie = this.getMostRecentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getMostRecentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentURL() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentURL == null || this.currentURL.length() == 0) {
                DataObject[] dataObjectArray = this.resDataObject.allInstances().toArray(new DataObject[0]);
                if (dataObjectArray.length != 1) {
                    this.currentURL = this.digForIt();
                } else {
                    DataObject dataObject = dataObjectArray[0];
                    if (dataObject instanceof DataShadow) {
                        dataObject = ((DataShadow)dataObject).getOriginal();
                    }
                    try {
                        this.currentURL = dataObject.getPrimaryFile().getURL().toString();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        this.currentURL = "";
                    }
                }
                if (Utilities.isWindows()) {
                    this.currentURL = this.currentURL.replace("\\", "/");
                }
            }
            return this.currentURL;
        }
    }

    private String digForIt() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        for (Object e : registry.getOpened()) {
            String string;
            CppEditorSupport.CppEditorComponent cppEditorComponent;
            if (!(e instanceof CppEditorSupport.CppEditorComponent) || !(cppEditorComponent = (CppEditorSupport.CppEditorComponent)e).isShowing()) continue;
            try {
                string = cppEditorComponent.getSupport().getDataObject().getPrimaryFile().getURL().toString();
            }
            catch (Exception exception) {
                continue;
            }
            return string;
        }
        return "";
    }

    public String getMostRecentURL() {
        Node[] nodeArray;
        String string = this.getCurrentURL();
        if (string.length() == 0 && (nodeArray = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                if (dataObject == null) continue;
                try {
                    string = dataObject.getPrimaryFile().getURL().toExternalForm();
                    break;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public String getCurrentFunctionName() {
        return "";
    }

    public String getSelectedFunctionName() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return "";
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return "";
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return "";
        }
        int n = jEditorPane.getCaret().getDot();
        Object var5_5 = null;
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        return "";
    }

    public int getFieldLineNumber(String string, String string2, String string3) {
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentMIMEType() {
        Object object = this.currentLock;
        synchronized (object) {
            FileObject fileObject;
            DataObject[] dataObjectArray = this.resDataObject.allInstances().toArray(new DataObject[0]);
            if (dataObjectArray.length != 1) {
                return "";
            }
            DataObject dataObject = dataObjectArray[0];
            if (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            String string = (fileObject = dataObject.getPrimaryFile()) != null ? fileObject.getMIMEType() : "";
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getCurrentDataObject() {
        Object object = this.currentLock;
        synchronized (object) {
            DataObject[] dataObjectArray = this.resDataObject.allInstances().toArray(new DataObject[0]);
            if (dataObjectArray.length != 1) {
                return null;
            }
            return dataObjectArray[0];
        }
    }

    public String getMostRecentMIMEType() {
        Node[] nodeArray;
        String string = this.getCurrentMIMEType();
        if (string.length() == 0 && (nodeArray = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                FileObject fileObject;
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                if (dataObject == null) continue;
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if ((fileObject = dataObject.getPrimaryFile()) == null) continue;
                string = fileObject.getMIMEType();
                break;
            }
        }
        return string;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private JEditorPane getCurrentEditor() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = EditorContextImpl.getOpenedPanes(editorCookie);
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    private JEditorPane getMostRecentEditor() {
        EditorCookie editorCookie = this.getMostRecentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = EditorContextImpl.getOpenedPanes(editorCookie);
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    public static JEditorPane[] getOpenedPanes(final EditorCookie editorCookie) {
        if (SwingUtilities.isEventDispatchThread()) {
            return editorCookie.getOpenedPanes();
        }
        final JEditorPane[][] jEditorPaneArray = new JEditorPane[1][1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    jEditorPaneArray[0] = editorCookie.getOpenedPanes();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify((Throwable)interruptedException);
        }
        return jEditorPaneArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditorCookie getCurrentEditorCookie() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentEditorCookie == null) {
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent != null) {
                    this.currentEditorCookie = (EditorCookie)topComponent.getLookup().lookup(EditorCookie.class);
                }
                if (this.currentEditorCookie instanceof EditorCookie.Observable) {
                    if (this.editorObservableListener == null) {
                        this.editorObservableListener = new EditorLookupListener(EditorCookie.Observable.class);
                    }
                    ((EditorCookie.Observable)this.currentEditorCookie).addPropertyChangeListener(this.editorObservableListener);
                }
            }
            return this.currentEditorCookie;
        }
    }

    private EditorCookie getMostRecentEditorCookie() {
        Node[] nodeArray;
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null && (nodeArray = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                editorCookie = (EditorCookie)nodeArray[i].getCookie(EditorCookie.class);
                if (editorCookie == null) continue;
                System.err.println("Got it!");
            }
        }
        return editorCookie;
    }

    private Line.Set getLineSet(DataObject dataObject, Object object) {
        Object object2;
        if (dataObject == null) {
            return null;
        }
        if (object != null) {
            object2 = (Registry)this.timeStampToRegistry.get(object);
            Line.Set set = null;
            try {
                set = ((Registry)object2).getLineSet(dataObject);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            if (set != null) {
                return set;
            }
        }
        if ((object2 = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return object2.getLineSet();
    }

    private Line getLine(DataObject dataObject, int n, Object object) {
        Line.Set set = this.getLineSet(dataObject, object);
        if (set == null) {
            return null;
        }
        try {
            if (object == null) {
                return set.getCurrent(n - 1);
            }
            return set.getOriginal(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static DataObject getDataObject(String string) {
        FileObject fileObject;
        assert (string != null && string.startsWith("file:") || !Boolean.getBoolean("gdb.assertions.enabled"));
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            assert (!Boolean.getBoolean("gdb.assertions.enabled"));
            return null;
        }
        catch (Exception exception) {
            assert (!Boolean.getBoolean("gdb.assertions.enabled"));
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private class EditorLookupListener
    implements LookupListener,
    PropertyChangeListener {
        private Class type;

        public EditorLookupListener(Class clazz) {
            this.type = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            if (this.type == DataObject.class) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == EditorCookie.class) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == Node.class) {
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("openedPanes")) {
                EditorContextImpl.this.pcs.firePropertyChange("openedPanes", null, null);
            }
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            HashSet hashSet = new HashSet(DataObject.getRegistry().getModifiedSet());
            hashSet.removeAll(EditorContextImpl.this.modifiedDataObjects);
            for (Registry registry : EditorContextImpl.this.timeStampToRegistry.values()) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    registry.register((DataObject)iterator.next());
                }
            }
            EditorContextImpl.this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        }
    }

    private static class Registry {
        private Map dataObjectToLineSet = new HashMap();

        private Registry() {
        }

        void register(DataObject dataObject) {
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lineCookie.getLineSet());
        }

        Line.Set getLineSet(DataObject dataObject) {
            return (Line.Set)this.dataObjectToLineSet.get(dataObject);
        }
    }
}

