/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.utils.CommandBuffer;

public class GdbContext
implements PropertyChangeListener {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<String, Request> requests = new HashMap<String, Request>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private final Map<String, Object> waitLocks = new HashMap<String, Object>();
    private static final int SYNC_UPDATE_TIMEOUT = 30000;
    public static final String PROP_REGISTERS = "Registers";
    private static GdbContext instance = null;

    private GdbContext() {
        this.requests.put(PROP_REGISTERS, new Request(){

            protected void request(CommandBuffer commandBuffer, GdbProxy gdbProxy) {
                gdbProxy.data_list_register_values(commandBuffer, "");
                gdbProxy.data_list_changed_registers(commandBuffer);
            }
        });
        this.pcs.addPropertyChangeListener(this);
    }

    public void invalidate(boolean bl) {
        this.cache.clear();
        if (bl) {
            for (String string : this.requests.keySet()) {
                if (!this.hasListeners(string)) continue;
                this.pcs.firePropertyChange(string, 0, 1);
            }
        }
    }

    public void update() {
        this.invalidate(false);
        for (Map.Entry<String, Request> entry : this.requests.entrySet()) {
            if (!this.hasListeners(entry.getKey())) continue;
            entry.getValue().run(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.waitLocks.get(propertyChangeEvent.getPropertyName());
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                object.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        Object object = this.cache.get(string);
        if (object == null) {
            boolean bl = true;
            Object object2 = this.waitLocks.get(string);
            if (object2 == null) {
                bl = false;
                object2 = "Lock for " + string;
            }
            Object object3 = object2;
            synchronized (object3) {
                this.waitLocks.put(string, object2);
                if (bl || this.requests.get(string).run(true)) {
                    try {
                        object2.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.waitLocks.remove(string);
            }
            return this.cache.get(string);
        }
        return object;
    }

    public void setProperty(String string, Object object) {
        this.cache.put(string, object);
        this.pcs.firePropertyChange(string, 0, 1);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
        if (!this.cache.containsKey(string)) {
            this.requests.get(string).run(true);
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private synchronized boolean hasListeners(String string) {
        return this.pcs.getPropertyChangeListeners(string).length > 0;
    }

    public static synchronized GdbContext getInstance() {
        if (instance == null) {
            instance = new GdbContext();
        }
        return instance;
    }

    private static GdbProxy getCurrentGdb() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        GdbDebugger gdbDebugger = (GdbDebugger)debuggerEngine.lookupFirst(null, GdbDebugger.class);
        if (gdbDebugger == null) {
            return null;
        }
        return gdbDebugger.getGdbProxy();
    }

    private static abstract class Request {
        private Request() {
        }

        public boolean run(boolean bl) {
            GdbProxy gdbProxy = GdbContext.getCurrentGdb();
            if (gdbProxy != null) {
                CommandBuffer commandBuffer = null;
                if (!bl) {
                    commandBuffer = new CommandBuffer(gdbProxy);
                }
                this.request(commandBuffer, gdbProxy);
                if (commandBuffer != null) {
                    commandBuffer.waitForCompletion();
                }
                return true;
            }
            return false;
        }

        protected abstract void request(CommandBuffer var1, GdbProxy var2);
    }
}

