/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerStartException;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.GdbEngineProvider;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.TypeInfo;
import org.netbeans.modules.cnd.debugger.gdb.actions.GdbActionHandler;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.modules.cnd.debugger.gdb.event.GdbBreakpointEvent;
import org.netbeans.modules.cnd.debugger.gdb.expr.Expression;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfile;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbMiDefinitions;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.timer.GdbTimer;
import org.netbeans.modules.cnd.debugger.gdb.utils.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbDebugger
implements PropertyChangeListener,
GdbMiDefinitions {
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public static final String PROP_KILLTERM = "killTerm";
    public static final String PROP_SHARED_LIB_LOADED = "sharedLibLoaded";
    public static final String PROP_VALUE_CHANGED = "valueChanged";
    public static final String PROP_LOCALS_REFRESH = "localsRefresh";
    public static final String STATE_NONE = "state_none";
    public static final String STATE_STARTING = "state_starting";
    public static final String STATE_LOADING = "state_loading";
    public static final String STATE_READY = "state_ready";
    public static final String STATE_RUNNING = "state_running";
    public static final String STATE_STOPPED = "state_stopped";
    public static final String STATE_SILENT_STOP = "state_silent_stop";
    public static final String STATE_EXITED = "state_exited";
    public static final Object LAST_GO_WAS_CONTINUE = "lastGoWasContinue";
    public static final Object LAST_GO_WAS_FINISH = "lastGoWasFinish";
    public static final Object LAST_GO_WAS_STEP = "lastGoWasStep";
    public static final Object LAST_GO_WAS_NEXT = "lastGoWasNext";
    private Object lastGo;
    private String lastStop;
    private static final int DEBUG_ATTACH = 999;
    public static final int GDB_TMP_BREAKPOINT = 3;
    public static final String ENGINE_ID = "netbeans-cnd-GdbSession/C";
    public static final String SESSION_ID = "netbeans-cnd-GdbSession";
    public static final String SESSION_PROVIDER_ID = "netbeans-cnd-GdbSessionProvider";
    public static final String DIS_UPDATE = "dis_update";
    private static final String MSG_BREAKPOINT_ERROR = "Cannot insert breakpoint";
    private GdbProxy gdb;
    private ContextProvider lookupProvider;
    private String state = "state_none";
    private PropertyChangeSupport pcs;
    private String runDirectory;
    private ArrayList<CallStackFrame> callstack = new ArrayList();
    private GdbEngineProvider gdbEngineProvider;
    private CallStackFrame currentCallStackFrame;
    public final Object LOCK = new Object();
    private long programPID = 0L;
    private double gdbVersion = 6.4;
    private boolean continueAfterFirstStop = true;
    private ArrayList<GdbVariable> localVariables = new ArrayList();
    private Map<Integer, BreakpointImpl> pendingBreakpointMap = new HashMap<Integer, BreakpointImpl>();
    private Map<String, BreakpointImpl> breakpointList = Collections.synchronizedMap(new HashMap());
    private List<String> temporaryBreakpoints = new ArrayList<String>();
    private static Map<String, TypeInfo> ticache = new HashMap<String, TypeInfo>();
    private static Logger log = Logger.getLogger("gdb.logger");
    private int currentToken = 0;
    private String currentThreadID = "1";
    private static final String[] emptyThreadsList = new String[0];
    private String[] threadsList = emptyThreadsList;
    private Timer startupTimer = null;
    private boolean cygwin = false;
    private boolean mingw = false;
    private boolean cplusplus = false;
    private String firstBPfullname;
    private String firstBPfile;
    private String firstBPline;
    private InputOutput iotab;
    private boolean firstOutput;
    private boolean dlopenPending;
    private String lastShare;
    private int shareToken;
    private final Disassembly disassembly;
    private GdbBreakpoint currentBreakpoint = null;

    public GdbDebugger(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.pcs = new PropertyChangeSupport(this);
        this.firstOutput = true;
        this.dlopenPending = false;
        this.addPropertyChangeListener(this);
        List list = contextProvider.lookup(null, DebuggerEngineProvider.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof GdbEngineProvider)) continue;
            this.gdbEngineProvider = (GdbEngineProvider)((Object)list.get(i));
        }
        if (this.gdbEngineProvider == null) {
            throw new IllegalArgumentException("GdbEngineProvider must be used to start GdbDebugger!");
        }
        this.threadsViewInit();
        this.disassembly = new Disassembly(this);
    }

    public ContextProvider getLookup() {
        return this.lookupProvider;
    }

    public void startDebugger() {
        String string = null;
        GdbTimer.getTimer("Startup").start("Startup1");
        GdbTimer.getTimer("Stop").start("Stop1");
        this.setStarting();
        try {
            String string2;
            ProjectActionEvent projectActionEvent = (ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class);
            this.iotab = (InputOutput)this.lookupProvider.lookupFirst(null, InputOutput.class);
            if (this.iotab != null) {
                this.iotab.setErrSeparated(false);
            }
            this.runDirectory = projectActionEvent.getProfile().getRunDirectory().replace("\\", "/") + "/";
            GdbProfile gdbProfile = (GdbProfile)projectActionEvent.getConfiguration().getAuxObject("gdbdebugger");
            int n = projectActionEvent.getProfile().getConsoleType().getValue();
            if (!Utilities.isWindows() && n != 2 && projectActionEvent.getID() != 999) {
                string = projectActionEvent.getProfile().getTerminalPath();
            }
            if (!Boolean.getBoolean("gdb.suppress-timeout")) {
                this.startupTimer = new Timer("GDB Startup Timer Thread");
                this.startupTimer.schedule(new TimerTask(){

                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_StartupTimeout")));
                        GdbDebugger.this.setExited();
                        GdbDebugger.this.finish(true);
                    }
                }, 30000L);
            }
            if ((string2 = gdbProfile.getGdbPath((MakeConfiguration)projectActionEvent.getConfiguration())).toLowerCase().contains("cygwin")) {
                this.cygwin = true;
            } else if (string2.toLowerCase().contains("mingw")) {
                this.mingw = true;
            }
            String string3 = this.getCompilerSetPath(projectActionEvent);
            this.gdb = new GdbProxy(this, string2, projectActionEvent.getProfile().getEnvironment().getenv(), this.runDirectory, string, string3);
            this.gdb.gdb_version();
            this.gdb.environment_directory(this.runDirectory);
            this.gdb.gdb_show("language");
            this.gdb.gdb_set("print repeat", Integer.toString(CppSettings.getDefault().getArrayRepeatThreshold()));
            if (projectActionEvent.getID() == 999) {
                this.programPID = (Long)this.lookupProvider.lookupFirst(null, Long.class);
                CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
                this.gdb.target_attach(commandBuffer, Long.toString(this.programPID));
                commandBuffer.waitForCompletion();
                String string4 = commandBuffer.getError();
                if (string4 != null || commandBuffer.timedOut()) {
                    final String string5 = string4 == null ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachTimeout") : (string4.toLowerCase().contains("no such process") || string4.toLowerCase().contains("couldn't open /proc file for process ") ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoSuchProcess") : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantAttach"));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string5));
                            GdbDebugger.this.setExited();
                            GdbDebugger.this.finish(false);
                        }
                    });
                } else {
                    String string6 = this.getFullPath(this.runDirectory, projectActionEvent.getExecutable());
                    if (!this.symbolsRead(commandBuffer.toString(), string6)) {
                        if (this.validAttachViaSlashProc(this.programPID, string6)) {
                            if (Utilities.getOperatingSystem() == 8) {
                                this.gdb.file_symbol_file(string6);
                            }
                            this.setLoading();
                        } else {
                            commandBuffer = new CommandBuffer(this.gdb);
                            this.gdb.info_files(commandBuffer);
                            commandBuffer.waitForCompletion();
                            if (this.symbolsReadFromInfoFiles(commandBuffer.toString(), string6)) {
                                this.setLoading();
                            } else {
                                final String string7 = NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachValidationFailure");
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string7));
                                        GdbDebugger.this.setExited();
                                        GdbDebugger.this.finish(false);
                                    }
                                });
                            }
                        }
                    } else {
                        this.setLoading();
                    }
                }
            } else {
                Object object;
                this.gdb.file_exec_and_symbols(this.getProgramName(projectActionEvent.getExecutable()));
                if (n == 2 && (object = this.getGdbHelper()) != null) {
                    if (Utilities.isMac()) {
                        this.gdb.gdb_set("environment", "DYLD_INSERT_LIBRARIES=" + (String)object);
                        this.gdb.gdb_set("environment", "DYLD_FORCE_FLAT_NAMESPACE=yes");
                    } else {
                        this.gdb.gdb_set("environment", "LD_PRELOAD=" + (String)object);
                    }
                }
                if (Utilities.isWindows() && n != 2) {
                    this.gdb.set_new_console();
                }
                if (projectActionEvent.getID() == 4) {
                    this.continueAfterFirstStop = false;
                }
                this.gdb.break_insert(3, "main");
                if (Utilities.isWindows()) {
                    this.gdb.break_insert(3, "WinMain");
                }
                try {
                    this.gdb.exec_run(projectActionEvent.getProfile().getArgsFlat());
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                    ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
                }
                if (Utilities.isWindows()) {
                    int n2;
                    object = new CommandBuffer(this.gdb);
                    this.gdb.info_threads((CommandBuffer)object);
                    String string8 = ((CommandBuffer)object).waitForCompletion();
                    if (string8.startsWith("* 1 thread ") && (n2 = string8.indexOf(46)) > 0) {
                        try {
                            this.programPID = Long.valueOf(string8.substring(11, n2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.warning("Failed to get PID from \"info threads\"");
                        }
                    }
                } else if (Utilities.getOperatingSystem() != 4096) {
                    this.gdb.info_proc();
                }
            }
            this.gdb.data_list_register_names("");
        }
        catch (Exception exception) {
            String string9;
            if (this.startupTimer != null) {
                this.startupTimer.cancel();
            }
            if ((string9 = exception.getLocalizedMessage()) == null || string9.length() == 0) {
                string9 = exception.getMessage();
            }
            if (string9 == null || string9.length() == 0) {
                string9 = NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnSpecifiedStartError");
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string9));
            this.setExited();
            this.finish(false);
        }
    }

    private String getCompilerSetPath(ProjectActionEvent projectActionEvent) {
        String string;
        CompilerSet2Configuration compilerSet2Configuration = ((MakeConfiguration)projectActionEvent.getConfiguration()).getCompilerSet();
        String string2 = compilerSet2Configuration.getOption();
        String string3 = CompilerSetManager.getDefault().getCompilerSet(string2).getDirectory();
        if (compilerSet2Configuration.getFlavor().equals(CompilerSet.CompilerFlavor.MinGW.toString()) && (string = CppUtils.getMSysBase()) != null && string.length() > 0) {
            string3 = string3 + File.pathSeparator + string + File.separator + "bin";
        }
        return string3;
    }

    private String getGdbHelper() {
        String string = "bin/GdbHelper" + this.getOsName() + this.getOsArch() + this.getExtension();
        File file = InstalledFileLocator.getDefault().locate(string, null, false);
        if (file != null && file.exists()) {
            return this.fixPath(file.getAbsolutePath());
        }
        return null;
    }

    private String getOsArch() {
        String string = System.getProperty("os.arch");
        return "-" + (string.equals("i386") || string.equals("i686") ? "x86" : string);
    }

    private String getOsName() {
        return "-" + System.getProperty("os.name").replace(" ", "_");
    }

    private String getExtension() {
        return Utilities.isWindows() ? ".dll" : (Utilities.isMac() ? ".dylib" : ".so");
    }

    private String fixPath(String string) {
        if (this.isCygwin() && string.charAt(1) == ':') {
            return "/cygdrive/" + string.charAt(0) + string.substring(2).replace("\\", "/");
        }
        if (this.isMinGW() && string.charAt(1) == ':') {
            return "/" + string.charAt(0) + string.substring(2).replace("\\", "/");
        }
        return string;
    }

    private String getFullPath(String string, String string2) {
        if (Utilities.isWindows() && Character.isLetter(string2.charAt(0)) && string2.charAt(1) == ':') {
            return string2;
        }
        if (Utilities.isUnix() && string2.charAt(0) == '/') {
            return string2;
        }
        return string + '/' + string2;
    }

    public void showCurrentSource(boolean bl) {
        final CallStackFrame callStackFrame = this.getCurrentCallStackFrame();
        if (callStackFrame == null) {
            return;
        }
        if (!bl) {
            bl = this.currentBreakpoint == null ? Disassembly.isInDisasm() : this.currentBreakpoint instanceof AddressBreakpoint;
        }
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorContextBridge.showSource(callStackFrame, bl2);
            }
        });
    }

    public String[] getThreadsList() {
        if (this.state.equals(STATE_STOPPED)) {
            if (this.threadsList == emptyThreadsList) {
                while (this.gdb == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
                this.gdb.info_threads(commandBuffer);
                String string = commandBuffer.waitForCompletion();
                if (string.length() > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string2 : string.split("\\\\n")) {
                        char c;
                        if (string2.startsWith("    ")) {
                            stringBuilder.append(" " + string2.replace("\\n", "").trim());
                            continue;
                        }
                        if (stringBuilder.length() > 0) {
                            arrayList.add(stringBuilder.toString());
                            stringBuilder.delete(0, stringBuilder.length());
                        }
                        if ((c = (string2 = string2.trim()).charAt(0)) != '*' && !Character.isDigit(c)) continue;
                        stringBuilder.append(string2);
                    }
                    if (stringBuilder.length() > 0) {
                        arrayList.add(stringBuilder.toString());
                    }
                    this.threadsList = arrayList.toArray(new String[arrayList.size()]);
                    return this.threadsList;
                }
            }
        } else {
            return new String[]{NbBundle.getMessage(GdbDebugger.class, (String)"CTL_NoThreadInfoWhileRunning")};
        }
        return this.threadsList;
    }

    public int getThreadCount() {
        return 1;
    }

    private void resetThreadInfo() {
        this.threadsList = emptyThreadsList;
    }

    private String getProgramName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                stringBuilder.append('/');
                continue;
            }
            if (string.charAt(i) == ' ') {
                stringBuilder.append("\\ ");
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public double getGdbVersion() {
        return this.gdbVersion;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(PROP_STATE)) {
            if (propertyChangeEvent.getNewValue().equals(STATE_LOADING)) {
                CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
                this.shareToken = this.gdb.info_share();
                commandBuffer.setID(this.shareToken);
            } else if (propertyChangeEvent.getNewValue().equals(STATE_READY)) {
                if (Utilities.isWindows()) {
                    this.gdb.break_insert("dlopen");
                } else {
                    this.gdb.gdb_set("stop-on-solib-events", "1");
                }
                if (this.continueAfterFirstStop) {
                    this.continueAfterFirstStop = false;
                    this.setRunning();
                } else {
                    this.gdb.stack_list_frames();
                    this.setStopped();
                }
            } else if (propertyChangeEvent.getNewValue() == STATE_STOPPED) {
                this.updateLocalVariables(0);
                GdbContext.getInstance().update();
            } else if (propertyChangeEvent.getNewValue() == STATE_SILENT_STOP) {
                this.interrupt();
            } else if (propertyChangeEvent.getNewValue() == STATE_RUNNING && (propertyChangeEvent.getOldValue() == STATE_SILENT_STOP || propertyChangeEvent.getOldValue() == STATE_READY)) {
                this.gdb.exec_continue();
            } else if (propertyChangeEvent.getNewValue() == STATE_EXITED) {
                this.finish(false);
            }
        } else if (propertyChangeEvent.getPropertyName().equals(PROP_CURRENT_THREAD)) {
            this.updateCurrentCallStack();
            this.updateLocalVariables(0);
            GdbContext.getInstance().update();
        }
    }

    private boolean symbolsRead(String string, String string2) {
        int n = -1;
        for (String string3 : string.split("\\\\n")) {
            String string4;
            if (!string3.contains("Reading symbols from ") && (Utilities.getOperatingSystem() != 4096 || !string3.contains("Symbols from "))) continue;
            if (Utilities.isWindows() && (n = string3.indexOf("/cygdrive/")) != -1) {
                string3 = string3.substring(0, n) + string3.substring(n + 10, n + 11).toUpperCase() + ':' + string3.substring(n + 11);
            }
            if (!(string4 = string3.substring(21, string3.length() - 8)).equals(string2) && (!Utilities.isWindows() || !string4.equals(string2 + ".exe"))) continue;
            return true;
        }
        return false;
    }

    private boolean symbolsReadFromInfoFiles(String string, String string2) {
        for (String string3 : string.split("\\\\n")) {
            String string4;
            if (!string3.contains("Symbols from ") || !(string4 = string3.substring(15, string3.length() - 3)).equals(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean validAttachViaSlashProc(long l, String string) {
        if (!Utilities.isWindows()) {
            String string2;
            File file;
            String string3 = "/proc/" + Long.toString(l);
            File file2 = new File(string3, "path/a.out");
            if (!file2.exists()) {
                file2 = new File(string3, "exe");
            }
            if (file2.exists() && (file = new File(string)).exists() && (string2 = this.getPathFromSymlink(file2.getAbsolutePath())).equals(file.getAbsolutePath())) {
                return true;
            }
        }
        return false;
    }

    private String getPathFromSymlink(String string) {
        SymlinkCommand symlinkCommand = new SymlinkCommand(string);
        return symlinkCommand.getPath();
    }

    public GdbProxy getGdbProxy() {
        return this.gdb;
    }

    public void finish(boolean bl) {
        if (!this.state.equals(STATE_NONE)) {
            Object object;
            if (bl) {
                this.firePropertyChange(PROP_KILLTERM, true, false);
            }
            if (this.gdb != null) {
                if (this.state.equals(STATE_RUNNING)) {
                    object = (ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class);
                    this.gdb.exec_interrupt();
                    if (object.getID() == 999) {
                        this.gdb.target_detach();
                    } else {
                        this.gdb.exec_abort();
                    }
                }
                this.gdb.gdb_exit();
            }
            this.stackUpdate(new ArrayList<String>());
            this.setState(STATE_NONE);
            this.programPID = 0L;
            this.gdbEngineProvider.getDestructor().killEngine();
            object = (GdbActionHandler)this.lookupProvider.lookupFirst(null, GdbActionHandler.class);
            if (object != null) {
                ((GdbActionHandler)object).executionFinished(0);
            }
            Disassembly.close();
            GdbContext.getInstance().invalidate(true);
            GdbTimer.getTimer("Step").reset();
        }
    }

    private void finish_from_main() {
        this.gdb.break_insert(3, "exit");
        this.gdb.exec_continue();
    }

    public long getProcessID() {
        return this.programPID;
    }

    public void unexpectedGdbExit(int n) {
        String string = n < 0 ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnexpectedGdbExit") : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnexpectedGdbExitRC", (Object)n);
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(GdbDebugger.class, (String)"TITLE_UnexpectedGdbFailure"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
        this.finish(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalVariables(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<GdbVariable> arrayList = this.localVariables;
            synchronized (arrayList) {
                this.localVariables.clear();
            }
            this.gdb.stack_select_frame(n);
            this.gdb.stack_list_arguments(1, n, n);
            this.gdb.stack_list_locals("--all-values");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGdbVariable(String string, String string2) {
        ArrayList<GdbVariable> arrayList = this.localVariables;
        synchronized (arrayList) {
            for (GdbVariable gdbVariable : this.localVariables) {
                if (!string.equals(gdbVariable.getName())) continue;
                gdbVariable.setValue(string2);
            }
        }
    }

    public void fireLocalsRefresh(Object object) {
        this.firePropertyChange(PROP_LOCALS_REFRESH, 0, object);
    }

    private void updateCurrentCallStack() {
        this.gdb.stack_list_frames();
    }

    public void resultRecord(int n, String string) {
        Integer n2 = n;
        this.currentToken = n + 1;
        if (string.startsWith("^done,bkpt=")) {
            Map<String, String> map = GdbUtils.createMapFromString(string = string.substring(12, string.length() - 1));
            boolean bl = this.breakpointValidation(n, map);
            if (!bl && this.getState().equals(STATE_SILENT_STOP) && this.pendingBreakpointMap.isEmpty()) {
                this.setRunning();
            }
        } else if (string.startsWith("^done,stack=")) {
            CommandBuffer commandBuffer;
            if (this.state.equals(STATE_STOPPED)) {
                this.stackUpdate(GdbUtils.createListFromString(string.substring(13, string.length() - 1)));
            } else if (this.state.equals(STATE_SILENT_STOP) && (commandBuffer = this.gdb.getCommandBuffer(n2)) != null) {
                commandBuffer.append(string.substring(13, string.length() - 1));
                commandBuffer.done();
            }
        } else if (string.startsWith("^done,locals=")) {
            if (this.state.equals(STATE_STOPPED)) {
                this.addLocalsToLocalVariables(string.substring(13));
            } else {
                log.finest("GD.resultRecord: Skipping results from -stack-list-locals (not stopped)");
            }
        } else if (string.startsWith("^done,stack-args=")) {
            if (this.state.equals(STATE_STOPPED)) {
                this.addArgsToLocalVariables(string.substring(17));
            } else {
                log.finest("GD.resultRecord: Skipping results from -stack-list-arguments (not stopped)");
            }
        } else if (string.startsWith("^done,new-thread-id=")) {
            String string2 = string.substring(21, string.indexOf(34, 22));
            if (!string2.equals(this.currentThreadID)) {
                String string3 = this.currentThreadID;
                this.currentThreadID = string2;
                log.finest("GD.resultRecord: Thread change, firing PROP_CURRENT_THREAD");
                this.firePropertyChange(PROP_CURRENT_THREAD, string3, this.currentThreadID);
            }
        } else if (string.startsWith("^done,value=") && string.contains("auto; currently c")) {
            if (string.contains("auto; currently c++")) {
                this.cplusplus = true;
                DebuggerManager.getDebuggerManager().getCurrentSession().setCurrentLanguage("C++");
            }
        } else if (string.startsWith("^done,value=")) {
            CommandBuffer commandBuffer = this.gdb.getCommandBuffer(n2);
            if (commandBuffer != null) {
                commandBuffer.append(string.substring(13, string.length() - 1));
                commandBuffer.done();
            }
        } else if (string.startsWith("^done,thread-id=") && Utilities.isMac()) {
            CommandBuffer commandBuffer = this.gdb.getCommandBuffer(n2);
            if (commandBuffer != null) {
                commandBuffer.done();
            }
        } else if (string.startsWith("^done,shlib-info=") && Utilities.isMac()) {
            String string4 = string.substring(17);
            CommandBuffer commandBuffer = this.gdb.getCommandBuffer(n2);
            if (commandBuffer != null) {
                commandBuffer.append(string4);
                commandBuffer.done();
                if (n == this.shareToken) {
                    ProjectActionEvent projectActionEvent;
                    int n3;
                    this.lastShare = string4;
                    if (this.lastShare.contains("GdbHelper") && (n3 = (projectActionEvent = (ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class)).getProfile().getConsoleType().getValue()) == 2) {
                        this.gdb.data_evaluate_expression("_gdbHelperSetLineBuffered()");
                    }
                }
            }
        } else if (string.startsWith("^done,asm_insns=[")) {
            this.disassembly.update(string);
        } else if (string.startsWith("^done,register-names=[")) {
            this.disassembly.updateRegNames(string);
        } else if (string.startsWith("^done,register-values=[")) {
            this.disassembly.updateRegValues(string);
        } else if (string.startsWith("^done,changed-registers=[")) {
            this.disassembly.updateRegModified(string);
            GdbContext.getInstance().setProperty("Registers", this.disassembly.getRegisterValues());
        } else if (string.equals("^done")) {
            CommandBuffer commandBuffer = this.gdb.getCommandBuffer(n2);
            if (commandBuffer != null) {
                commandBuffer.done();
                if (n == this.shareToken) {
                    ProjectActionEvent projectActionEvent;
                    int n4;
                    this.lastShare = commandBuffer.toString();
                    if (this.lastShare.contains("GdbHelper") && (n4 = (projectActionEvent = (ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class)).getProfile().getConsoleType().getValue()) == 2 && !Utilities.isWindows()) {
                        this.gdb.data_evaluate_expression("_gdbHelperSetLineBuffered()");
                    }
                }
            } else if (this.pendingBreakpointMap.get(n2) != null) {
                this.breakpointValidation(n, null);
            }
        } else if (string.startsWith("^running") && this.getState().equals(STATE_STOPPED)) {
            this.setRunning();
        } else if (string.startsWith("^error,msg=")) {
            string = string.substring(11);
            CommandBuffer commandBuffer = this.gdb.getCommandBuffer(n2);
            if (commandBuffer != null) {
                commandBuffer.error(string);
            } else if (string.equals("\"Can't attach to process.\"")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantAttach")));
                ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
            } else if (string.startsWith("\"No symbol ") && string.endsWith(" in current context.\"")) {
                String string5 = string.substring(13, string.length() - 23);
                log.warning("Failed type lookup for " + string5);
            } else if (string.equals("\"\\\"finish\\\" not meaningful in the outermost frame.\"")) {
                this.finish_from_main();
            } else if (string.contains("(corrupt stack?)")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CorruptedStack")));
                ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
            } else if (string.contains("error reading line numbers")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantReadLineNumbers")));
            } else if (string.contains("No symbol table is loaded")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoSymbolTable")));
                ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
            } else if (!(string.contains("Cannot access memory at address") || string.contains("mi_cmd_break_insert: Garbage following <location>") || string.contains("Undefined mi command: ") && string.contains("(missing implementation"))) {
                if (string.contains(MSG_BREAKPOINT_ERROR)) {
                    String string6;
                    BreakpointImpl breakpointImpl;
                    this.setStopped();
                    int n5 = string.indexOf(MSG_BREAKPOINT_ERROR) + MSG_BREAKPOINT_ERROR.length();
                    int n6 = string.indexOf(".", n5);
                    if (n6 != -1 && (breakpointImpl = this.breakpointList.get(string6 = string.substring(n5, n6).trim())) != null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidBreakpoint", (Object)((Object)breakpointImpl.getBreakpoint()))));
                        breakpointImpl.getBreakpoint().disable();
                    }
                } else if (this.pendingBreakpointMap.remove(n) != null) {
                    if (this.pendingBreakpointMap.isEmpty() && this.state.equals(STATE_LOADING)) {
                        this.setReady();
                    }
                } else if (!this.state.equals(STATE_NONE)) {
                    log.warning("Unexpected gdb error: " + string);
                }
            }
        }
    }

    public void fireDisUpdate(boolean bl) {
        this.firePropertyChange(DIS_UPDATE, bl, !bl);
    }

    public void execAsyncOutput(int n, String string) {
        if (string.startsWith("*stopped")) {
            Map<Object, Object> map = string.length() > 9 ? GdbUtils.createMapFromString(string.substring(9)) : new HashMap();
            this.stopped(n, map);
        }
    }

    public void consoleStreamOutput(int n, String string) {
        CommandBuffer commandBuffer = this.gdb.getCommandBuffer(n);
        String string2 = string.endsWith("\\n") ? string.substring(0, string.length() - 2) : string;
        if (commandBuffer != null) {
            commandBuffer.append(string);
        } else if (string2.startsWith("GNU gdb ") && this.startupTimer != null) {
            this.startupTimer.cancel();
            this.startupTimer = null;
            int n2 = string2.indexOf(46);
            int n3 = string2.lastIndexOf(46);
            try {
                this.gdbVersion = n2 == n3 ? Double.parseDouble(string2.substring(8)) : Double.parseDouble(string2.substring(8, n3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (string2.contains("cygwin")) {
                this.cygwin = true;
            }
        } else if (string2.toLowerCase().contains("mingw")) {
            this.mingw = true;
        } else if (string2.startsWith("Breakpoint ") && string2.contains(" at 0x")) {
            int n4 = string2.indexOf(32, 12);
            String string3 = string2.substring(11, n4);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("number", string3);
            boolean bl = this.breakpointValidation(n, hashMap);
            if (!bl && this.getState().equals(STATE_SILENT_STOP) && this.pendingBreakpointMap.isEmpty()) {
                this.setRunning();
            }
        } else if (!(string2.startsWith("Copyright ") || string2.startsWith("GDB is free software,") || string2.startsWith("welcome to change it and") || string2.contains("show copying") || string2.startsWith("There is absolutely no warranty for GDB") || string2.startsWith("Source directories searched: ") || string2.startsWith("This GDB was configured as"))) {
            if (this.programPID == 0L && string2.startsWith("process ")) {
                int n5 = string2.indexOf(32, 8);
                String string4 = n5 > 0 ? string2.substring(8, n5) : string2.substring(8);
                try {
                    this.programPID = Long.parseLong(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    log.warning("Failed to get PID from \"info proc\"");
                }
            } else if (this.programPID == 0L) {
                int n6;
                if (string2.startsWith("* 1 thread ")) {
                    int n7 = string2.indexOf(46);
                    if (n7 > 0) {
                        try {
                            this.programPID = Long.valueOf(string2.substring(11, n7));
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.warning("Failed to get PID from \"info threads\"");
                        }
                    }
                } else if (string2.startsWith("[Switching to process ") && (n6 = string2.indexOf(32, 22)) > 0) {
                    try {
                        this.programPID = Long.valueOf(string2.substring(22, n6));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (string2.startsWith("Stopped due to shared library event")) {
                this.dlopenPending = true;
            }
        }
    }

    public void logStreamOutput(String string) {
        if (string.startsWith("&\"No source file named ")) {
            this.breakpointValidation(this.currentToken, string.substring(2, string.length() - 3));
        } else if (!(string.startsWith("&\"info proc") || string.startsWith("&\"info threads") || string.startsWith("&\"directory ") || string.startsWith("&\"set new-console") || string.startsWith("&\"whatis ") || string.startsWith("&\"warning: Temporarily disabling breakpoints for unloaded shared library") || string.contains("/usr/lib/ld.so"))) {
            log.finest("GD.logStreamOutput: " + string);
        }
    }

    public void statusAsyncOutput(int n, String string) {
        log.finest("GD.statusAsyncOutput[" + n + "]: " + string);
    }

    public void notifyAsyncOutput(int n, String string) {
        log.finest("GD.notifyAsyncOutput[" + n + "]: " + string);
    }

    public void targetStreamOutput(String string) {
        log.finest("GD.targetStreamOutput: " + string);
    }

    public void output(String string) {
        if (!(this.iotab == null || this.firstOutput && Utilities.getOperatingSystem() == 8 && string.startsWith("PR_"))) {
            this.firstOutput = false;
            this.iotab.getOut().println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArgsToLocalVariables(String string) {
        int n;
        if (string.startsWith("[frame={level=") && (n = string.indexOf(",args=[")) > 0 && string.endsWith("]}]")) {
            string = string.substring(n + 7, string.length() - 3);
        } else if (Utilities.getOperatingSystem() == 4096 && string.startsWith("{frame={level=") && (n = string.indexOf(",args={")) > 0 && string.endsWith("}}}")) {
            string = string.substring(n + 7, string.length() - 3);
        }
        List<GdbVariable> list = GdbUtils.createArgumentList(string);
        if (!list.isEmpty()) {
            log.finest("GD.addArgsToLocalVariables: Starting to add Args to localVariables");
            ArrayList<GdbVariable> arrayList = this.localVariables;
            synchronized (arrayList) {
                this.localVariables.addAll(list);
            }
            log.finest("GD.addArgsToLocalVariables: Added " + list.size() + " args");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocalsToLocalVariables(String string) {
        List<GdbVariable> list = GdbUtils.createLocalsList(string.substring(1, string.length() - 1));
        if (!list.isEmpty()) {
            log.finest("GD.addLocalsToLocalVariables: Starting to add locals to localVariables");
            ArrayList<GdbVariable> arrayList = this.localVariables;
            synchronized (arrayList) {
                for (GdbVariable gdbVariable : list) {
                    if (this.localVariables.contains(gdbVariable)) continue;
                    this.localVariables.add(gdbVariable);
                }
            }
            log.finest("GD.addLocalsToLocalVariables: Added " + list.size() + " locals");
        }
    }

    public String updateVariable(String string, String string2) {
        CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
        this.gdb.data_evaluate_expression(commandBuffer, string + '=' + string2);
        return commandBuffer.waitForCompletion();
    }

    public void variableChanged(Object object) {
        this.firePropertyChange(PROP_VALUE_CHANGED, null, object);
    }

    public void suspend() {
        this.setState(STATE_STOPPED);
    }

    public void interrupt() {
        this.gdb.exec_interrupt();
    }

    public void kill(int n) {
        if (this.programPID > 0L) {
            this.kill(n, this.programPID);
        }
    }

    public void kill(int n, long l) {
        if (l > 0L) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (Utilities.isWindows()) {
                File file = InstalledFileLocator.getDefault().locate("bin/GdbKillProc.exe", null, false);
                if (file.exists()) {
                    arrayList.add(file.getAbsolutePath());
                }
            } else {
                File file = new File("/usr/bin/kill");
                if (file.exists()) {
                    arrayList.add(file.getAbsolutePath());
                } else {
                    file = new File("/bin/kill");
                    if (file.exists()) {
                        arrayList.add(file.getAbsolutePath());
                    }
                }
            }
            if (arrayList.size() > 0) {
                arrayList.add("-s");
                arrayList.add(Utilities.isMac() && n == 2 ? "TRAP" : Integer.toString(n));
                arrayList.add(Long.toString(l));
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                try {
                    processBuilder.start();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.gdb.getLogger().logMessage("External Command: " + arrayList.toString());
            }
        }
    }

    public void resume() {
        this.setState(STATE_RUNNING);
        this.gdb.exec_continue();
    }

    public void stepInto() {
        GdbTimer.getTimer("Step").start("Step1", 10);
        this.setState(STATE_RUNNING);
        this.gdb.exec_step();
    }

    public void stepOver() {
        this.setState(STATE_RUNNING);
        this.gdb.exec_next();
    }

    public void stepI() {
        this.setState(STATE_RUNNING);
        this.gdb.exec_instruction();
    }

    public void stepOverInstr() {
        Disassembly disassembly = Disassembly.getCurrent();
        if (disassembly == null) {
            return;
        }
        CallStackFrame callStackFrame = this.getCurrentCallStackFrame();
        if (callStackFrame == null) {
            return;
        }
        String string = disassembly.getNextAddress(this.getCurrentCallStackFrame().getAddr());
        if (string.length() == 0) {
            this.stepI();
        } else {
            this.gdb.break_insert(3, "*" + string);
            this.resume();
        }
    }

    public void stepOut() {
        if (this.callstack.size() > 0 || this.isValidStackFrame(this.callstack.get(1))) {
            this.setState(STATE_RUNNING);
            this.gdb.stack_select_frame(0);
            this.gdb.exec_finish();
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    public String getState() {
        return this.state;
    }

    private void setState(String string) {
        if (string.equals(this.state)) {
            return;
        }
        String string2 = this.state;
        this.state = string;
        this.firePropertyChange(PROP_STATE, string2, string);
    }

    public void setStarting() {
        this.setState(STATE_STARTING);
    }

    public void setLoading() {
        this.setState(STATE_LOADING);
    }

    public void setReady() {
        this.setState(STATE_READY);
    }

    public void setRunning() {
        this.setState(STATE_RUNNING);
    }

    public void setStopped() {
        this.setState(STATE_STOPPED);
    }

    public void setSilentStop() {
        this.setState(STATE_SILENT_STOP);
    }

    public void setExited() {
        this.setState(STATE_EXITED);
    }

    public Boolean evaluateIn(Expression expression, Object object) {
        return Boolean.FALSE;
    }

    public void fireBreakpointEvent(GdbBreakpoint gdbBreakpoint, GdbBreakpointEvent gdbBreakpointEvent) {
        gdbBreakpoint.fireGdbBreakpointChange(gdbBreakpointEvent);
    }

    public void stopped(int n, Map<String, String> map) {
        String string = map.get("reason");
        if (this.state.equals(STATE_STARTING)) {
            String string2 = map.get("frame");
            if (string2 != null) {
                map = GdbUtils.createMapFromString(string2);
                String string3 = map.get("fullname");
                String string4 = map.get("line");
                if (string3 != null && string4 != null) {
                    this.lastStop = string3 + ":" + string4;
                }
            }
            this.setLoading();
            return;
        }
        if (!this.state.equals(STATE_RUNNING)) {
            log.warning("GdbDebugger.stopped while not in STATE_RUNNING");
            return;
        }
        log.finest("GD.stopped[" + GdbUtils.threadId() + "]:\n");
        this.resetThreadInfo();
        if (string != null) {
            this.setCurrentCallStackFrameNoFire(null);
            if (string.equals("exited-normally")) {
                this.setExited();
                this.finish(false);
            } else if (string.equals("breakpoint-hit")) {
                String string5;
                String string6;
                BreakpointImpl breakpointImpl;
                String string7 = map.get("thread-id");
                this.lastStop = null;
                if (string7 != null && !string7.equals(this.currentThreadID)) {
                    this.currentThreadID = string7;
                }
                if ((breakpointImpl = this.getBreakpointList().get(map.get("bkptno"))) == null) {
                    int n2 = this.temporaryBreakpoints.indexOf(map.get("bkptno"));
                    if (n2 >= 0) {
                        this.temporaryBreakpoints.remove(n2);
                        if (Utilities.isMac()) {
                            this.updateCurrentCallStack();
                            this.setStopped();
                        }
                    } else {
                        log.warning("GD.stopped: Stopped at unknown breakpoint");
                        this.gdb.exec_continue();
                    }
                    if ((string6 = map.get("frame")) != null && string6.contains("func=\"dlopen\"")) {
                        this.dlopenPending = true;
                        Object object = this.lastGo;
                        this.gdb.exec_finish();
                        this.setLastGo(object);
                        return;
                    }
                } else {
                    GdbBreakpoint gdbBreakpoint = breakpointImpl.getBreakpoint();
                    if (gdbBreakpoint.getSuspend() == 0) {
                        this.fireBreakpointEvent(gdbBreakpoint, new GdbBreakpointEvent(gdbBreakpoint, this, 0, null));
                        this.gdb.exec_continue();
                    } else {
                        this.updateCurrentCallStack();
                        this.fireBreakpointEvent(gdbBreakpoint, new GdbBreakpointEvent(gdbBreakpoint, this, 0, null));
                        this.setStopped();
                    }
                }
                if (this.dlopenPending) {
                    this.dlopenPending = false;
                    this.checkSharedLibs();
                }
                if ((string5 = map.get("frame")) != null) {
                    map = GdbUtils.createMapFromString(string5);
                    string6 = map.get("fullname");
                    String string8 = map.get("line");
                    if (string6 != null && string8 != null) {
                        this.lastStop = string6 + ":" + string8;
                    }
                }
                GdbTimer.getTimer("Startup").stop("Startup1");
                GdbTimer.getTimer("Startup").report("Startup1");
                GdbTimer.getTimer("Startup").free();
                GdbTimer.getTimer("Stop").mark("Stop1");
            } else if (string.equals("exited-signalled")) {
                String string9 = map.get("signal-name");
                if (string9 != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ExitedFromSignal", (Object)string9)));
                    this.setExited();
                    this.finish(false);
                }
            } else if (string.equals("end-stepping-range")) {
                this.lastStop = null;
                this.gdb.stack_list_frames();
                this.setStopped();
                String string10 = map.get("frame");
                if (string10 != null) {
                    map = GdbUtils.createMapFromString(string10);
                    String string11 = map.get("fullname");
                    String string12 = map.get("line");
                    if (string11 != null && string12 != null) {
                        this.lastStop = string11 + ":" + string12;
                    }
                }
                if (GdbTimer.getTimer("Step").getSkipCount() == 0) {
                    GdbTimer.getTimer("Step").stop("Step1");
                    GdbTimer.getTimer("Step").report("Step1");
                }
            } else if (string.equals("shlib-event")) {
                this.checkSharedLibs();
            } else if (string.equals("signal-received")) {
                if (this.getState().equals(STATE_RUNNING)) {
                    String string13 = map.get("thread-id");
                    if (string13 != null && !string13.equals(this.currentThreadID)) {
                        this.currentThreadID = string13;
                    }
                    this.gdb.stack_list_frames();
                    this.setStopped();
                }
            } else if (string.equals("function-finished") && this.dlopenPending) {
                this.dlopenPending = false;
                this.checkSharedLibs();
            } else if (!string.startsWith("exited")) {
                this.gdb.stack_list_frames();
                this.setStopped();
            } else {
                this.setStopped();
                this.setExited();
            }
        } else if (this.dlopenPending) {
            this.dlopenPending = false;
            this.checkSharedLibs();
        } else {
            this.gdb.stack_list_frames();
            this.setStopped();
        }
    }

    private void checkSharedLibs() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CommandBuffer commandBuffer = new CommandBuffer(GdbDebugger.this.gdb);
                GdbDebugger.this.gdb.info_share(commandBuffer);
                String string = commandBuffer.waitForCompletion();
                if (string.length() > 0 && !string.equals(GdbDebugger.this.lastShare)) {
                    if (string.length() > GdbDebugger.this.lastShare.length()) {
                        log.fine("GD.checkSharedLibs: Added a shared library");
                        GdbDebugger.this.firePropertyChange(GdbDebugger.PROP_SHARED_LIB_LOADED, GdbDebugger.this.lastShare, string);
                        GdbDebugger.this.lastShare = string;
                    } else {
                        log.fine("GD.checkSharedLibs: Closed a shared library");
                    }
                }
                if (GdbDebugger.this.lastGo == LAST_GO_WAS_CONTINUE) {
                    GdbDebugger.this.gdb.exec_continue();
                } else {
                    GdbDebugger.this.stepOutOfDlopen();
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stepOutOfDlopen() {
        String string = this.state;
        this.state = STATE_SILENT_STOP;
        CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
        commandBuffer.setID(this.gdb.stack_list_frames(commandBuffer));
        String string2 = commandBuffer.waitForCompletion();
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        for (String string3 : GdbUtils.createListFromString(string2)) {
            Map<String, String> map = GdbUtils.createMapFromString(string3.substring(6, string3.length()));
            String string4 = map.get("func");
            if (string4 != null && string4.equals("dlopen") && !bl2) {
                if (!Utilities.isMac()) {
                    this.gdb.stack_select_frame(n);
                    this.gdb.gdb_set("stop-on-solib-event", "0");
                    this.gdb.exec_finish();
                    this.gdb.gdb_set("stop-on-solib-event", "1");
                    this.gdb.exec_next();
                    this.state = string;
                    return;
                }
                bl2 = true;
            } else {
                String string5 = map.get("fullname");
                if (string5 != null) {
                    String string6;
                    File file = new File(this.getOSPath(string5));
                    boolean bl3 = bl = file != null && file.exists();
                    if (bl && bl2 && (string6 = map.get("line")) != null) {
                        int n2 = Integer.parseInt(string6) + 1;
                        this.gdb.break_insert(3, string5 + ":" + n2);
                        this.gdb.exec_continue();
                        return;
                    }
                } else {
                    bl = false;
                }
            }
            ++n;
        }
        if (bl) {
            this.gdb.exec_next();
        } else if (this.lastStop != null) {
            int n3 = this.lastStop.lastIndexOf(58);
            int n4 = Integer.parseInt(this.lastStop.substring(n3 + 1)) + 1;
            this.gdb.break_insert(3, this.lastStop.substring(0, n3 + 1) + n4);
            this.gdb.exec_continue();
        }
        this.state = string;
    }

    private String getOSPath(String string) {
        if (Utilities.isWindows()) {
            if (this.isCygwin() && string.startsWith("/cygdrive/")) {
                return string.charAt(10) + ":" + string.substring(11);
            }
            if (this.isMinGW() && string.charAt(0) == '/' && string.charAt(2) == '/') {
                return string.charAt(1) + ":" + string.substring(2);
            }
            return string;
        }
        return string;
    }

    private void threadsViewInit() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");
        properties.getProperties("ThreadState").setBoolean("visible", false);
        properties.getProperties("ThreadSuspended").setBoolean("visible", false);
    }

    public void addPendingBreakpoint(int n, BreakpointImpl breakpointImpl) {
        this.pendingBreakpointMap.put(n, breakpointImpl);
    }

    private boolean breakpointValidation(int n, Object object) {
        BreakpointImpl breakpointImpl = this.pendingBreakpointMap.get(n);
        if (breakpointImpl != null) {
            if (object instanceof String) {
                breakpointImpl.addError((String)object);
            } else if (object instanceof Map || object == null) {
                this.pendingBreakpointMap.remove(n);
                breakpointImpl.completeValidation((Map)object);
                if (object != null && breakpointImpl.getBreakpoint().isEnabled()) {
                    Map map = (Map)object;
                    String string = (String)map.get("fullname");
                    String string2 = (String)map.get("file");
                    String string3 = (String)map.get("line");
                    if (this.firstBPfullname != null && this.firstBPfullname.equals(string) && this.firstBPline != null && this.firstBPline.equals(string3)) {
                        this.continueAfterFirstStop = false;
                    } else if (Utilities.getOperatingSystem() == 4096 && this.firstBPfile != null && this.firstBPfile.equals(string2) && this.firstBPline != null && this.firstBPline.equals(string3)) {
                        this.continueAfterFirstStop = false;
                    }
                }
            }
            if (this.pendingBreakpointMap.isEmpty() && this.state.equals(STATE_LOADING)) {
                this.setReady();
            } else if (breakpointImpl.isRunWhenValidated()) {
                breakpointImpl.setRunWhenValidated(false);
                this.setRunning();
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            String string = (String)map.get("number");
            String string4 = (String)map.get("fullname");
            String string5 = (String)map.get("file");
            String string6 = (String)map.get("line");
            String string7 = (String)map.get("func");
            if (string != null && (string.equals("1") || string.equals("2") && string7 != null && string7.equals("WinMain") && Utilities.isWindows())) {
                this.firstBPfullname = string4;
                this.firstBPfile = string5;
                this.firstBPline = string6;
            }
            this.temporaryBreakpoints.add(string);
        }
        return false;
    }

    public static void attach(String string, ProjectInformation projectInformation) throws DebuggerStartException {
        Project project = projectInformation.getProject();
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider != null) {
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
            MakeConfiguration makeConfiguration = (MakeConfiguration)makeConfigurationDescriptor.getConfs().getActive();
            MakeArtifact makeArtifact = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
            String string2 = makeConfiguration.getProfile().getRunDirectory().replace("\\", "/");
            String string3 = string2 + '/' + makeArtifact.getOutput();
            if (GdbDebugger.isExecutable(makeConfiguration, string3)) {
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, 999, projectInformation.getDisplayName(), string3, (Configuration)makeConfiguration, null, false);
                DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)SESSION_PROVIDER_ID, (Object[])new Object[]{projectActionEvent, Long.valueOf(string)}));
                if (debuggerEngineArray == null) {
                    throw new DebuggerStartException(new InternalError());
                }
            } else {
                final String string4 = NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachValidationFailure");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string4));
                    }
                });
            }
        }
    }

    private static boolean isExecutable(MakeConfiguration makeConfiguration, String string) {
        if (makeConfiguration.isApplicationConfiguration()) {
            return true;
        }
        if (makeConfiguration.isMakefileConfiguration()) {
            String string2;
            File file;
            if (Utilities.isWindows()) {
                if (string.endsWith(".dll")) {
                    return false;
                }
                if (!string.endsWith(".exe")) {
                    string = string + ".exe";
                }
                if ((file = new File(string)).exists()) {
                    return true;
                }
            }
            return (file = new File(string)).exists() && (string2 = FileUtil.getMIMEType((FileObject)FileUtil.toFileObject((File)file))) != null && string2.startsWith("application/x-exe");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stackUpdate(List<String> list) {
        ArrayList<CallStackFrame> arrayList = this.callstack;
        synchronized (arrayList) {
            this.callstack.clear();
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                Map<String, String> map = GdbUtils.createMapFromString(string.substring(6));
                String string2 = map.get("func");
                String string3 = map.get("file");
                String string4 = map.get("fullname");
                String string5 = map.get("line");
                String string6 = map.get("addr");
                if (string4 == null && string3 != null) {
                    if (string3.charAt(0) == '/') {
                        string4 = string3;
                        log.finest("GD.stackUpdate: Setting fullname from file");
                    } else {
                        string4 = this.runDirectory + string3;
                        log.finest("GD.stackUpdate: Setting fullname from runDirectory + file");
                    }
                }
                this.callstack.add(i, new CallStackFrame(this, string2, string3, string4, string5, string6, i));
            }
        }
        if (!list.isEmpty()) {
            this.pcs.firePropertyChange(PROP_CURRENT_CALL_STACK_FRAME, 0, 1);
        }
    }

    public void setCurrentThread(String string) {
        int n;
        if (string.length() > 0 && Character.isDigit(string.charAt(0)) && (n = string.indexOf(32)) > 0) {
            this.resetThreadInfo();
            this.gdb.thread_select(string.substring(0, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GdbVariable> getLocalVariables() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        ArrayList<GdbVariable> arrayList = this.localVariables;
        synchronized (arrayList) {
            return (List)this.localVariables.clone();
        }
    }

    public String evaluate(String string) {
        if (this.gdb == null) {
            return null;
        }
        CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
        if (string.indexOf(40) != -1) {
            this.suspendBreakpointsAndSignals();
            this.gdb.data_evaluate_expression(commandBuffer, '\"' + string + '\"');
            this.restoreBreakpointsAndSignals();
        } else {
            this.gdb.data_evaluate_expression(commandBuffer, '\"' + string + '\"');
        }
        String string2 = commandBuffer.waitForCompletion();
        if (commandBuffer.getState() == 4) {
            return NbBundle.getMessage(GdbDebugger.class, (String)"ERR_WatchedFunctionAborted");
        }
        if (string2.startsWith("@0x")) {
            int n;
            commandBuffer = new CommandBuffer(this.gdb);
            this.gdb.print(commandBuffer, string);
            string2 = commandBuffer.waitForCompletion();
            if (string2.length() > 0 && string2.charAt(0) == '$' && (n = string2.indexOf(61)) != -1 && n + 2 < string2.length()) {
                string2 = string2.substring(n + 2, string2.length()).replace("\\n", "").trim();
            }
        }
        return string2.length() > 0 ? string2 : null;
    }

    public Map<String, TypeInfo> getTypeInfoCache() {
        return ticache;
    }

    public String requestValue(String string) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state.equals(STATE_STOPPED)) {
            CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
            this.gdb.data_evaluate_expression(commandBuffer, string);
            String string2 = commandBuffer.waitForCompletion();
            if (string2.length() == 0 || commandBuffer.getState() != 3) {
                if (commandBuffer.getState() == 4) {
                    log.fine("GD.requestValue[" + commandBuffer.getID() + "]: Error [" + commandBuffer.getError() + "]");
                    return '>' + commandBuffer.getError() + '<';
                }
                log.fine("GD.requestValue[" + commandBuffer.getID() + "]: Failure [" + string2.length() + ", " + commandBuffer.getState() + "]");
                return "";
            }
            return string2;
        }
        return null;
    }

    public String requestWhatis(String string) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state.equals(STATE_STOPPED) && string != null && string.length() > 0) {
            CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
            this.gdb.whatis(commandBuffer, string);
            String string2 = commandBuffer.waitForCompletion();
            if (string2.length() == 0 || commandBuffer.getState() != 3) {
                if (commandBuffer.getState() == 4) {
                    log.fine("GD.requestWhatis[" + commandBuffer.getID() + "]: Error [" + commandBuffer.getError() + "]");
                    return "";
                }
                log.fine("GD.requestWhatis[" + commandBuffer.getID() + "]: Failure [" + string2.length() + ", " + commandBuffer.getState() + "]");
                return "";
            }
            return string2.substring(7, string2.length() - 2);
        }
        return null;
    }

    public String requestSymbolType(String string) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state.equals(STATE_STOPPED) && string != null && string.length() > 0) {
            CommandBuffer commandBuffer = new CommandBuffer(this.gdb);
            this.gdb.symbol_type(commandBuffer, string);
            String string2 = commandBuffer.waitForCompletion();
            if (string2.length() == 0 || commandBuffer.getState() != 3) {
                if (commandBuffer.getState() == 4) {
                    log.fine("GD.requestSymbolType[" + commandBuffer.getID() + "]: Error [" + commandBuffer.getError() + "]");
                    return "";
                }
                log.fine("GD.requestSymbolType[" + commandBuffer.getID() + "]: Failure [" + string2.length() + ", " + commandBuffer.getState() + "]. Returning original type");
                return string;
            }
            log.fine("GD.requestSymbolType[" + commandBuffer.getID() + "]: " + string + " --> [" + string2 + "]");
            return string2.substring(7, string2.length() - 2);
        }
        return null;
    }

    private void suspendBreakpointsAndSignals() {
        for (BreakpointImpl breakpointImpl : this.getBreakpointList().values()) {
            if (!breakpointImpl.getBreakpoint().isEnabled()) continue;
            this.gdb.break_disable(breakpointImpl.getBreakpointNumber());
        }
        this.gdb.set_unwindonsignal("on");
    }

    private void restoreBreakpointsAndSignals() {
        this.gdb.set_unwindonsignal("off");
        for (BreakpointImpl breakpointImpl : this.getBreakpointList().values()) {
            if (!breakpointImpl.getBreakpoint().isEnabled()) continue;
            this.gdb.break_enable(breakpointImpl.getBreakpointNumber());
        }
    }

    public ArrayList<CallStackFrame> getCallStack() {
        return this.callstack;
    }

    public CallStackFrame[] getCallStackFrames(int n, int n2) {
        int n3 = n2 - n;
        if (n + n3 <= this.getStackDepth()) {
            CallStackFrame[] callStackFrameArray = new CallStackFrame[n3];
            for (int i = 0; i < n3; ++i) {
                callStackFrameArray[i] = this.callstack.get(n + i);
            }
            return callStackFrameArray;
        }
        return new CallStackFrame[0];
    }

    public int getStackDepth() {
        return this.callstack.size();
    }

    public synchronized CallStackFrame getCurrentCallStackFrame() {
        if (this.currentCallStackFrame != null) {
            return this.currentCallStackFrame;
        }
        if (!this.callstack.isEmpty()) {
            return this.callstack.get(0);
        }
        return null;
    }

    public void setCurrentCallStackFrame(CallStackFrame callStackFrame) {
        if (this.isValidStackFrame(callStackFrame)) {
            CallStackFrame callStackFrame2 = this.setCurrentCallStackFrameNoFire(callStackFrame);
            this.updateLocalVariables(callStackFrame.getFrameNumber());
            if (callStackFrame2 == callStackFrame) {
                return;
            }
            this.pcs.firePropertyChange(PROP_CURRENT_CALL_STACK_FRAME, callStackFrame2, callStackFrame);
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallStackFrame setCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2;
        GdbDebugger gdbDebugger = this;
        synchronized (gdbDebugger) {
            callStackFrame2 = this.getCurrentCallStackFrame();
            if (callStackFrame == callStackFrame2) {
                return callStackFrame;
            }
            this.currentCallStackFrame = callStackFrame;
        }
        return callStackFrame2;
    }

    public boolean isValidStackFrame(CallStackFrame callStackFrame) {
        return callStackFrame.getFileName() != null && callStackFrame.getFullname() != null && callStackFrame.getFunctionName() != null;
    }

    public boolean isStepOutValid() {
        return this.callstack.size() == 1 || this.callstack.size() > 1 && this.isValidStackFrame(this.callstack.get(1));
    }

    public void popTopmostCall() {
        if (this.callstack.size() > 0 && this.isValidStackFrame(this.callstack.get(1))) {
            this.gdb.stack_select_frame(0);
            this.gdb.exec_finish();
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    public Map<String, BreakpointImpl> getBreakpointList() {
        return this.breakpointList;
    }

    public String getBestPath(String string) {
        if (string.indexOf(32) == -1 && Utilities.getOperatingSystem() != 4096) {
            return string;
        }
        if (string.startsWith(this.runDirectory)) {
            return string.substring(this.runDirectory.length());
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getRunDirectory() {
        return this.runDirectory;
    }

    public boolean canFixClasses() {
        return false;
    }

    public boolean canPopFrames() {
        return true;
    }

    public boolean canBeModified() {
        return true;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public int getCurrentToken() {
        return this.currentToken;
    }

    public boolean isCygwin() {
        return this.cygwin;
    }

    public boolean isMinGW() {
        return this.mingw;
    }

    public boolean isCplusPlus() {
        return this.cplusplus;
    }

    public Disassembly getDisassembly() {
        return this.disassembly;
    }

    public void setCurrentBreakpoint(GdbBreakpoint gdbBreakpoint) {
        this.currentBreakpoint = gdbBreakpoint;
    }

    public void setLastGo(Object object) {
        if (object == LAST_GO_WAS_CONTINUE || object == LAST_GO_WAS_FINISH || object == LAST_GO_WAS_STEP || object == LAST_GO_WAS_NEXT) {
            this.lastGo = object;
        }
    }

    private static class SymlinkCommand {
        private String path;
        private ProcessBuilder pb;
        private String linkline;

        SymlinkCommand(String string) {
            this.path = string;
            this.linkline = null;
            File file = new File("/bin/ls");
            if (file.exists()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("/bin/ls");
                arrayList.add("-l");
                arrayList.add(string);
                this.pb = new ProcessBuilder(arrayList);
                this.pb.redirectErrorStream(true);
            } else {
                this.pb = null;
            }
        }

        public String getPath() {
            if (this.pb != null) {
                try {
                    Process process = this.pb.start();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string = bufferedReader.readLine();
                    bufferedReader.close();
                    int n = string.indexOf("->");
                    if (n > 0) {
                        return string.substring(n + 2).trim();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.linkline;
        }
    }
}

