/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerStartException;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.actions.AttachTableColumn;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessList;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessListReader;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbAttachPanel
extends JPanel
implements Controller,
ProcessListReader {
    private ProcessList procList = new ProcessList(this);
    private AttachTableModel processModel;
    private FilterController filterController = new FilterController(this);
    private static List<FilterItem> filterList = new ArrayList<FilterItem>();
    private static String selectedFilter = "";
    private JComboBox filterCB;
    private JLabel filterLabel;
    private JScrollPane jScrollPane1;
    private JLabel procLabel;
    private JTable processTable;
    private JComboBox projectCB;
    private JLabel projectLabel;

    public GdbAttachPanel() {
        this.initProcessModel();
        this.initComponents();
        this.postComponentsInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postComponentsInit() {
        this.filterCB.addItem("");
        for (FilterItem projectArray : filterList) {
            this.filterCB.addItem(projectArray);
        }
        this.filterCB.setSelectedItem(selectedFilter);
        Object object = this.processTable.getColumn(this.procList.getArgsHeader());
        ((TableColumn)object).setPreferredWidth(300);
        ((TableColumn)object).setMinWidth(75);
        object = OpenProjects.getDefault().getMainProject();
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            PItem pItem = new PItem(projectInformation);
            this.projectCB.addItem(pItem);
            if (object == null || project != object) continue;
            this.projectCB.setSelectedItem(pItem);
        }
    }

    private void initProcessModel() {
        this.processModel = new AttachTableModel();
        for (AttachTableColumn attachTableColumn : this.procList.getColumnHeaders()) {
            this.processModel.addColumn(attachTableColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessList() {
        this.initProcessModel();
        this.processTable.setModel(this.processModel);
        TableColumn tableColumn = this.processTable.getColumn(this.procList.getArgsHeader());
        tableColumn.setPreferredWidth(300);
        tableColumn.setMinWidth(75);
        this.procList = new ProcessList(this);
    }

    public boolean cancel() {
        return true;
    }

    public boolean ok() {
        int n = this.processTable.getSelectedRow();
        if (n >= 0) {
            String string = this.processModel.getValueAt(n, 1).toString();
            PItem pItem = (PItem)this.projectCB.getSelectedItem();
            if (pItem != null) {
                try {
                    GdbDebugger.attach(string, pItem.getProjectInformation());
                }
                catch (DebuggerStartException debuggerStartException) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbAttachPanel.class, (String)"ERR_UnexpecedAttachFailure", (Object)string)));
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.projectCB.getItemCount() > 0;
    }

    @Override
    public void processListCallback(List<String> list) {
        Pattern pattern = this.getFilterRE();
        for (String string : list) {
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            if (pattern != null && !pattern.matcher(string).find()) continue;
            if (this.procList.isCygwin()) {
                this.processModel.addRow(this.reorderCygwinRow(vector));
                continue;
            }
            this.processModel.addRow(this.combineArgs(vector));
        }
    }

    private Vector<String> reorderCygwinRow(Vector<String> vector) {
        StringBuilder stringBuilder = new StringBuilder();
        Vector<String> vector2 = new Vector<String>(vector.size() - 2);
        String string = vector.get(0);
        if (string.length() == 1 && (string.equals("I") || string.equals("C") || string.equals("O"))) {
            int n;
            vector2.add(0, vector.get(6));
            vector2.add(1, vector.get(4));
            vector2.add(2, vector.get(1));
            vector2.add(3, vector.get(2));
            vector2.add(4, vector.get(7));
            String string2 = vector.get(7);
            if (Character.isDigit(string2.charAt(0))) {
                n = 8;
            } else {
                string2 = string2 + ' ' + vector.get(8);
                n = 9;
            }
            vector2.add(4, string2);
            while (n < vector.size()) {
                stringBuilder.append(vector.get(n++));
            }
        } else {
            int n;
            vector2.add(0, vector.get(5));
            vector2.add(1, vector.get(3));
            vector2.add(2, vector.get(0));
            vector2.add(3, vector.get(1));
            String string3 = vector.get(6);
            if (Character.isDigit(string3.charAt(0))) {
                n = 7;
            } else {
                string3 = string3 + ' ' + vector.get(7);
                n = 8;
            }
            vector2.add(4, string3);
            while (n < vector.size()) {
                stringBuilder.append(vector.get(n++));
            }
        }
        vector2.add(5, stringBuilder.toString());
        return vector2;
    }

    private Vector<String> combineArgs(Vector<String> vector) {
        Vector<String> vector2 = new Vector<String>(vector.size());
        vector2.add(0, vector.get(0));
        vector2.add(1, vector.get(1));
        vector2.add(2, vector.get(2));
        vector2.add(3, vector.get(3));
        vector2.add(4, vector.get(4));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 5; i < vector.size(); ++i) {
            stringBuilder.append(vector.get(i) + ' ');
        }
        vector2.add(5, stringBuilder.toString());
        return vector2;
    }

    private Pattern getFilterRE() {
        if (selectedFilter.length() > 0) {
            for (FilterItem filterItem : filterList) {
                if (!filterItem.toString().equals(selectedFilter)) continue;
                return filterItem.getPattern();
            }
        }
        return null;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.processTable = new JTable();
        this.filterLabel = new JLabel();
        this.filterCB = new JComboBox();
        this.filterCB.addActionListener(this.filterController);
        this.procLabel = new JLabel();
        this.projectLabel = new JLabel();
        this.projectCB = new JComboBox();
        this.processTable.setModel(this.processModel);
        this.processTable.setColumnSelectionAllowed(false);
        this.processTable.setRowSelectionAllowed(true);
        this.processTable.setShowVerticalLines(false);
        this.jScrollPane1.setViewportView(this.processTable);
        this.filterLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachFilterMNEM").charAt(0));
        this.filterLabel.setLabelFor(this.filterCB);
        this.filterLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachFilterLabel"));
        this.filterCB.setEditable(true);
        this.filterCB.setSelectedItem(selectedFilter);
        this.procLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachProcessMNEM").charAt(0));
        this.procLabel.setLabelFor(this.jScrollPane1);
        this.procLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachProcessLabel"));
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachProjectMNEM").charAt(0));
        this.projectLabel.setLabelFor(this.projectCB);
        this.projectLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachProjectLabel"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filterLabel).addPreferredGap(1).add((Component)this.filterCB, 0, 495, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectLabel).addPreferredGap(0).add((Component)this.projectCB, 0, 488, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.procLabel).addContainerGap()).add((Component)this.jScrollPane1, -1, 544, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.filterLabel).add((Component)this.filterCB, -2, -1, -2)).addPreferredGap(1).add((Component)this.procLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 257, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLabel).add((Component)this.projectCB, -2, -1, -2))));
    }

    class AttachTableModel
    extends DefaultTableModel {
        AttachTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class PItem {
        private ProjectInformation pinfo;

        public PItem(ProjectInformation projectInformation) {
            this.pinfo = projectInformation;
        }

        public String toString() {
            return this.pinfo.getDisplayName();
        }

        public Project getProject() {
            return this.pinfo.getProject();
        }

        public ProjectInformation getProjectInformation() {
            return this.pinfo;
        }
    }

    class FilterItem {
        private String text;
        private Pattern pattern;
        private boolean valid;

        public FilterItem(String string) {
            this.text = string;
            try {
                this.pattern = Pattern.compile(string);
                this.valid = true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbAttachPanel.class, (String)"ERR_BadFilterPattern")));
            }
        }

        public String toString() {
            return this.text;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }

    class FilterController
    implements ActionListener {
        private GdbAttachPanel panel;

        public FilterController(GdbAttachPanel gdbAttachPanel2) {
            this.panel = gdbAttachPanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = GdbAttachPanel.this.filterCB.getSelectedItem().toString();
            String string2 = actionEvent.getActionCommand();
            boolean bl = false;
            if (string2.equals("comboBoxEdited")) {
                FilterItem filterItem;
                if (string.length() > 0 && !filterList.contains(string) && (filterItem = new FilterItem(string)).isValid()) {
                    filterList.add(filterItem);
                    GdbAttachPanel.this.filterCB.addItem(filterItem);
                    selectedFilter = string;
                }
            } else if (string2.equals("comboBoxChanged") && !string.equals(selectedFilter)) {
                selectedFilter = string;
                bl = true;
            }
            if (bl) {
                this.panel.updateProcessList();
            }
        }
    }
}

