/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.debugger.gdb.actions.AttachTableColumn;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessListReader;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessList
implements Runnable {
    public static final int PTYPE_UNINITIALIZED = -1;
    public static final int PTYPE_STD = 0;
    public static final int PTYPE_CYGWIN = 1;
    private int ptype = -1;
    private List<String> args;
    private List<String> proclist;
    private ProcessBuilder pb;
    private BufferedReader reader;
    private ProcessListReader plr;

    protected ProcessList(ProcessListReader processListReader) {
        this.plr = processListReader;
        this.args = this.getProcessCommand();
        this.pb = new ProcessBuilder(this.args);
        this.pb.redirectErrorStream(true);
        this.proclist = new ArrayList<String>();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    @Override
    public void run() {
        try {
            String string;
            Process process = this.pb.start();
            this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.reader.readLine();
            while ((string = this.reader.readLine()) != null) {
                this.proclist.add(string);
            }
            this.plr.processListCallback(this.proclist);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int getPType() {
        return this.ptype;
    }

    protected boolean isStd() {
        return this.ptype == 0;
    }

    protected boolean isCygwin() {
        return this.ptype == 1;
    }

    protected List<AttachTableColumn> getColumnHeaders() {
        ArrayList<AttachTableColumn> arrayList = new ArrayList<AttachTableColumn>();
        if (this.ptype == 0) {
            arrayList.add(new AttachTableColumn("user", NbBundle.getMessage(ProcessList.class, (String)"HDR_USER")));
            arrayList.add(new AttachTableColumn("pid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PID")));
            arrayList.add(new AttachTableColumn("ppid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PPID")));
            arrayList.add(new AttachTableColumn("stime", NbBundle.getMessage(ProcessList.class, (String)"HDR_STIME")));
            arrayList.add(new AttachTableColumn("time", NbBundle.getMessage(ProcessList.class, (String)"HDR_TIME")));
            arrayList.add(new AttachTableColumn("args", NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS")));
        } else if (this.ptype == 1) {
            arrayList.add(new AttachTableColumn("uid", NbBundle.getMessage(ProcessList.class, (String)"HDR_UID")));
            arrayList.add(new AttachTableColumn("winpid", NbBundle.getMessage(ProcessList.class, (String)"HDR_WINPID")));
            arrayList.add(new AttachTableColumn("pid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PID")));
            arrayList.add(new AttachTableColumn("ppid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PPID")));
            arrayList.add(new AttachTableColumn("stime", NbBundle.getMessage(ProcessList.class, (String)"HDR_STIME")));
            arrayList.add(new AttachTableColumn("args", NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS")));
        }
        return arrayList;
    }

    protected String getArgsHeader() {
        return NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS");
    }

    private List<String> getProcessCommand() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Utilities.isWindows()) {
            File file = new File(CppUtils.getCygwinBase() + "/bin", "ps.exe");
            if (file.exists()) {
                arrayList.add(file.getAbsolutePath());
                this.ptype = 1;
            } else {
                file = new File(CppUtils.getMSysBase() + "/bin", "ps.exe");
                if (file.exists()) {
                    arrayList.add(file.getAbsolutePath());
                    this.ptype = 1;
                }
            }
        } else if (new File("/bin/ps").exists()) {
            arrayList.add("/bin/ps");
            arrayList.add("-a");
            arrayList.add("-o");
            if (Utilities.getOperatingSystem() == 4096) {
                arrayList.add("user,pid,ppid,stime,time,command");
            } else {
                arrayList.add("user,pid,ppid,stime,time,args");
            }
            this.ptype = 0;
        } else if (new File("/usr/bin/ps").exists()) {
            arrayList.add("/usr/bin/ps");
            arrayList.add("-a");
            arrayList.add("-o");
            arrayList.add("user,pid,ppid,stime,time,args");
            this.ptype = 0;
        }
        return arrayList;
    }
}

