/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointsReader;

public class AddressBreakpointImpl
extends BreakpointImpl {
    private AddressBreakpoint breakpoint;
    private BreakpointsReader reader;

    public AddressBreakpointImpl(AddressBreakpoint addressBreakpoint, BreakpointsReader breakpointsReader, GdbDebugger gdbDebugger, Session session) {
        super(addressBreakpoint, breakpointsReader, gdbDebugger, session);
        this.reader = breakpointsReader;
        this.breakpoint = addressBreakpoint;
        this.set();
    }

    protected void setRequests() {
        String string = this.getState();
        if (this.getDebugger().getState().equals("state_running")) {
            this.getDebugger().setSilentStop();
            this.setRunWhenValidated(true);
        }
        if (string.equals("BpState_Unvalidated") || string.equals("BpState_Revalidate")) {
            if (string.equals("BpState_Revalidate") && this.getBreakpointNumber() > 0) {
                this.getDebugger().getGdbProxy().break_delete(this.getBreakpointNumber());
            }
            this.setState("BpState_ValidationPending");
            String string2 = this.breakpoint.getAddress();
            int n = this.getBreakpoint().getSuspend() == 1 ? this.getDebugger().getGdbProxy().break_insert(1, "*" + string2, this.getBreakpoint().getThreadID()) : this.getDebugger().getGdbProxy().break_insert("*" + string2);
            this.getDebugger().addPendingBreakpoint(n, this);
        } else {
            if (string.equals("BpState_DeletionPending")) {
                this.getDebugger().getGdbProxy().break_delete(this.getBreakpointNumber());
            } else if (string.equals("BpState_Validated")) {
                if (this.breakpoint.isEnabled()) {
                    this.getDebugger().getGdbProxy().break_enable(this.getBreakpointNumber());
                } else {
                    this.getDebugger().getGdbProxy().break_disable(this.getBreakpointNumber());
                }
            }
            if (this.isRunWhenValidated()) {
                this.getDebugger().setRunning();
                this.setRunWhenValidated(false);
            }
        }
    }
}

