/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointsReader;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.event.GdbBreakpointEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BreakpointImpl
implements PropertyChangeListener {
    public static final String BPSTATE_UNVALIDATED = "BpState_Unvalidated";
    public static final String BPSTATE_REVALIDATE = "BpState_Revalidate";
    public static final String BPSTATE_VALIDATION_PENDING = "BpState_ValidationPending";
    public static final String BPSTATE_VALIDATION_FAILED = "BpState_ValidationFailed";
    public static final String BPSTATE_VALIDATED = "BpState_Validated";
    public static final String BPSTATE_DELETION_PENDING = "BpState_DeletionPending";
    private GdbDebugger debugger;
    private String state;
    private int breakpointNumber;
    private GdbBreakpoint breakpoint;
    private BreakpointsReader reader;
    private final Session session;
    private String err;
    private boolean runWhenValidated;

    protected BreakpointImpl(GdbBreakpoint gdbBreakpoint, BreakpointsReader breakpointsReader, GdbDebugger gdbDebugger, Session session) {
        this.debugger = gdbDebugger;
        this.reader = breakpointsReader;
        this.breakpoint = gdbBreakpoint;
        this.session = session;
        this.state = BPSTATE_UNVALIDATED;
        this.breakpointNumber = -1;
        this.err = null;
        this.runWhenValidated = false;
    }

    public void completeValidation(Map<String, String> map) {
        if (!this.getState().equals(BPSTATE_DELETION_PENDING)) {
            assert (this.getState().equals(BPSTATE_VALIDATION_PENDING)) : this.getState();
            String string = map != null ? map.get("number") : null;
            if (string != null) {
                int n;
                String string2;
                this.breakpointNumber = Integer.parseInt(string);
                this.setState(BPSTATE_VALIDATED);
                if (!this.breakpoint.isEnabled()) {
                    this.getDebugger().getGdbProxy().break_disable(this.breakpointNumber);
                }
                if ((string2 = this.breakpoint.getCondition()).length() > 0) {
                    this.getDebugger().getGdbProxy().break_condition(this.breakpointNumber, string2);
                }
                if ((n = this.breakpoint.getSkipCount()) > 0) {
                    this.getDebugger().getGdbProxy().break_after(this.breakpointNumber, Integer.toString(n));
                }
                if (this instanceof FunctionBreakpointImpl) {
                    try {
                        this.breakpoint.setURL(map.get("fullname"));
                        this.breakpoint.setLineNumber(Integer.parseInt(map.get("line")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.breakpoint.setValid();
            } else {
                this.breakpoint.setInvalid(this.err);
                this.setState(BPSTATE_VALIDATION_FAILED);
            }
            this.getDebugger().getBreakpointList().put(string, this);
        }
    }

    public void addError(String string) {
        this.err = this.err != null ? this.err + string : string;
    }

    protected String getState() {
        return this.state;
    }

    protected void setState(String string) {
        if (!string.equals(this.state) && (string.equals(BPSTATE_UNVALIDATED) || string.equals(BPSTATE_REVALIDATE) || string.equals(BPSTATE_VALIDATION_PENDING) || string.equals(BPSTATE_VALIDATION_FAILED) || string.equals(BPSTATE_VALIDATED) || string.equals(BPSTATE_DELETION_PENDING))) {
            this.state = string;
            if (string.equals(BPSTATE_UNVALIDATED)) {
                this.setBreakpointNumber(-1);
            }
        }
    }

    public int getBreakpointNumber() {
        return this.breakpointNumber;
    }

    protected void setBreakpointNumber(int n) {
        this.breakpointNumber = n;
    }

    final void set() {
        this.breakpoint.setDebugger(this.getDebugger());
        this.breakpoint.addPropertyChangeListener(this);
        this.update();
    }

    protected abstract void setRequests();

    protected void suspend() {
        this.getDebugger().getGdbProxy().break_delete(this.getBreakpointNumber());
        this.setState(BPSTATE_UNVALIDATED);
        this.setRequests();
    }

    void fixed() {
        this.update();
    }

    final void update() {
        if (!this.getDebugger().getState().equals("state_none")) {
            this.setRequests();
        }
    }

    protected final void setValidity(Breakpoint.VALIDITY vALIDITY, String string) {
        if (this.breakpoint instanceof ChangeListener) {
            ((ChangeListener)((Object)this.breakpoint)).stateChanged(new ValidityChangeEvent(vALIDITY, string));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("disposed")) {
            this.remove();
        }
        if (string.equals("condition")) {
            this.getDebugger().getGdbProxy().break_condition(this.breakpointNumber, propertyChangeEvent.getNewValue().toString());
        } else if (string.equals("skipCount")) {
            this.getDebugger().getGdbProxy().break_after(this.breakpointNumber, propertyChangeEvent.getNewValue().toString());
        } else if (string.equals("suspend")) {
            this.suspend();
        } else if (string.equals("lineNumber") && this.getState().equals(BPSTATE_VALIDATED)) {
            this.setState(BPSTATE_REVALIDATE);
            this.update();
        } else if (string.equals("functionName") && this.getState().equals(BPSTATE_VALIDATED)) {
            this.setState(BPSTATE_REVALIDATE);
            this.update();
        } else if (string.equals("address") && this.getState().equals(BPSTATE_VALIDATED)) {
            this.setState(BPSTATE_REVALIDATE);
            this.update();
        } else if (!string.equals("lineNumber") && !"refresh".equals(string)) {
            this.update();
        }
    }

    protected final void remove() {
        this.breakpoint.removePropertyChangeListener(this);
        this.setState(BPSTATE_DELETION_PENDING);
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
        if (this.breakpointNumber > 0) {
            this.getDebugger().getBreakpointList().remove(this.breakpointNumber);
        }
    }

    public GdbBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected GdbDebugger getDebugger() {
        return this.debugger;
    }

    public boolean perform(String string) {
        boolean bl = false;
        if (string == null || string.equals("")) {
            GdbBreakpointEvent gdbBreakpointEvent = new GdbBreakpointEvent(this.getBreakpoint(), this.getDebugger(), 0, null);
            this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), gdbBreakpointEvent);
        }
        if (!bl) {
            DebuggerManager.getDebuggerManager().setCurrentSession(this.session);
        }
        return bl;
    }

    public void setRunWhenValidated(boolean bl) {
        this.runWhenValidated = bl;
    }

    public boolean isRunWhenValidated() {
        return this.runWhenValidated;
    }

    private static final class ValidityChangeEvent
    extends ChangeEvent {
        private String reason;

        public ValidityChangeEvent(Breakpoint.VALIDITY vALIDITY, String string) {
            super(vALIDITY);
            this.reason = string;
        }

        public String toString() {
            return this.reason;
        }
    }
}

