/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointsReader;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;

public class LineBreakpointImpl
extends BreakpointImpl {
    private LineBreakpoint breakpoint;
    private int lineNumber;
    private BreakpointsReader reader;

    public LineBreakpointImpl(LineBreakpoint lineBreakpoint, BreakpointsReader breakpointsReader, GdbDebugger gdbDebugger, Session session) {
        super(lineBreakpoint, breakpointsReader, gdbDebugger, session);
        this.reader = breakpointsReader;
        this.breakpoint = lineBreakpoint;
        this.lineNumber = lineBreakpoint.getLineNumber();
        this.set();
    }

    void fixed() {
        this.lineNumber = this.breakpoint.getLineNumber();
        super.fixed();
    }

    protected void setRequests() {
        String string = this.getState();
        if (this.getDebugger().getState().equals("state_running") && !string.equals("BpState_Revalidate")) {
            this.getDebugger().setSilentStop();
            this.setRunWhenValidated(true);
        }
        if (string.equals("BpState_Unvalidated") || string.equals("BpState_Revalidate")) {
            if (string.equals("BpState_Revalidate") && this.getBreakpointNumber() > 0) {
                this.getDebugger().getGdbProxy().break_delete(this.getBreakpointNumber());
            }
            this.setState("BpState_ValidationPending");
            this.lineNumber = this.breakpoint.getLineNumber();
            String string2 = this.getDebugger().getBestPath(this.breakpoint.getPath());
            int n = this.getBreakpoint().getSuspend() == 1 ? this.getDebugger().getGdbProxy().break_insert(1, string2 + ':' + this.lineNumber, this.getBreakpoint().getThreadID()) : this.getDebugger().getGdbProxy().break_insert(string2 + ':' + this.lineNumber);
            this.getDebugger().addPendingBreakpoint(n, this);
        } else {
            int n = this.getBreakpointNumber();
            if (n > 0) {
                if (string.equals("BpState_DeletionPending")) {
                    this.getDebugger().getGdbProxy().break_delete(n);
                } else if (string.equals("BpState_Validated")) {
                    if (this.breakpoint.isEnabled()) {
                        this.getDebugger().getGdbProxy().break_enable(n);
                    } else {
                        this.getDebugger().getGdbProxy().break_disable(n);
                    }
                }
                if (this.isRunWhenValidated()) {
                    this.getDebugger().setRunning();
                    this.setRunWhenValidated(false);
                }
            }
        }
    }
}

