/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.Field;
import org.netbeans.modules.cnd.debugger.gdb.LocalVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class VariablesNodeModel
implements ExtendedNodeModel {
    public static final String FIELD = "org/netbeans/modules/debugger/resources/watchesView/Field.gif";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/LocalVariable.gif";
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    private RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection<ModelListener> modelListeners = new HashSet<ModelListener>();
    private String LC_NoInfo = NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_No_Info");
    private String LC_NoCurrentThreadVar = NbBundle.getMessage(VariablesNodeModel.class, (String)"NoCurrentThreadVar");
    private String LC_LocalsModelColumnNameName = NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_Name");
    private String LC_LocalsModelColumnNameDesc = NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_Desc");
    private final String strNoInfo = "NoInfo";
    private final String strSubArray = "SubArray";
    private final String strNoCurrentThread = "No current thread";
    private Map<Object, String> shortDescriptionMap = new HashMap<Object, String>();

    public VariablesNodeModel(ContextProvider contextProvider) {
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return this.LC_LocalsModelColumnNameName;
        }
        if (object instanceof Field) {
            return ((Field)object).getName();
        }
        if (object instanceof LocalVariable) {
            return ((LocalVariable)object).getName();
        }
        String string = object.toString();
        if (string.equals("NoInfo")) {
            return this.LC_NoInfo;
        }
        if (string.equals("No current thread")) {
            return this.LC_NoCurrentThreadVar;
        }
        if (string.startsWith("SubArray")) {
            int n = string.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_SubArray", (Object)string.substring(8, n), (Object)string.substring(n + 1));
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final Object object) throws UnknownTypeException {
        Map<Object, String> map = this.shortDescriptionMap;
        synchronized (map) {
            String string = this.shortDescriptionMap.remove(object);
            if (string instanceof String) {
                return string;
            }
            if (string instanceof UnknownTypeException) {
                throw (UnknownTypeException)string;
            }
        }
        this.testKnown(object);
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = VariablesNodeModel.this.getShortDescriptionSync(object);
                if (string != null && string.length() > 0) {
                    Map map = VariablesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        VariablesNodeModel.this.shortDescriptionMap.put(object, string);
                    }
                    VariablesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesNodeModel.this, object, 4));
                }
            }
        });
        return "";
    }

    private String getShortDescriptionSync(Object object) {
        if (object == "Root") {
            return this.LC_LocalsModelColumnNameDesc;
        }
        if (object instanceof Field) {
            Field field = (Field)object;
            if (field.getType().length() == 0 && field.getValue().equals("...")) {
                return NbBundle.getMessage(VariablesNodeModel.class, (String)"LBL_TruncatedByGdb");
            }
            return "(" + ((Field)object).getType() + ") " + ((Field)object).getValue();
        }
        if (object instanceof LocalVariable) {
            return "(" + ((LocalVariable)object).getType() + ") " + ((LocalVariable)object).getValue();
        }
        String string = object.toString();
        if (string.startsWith("SubArray")) {
            int n = string.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Descr_SubArray", (Object)string.substring(8, n), (Object)string.substring(n + 1));
        }
        if (string.equals("NoInfo")) {
            return this.LC_NoInfo;
        }
        if (string.equals("No current thread")) {
            return this.LC_NoCurrentThreadVar;
        }
        return "";
    }

    private void testKnown(Object object) throws UnknownTypeException {
        if (object == "Root" || object instanceof Field || object instanceof LocalVariable) {
            return;
        }
        String string = object.toString();
        if (string.startsWith("SubArray") || string.equals("NoInfo") || string.equals("No current thread")) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
        if (object == "Root" || object instanceof GdbWatchVariable || object instanceof Watch) {
            return WATCH;
        }
        if (object instanceof Field) {
            return FIELD;
        }
        if (object instanceof AbstractVariable) {
            return LOCAL;
        }
        String string = object.toString();
        if (string.startsWith("SubArray")) {
            return LOCAL;
        }
        if (string.equals("NoInfo") || string.equals("No current thread")) {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent modelEvent) {
        Object[] objectArray;
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            objectArray = this.modelListeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged(modelEvent);
        }
    }

    public boolean canRename(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object object) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
        return null;
    }

    public void setName(Object object, String string) throws UnknownTypeException {
        throw new UnsupportedOperationException();
    }
}

