/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.completion.cplusplus.NbCompletionJavaDoc;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmResultItem;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmSyntaxSupport;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.MethodParamsTipPaintComponent;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.NbBundle;

public class CsmCompletionProvider
implements CompletionProvider {
    private static final boolean TRACE = false;
    private static final CompletionItem lastItem = new LastResultItem();

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        CsmSyntaxSupport csmSyntaxSupport = (CsmSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent).get(CsmSyntaxSupport.class);
        if (csmSyntaxSupport == null) {
            return 0;
        }
        int n = jTextComponent.getCaret().getDot();
        if (CsmCompletionQuery.checkCondition(csmSyntaxSupport, n)) {
            try {
                if (csmSyntaxSupport.needShowCompletionOnText(jTextComponent, string)) {
                    return 1;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        CsmSyntaxSupport csmSyntaxSupport = (CsmSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent).get(CsmSyntaxSupport.class);
        int n2 = jTextComponent.getCaret().getDot();
        CsmResultItem.setEnableInstantSubstitution(true);
        if (CsmCompletionQuery.checkCondition(csmSyntaxSupport, n2)) {
            if ((n & 1) == 1) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new Query(n2, n), jTextComponent);
            }
            if (n == 2) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), jTextComponent);
            }
            if (n == 4) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new ToolTipQuery(), jTextComponent);
            }
        }
        return null;
    }

    public static final CsmCompletionQuery getCompletionQuery() {
        return new NbCsmCompletionQuery(null, CsmCompletionQuery.QueryScope.GLOBAL_QUERY);
    }

    public static final CsmCompletionQuery getCompletionQuery(CsmFile csmFile, CsmCompletionQuery.QueryScope queryScope) {
        return new NbCsmCompletionQuery(csmFile, queryScope);
    }

    private static final class LastResultItem
    extends CsmResultItem {
        private final String str = "" + Query.access$600() + " " + NbBundle.getBundle(CsmCompletionProvider.class).getString("last-item-text");
        private static final CsmPaintComponent.StringPaintComponent stringComponent = new CsmPaintComponent.StringPaintComponent();

        public LastResultItem() {
            super(null, Integer.MAX_VALUE);
        }

        public Component getPaintComponent(boolean bl) {
            stringComponent.setString(this.str);
            return stringComponent;
        }

        public void defaultAction(JTextComponent jTextComponent) {
        }

        public String getItemText() {
            return this.str;
        }
    }

    static class ToolTipQuery
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private JToolTip queryToolTip;
        private Position queryMethodParamsStartPos = null;
        private boolean otherMethodContext;

        ToolTipQuery() {
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            BaseDocument baseDocument;
            Position position = this.queryMethodParamsStartPos;
            this.queryMethodParamsStartPos = null;
            NbCsmCompletionQuery nbCsmCompletionQuery = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery();
            CsmCompletionQuery.CsmCompletionResult csmCompletionResult = (CsmCompletionQuery.CsmCompletionResult)nbCsmCompletionQuery.query(this.component, n, (baseDocument = (BaseDocument)document).getSyntaxSupport(), true, false);
            if (csmCompletionResult != null) {
                this.queryCaretOffset = n;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = -1;
                boolean bl = false;
                for (Object e : csmCompletionResult.getData()) {
                    Object object;
                    if (!(e instanceof CsmResultItem.ConstructorResultItem)) continue;
                    CsmResultItem.ConstructorResultItem constructorResultItem = (CsmResultItem.ConstructorResultItem)e;
                    if (!bl) {
                        object = constructorResultItem.getExpression();
                        int n3 = ((CsmCompletionExpression)object).getTokenCount() - 1;
                        if (n3 >= 0) {
                            if (((CsmCompletionExpression)object).getExpID() == 11 && ((CsmCompletionExpression)object).getTokenID(n3) == CCTokenContext.RPAREN) {
                                if (((CsmCompletionExpression)object).getTokenOffset(n3) + ((CsmCompletionExpression)object).getTokenLength(n3) <= n) {
                                    completionResultSet.finish();
                                    return;
                                }
                            } else if (((CsmCompletionExpression)object).getExpID() == 1 && ((CsmCompletionExpression)object).getTokenOffset(0) + ((CsmCompletionExpression)object).getTokenLength(0) >= n) {
                                completionResultSet.finish();
                                return;
                            }
                            try {
                                this.queryMethodParamsStartPos = baseDocument.createPosition(((CsmCompletionExpression)object).getTokenOffset(0));
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        bl = true;
                    }
                    if ((object = constructorResultItem.createParamsList()).size() > 0) {
                        n2 = constructorResultItem.getCurrentParamIndex();
                    } else {
                        object.add(NbBundle.getMessage(CsmCompletionProvider.class, (String)"CC-no-parameters"));
                    }
                    arrayList.add(object);
                }
                this.queryAnchorOffset = csmCompletionResult.getSubstituteOffset() + 1;
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                this.queryToolTip = new MethodParamsTipPaintComponent(arrayList, n2);
                completionResultSet.setToolTip(this.queryToolTip);
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            String string = null;
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            try {
                string = n - this.queryCaretOffset > 0 ? document.getText(this.queryCaretOffset, n - this.queryCaretOffset) : (n - this.queryCaretOffset < 0 ? document.getText(n, this.queryCaretOffset - n) : "");
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (string == null) {
                return false;
            }
            boolean bl = true;
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ',': {
                        bl = false;
                        break;
                    }
                    case '(': {
                        ++n2;
                        bl = false;
                        break;
                    }
                    case ')': {
                        --n2;
                        bl = false;
                    }
                }
                if (n2 >= 0) continue;
                this.otherMethodContext = true;
            }
            if (this.otherMethodContext && n2 < 0) {
                this.otherMethodContext = false;
            }
            if (this.queryMethodParamsStartPos == null || n <= this.queryMethodParamsStartPos.getOffset()) {
                bl = false;
            }
            return this.otherMethodContext || bl;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (!this.otherMethodContext) {
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                completionResultSet.setToolTip(this.queryToolTip);
            }
            completionResultSet.finish();
        }
    }

    static class DocQuery
    extends AsyncCompletionQuery {
        private Object item;
        private JTextComponent component;

        DocQuery(Object object) {
            this.item = object;
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            if (this.item == null) {
                this.item = CompletionUtilities.findItemAtCaretPos(this.component, n);
            }
            if (this.item != null) {
                completionResultSet.setDocumentation((CompletionDocumentation)new DocItem(this.getAssociatedObject(this.item), ExtUtilities.getExtEditorUI((JTextComponent)this.component)));
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        private Object getAssociatedObject(Object object) {
            Object object2 = object;
            if (object instanceof NbCsmResultItem) {
                object2 = ((NbCsmResultItem)object).getAssociatedObject();
            }
            return object2;
        }

        private class DocItem
        implements CompletionDocumentation {
            private String text;
            private MyJavaDoc doc;
            private Action goToSource = null;
            private ExtEditorUI ui;
            private URL url;

            public DocItem(Object object, ExtEditorUI extEditorUI) {
                this.ui = extEditorUI;
                this.doc = new MyJavaDoc(extEditorUI);
                this.doc.setItem(object);
                this.url = this.getURL(object);
            }

            public CompletionDocumentation resolveLink(String string) {
                Object object = this.doc.parseLink(string, null);
                return object != null ? new DocItem(object, this.ui) : null;
            }

            public String getText() {
                return this.text;
            }

            public URL getURL() {
                return this.url;
            }

            private URL getURL(Object object) {
                return this.doc.getURL(object);
            }

            public Action getGotoSourceAction() {
                return this.goToSource;
            }

            private class MyJavaDoc
            extends NbCompletionJavaDoc {
                private MyJavaDoc(ExtEditorUI extEditorUI) {
                    super(extEditorUI);
                }

                private void setItem(Object object) {
                    new MyJavaDocParser(object).run();
                }

                private URL getURL(Object object) {
                    URL[] uRLArray = this.getCsmSyntaxSupport().getJavaDocURLs(object);
                    return uRLArray == null || uRLArray.length < 1 ? null : uRLArray[0];
                }

                private class MyJavaDocParser
                extends NbCompletionJavaDoc.ParsingThread {
                    private MyJavaDocParser(Object object) {
                        super(MyJavaDoc.this, object);
                    }

                    protected void showJavaDoc(String string) {
                        DocItem.this.text = string;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Query
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private CsmCompletionQuery.CsmCompletionResult queryResult;
        private int creationCaretOffset;
        private int queryAnchorOffset;
        private String filterPrefix;
        private boolean caseSensitive = false;
        private CsmCompletionQuery.QueryScope queryScope;
        private static final int MAX_ITEMS_TO_DISPLAY;

        Query(int n, int n2) {
            this.creationCaretOffset = n;
            this.queryAnchorOffset = -1;
            this.queryScope = (n2 & 9) != 9 ? CsmCompletionQuery.QueryScope.SMART_QUERY : CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
        }

        private String getTestState() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" creationCaretOffset = " + this.creationCaretOffset);
            stringBuilder.append(" queryAnchorOffset = " + this.queryAnchorOffset);
            stringBuilder.append(" queryScope = " + (Object)((Object)this.queryScope));
            stringBuilder.append(" filterPrefix = " + this.filterPrefix);
            if (this.queryResult == null) {
                stringBuilder.append(" no queryResult");
            } else if (this.queryResult.isSimpleVariableExpression()) {
                stringBuilder.append(" queryResult is simple");
            } else {
                stringBuilder.append(" queryResult is not simple");
            }
            return stringBuilder.toString();
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            Class clazz = Utilities.getKitClass((JTextComponent)jTextComponent);
            boolean bl = this.caseSensitive = clazz != null ? this.getCaseSensitive(clazz) : false;
            if (this.creationCaretOffset > 0 && n >= this.creationCaretOffset) {
                try {
                    if (this.isCppIdentifierPart(document.getText(this.creationCaretOffset, n - this.creationCaretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        private void addItems(CompletionResultSet completionResultSet, Collection<CompletionItem> collection) {
            boolean bl = false;
            if (collection.size() > MAX_ITEMS_TO_DISPLAY && this.queryResult.isSimpleVariableExpression()) {
                bl = true;
            }
            completionResultSet.setHasAdditionalItems(this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY);
            if (!bl) {
                CsmResultItem.setEnableInstantSubstitution(this.queryScope == CsmCompletionQuery.QueryScope.GLOBAL_QUERY);
                completionResultSet.estimateItems(collection.size(), -1);
                completionResultSet.addAllItems(collection);
            } else {
                completionResultSet.estimateItems(MAX_ITEMS_TO_DISPLAY + 1, -1);
                int n = 0;
                for (CompletionItem completionItem : collection) {
                    completionResultSet.addItem(completionItem);
                    if (++n <= MAX_ITEMS_TO_DISPLAY) continue;
                    break;
                }
                completionResultSet.addItem(lastItem);
            }
        }

        private boolean getCaseSensitive(Class clazz) {
            return SettingsUtil.getBoolean((Class)clazz, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            boolean bl;
            boolean bl2 = bl = n <= this.queryAnchorOffset && this.filterPrefix == null;
            if (!bl) {
                this.creationCaretOffset = n;
                SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)this.component);
                if (syntaxSupport != null) {
                    CsmSyntaxSupport csmSyntaxSupport = (CsmSyntaxSupport)syntaxSupport.get(CsmSyntaxSupport.class);
                    NbCsmCompletionQuery nbCsmCompletionQuery = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery(null, this.queryScope);
                    CsmCompletionQuery.CsmCompletionResult csmCompletionResult = (CsmCompletionQuery.CsmCompletionResult)nbCsmCompletionQuery.query(this.component, n, (SyntaxSupport)csmSyntaxSupport);
                    if (csmCompletionResult == null || csmCompletionResult.getData().isEmpty() && this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY) {
                        this.queryScope = CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
                        if (csmCompletionResult == null || csmCompletionResult.isSimpleVariableExpression()) {
                            nbCsmCompletionQuery = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery(null, this.queryScope);
                            csmCompletionResult = (CsmCompletionQuery.CsmCompletionResult)nbCsmCompletionQuery.query(this.component, n, (SyntaxSupport)csmSyntaxSupport);
                        }
                    }
                    if (csmCompletionResult != null) {
                        if (this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY && !csmCompletionResult.isSimpleVariableExpression()) {
                            this.queryScope = CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
                        }
                        this.queryAnchorOffset = csmCompletionResult.getSubstituteOffset();
                        List list = csmCompletionResult.getData();
                        completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                        this.queryResult = csmCompletionResult;
                        this.addItems(completionResultSet, list);
                    }
                }
            } else {
                Completion.get().hideCompletion();
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && n >= this.creationCaretOffset) {
                try {
                    this.filterPrefix = document.getText(this.queryAnchorOffset, n - this.queryAnchorOffset);
                    if (this.queryResult == null || !this.isCppIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    } else {
                        Collection collection = this.getFilteredData(this.queryResult.getData(), this.filterPrefix);
                        if (collection.isEmpty()) {
                            this.filterPrefix = null;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                Collection collection = this.getFilteredData(this.queryResult.getData(), this.filterPrefix);
                this.addItems(completionResultSet, collection);
            }
            completionResultSet.finish();
        }

        private boolean isCppIdentifierPart(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (CndLexerUtilities.isCppIdentifierPart((char)string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection collection, String string) {
            ArrayList<CompletionQuery.ResultItem> arrayList = new ArrayList<CompletionQuery.ResultItem>(1024);
            boolean bl = string.length() > 1 && string.equals(string.toUpperCase());
            for (CompletionQuery.ResultItem resultItem : collection) {
                if (!this.matchPrefix(resultItem.getItemText(), string, this.caseSensitive)) continue;
                arrayList.add(resultItem);
            }
            return arrayList;
        }

        private boolean matchPrefix(String string, String string2, boolean bl) {
            return bl ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
        }

        private String getFilteredTitle(String string, String string2) {
            String string3;
            int n = string.lastIndexOf(46);
            String string4 = string3 = n == -1 ? string2 : string.substring(0, n + 1) + string2;
            if (string.endsWith("*")) {
                string3 = string3 + "*";
            }
            return string3;
        }

        static /* synthetic */ int access$600() {
            return MAX_ITEMS_TO_DISPLAY;
        }

        static {
            int n = 256;
            if (System.getProperty("cnd.completion.items") != null) {
                try {
                    n = Integer.parseInt(System.getProperty("cnd.completion.items"));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 256;
                }
            }
            MAX_ITEMS_TO_DISPLAY = n;
        }
    }
}

