/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.openide.filesystems.FileObject;

public class CsmFinderImpl
implements CsmFinder,
SettingsChangeListener {
    public CsmModel model = null;
    private boolean caseSensitive = false;
    private boolean naturalSort = false;
    private FileObject fo;
    private CsmFile csmFile;
    private Class kitClass;

    public CsmFinderImpl(FileObject fileObject, Class clazz) {
        this();
        this.fo = fileObject;
        this.kitClass = clazz;
        this.caseSensitive = this.getCaseSensitive();
        this.naturalSort = this.getNaturalSort();
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public CsmFinderImpl(CsmFile csmFile, Class clazz) {
        this();
        this.csmFile = csmFile;
        this.kitClass = clazz;
        this.caseSensitive = this.getCaseSensitive();
        this.naturalSort = this.getNaturalSort();
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public CsmFinderImpl() {
    }

    public CsmFile getCsmFile() {
        return this.csmFile;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (settingsChangeEvent == null || this.kitClass != settingsChangeEvent.getKitClass()) {
            return;
        }
        if ("completion-case-sensitive".equals(settingsChangeEvent.getSettingName())) {
            this.caseSensitive = this.getCaseSensitive();
        } else if ("completion-natural-sort".equals(settingsChangeEvent.getSettingName())) {
            this.naturalSort = this.getNaturalSort();
        }
    }

    private boolean getCaseSensitive() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
    }

    private boolean getNaturalSort() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-natural-sort", (Boolean)ExtSettingsDefaults.defaultCompletionNaturalSort);
    }

    private CsmNamespace resolveNamespace(String string, boolean bl) {
        CsmNamespace csmNamespace;
        CsmModel csmModel = CsmModelAccessor.getModel();
        HashSet hashSet = new HashSet();
        for (CsmProject csmProject : csmModel.projects()) {
            csmNamespace = csmProject.findNamespace((CharSequence)string);
            if (csmNamespace != null) {
                return csmNamespace;
            }
            hashSet.addAll(csmProject.getLibraries());
        }
        for (CsmProject csmProject : hashSet) {
            csmNamespace = csmProject.findNamespace((CharSequence)string);
            if (csmNamespace == null) continue;
            return csmNamespace;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmNamespace getExactNamespace(String string) {
        CsmNamespace csmNamespace;
        CsmNamespace csmNamespace2 = csmNamespace = this.resolveNamespace(string, true);
        return csmNamespace2;
    }

    public CsmClassifier getExactClassifier(String string) {
        CsmClassifier csmClassifier = this.csmFile.getProject().findClassifier((CharSequence)string);
        return csmClassifier;
    }

    public List findNamespaces(String string, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public List findNestedNamespaces(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        List list = new ArrayList();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        list = csmProjectContentResolver.getNestedNamespaces(csmNamespace, string, bl);
        return list;
    }

    public List findNamespaceElements(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (this.csmFile != null && this.csmFile.getProject() != null) {
            CsmProject csmProject = this.csmFile.getProject();
            CsmNamespace csmNamespace2 = csmNamespace == null ? csmProject.getGlobalNamespace() : csmNamespace;
            Collection collection = csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace2, string, bl, bl2);
            if (collection != null) {
                arrayList.addAll(collection);
            }
            if ((collection = csmProjectContentResolver.getNamespaceEnumerators(csmNamespace2, string, bl, bl2)) != null) {
                arrayList.addAll(collection);
            }
            if ((collection = csmProjectContentResolver.getNamespaceVariables(csmNamespace2, string, bl, bl2)) != null) {
                arrayList.addAll(collection);
            }
            if ((collection = csmProjectContentResolver.getNamespaceFunctions(csmNamespace2, string, bl, bl2)) != null) {
                arrayList.addAll(collection);
            }
            if (csmProject.getGlobalNamespace() != csmNamespace2 && (collection = csmProjectContentResolver.getLibClassesEnums(string, bl)) != null) {
                arrayList.addAll(collection);
            }
        }
        return arrayList;
    }

    public List findClasses(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (this.csmFile != null && this.csmFile.getProject() != null) {
            CsmProject csmProject = this.csmFile.getProject();
            CsmNamespace csmNamespace2 = csmNamespace == null ? csmProject.getGlobalNamespace() : csmNamespace;
            List list = csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace2, string, bl, bl2);
            if (list != null) {
                arrayList.addAll(list);
            }
            Collection collection = list = csmProject.getGlobalNamespace() == csmNamespace2 ? null : csmProjectContentResolver.getLibClassesEnums(string, bl);
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    private void addNestedNamespaces(List list, CsmNamespace csmNamespace) {
        for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
            list.add(csmNamespace2);
            this.addNestedNamespaces(list, csmNamespace2);
        }
    }

    private List getClassListForList(List list) {
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getClassList((CsmClass)iterator.next()));
        }
        return arrayList;
    }

    private List getClassList(CsmClass csmClass) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private List getOuterClasses(CsmClass csmClass) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(csmClass);
        while (csmClass != null) {
            Collection collection = csmClass.getBaseClasses();
            if (collection == null) continue;
            arrayList.add(collection);
        }
        return arrayList;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setNaturalSort(boolean bl) {
        this.naturalSort = bl;
    }

    private boolean startsWith(String string, String string2) {
        return this.caseSensitive ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public List findFields(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List list = csmProjectContentResolver.getFields(csmClass, csmOffsetableDeclaration, string, bl2, bl, bl4, bl5);
        return list;
    }

    public List findEnumerators(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List list = csmProjectContentResolver.getEnumerators(csmClass, csmOffsetableDeclaration, string, bl, bl3, bl4);
        return list;
    }

    public List findMethods(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        CsmClass csmClass2 = csmClass;
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (csmOffsetableDeclaration == null) {
            csmOffsetableDeclaration = csmClass2;
        }
        List list = csmProjectContentResolver.getMethods(csmClass2, csmOffsetableDeclaration, string, bl2, bl, bl4, bl5);
        return list;
    }

    public List findNestedClassifiers(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3) {
        CsmClass csmClass2 = csmClass;
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List list = csmProjectContentResolver.getNestedClassifiers(csmClass2, csmOffsetableDeclaration, string, bl, bl2);
        return list;
    }
}

