/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.utils.Token;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public class CsmIncludeHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    private static final boolean NEED_TO_TRACE_UNRESOLVED_INCLUDE = CsmIncludeHyperlinkProvider.getBoolean("cnd.modelimpl.trace.failed.include", false);
    private static final CsmOffsetable.Position DUMMY_POSITION = new CsmOffsetable.Position(){

        public int getOffset() {
            return -1;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    };

    protected boolean isValidToken(Token token) {
        return CsmIncludeHyperlinkProvider.isSupportedToken(token);
    }

    public static boolean isSupportedToken(Token token) {
        return token != null && (token.getTokenID() == CCTokenContext.SYS_INCLUDE || token.getTokenID() == CCTokenContext.USR_INCLUDE || token.getTokenID() == CCTokenContext.CPPINCLUDE || token.getTokenID() == CCTokenContext.CPPINCLUDE_NEXT);
    }

    protected void performAction(BaseDocument baseDocument, JTextComponent jTextComponent, int n) {
        this.goToInclude(baseDocument, jTextComponent, n);
    }

    public boolean goToInclude(BaseDocument baseDocument, JTextComponent jTextComponent, int n) {
        if (!this.preJump(baseDocument, jTextComponent, n, "opening-include-element")) {
            return false;
        }
        CsmOffsetable csmOffsetable = this.findTargetObject(baseDocument, n);
        return this.postJump(csmOffsetable, "goto_source_source_not_found", "cannot-open-include-element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmOffsetable findTargetObject(BaseDocument baseDocument, int n) {
        IncludeTarget includeTarget;
        CsmInclude csmInclude = this.findInclude(baseDocument, n);
        IncludeTarget includeTarget2 = includeTarget = csmInclude == null ? null : new IncludeTarget(csmInclude);
        if (csmInclude != null && NEED_TO_TRACE_UNRESOLVED_INCLUDE && csmInclude.getIncludeFile() == null) {
            System.setProperty("cnd.modelimpl.trace.trace_now", "yes");
            try {
                csmInclude.getIncludeFile();
            }
            finally {
                System.setProperty("cnd.modelimpl.trace.trace_now", "no");
            }
        }
        return includeTarget;
    }

    private CsmInclude findInclude(BaseDocument baseDocument, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)true);
        if (csmFile != null) {
            return ReferencesSupport.findInclude(csmFile, n);
        }
        return null;
    }

    private static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    private static final class IncludeTarget
    implements CsmOffsetable {
        private CsmInclude include;

        public IncludeTarget(CsmInclude csmInclude) {
            this.include = csmInclude;
        }

        public CsmFile getContainingFile() {
            return this.include.getIncludeFile();
        }

        public int getStartOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public int getEndOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public String getText() {
            return ((Object)this.include.getIncludeName()).toString();
        }
    }
}

