/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionResolverImpl
implements CompletionResolver {
    private static final boolean DEBUG_SUMMARY = Boolean.getBoolean("csm.utilities.trace.summary");
    private static final boolean TRACE = Boolean.getBoolean("csm.utilities.trace");
    private static final boolean DEBUG = TRACE | DEBUG_SUMMARY;
    private int resolveTypes = 0;
    private int hideTypes = -1;
    private CsmFile file;
    private CsmContext context;
    CompletionResolver.Result result = EMPTY_RESULT;
    CsmProjectContentResolver contResolver = null;
    private boolean caseSensitive = false;
    private boolean naturalSort = false;
    private boolean sort = false;
    private CsmCompletionQuery.QueryScope queryScope = CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
    public static final boolean STAT_COMPLETION = Boolean.getBoolean("cnd.completion.stat");
    public static final boolean TIMING_COMPLETION = Boolean.getBoolean("cnd.completion.timing") || STAT_COMPLETION;
    private static final CompletionResolver.Result EMPTY_RESULT = new EmptyResultImpl();

    public boolean isSortNeeded() {
        return this.sort;
    }

    public void setSortNeeded(boolean bl) {
        this.sort = bl;
    }

    public void setResolveScope(CsmCompletionQuery.QueryScope queryScope) {
        this.queryScope = queryScope;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public CompletionResolverImpl(CsmFile csmFile) {
        this(csmFile, false, false, false);
    }

    public CompletionResolverImpl(CsmFile csmFile, boolean bl, boolean bl2, boolean bl3) {
        this(csmFile, 1, bl, bl2, bl3);
    }

    public CompletionResolverImpl(CsmFile csmFile, int n, boolean bl, boolean bl2, boolean bl3) {
        this.file = csmFile;
        this.resolveTypes = n;
        this.caseSensitive = bl;
        this.naturalSort = bl3;
        this.sort = bl2;
    }

    @Override
    public void setResolveTypes(int n) {
        this.resolveTypes = n;
    }

    @Override
    public boolean refresh() {
        this.result = EMPTY_RESULT;
        if (this.file != null && this.file.getProject() != null && !this.file.getProject().isValid()) {
            this.file = CsmUtilities.getCsmFile((FileObject)CsmUtilities.getFileObject((CsmFile)this.file), (boolean)true);
        }
        this.context = null;
        this.contResolver = null;
        if (this.file == null) {
            return false;
        }
        this.contResolver = this.createContentResolver(this.file.getProject());
        return true;
    }

    public boolean update(boolean bl, boolean bl2) {
        this.caseSensitive = bl;
        this.naturalSort = bl2;
        return this.refresh();
    }

    @Override
    public boolean resolve(int n, String string, boolean bl) {
        if (this.file == null) {
            return false;
        }
        this.context = CsmOffsetResolver.findContext(this.file, n);
        if (DEBUG) {
            System.out.println("context for offset " + n + " :\n" + this.context);
        }
        this.initResolveMask(this.context, n, string, bl);
        this.hideTypes = CompletionResolverImpl.initHideMask(this.context, n, this.resolveTypes, this.queryScope, string);
        this.resolveContext(this.context, n, string, bl);
        return this.file != null;
    }

    @Override
    public CompletionResolver.Result getResult() {
        return this.result;
    }

    private void resolveContext(CsmContext csmContext, int n, String string, boolean bl) {
        CsmProject csmProject;
        long l = 0L;
        if (TIMING_COMPLETION) {
            l = System.currentTimeMillis();
            System.err.println("Started resolving context");
        }
        ArrayList<CsmDeclaration> arrayList = null;
        List list = null;
        List list2 = null;
        List list3 = null;
        ArrayList<CsmDeclaration> arrayList2 = null;
        List list4 = null;
        ArrayList<CsmDeclaration> arrayList3 = null;
        List list5 = null;
        Collection collection = null;
        List list6 = null;
        Collection collection2 = null;
        Collection collection3 = null;
        List list7 = null;
        Collection collection4 = null;
        Collection collection5 = null;
        Collection collection6 = null;
        Collection collection7 = null;
        List list8 = null;
        List list9 = null;
        Collection collection8 = null;
        Collection collection9 = null;
        Collection collection10 = null;
        Collection collection11 = null;
        Collection collection12 = null;
        CsmProject csmProject2 = csmProject = this.file != null ? this.file.getProject() : null;
        if (csmProject == null) {
            return;
        }
        if (this.needClasses(csmContext, n)) {
            arrayList2 = this.getClassesEnums(csmContext, csmProject, string, bl, n, false);
        } else if (this.needContextClasses(csmContext, n)) {
            arrayList2 = this.getClassesEnums(csmContext, csmProject, string, bl, n, true);
        }
        if (this.needLocalVars(csmContext, n)) {
            CsmClass csmClass;
            boolean bl2;
            arrayList3 = this.contResolver.getFileLocalEnumerators(csmContext, string, bl);
            CsmFunction csmFunction = CsmContextUtilities.getFunction(csmContext);
            boolean bl3 = bl2 = csmFunction == null ? true : CsmBaseUtilities.isStaticContext((CsmFunction)csmFunction);
            if (this.needFunctionVars(csmContext, n)) {
                csmClass = this.contResolver.findFunctionLocalDeclarations(csmContext, string, bl);
                arrayList = new ArrayList<CsmDeclaration>(csmClass.size());
                for (CsmDeclaration csmDeclaration : csmClass) {
                    if (CsmKindUtilities.isVariable((CsmObject)csmDeclaration)) {
                        arrayList.add(csmDeclaration);
                    }
                    if (this.needLocalClasses(csmContext, n) && CsmKindUtilities.isClassifier((CsmObject)csmDeclaration)) {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<CsmDeclaration>();
                        }
                        arrayList2.add(csmDeclaration);
                    }
                    if (!CsmKindUtilities.isEnumerator((CsmObject)csmDeclaration)) continue;
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<CsmDeclaration>();
                    }
                    arrayList3.add(csmDeclaration);
                }
            }
            if (this.needClassElements(csmContext, n) && (csmClass = CsmBaseUtilities.getFunctionClass((CsmFunction)csmFunction)) != null) {
                list = this.contResolver.getFields(csmClass, (CsmOffsetableDeclaration)csmFunction, string, bl2, bl, true, false);
                list2 = this.contResolver.getEnumerators(csmClass, (CsmOffsetableDeclaration)csmFunction, string, bl, true, false);
                list3 = this.contResolver.getMethods(csmClass, (CsmOffsetableDeclaration)csmFunction, string, bl2, bl, true, false);
            }
        } else if (this.needClassElements(csmContext, n)) {
            CsmFunction csmFunction = CsmContextUtilities.getFunction(csmContext);
            CsmClass csmClass = csmFunction == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)csmFunction);
            CsmClass csmClass2 = csmClass = csmClass != null ? csmClass : CsmContextUtilities.getClass(csmContext, false);
            if (csmClass != null) {
                CsmFunction csmFunction2;
                boolean bl4 = false;
                Object object = csmFunction2 = csmFunction != null ? csmFunction : CsmContextUtilities.getClass(csmContext, false);
                if (this.needClassMethods(csmContext, n) && csmClass != null) {
                    list3 = this.contResolver.getMethods(csmClass, (CsmOffsetableDeclaration)csmFunction2, string, bl4, bl, true, false);
                }
                if (this.needClassFields(csmContext, n)) {
                    list = this.contResolver.getFields(csmClass, (CsmOffsetableDeclaration)csmFunction2, string, bl4, bl, true, false);
                }
                if (this.needClassEnumerators(csmContext, n)) {
                    list2 = this.contResolver.getEnumerators(csmClass, (CsmOffsetableDeclaration)csmFunction2, string, bl, true, false);
                }
                if (this.needNestedClassifiers(csmContext, n)) {
                    List list10 = this.contResolver.getNestedClassifiers(csmClass, (CsmOffsetableDeclaration)csmFunction2, string, bl, true);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList();
                    }
                    arrayList2.addAll(list10);
                }
            }
        }
        if (this.needFileLocalMacros(csmContext, n)) {
            list5 = this.contResolver.getFileLocalMacros(csmContext, string, bl);
        }
        if (this.needFileLocalFunctions(csmContext, n)) {
            collection = this.getFileLocalFunctions(csmContext, string, bl);
        }
        if (this.needFileLocalVars(csmContext, n)) {
            list4 = this.contResolver.getFileLocalVariables(csmContext, string, bl, this.queryScope == CsmCompletionQuery.QueryScope.LOCAL_QUERY);
        }
        if (this.needFileIncludedMacros(csmContext, n)) {
            list6 = this.contResolver.getFileIncludedProjectMacros(csmContext, string, bl);
        }
        if (this.needFileIncludedLibMacros(csmContext, n)) {
            list8 = this.contResolver.getFileIncludeLibMacros(csmContext, string, bl);
        }
        if (this.needGlobalMacros(csmContext, n)) {
            list7 = this.contResolver.getProjectMacros(csmContext, string, bl);
        }
        if (this.needGlobalLibMacros(csmContext, n)) {
            list9 = this.contResolver.getLibMacros(csmContext, string, bl);
        }
        if (this.needGlobalVariables(csmContext, n)) {
            collection2 = this.getGlobalVariables(csmContext, csmProject, string, bl, n);
        }
        if (this.needGlobalEnumerators(csmContext, n)) {
            collection3 = this.getGlobalEnumerators(csmContext, csmProject, string, bl, n);
        }
        if (this.needGlobalFunctions(csmContext, n)) {
            collection4 = this.getGlobalFunctions(csmContext, csmProject, string, bl, n);
        }
        if (this.needGlobalNamespaces(csmContext, n)) {
            collection5 = this.getGlobalNamespaces(csmContext, csmProject, string, bl, n);
            collection6 = this.getProjectNamespaceAliases(csmContext, csmProject, string, bl, n);
        }
        if (this.needLibClasses(csmContext, n)) {
            collection7 = this.getLibClassesEnums(csmProject, string, bl);
        }
        if (this.needLibVariables(csmContext, n)) {
            collection8 = this.getLibVariables(csmProject, string, bl);
        }
        if (this.needLibEnumerators(csmContext, n)) {
            collection9 = this.getLibEnumerators(csmProject, string, bl);
        }
        if (this.needLibFunctions(csmContext, n)) {
            collection10 = this.getLibFunctions(csmProject, string, bl);
        }
        if (this.needLibNamespaces(csmContext, n)) {
            collection11 = this.getLibNamespaces(csmProject, string, bl);
        }
        this.result = CompletionResolverImpl.buildResult(csmContext, arrayList, list, list2, list3, arrayList2, list4, arrayList3, list5, collection, list6, collection2, collection3, list7, collection4, collection5, collection6, collection7, list8, list9, collection8, collection9, collection10, collection11, collection12);
        if (TIMING_COMPLETION) {
            l = System.currentTimeMillis() - l;
            System.err.println("Resolving context took " + l + "ms");
        }
    }

    private static int initHideMask(CsmContext csmContext, int n, int n2, CsmCompletionQuery.QueryScope queryScope, String string) {
        int n3 = -1;
        if ((n2 & 1) == 1 && string.length() == 0) {
            n3 &= 0xFFF570FF;
            if (!CsmKindUtilities.isFile((CsmObject)csmContext.getLastScope())) {
                n3 &= 0xFFFEFFFF;
            }
        }
        if (queryScope == CsmCompletionQuery.QueryScope.LOCAL_QUERY || queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY) {
            n3 &= 0xFFF570FF;
            n3 &= 0xFFFEFFFF;
            n3 &= 0xFFFFBFFF;
            n3 &= 0xFFFBFFFF;
            n3 &= 0xFFFFFFFD;
            n3 &= 0xFFFFFFFB;
            n3 &= 0xFFFFFFF7;
            n3 &= 0xFFFFEFFF;
        }
        if (queryScope == CsmCompletionQuery.QueryScope.LOCAL_QUERY) {
            n3 &= 0xFFFFFFEF;
            n3 &= 0xFFFFFFDF;
            n3 &= 0xFFDFFFFF;
            n3 &= 0xFFEFFFFF;
        }
        return n3;
    }

    private static CompletionResolver.Result buildResult(CsmContext csmContext, Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6, Collection collection7, Collection collection8, Collection collection9, Collection collection10, Collection collection11, Collection collection12, Collection collection13, Collection collection14, Collection collection15, Collection collection16, Collection collection17, Collection collection18, Collection collection19, Collection collection20, Collection collection21, Collection collection22, Collection collection23, Collection collection24) {
        int n = 0;
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection, "Local variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection2, "Class fields");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection3, "Class enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection4, "Class methods");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection5, "Classes/Enums/Typedefs");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection6, "File Local Variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection7, "File Local Enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection8, "File Local Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection9, "File Local Functions");
        }
        CompletionResolverImpl.remove(collection10, collection8);
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection10, "File Included Project Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection11, "Global variables");
        }
        CompletionResolverImpl.remove(collection12, collection7);
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection12, "Global enumerators");
        }
        CompletionResolverImpl.remove(collection13, collection10);
        CompletionResolverImpl.remove(collection13, collection8);
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection13, "Global Project Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection14, "Global Project functions");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection15, "Global Project Namespaces");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection16, "Project Namespace Aliases");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection17, "Library classes");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection18, "File Included Library Macros");
        }
        CompletionResolverImpl.remove(collection19, collection18);
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection19, "Global Library Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection20, "Global Library variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection21, "Global Library enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection22, "Global Library functions");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection23, "Global Library Namespaces");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(collection24, "Global Library Namespace Aliases");
        }
        if (DEBUG || STAT_COMPLETION) {
            CompletionResolverImpl.trace(null, "There are " + n + " resovled elements");
        }
        ResultImpl resultImpl = new ResultImpl(collection, collection2, collection3, collection4, collection5, collection6, collection7, collection8, collection9, collection10, collection11, collection12, collection13, collection14, collection15, collection16, collection17, collection18, collection19, collection20, collection21, collection22, collection23, collection24);
        return resultImpl;
    }

    private static Collection remove(Collection collection, Collection collection2) {
        CsmUtilities.removeAll((Collection)collection, (Collection)collection2);
        return collection;
    }

    protected CsmProjectContentResolver createContentResolver(CsmProject csmProject) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(csmProject, this.isCaseSensitive(), this.isSortNeeded(), this.isNaturalSort());
        return csmProjectContentResolver;
    }

    protected CsmProjectContentResolver createLibraryResolver(CsmProject csmProject) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(csmProject, this.isCaseSensitive(), this.isSortNeeded(), this.isNaturalSort());
        return csmProjectContentResolver;
    }

    private static Collection merge(Collection collection, Collection collection2) {
        return CsmUtilities.merge((Collection)collection, (Collection)collection2);
    }

    private Collection getClassesEnums(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n, boolean bl2) {
        if (csmProject == null) {
            return null;
        }
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, bl2);
        LinkedHashSet linkedHashSet = new LinkedHashSet(1024);
        for (Object object : collection) {
            List list = this.contResolver.getNamespaceClassesEnums((CsmNamespace)object, string, bl, false);
            linkedHashSet.addAll(list);
        }
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        if (!bl2) {
            Object object;
            object = this.getUsedDeclarations(this.file, n, string, bl, kindArray);
            linkedHashSet.addAll(object);
        }
        return linkedHashSet;
    }

    private Collection getGlobalVariables(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        Object object2;
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, false);
        LinkedHashSet linkedHashSet = new LinkedHashSet(1024);
        for (Object object2 : collection) {
            List list = this.contResolver.getNamespaceVariables((CsmNamespace)object2, string, bl, false);
            linkedHashSet.addAll(list);
        }
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE};
        object2 = this.getUsedDeclarations(this.file, n, string, bl, kindArray);
        linkedHashSet.addAll(object2);
        return linkedHashSet;
    }

    private Collection getGlobalEnumerators(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, false);
        LinkedHashSet linkedHashSet = new LinkedHashSet(1024);
        for (CsmNamespace csmNamespace : collection) {
            List list = this.contResolver.getNamespaceEnumerators(csmNamespace, string, bl, false);
            linkedHashSet.addAll(list);
        }
        return linkedHashSet;
    }

    private Collection getGlobalFunctions(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        Object object2;
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, false);
        LinkedHashSet linkedHashSet = new LinkedHashSet(1024);
        for (Object object2 : collection) {
            List list = this.contResolver.getNamespaceFunctions((CsmNamespace)object2, string, bl, false);
            linkedHashSet.addAll(list);
        }
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        object2 = this.getUsedDeclarations(this.file, n, string, bl, kindArray);
        linkedHashSet.addAll(object2);
        return linkedHashSet;
    }

    private Collection getFileLocalFunctions(CsmContext csmContext, String string, boolean bl) {
        List list = this.contResolver.getFileLocalFunctions(csmContext, string, bl, this.queryScope == CsmCompletionQuery.QueryScope.LOCAL_QUERY);
        return list;
    }

    private Collection getGlobalNamespaces(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, false);
        LinkedHashSet linkedHashSet = new LinkedHashSet(1024);
        for (CsmNamespace csmNamespace : collection) {
            List list = this.contResolver.getNestedNamespaces(csmNamespace, string, bl);
            linkedHashSet.addAll(list);
        }
        return linkedHashSet;
    }

    private Collection getProjectNamespaceAliases(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        CsmProject csmProject2 = string.length() == 0 ? csmProject : null;
        Collection<CsmDeclaration> collection = CsmUsingResolver.getDefault().findNamespaceAliases(this.file, n, csmProject2);
        Collection<CsmDeclaration> collection2 = string.length() > 0 ? this.filterDeclarations(collection, string, bl, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_ALIAS}) : collection;
        return collection2;
    }

    private Collection getLibClassesEnums(CsmProject csmProject, String string, boolean bl) {
        Collection collection = this.contResolver.getLibClassesEnums(string, bl);
        return collection;
    }

    private Collection getLibVariables(CsmProject csmProject, String string, boolean bl) {
        Collection collection = this.contResolver.getLibVariables(string, bl);
        return collection;
    }

    private Collection getLibEnumerators(CsmProject csmProject, String string, boolean bl) {
        Collection collection = this.contResolver.getLibEnumerators(string, bl, true);
        return collection;
    }

    private Collection getLibFunctions(CsmProject csmProject, String string, boolean bl) {
        Collection collection = this.contResolver.getLibFunctions(string, bl);
        return collection;
    }

    private Collection getLibNamespaces(CsmProject csmProject, String string, boolean bl) {
        Collection collection = this.contResolver.getLibNamespaces(string, bl);
        return collection;
    }

    private boolean needLocalClasses(CsmContext csmContext, int n) {
        return this.needLocalVars(csmContext, n);
    }

    private boolean needClasses(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 2) == 2;
    }

    private boolean needContextClasses(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x800000) == 0x800000;
    }

    private void updateResolveTypesInFunction(int n, CsmContext csmContext, boolean bl) {
        boolean bl2 = CsmContextUtilities.isInType(csmContext, n);
        if (!bl2) {
            this.resolveTypes |= 0x80;
            this.resolveTypes |= 0x40;
            this.resolveTypes |= 4;
            this.resolveTypes |= 0x1000;
            this.resolveTypes |= 0x80;
            this.resolveTypes |= 0x10;
            this.resolveTypes |= 0x100000;
            this.resolveTypes |= 0x800;
        }
        if (CsmContextUtilities.isInFunctionBodyOrInitializerList(csmContext, n)) {
            if (!bl2) {
                this.resolveTypes |= 0x200;
                this.resolveTypes |= 8;
                this.resolveTypes |= 0x400000;
                this.resolveTypes |= 0x400;
                this.resolveTypes |= 0x20;
            }
            if (!bl) {
                this.resolveTypes |= 0x80;
                this.resolveTypes |= 0x40;
                this.resolveTypes |= 4;
                this.resolveTypes |= 0x80;
                this.resolveTypes |= 0x10;
                this.resolveTypes |= 0x100000;
            }
        }
    }

    private boolean needFileLocalVars(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x80) == 128;
    }

    private boolean needLocalVars(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x40) == 64;
    }

    private boolean needGlobalVariables(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 4) == 4;
    }

    private boolean needGlobalEnumerators(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x1000) == 4096;
    }

    private boolean needGlobalFunctions(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 8) == 8;
    }

    private boolean needGlobalNamespaces(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x40000) == 262144;
    }

    private boolean needFunctionVars(CsmContext csmContext, int n) {
        return this.needLocalVars(csmContext, n);
    }

    private boolean needLibClasses(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x100) == 256;
    }

    private boolean needLibVariables(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x200) == 512;
    }

    private boolean needLibEnumerators(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x800) == 2048;
    }

    private boolean needLibFunctions(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x400) == 1024;
    }

    private boolean needLibNamespaces(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x80000) == 524288;
    }

    private boolean needFileLocalMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x2000) == 8192;
    }

    private boolean needFileLocalFunctions(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x400000) == 0x400000;
    }

    private boolean needFileIncludedMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x4000) == 16384;
    }

    private boolean needFileIncludedLibMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x8000) == 32768;
    }

    private boolean needGlobalMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x10000) == 65536;
    }

    private boolean needGlobalLibMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x20000) == 131072;
    }

    private boolean needClassMethods(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x20) == 32;
    }

    private boolean needClassFields(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x10) == 16;
    }

    private boolean needClassEnumerators(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x100000) == 0x100000;
    }

    private boolean needNestedClassifiers(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x200000) == 0x200000;
    }

    private boolean needClassElements(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x20) == 32 || (this.hideTypes & this.resolveTypes & 0x10) == 16 || (this.hideTypes & this.resolveTypes & 0x200000) == 0x200000 || (this.hideTypes & this.resolveTypes & 0x100000) == 0x100000;
    }

    private static int trace(Collection collection, String string) {
        System.err.println("\t" + string + " [size - " + (collection == null ? "null" : Integer.valueOf(collection.size())) + "]");
        if (collection == null) {
            return 0;
        }
        if (TRACE) {
            int n = 0;
            for (Object e : collection) {
                CsmObject csmObject = (CsmObject)e;
                System.err.println("\t\t[" + n + "]" + CsmUtilities.getCsmName((CsmObject)csmObject));
                ++n;
            }
        }
        return collection.size();
    }

    private static Collection maskNull(Collection collection) {
        return collection != null ? collection : Collections.EMPTY_LIST;
    }

    private static Collection appendResult(Collection collection, ResultImpl resultImpl) {
        assert (collection != null);
        CompletionResolverImpl.merge(collection, resultImpl.localVars);
        CompletionResolverImpl.merge(collection, resultImpl.classFields);
        CompletionResolverImpl.merge(collection, resultImpl.classEnumerators);
        CompletionResolverImpl.merge(collection, resultImpl.classMethods);
        CompletionResolverImpl.merge(collection, resultImpl.classesEnumsTypedefs);
        CompletionResolverImpl.merge(collection, resultImpl.fileLocalVars);
        CompletionResolverImpl.merge(collection, resultImpl.fileLocalEnumerators);
        CompletionResolverImpl.merge(collection, resultImpl.fileLocalMacros);
        CompletionResolverImpl.merge(collection, resultImpl.fileLocalFunctions);
        CompletionResolverImpl.merge(collection, resultImpl.fileProjectMacros);
        CompletionResolverImpl.merge(collection, resultImpl.globVars);
        CompletionResolverImpl.merge(collection, resultImpl.globEnumerators);
        CompletionResolverImpl.merge(collection, resultImpl.globProjectMacros);
        CompletionResolverImpl.merge(collection, resultImpl.globFuns);
        CompletionResolverImpl.merge(collection, resultImpl.globProjectNSs);
        CompletionResolverImpl.merge(collection, resultImpl.projectNsAliases);
        CompletionResolverImpl.merge(collection, resultImpl.libClasses);
        CompletionResolverImpl.merge(collection, resultImpl.fileLibMacros);
        CompletionResolverImpl.merge(collection, resultImpl.globLibMacros);
        CompletionResolverImpl.merge(collection, resultImpl.libVars);
        CompletionResolverImpl.merge(collection, resultImpl.libEnumerators);
        CompletionResolverImpl.merge(collection, resultImpl.libFuns);
        CompletionResolverImpl.merge(collection, resultImpl.libNSs);
        CompletionResolverImpl.merge(collection, resultImpl.libNsAliases);
        return collection;
    }

    private void initResolveMask(CsmContext csmContext, int n, String string, boolean bl) {
        if ((this.resolveTypes & 1) == 1) {
            this.resolveTypes = string.length() == 0 ? (this.resolveTypes |= 0x6000) : (this.resolveTypes |= 0x32000);
            this.resolveTypes |= 0x800000;
            this.resolveTypes |= 2;
            this.resolveTypes |= 0x40000;
            this.resolveTypes |= 0x100;
            this.resolveTypes |= 0x80000;
            this.resolveTypes |= 0x200000;
            assert (csmContext != null);
            if (CsmContextUtilities.isInFunction(csmContext, n)) {
                this.updateResolveTypesInFunction(n, csmContext, bl);
            } else if (CsmContextUtilities.getClass(csmContext, false) != null) {
                this.resolveTypes |= 0x10;
                this.resolveTypes |= 0x20;
                this.resolveTypes |= 0x100000;
            } else {
                this.resolveTypes |= 4;
                this.resolveTypes |= 0x1000;
                this.resolveTypes |= 8;
                this.resolveTypes |= 0x400000;
                this.resolveTypes |= 0x80;
                this.resolveTypes |= 0x40000;
                this.resolveTypes |= 0x100;
                this.resolveTypes |= 0x200;
                this.resolveTypes |= 0x800;
                this.resolveTypes |= 0x400;
                this.resolveTypes |= 0x80000;
            }
        }
    }

    private Collection<CsmDeclaration> getUsedDeclarations(CsmFile csmFile, int n, String string, boolean bl, CsmDeclaration.Kind[] kindArray) {
        CsmProject csmProject = csmFile.getProject();
        CsmProject csmProject2 = string.length() == 0 ? csmProject : null;
        Collection collection = CsmUsingResolver.getDefault().findUsedDeclarations(csmFile, n, csmProject2);
        Collection<CsmDeclaration> collection2 = this.filterDeclarations(collection, string, bl, kindArray);
        return collection2;
    }

    private Collection<CsmDeclaration> filterDeclarations(Collection<CsmDeclaration> collection, String string, boolean bl, CsmDeclaration.Kind[] kindArray) {
        LinkedHashSet<CsmDeclaration> linkedHashSet = new LinkedHashSet<CsmDeclaration>(collection.size());
        this.contResolver.filterDeclarations(collection.iterator(), linkedHashSet, kindArray, string, bl, false);
        return linkedHashSet;
    }

    private Collection<CsmNamespace> getNamespacesToSearch(CsmContext csmContext, CsmFile csmFile, int n, boolean bl, boolean bl2) {
        CsmProject csmProject = csmFile.getProject();
        CsmProject csmProject2 = bl || bl2 ? csmProject : null;
        Collection<CsmNamespace> collection = new ArrayList<CsmNamespace>();
        if (!bl2) {
            collection.addAll(CsmUsingResolver.getDefault().findVisibleNamespaces(csmFile, n, csmProject2));
        }
        CsmNamespace csmNamespace = csmProject.getGlobalNamespace();
        collection.add(csmNamespace);
        Collection<CsmNamespace> collection2 = this.getContextNamespaces(csmContext);
        collection.addAll(collection2);
        collection = this.filterNamespaces(collection, csmProject2);
        return collection;
    }

    private Collection<CsmNamespace> getContextNamespaces(CsmContext csmContext) {
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        for (CsmNamespace csmNamespace = CsmContextUtilities.getNamespace(csmContext); csmNamespace != null && !csmNamespace.isGlobal(); csmNamespace = csmNamespace.getParent()) {
            arrayList.add(csmNamespace);
        }
        return arrayList;
    }

    private Collection<CsmNamespace> filterNamespaces(Collection<CsmNamespace> collection, CsmProject csmProject) {
        if (csmProject == null) {
            return collection;
        }
        LinkedHashSet<CsmNamespace> linkedHashSet = new LinkedHashSet<CsmNamespace>(collection.size());
        for (CsmNamespace csmNamespace : collection) {
            if (csmNamespace.getProject() != csmProject) continue;
            linkedHashSet.add(csmNamespace);
        }
        return linkedHashSet;
    }

    private static final class EmptyResultImpl
    implements CompletionResolver.Result {
        private EmptyResultImpl() {
        }

        public Collection getLocalVariables() {
            return Collections.EMPTY_LIST;
        }

        public Collection getClassFields() {
            return Collections.EMPTY_LIST;
        }

        public Collection getClassEnumerators() {
            return Collections.EMPTY_LIST;
        }

        public Collection getClassMethods() {
            return Collections.EMPTY_LIST;
        }

        public Collection getProjectClassesifiersEnums() {
            return Collections.EMPTY_LIST;
        }

        public Collection getFileLocalVars() {
            return Collections.EMPTY_LIST;
        }

        public Collection getFileLocalEnumerators() {
            return Collections.EMPTY_LIST;
        }

        public Collection getFileLocalMacros() {
            return Collections.EMPTY_LIST;
        }

        public Collection getFileLocalFunctions() {
            return Collections.EMPTY_LIST;
        }

        public Collection getInFileIncludedProjectMacros() {
            return Collections.EMPTY_LIST;
        }

        public Collection getGlobalVariables() {
            return Collections.EMPTY_LIST;
        }

        public Collection getGlobalEnumerators() {
            return Collections.EMPTY_LIST;
        }

        public Collection getGlobalProjectMacros() {
            return Collections.EMPTY_LIST;
        }

        public Collection getGlobalProjectFunctions() {
            return Collections.EMPTY_LIST;
        }

        public Collection getGlobalProjectNamespaces() {
            return Collections.EMPTY_LIST;
        }

        public Collection getLibClassifiersEnums() {
            return Collections.EMPTY_LIST;
        }

        public Collection getInFileIncludedLibMacros() {
            return Collections.EMPTY_LIST;
        }

        public Collection getLibMacros() {
            return Collections.EMPTY_LIST;
        }

        public Collection getLibVariables() {
            return Collections.EMPTY_LIST;
        }

        public Collection getLibEnumerators() {
            return Collections.EMPTY_LIST;
        }

        public Collection getLibFunctions() {
            return Collections.EMPTY_LIST;
        }

        public Collection getLibNamespaces() {
            return Collections.EMPTY_LIST;
        }

        public Collection addResulItemsToCol(Collection collection) {
            return collection;
        }

        public int size() {
            return 0;
        }

        public Collection getProjectNamespaceAliases() {
            return Collections.EMPTY_LIST;
        }

        public Collection getLibNamespaceAliases() {
            return Collections.EMPTY_LIST;
        }
    }

    private static final class ResultImpl
    implements CompletionResolver.Result {
        private final Collection localVars;
        private final Collection classFields;
        private final Collection classEnumerators;
        private final Collection classMethods;
        private final Collection classesEnumsTypedefs;
        private final Collection fileLocalVars;
        private final Collection fileLocalEnumerators;
        private final Collection fileLocalMacros;
        private final Collection fileLocalFunctions;
        private final Collection fileProjectMacros;
        private final Collection globVars;
        private final Collection globEnumerators;
        private final Collection globProjectMacros;
        private final Collection globFuns;
        private final Collection globProjectNSs;
        private final Collection projectNsAliases;
        private final Collection libClasses;
        private final Collection fileLibMacros;
        private final Collection globLibMacros;
        private final Collection libVars;
        private final Collection libEnumerators;
        private final Collection libFuns;
        private final Collection libNSs;
        private final Collection libNsAliases;
        int size = -1;

        private ResultImpl(Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6, Collection collection7, Collection collection8, Collection collection9, Collection collection10, Collection collection11, Collection collection12, Collection collection13, Collection collection14, Collection collection15, Collection collection16, Collection collection17, Collection collection18, Collection collection19, Collection collection20, Collection collection21, Collection collection22, Collection collection23, Collection collection24) {
            this.localVars = collection;
            this.classFields = collection2;
            this.classEnumerators = collection3;
            this.classMethods = collection4;
            this.classesEnumsTypedefs = collection5;
            this.fileLocalVars = collection6;
            this.fileLocalEnumerators = collection7;
            this.fileLocalMacros = collection8;
            this.fileLocalFunctions = collection9;
            this.fileProjectMacros = collection10;
            this.globVars = collection11;
            this.globEnumerators = collection12;
            this.globProjectMacros = collection13;
            this.globFuns = collection14;
            this.globProjectNSs = collection15;
            this.projectNsAliases = collection16;
            this.libClasses = collection17;
            this.fileLibMacros = collection18;
            this.globLibMacros = collection19;
            this.libVars = collection20;
            this.libEnumerators = collection21;
            this.libFuns = collection22;
            this.libNSs = collection23;
            this.libNsAliases = collection24;
        }

        public Collection getLocalVariables() {
            return CompletionResolverImpl.maskNull(this.localVars);
        }

        public Collection getClassFields() {
            return CompletionResolverImpl.maskNull(this.classFields);
        }

        public Collection getClassEnumerators() {
            return CompletionResolverImpl.maskNull(this.classEnumerators);
        }

        public Collection getClassMethods() {
            return CompletionResolverImpl.maskNull(this.classMethods);
        }

        public Collection getProjectClassesifiersEnums() {
            return CompletionResolverImpl.maskNull(this.classesEnumsTypedefs);
        }

        public Collection getFileLocalVars() {
            return CompletionResolverImpl.maskNull(this.fileLocalVars);
        }

        public Collection getFileLocalEnumerators() {
            return CompletionResolverImpl.maskNull(this.fileLocalEnumerators);
        }

        public Collection getFileLocalMacros() {
            return CompletionResolverImpl.maskNull(this.fileLocalMacros);
        }

        public Collection getFileLocalFunctions() {
            return CompletionResolverImpl.maskNull(this.fileLocalFunctions);
        }

        public Collection getInFileIncludedProjectMacros() {
            return CompletionResolverImpl.maskNull(this.fileProjectMacros);
        }

        public Collection getGlobalVariables() {
            return CompletionResolverImpl.maskNull(this.globVars);
        }

        public Collection getGlobalEnumerators() {
            return CompletionResolverImpl.maskNull(this.globEnumerators);
        }

        public Collection getGlobalProjectMacros() {
            return CompletionResolverImpl.maskNull(this.globProjectMacros);
        }

        public Collection getGlobalProjectFunctions() {
            return CompletionResolverImpl.maskNull(this.globFuns);
        }

        public Collection getGlobalProjectNamespaces() {
            return CompletionResolverImpl.maskNull(this.globProjectNSs);
        }

        public Collection getProjectNamespaceAliases() {
            return CompletionResolverImpl.maskNull(this.projectNsAliases);
        }

        public Collection getLibClassifiersEnums() {
            return CompletionResolverImpl.maskNull(this.libClasses);
        }

        public Collection getInFileIncludedLibMacros() {
            return CompletionResolverImpl.maskNull(this.fileLibMacros);
        }

        public Collection getLibMacros() {
            return CompletionResolverImpl.maskNull(this.globLibMacros);
        }

        public Collection getLibVariables() {
            return CompletionResolverImpl.maskNull(this.libVars);
        }

        public Collection getLibEnumerators() {
            return CompletionResolverImpl.maskNull(this.libEnumerators);
        }

        public Collection getLibFunctions() {
            return CompletionResolverImpl.maskNull(this.libFuns);
        }

        public Collection getLibNamespaces() {
            return CompletionResolverImpl.maskNull(this.libNSs);
        }

        public Collection getLibNamespaceAliases() {
            return CompletionResolverImpl.maskNull(this.libNsAliases);
        }

        public Collection addResulItemsToCol(Collection collection) {
            assert (collection != null);
            return CompletionResolverImpl.appendResult(collection, this);
        }

        public int size() {
            if (this.size == -1) {
                this.size = 0;
                this.size += this.getLocalVariables().size();
                this.size += this.getClassFields().size();
                this.size += this.getClassEnumerators().size();
                this.size += this.getClassMethods().size();
                this.size += this.getProjectClassesifiersEnums().size();
                this.size += this.getFileLocalVars().size();
                this.size += this.getFileLocalEnumerators().size();
                this.size += this.getFileLocalMacros().size();
                this.size += this.getFileLocalFunctions().size();
                this.size += this.getInFileIncludedProjectMacros().size();
                this.size += this.getGlobalVariables().size();
                this.size += this.getGlobalEnumerators().size();
                this.size += this.getGlobalProjectMacros().size();
                this.size += this.getGlobalProjectFunctions().size();
                this.size += this.getGlobalProjectNamespaces().size();
                this.size += this.getLibClassifiersEnums().size();
                this.size += this.getInFileIncludedLibMacros().size();
                this.size += this.getLibMacros().size();
                this.size += this.getLibVariables().size();
                this.size += this.getLibEnumerators().size();
                this.size += this.getLibFunctions().size();
                this.size += this.getLibNamespaces().size();
            }
            return this.size;
        }
    }
}

