/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public class CsmContext {
    private int offset;
    private List context;
    private CsmObject csmLastObject;

    public CsmContext(int n) {
        this.offset = n;
        this.context = new ArrayList();
    }

    public CsmContextEntry get(int n) {
        return (CsmContextEntry)this.context.get(n);
    }

    public CsmContextEntry create(CsmScope csmScope) {
        return new CsmContextEntry(csmScope);
    }

    public CsmContextEntry create(CsmScope csmScope, int n) {
        return new CsmContextEntry(csmScope, n);
    }

    protected void add(CsmContextEntry csmContextEntry) {
        this.context.add(csmContextEntry);
    }

    public void add(CsmScope csmScope) {
        this.add(this.create(csmScope));
    }

    public void add(CsmScope csmScope, int n) {
        this.add(this.create(csmScope, n));
    }

    public void remove(CsmContextEntry csmContextEntry) {
        this.context.remove(csmContextEntry);
    }

    public CsmContextEntry getLastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    public CsmScope getLastScope() {
        if (this.getLastEntry() != null) {
            return this.getLastEntry().getScope();
        }
        return null;
    }

    public CsmObject getLastObject() {
        return this.csmLastObject;
    }

    public void setLastObject(CsmObject csmObject) {
        this.csmLastObject = csmObject;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.context.size();
    }

    public Iterator iterator() {
        return this.context.iterator();
    }

    public int getStartOffset() {
        return this.offset;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nlast element is " + this.csmLastObject);
        stringBuilder.append("\ncontext for offset ").append(this.offset);
        if (this.isEmpty()) {
            stringBuilder.append(" empty");
        } else {
            stringBuilder.append(" with ").append(this.size()).append(" elements:\n");
            for (CsmContextEntry csmContextEntry : this.context) {
                stringBuilder.append(csmContextEntry);
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public static class CsmContextEntry {
        private CsmScope scope;
        private int offset;
        public static final int WHOLE_SCOPE = -1;

        public CsmContextEntry(CsmScope csmScope) {
            this(csmScope, -1);
        }

        public CsmContextEntry(CsmScope csmScope, int n) {
            this.scope = csmScope;
            this.offset = n;
        }

        public CsmScope getScope() {
            return this.scope;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isWholeScope() {
            return this.getOffset() == -1;
        }

        public String toString() {
            CsmOffsetable csmOffsetable;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            if (this.isWholeScope()) {
                stringBuilder.append("whole scope");
            } else {
                stringBuilder.append("jump in ").append(this.getOffset());
            }
            CsmOffsetable csmOffsetable2 = csmOffsetable = CsmKindUtilities.isOffsetable((Object)this.scope) ? (CsmOffsetable)this.scope : null;
            if (csmOffsetable != null) {
                stringBuilder.append(" (");
                CsmOffsetable.Position position = csmOffsetable.getStartPosition();
                stringBuilder.append(position.getLine()).append(":").append(position.getColumn()).append(",").append(position.getOffset());
                stringBuilder.append(";");
                position = csmOffsetable.getEndPosition();
                stringBuilder.append(position.getLine()).append(":").append(position.getColumn()).append(",").append(position.getOffset());
                stringBuilder.append(")");
            }
            stringBuilder.append(CsmUtilities.getCsmName((CsmObject)this.scope));
            stringBuilder.append(" scope - ");
            if (CsmKindUtilities.isScope((CsmObject)this.scope)) {
                stringBuilder.append(" [scope object] ");
            }
            if (CsmKindUtilities.isScopeElement((CsmObject)this.scope)) {
                stringBuilder.append(" [scope element] ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

