/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.editor.StringMap;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsmProjectContentResolver {
    private boolean caseSensitive = false;
    private boolean naturalSort = false;
    private boolean sort = false;
    private CsmFile file;
    private CsmProject project;
    private static final NsContentResultsFilter NS_VARIABLE_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getNamespaceVariables(csmNamespace, string, bl, bl2);
        }
    };
    private static final NsContentResultsFilter NS_FUNCTION_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getNamespaceFunctions(csmNamespace, string, bl, bl2);
        }
    };
    private static final NsContentResultsFilter NS_CLASS_ENUM_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace, string, bl, bl2);
        }
    };
    private static final NsContentResultsFilter NS_ENUMERATOR_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getNamespaceEnumerators(csmNamespace, string, bl, bl2);
        }
    };
    private static final NsContentResultsFilter NS_NAMESPACES_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getGlobalNamespaces(string, bl);
        }
    };
    private static final int INIT_INHERITANCE_LEVEL = 0;
    private static final int NO_INHERITANCE = 1;
    private static final int EXACT_CLASS = 2;
    private static final int CHILD_INHERITANCE = 3;

    public CsmProjectContentResolver() {
        this(false);
    }

    public CsmProjectContentResolver(boolean bl) {
        this(bl, false, false);
    }

    public CsmProjectContentResolver(boolean bl, boolean bl2) {
        this(bl, true, bl2);
    }

    public CsmProjectContentResolver(boolean bl, boolean bl2, boolean bl3) {
        this.caseSensitive = bl;
        this.naturalSort = bl3;
        this.sort = bl2;
    }

    public CsmProjectContentResolver(CsmProject csmProject) {
        this(csmProject, false);
    }

    public CsmProjectContentResolver(CsmProject csmProject, boolean bl) {
        this(csmProject, bl, false, false);
    }

    public CsmProjectContentResolver(CsmProject csmProject, boolean bl, boolean bl2, boolean bl3) {
        this((CsmFile)null, bl, bl2, bl3);
        this.project = csmProject;
    }

    public CsmProjectContentResolver(CsmFile csmFile) {
        this(csmFile, false, false, false);
    }

    public CsmProjectContentResolver(CsmFile csmFile, boolean bl) {
        this(csmFile, bl, false, false);
    }

    public CsmProjectContentResolver(CsmFile csmFile, boolean bl, boolean bl2, boolean bl3) {
        this.caseSensitive = bl;
        this.naturalSort = bl3;
        this.file = csmFile;
        this.project = csmFile != null ? csmFile.getProject() : null;
        this.sort = bl2;
    }

    private List<CsmEnumerator> getEnumeratorsFromEnumsAndTypedefs(List list, boolean bl, String string, boolean bl2) {
        ArrayList<CsmEnumerator> arrayList = new ArrayList<CsmEnumerator>();
        if (list != null) {
            for (CsmObject csmObject : list) {
                CsmEnum csmEnum = null;
                if (CsmKindUtilities.isEnum((CsmObject)csmObject)) {
                    csmEnum = (CsmEnum)csmObject;
                } else {
                    CsmType csmType;
                    assert (CsmKindUtilities.isTypedef((CsmObject)csmObject));
                    CsmTypedef csmTypedef = (CsmTypedef)csmObject;
                    if (csmTypedef.isTypeUnnamed() && csmTypedef.getType() != null && CsmKindUtilities.isEnum((CsmObject)(csmType = csmTypedef.getType()).getClassifier())) {
                        csmEnum = (CsmEnum)csmType.getClassifier();
                    }
                }
                if (csmEnum == null) continue;
                for (CsmType csmType : csmEnum.getEnumerators()) {
                    if (!this.matchName(((Object)csmType.getName()).toString(), string, bl)) continue;
                    arrayList.add((CsmEnumerator)csmType);
                }
            }
            if (bl2 && arrayList != null) {
                CsmSortUtilities.sortMembers(arrayList, (boolean)this.isCaseSensitive());
            }
        }
        return arrayList;
    }

    private CsmProject getProject() {
        return this.project;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public void setNaturalSort(boolean bl) {
        this.naturalSort = bl;
    }

    public boolean isSortNeeded() {
        return this.sort;
    }

    public void setSortNeeded(boolean bl) {
        this.sort = bl;
    }

    public CsmFile getFile() {
        return this.file;
    }

    public void setFile(CsmFile csmFile) {
        this.file = csmFile;
    }

    public List getGlobalVariables(String string, boolean bl) {
        boolean bl2 = this.isSortNeeded();
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        CsmNamespace csmNamespace = this.project.getGlobalNamespace();
        List list = this.getNamespaceVariables(csmNamespace, string, bl, false, false);
        if (list != null && bl2) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getGlobalFunctions(String string, boolean bl) {
        boolean bl2 = this.isSortNeeded();
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        CsmNamespace csmNamespace = this.project.getGlobalNamespace();
        List list = this.getNamespaceFunctions(csmNamespace, string, bl, false, false);
        if (list != null && bl2) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getGlobalNamespaces(String string, boolean bl) {
        boolean bl2 = this.isSortNeeded();
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        CsmNamespace csmNamespace = this.project.getGlobalNamespace();
        List list = this.getNestedNamespaces(csmNamespace, string, bl);
        if (list != null && bl2) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getFileLocalMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findFileLocalMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getFileIncludedProjectMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findFileIncludedProjectMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getFileIncludeLibMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findFileIncludedLibMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getProjectMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findProjectMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getLibMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findLibMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public Collection getLibVariables(String string, boolean bl) {
        return this.getLibElements(NS_VARIABLE_FILTER, string, bl, this.isSortNeeded(), false);
    }

    public Collection getLibFunctions(String string, boolean bl) {
        return this.getLibElements(NS_FUNCTION_FILTER, string, bl, this.isSortNeeded(), false);
    }

    public Collection getLibClassesEnums(String string, boolean bl) {
        return this.getLibElements(NS_CLASS_ENUM_FILTER, string, bl, this.isSortNeeded(), false);
    }

    public Collection getLibEnumerators(String string, boolean bl, boolean bl2) {
        return this.getLibElements(NS_ENUMERATOR_FILTER, string, bl, this.isSortNeeded(), false);
    }

    public Collection getLibNamespaces(String string, boolean bl) {
        return this.getLibElements(NS_NAMESPACES_FILTER, string, bl, this.isSortNeeded(), false);
    }

    private Collection getLibElements(NsContentResultsFilter nsContentResultsFilter, String string, boolean bl, boolean bl2, boolean bl3) {
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        Map<String, CsmObject> map = new HashMap<String, CsmObject>();
        for (Object object2 : this.project.getLibraries()) {
            if (hashSet.contains(object2)) continue;
            hashSet.add((CsmProject)object2);
            CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver((CsmProject)object2, this.isCaseSensitive(), this.isSortNeeded(), this.isNaturalSort());
            map = this.mergeByFQN(map, nsContentResultsFilter.getResults(csmProjectContentResolver, object2.getGlobalNamespace(), string, bl, bl3));
        }
        Object object = map.values();
        if (map != null && bl2) {
            Object object2;
            object2 = new ArrayList(object);
            CsmSortUtilities.sortMembers((List)object2, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
            object = object2;
        }
        return object;
    }

    public List<CsmDeclaration> findFunctionLocalDeclarations(CsmContext csmContext, String string, boolean bl) {
        List<CsmDeclaration> list = CsmContextUtilities.findFunctionLocalDeclarations(csmContext, string, bl, this.isCaseSensitive());
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getFileLocalEnumerators(CsmContext csmContext, String string, boolean bl) {
        List<CsmDeclaration> list = CsmContextUtilities.findFileLocalEnumerators(csmContext, string, bl, this.isCaseSensitive());
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getFileLocalVariables(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        ArrayList<CsmOffsetableDeclaration> arrayList = new ArrayList<CsmOffsetableDeclaration>();
        if (!csmContext.isEmpty()) {
            Iterator iterator = csmContext.iterator();
            while (iterator.hasNext()) {
                CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
                if (!CsmKindUtilities.isFile((CsmObject)csmContextEntry.getScope())) continue;
                CsmFile csmFile = (CsmFile)csmContextEntry.getScope();
                this.fillFileLocalVariables(string, bl, csmFile.getDeclarations(), bl2, false, arrayList);
                break;
            }
        }
        return arrayList;
    }

    public List getFileLocalFunctions(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        ArrayList<CsmOffsetableDeclaration> arrayList = new ArrayList<CsmOffsetableDeclaration>();
        if (!csmContext.isEmpty()) {
            Iterator iterator = csmContext.iterator();
            while (iterator.hasNext()) {
                CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
                if (!CsmKindUtilities.isFile((CsmObject)csmContextEntry.getScope())) continue;
                CsmFile csmFile = (CsmFile)csmContextEntry.getScope();
                this.fillFileLocalFunctions(string, bl, csmFile.getDeclarations(), bl2, false, arrayList);
                break;
            }
        }
        return arrayList;
    }

    private void fillFileLocalFunctions(String string, boolean bl, Collection<CsmOffsetableDeclaration> collection, boolean bl2, boolean bl3, Collection<CsmOffsetableDeclaration> collection2) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection) {
            if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
                CsmFunction csmFunction = (CsmFunction)csmOffsetableDeclaration;
                if (!bl3 && !CsmBaseUtilities.isFileLocalFunction((CsmFunction)csmFunction) || csmOffsetableDeclaration.getName().length() == 0 || !this.matchName(((Object)csmOffsetableDeclaration.getName()).toString(), string, bl)) continue;
                collection2.add((CsmOffsetableDeclaration)csmFunction);
                continue;
            }
            if (!bl2 || !CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration) || ((CsmNamespaceDefinition)csmOffsetableDeclaration).getName().length() != 0) continue;
            this.fillFileLocalFunctions(string, bl, ((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), bl2, true, collection2);
        }
    }

    private void fillFileLocalVariables(String string, boolean bl, Collection<CsmOffsetableDeclaration> collection, boolean bl2, boolean bl3, Collection<CsmOffsetableDeclaration> collection2) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection) {
            if (CsmKindUtilities.isVariable((CsmObject)csmOffsetableDeclaration)) {
                CsmClassifier csmClassifier;
                CharSequence charSequence = csmOffsetableDeclaration.getName();
                if (!bl3 && !CsmKindUtilities.isFileLocalVariable((CsmObject)csmOffsetableDeclaration)) continue;
                if (charSequence.length() != 0) {
                    if (!this.matchName(((Object)charSequence).toString(), string, bl)) continue;
                    collection2.add(csmOffsetableDeclaration);
                    continue;
                }
                CsmVariable csmVariable = (CsmVariable)csmOffsetableDeclaration;
                CsmType csmType = csmVariable.getType();
                if (csmType == null || (csmClassifier = csmType.getClassifier()) == null || !CsmKindUtilities.isUnion((CsmObject)csmClassifier)) continue;
                CsmClass csmClass = (CsmClass)csmClassifier;
                List list = CsmSortUtilities.filterList((Collection)csmClass.getMembers(), (CharSequence)string, (boolean)bl, (boolean)this.caseSensitive);
                collection2.addAll(list);
                continue;
            }
            if (!bl2 || !CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration) || ((CsmNamespaceDefinition)csmOffsetableDeclaration).getName().length() != 0) continue;
            this.fillFileLocalVariables(string, bl, ((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), bl2, true, collection2);
        }
    }

    public List getNamespaceVariables(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        return this.getNamespaceVariables(csmNamespace, string, bl, this.isSortNeeded(), bl2);
    }

    private List getNamespaceVariables(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2, boolean bl3) {
        List list = this.getNamespaceMembers(csmNamespace, CsmDeclaration.Kind.VARIABLE, string, bl, bl3, false);
        list = this.filterVariables(list);
        if (bl2 && list != null) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getNamespaceFunctions(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        return this.getNamespaceFunctions(csmNamespace, string, bl, this.isSortNeeded(), bl2);
    }

    private List getNamespaceFunctions(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2, boolean bl3) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        List list = this.getNamespaceMembers(csmNamespace, kindArray, string, bl, bl3, false);
        list = this.filterFunctionDefinitions(list);
        if (bl2 && list != null) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getNestedNamespaces(CsmNamespace csmNamespace, String string, boolean bl) {
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
            if (csmNamespace2.getName().length() == 0 || !this.matchName(((Object)csmNamespace2.getName()).toString(), string, bl)) continue;
            arrayList.add(csmNamespace2);
        }
        if (this.sort && arrayList != null) {
            CsmSortUtilities.sortMembers(arrayList, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return arrayList;
    }

    public List getNamespaceClassesEnums(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List list = this.getNamespaceMembers(csmNamespace, kindArray, string, bl, bl2, false);
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortClasses((List)list, (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getNamespaceEnumerators(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        boolean bl3 = this.isSortNeeded();
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List list = this.getNamespaceMembers(csmNamespace, kindArray, "", false, bl2, true);
        List<CsmEnumerator> list2 = this.getEnumeratorsFromEnumsAndTypedefs(list, bl, string, bl3);
        return list2;
    }

    public List getNestedClassifiers(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.ENUM};
        List list = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, string, false, bl, bl2, true, false);
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getMethods(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        List list = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, string, bl, bl2, bl3, bl4, false);
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getFields(CsmClass csmClass, boolean bl) {
        return this.getFields(csmClass, (CsmOffsetableDeclaration)csmClass, "", bl, false, true, false);
    }

    public List getFields(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        List list = this.getClassMembers(csmClass, csmOffsetableDeclaration, CsmDeclaration.Kind.VARIABLE, string, bl, bl2, bl3, bl4);
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getEnumerators(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.isSortNeeded();
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List list = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, "", false, false, bl2, bl3, true);
        List<CsmEnumerator> list2 = this.getEnumeratorsFromEnumsAndTypedefs(list, bl, string, bl4);
        return list2;
    }

    public List getFieldsAndMethods(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        List list = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, string, bl, bl2, bl3, bl4, false);
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    private List getClassMembers(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmDeclaration.Kind kind, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.getClassMembers(csmClass, csmOffsetableDeclaration, new CsmDeclaration.Kind[]{kind}, string, bl, bl2, bl3, bl4, false);
    }

    private List getClassMembers(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        CsmVisibility csmVisibility;
        assert (csmClass != null);
        if (csmOffsetableDeclaration == null) {
            csmVisibility = CsmInheritanceUtilities.MAX_VISIBILITY;
        } else if (bl4) {
            csmVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration, (CsmVisibility)CsmVisibility.PUBLIC, (boolean)bl3);
            if (csmVisibility == CsmVisibility.NONE) {
                bl = true;
                csmVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration);
            }
        } else {
            csmVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration);
        }
        Map map = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, string, bl, bl2, new HashSet(), csmVisibility, 0, bl3, bl5);
        ArrayList<Object> arrayList = new ArrayList();
        if (map != null && map.size() > 0) {
            arrayList = new ArrayList(map.values());
        }
        return arrayList;
    }

    private Map getClassMembers(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2, Set set, CsmVisibility csmVisibility, int n, boolean bl3, boolean bl4) {
        Object object;
        Object object2;
        CsmDeclaration.Kind[] kindArray22;
        Object object3;
        assert (csmClass != null);
        if (set.contains(csmClass)) {
            return Collections.EMPTY_MAP;
        }
        if (csmVisibility == CsmVisibility.NONE) {
            return Collections.EMPTY_MAP;
        }
        if (n == 0) {
            n = 1;
            object3 = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)csmOffsetableDeclaration);
            if (csmClass.equals(object3)) {
                n = 2;
            } else if (object3 != null && CsmInheritanceUtilities.isAssignableFrom((CsmClass)object3, (CsmClass)csmClass)) {
                n = 3;
            }
        } else if (csmOffsetableDeclaration != null) {
            csmVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration, (CsmVisibility)csmVisibility, (n == 3 ? 1 : 0) != 0);
        }
        set.add(csmClass);
        object3 = new StringMap();
        for (CsmDeclaration.Kind[] kindArray22 : csmClass.getMembers()) {
            CharSequence charSequence;
            if (!CsmProjectContentResolver.isKindOf(kindArray22.getKind(), kindArray) || bl && !kindArray22.isStatic() || !this.matchVisibility((CsmMember)kindArray22, csmVisibility) || !this.matchName(((Object)(charSequence = kindArray22.getName())).toString(), string, bl2) && (charSequence.length() != 0 || !bl4)) continue;
            if (CsmKindUtilities.isFunction((CsmObject)kindArray22)) {
                object3.put(((Object)((CsmFunction)kindArray22).getSignature()).toString(), kindArray22);
                continue;
            }
            object3.put(((Object)kindArray22.getQualifiedName()).toString(), kindArray22);
        }
        kindArray22 = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.CLASS};
        for (CharSequence charSequence : csmClass.getMembers()) {
            if (!CsmProjectContentResolver.isKindOf(charSequence.getKind(), kindArray22) || !this.matchVisibility((CsmMember)charSequence, csmVisibility) || (object2 = charSequence.getName()).length() != 0) continue;
            object = this.getClassMembers((CsmClass)charSequence, csmOffsetableDeclaration, kindArray, string, bl, bl2, new HashSet(), CsmVisibility.PUBLIC, 0, bl3, bl4);
            object3.putAll(object);
        }
        if (bl3) {
            for (CharSequence charSequence : csmClass.getBaseClasses()) {
                Map map;
                object2 = charSequence.getCsmClass();
                if (object2 == null) continue;
                int n2 = n;
                if (n == 1) {
                    object = CsmInheritanceUtilities.mergeExtInheritedVisibility((CsmVisibility)csmVisibility, (CsmVisibility)charSequence.getVisibility());
                    n2 = 1;
                } else if (n == 2) {
                    object = CsmInheritanceUtilities.mergeInheritedVisibility((CsmVisibility)csmVisibility, (CsmVisibility)charSequence.getVisibility());
                    n2 = 3;
                } else {
                    assert (n == 3);
                    object = CsmInheritanceUtilities.mergeChildInheritanceVisibility((CsmVisibility)csmVisibility, (CsmVisibility)charSequence.getVisibility());
                    n2 = 3;
                }
                if ((map = this.getClassMembers((CsmClass)object2, csmOffsetableDeclaration, kindArray, string, bl, bl2, set, (CsmVisibility)object, n2, bl3, bl4)) == null || map.size() <= 0) continue;
                map.putAll(object3);
                object3 = map;
            }
        }
        return object3;
    }

    private List getNamespaceMembers(CsmNamespace csmNamespace, CsmDeclaration.Kind kind, String string, boolean bl, boolean bl2, boolean bl3) {
        return this.getNamespaceMembers(csmNamespace, new CsmDeclaration.Kind[]{kind}, string, bl, bl2, bl3);
    }

    private List getNamespaceMembers(CsmNamespace csmNamespace, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2, boolean bl3) {
        List list = this.getNamespaceMembers(csmNamespace, kindArray, string, bl, new HashSet(), bl2, bl3);
        return list;
    }

    private List getNamespaceMembers(CsmNamespace csmNamespace, CsmDeclaration.Kind[] kindArray, String string, boolean bl, Set set, boolean bl2, boolean bl3) {
        if (set.contains(csmNamespace)) {
            return Collections.EMPTY_LIST;
        }
        set.add(csmNamespace);
        ArrayList arrayList = new ArrayList();
        this.filterDeclarations(csmNamespace, arrayList, kindArray, string, bl, bl3);
        if (bl2) {
            for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
                arrayList.addAll(this.getNamespaceMembers(csmNamespace2, kindArray, string, bl, set, true, bl3));
            }
        }
        return arrayList;
    }

    void filterDeclarations(CsmNamespace csmNamespace, Collection collection, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2) {
        CsmSelect.CsmFilter csmFilter = null;
        if (kindArray != null && string != null) {
            csmFilter = CsmSelect.getDefault().getFilterBuilder().getCompoundAcceptor(CsmSelect.getDefault().getFilterBuilder().getKindAcceptor(kindArray), CsmSelect.getDefault().getFilterBuilder().getNameAcceptor(string, bl, this.caseSensitive, bl2));
        } else if (kindArray != null) {
            csmFilter = CsmSelect.getDefault().getFilterBuilder().getKindAcceptor(kindArray);
        } else if (string != null) {
            csmFilter = CsmSelect.getDefault().getFilterBuilder().getNameAcceptor(string, bl, this.caseSensitive, bl2);
        }
        Iterator iterator = CsmSelect.getDefault().getDeclarations(csmNamespace, csmFilter);
        while (iterator.hasNext()) {
            String string2;
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (!CsmProjectContentResolver.isKindOf(csmDeclaration.getKind(), kindArray) || !this.matchName(string2 = ((Object)csmDeclaration.getName()).toString(), string, bl) && (string2.length() != 0 || !bl2)) continue;
            collection.add(csmDeclaration);
        }
    }

    void filterDeclarations(Iterator iterator, Collection collection, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2) {
        while (iterator.hasNext()) {
            String string2;
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (!CsmProjectContentResolver.isKindOf(csmDeclaration.getKind(), kindArray) || !this.matchName(string2 = ((Object)csmDeclaration.getName()).toString(), string, bl) && (string2.length() != 0 || !bl2)) continue;
            collection.add(csmDeclaration);
        }
    }

    private static boolean isKindOf(CsmDeclaration.Kind kind, CsmDeclaration.Kind[] kindArray) {
        for (int i = 0; i < kindArray.length; ++i) {
            if (kind != kindArray[i]) continue;
            return true;
        }
        return false;
    }

    private boolean matchName(String string, String string2) {
        return CsmSortUtilities.matchName((CharSequence)string, (CharSequence)string2, (boolean)false, (boolean)this.caseSensitive);
    }

    private boolean matchName(String string, String string2, boolean bl) {
        return CsmSortUtilities.matchName((CharSequence)string, (CharSequence)string2, (boolean)bl, (boolean)this.caseSensitive);
    }

    private static boolean matchName(String string, String string2, boolean bl, boolean bl2) {
        return CsmSortUtilities.matchName((CharSequence)string, (CharSequence)string2, (boolean)bl, (boolean)bl2);
    }

    public boolean matchVisibility(CsmMember csmMember, CsmVisibility csmVisibility) {
        return CsmInheritanceUtilities.matchVisibility((CsmMember)csmMember, (CsmVisibility)csmVisibility);
    }

    private Map<String, CsmObject> mergeByFQN(Map<String, CsmObject> map, Collection<CsmObject> collection) {
        assert (map != null);
        if (collection != null && collection.size() > 0) {
            for (CsmObject csmObject : collection) {
                assert (CsmKindUtilities.isQualified((CsmObject)csmObject));
                String string = ((Object)((CsmQualifiedNamedElement)csmObject).getQualifiedName()).toString();
                map.put(string, csmObject);
            }
        }
        return map;
    }

    private <T> Collection<T> merge(Collection<T> collection, Collection<T> collection2) {
        return CsmUtilities.merge(collection, collection2);
    }

    private List filterFunctionDefinitions(List list) {
        ArrayList<CsmObject> arrayList = new ArrayList<CsmObject>();
        if (list != null && list.size() > 0) {
            for (CsmObject csmObject : list) {
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) && ((CsmFunctionDefinition)csmObject).getDeclaration() != csmObject) continue;
                arrayList.add(csmObject);
            }
        }
        return arrayList;
    }

    private List filterVariables(List<CsmVariable> list) {
        HashMap<String, CsmVariable> hashMap = new HashMap<String, CsmVariable>(list.size());
        for (CsmVariable csmVariable : list) {
            String string = ((Object)csmVariable.getQualifiedName()).toString();
            CsmVariable csmVariable2 = (CsmVariable)hashMap.get(string);
            if (csmVariable2 != null && CsmKindUtilities.isExternVariable((CsmDeclaration)csmVariable)) continue;
            hashMap.put(string, csmVariable);
        }
        return new ArrayList(hashMap.values());
    }

    private static interface NsContentResultsFilter {
        public Collection getResults(CsmProjectContentResolver var1, CsmNamespace var2, String var3, boolean var4, boolean var5);
    }
}

