/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionProvider;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmIncludeHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.utils.TokenUtilities;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Parameters;
import org.openide.util.UserQuestionException;

public final class ReferencesSupport {
    private ReferencesSupport() {
    }

    public static int getDocumentOffset(BaseDocument baseDocument, int n, int n2) {
        return Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n - 1)) + (n2 - 1);
    }

    public static BaseDocument getBaseDocument(String string) throws DataObjectNotFoundException, IOException {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            throw new IllegalStateException("Given file (\"" + dataObject.getName() + "\") does not have EditorCookie.");
        }
        StyledDocument styledDocument = null;
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (UserQuestionException userQuestionException) {
            userQuestionException.confirmed();
            styledDocument = editorCookie.openDocument();
        }
        return styledDocument instanceof BaseDocument ? (BaseDocument)styledDocument : null;
    }

    public static CsmObject findReferencedObject(CsmFile csmFile, BaseDocument baseDocument, int n) {
        return ReferencesSupport.findReferencedObject(csmFile, baseDocument, n, null);
    }

    static CsmObject findOwnerObject(CsmFile csmFile, BaseDocument baseDocument, int n, org.netbeans.modules.cnd.completion.cplusplus.utils.Token token) {
        CsmObject csmObject = CsmOffsetResolver.findObject(csmFile, n);
        return csmObject;
    }

    static CsmObject findReferencedObject(CsmFile csmFile, BaseDocument baseDocument, int n, org.netbeans.modules.cnd.completion.cplusplus.utils.Token token) {
        CsmFile csmFile2 = null;
        CsmInclude csmInclude = null;
        org.netbeans.modules.cnd.completion.cplusplus.utils.Token token2 = token = token != null ? token : ReferencesSupport.getTokenByOffset(baseDocument, n);
        if (token != null) {
            switch (token.getTokenID().getNumericID()) {
                case 154: 
                case 155: {
                    csmInclude = ReferencesSupport.findInclude(csmFile, n);
                }
            }
        }
        CsmFile csmFile3 = csmFile2 = csmInclude == null ? null : csmInclude.getIncludeFile();
        if (csmFile2 == null) {
            csmFile2 = ReferencesSupport.findDeclaration(csmFile, baseDocument, token, n);
        }
        return csmFile2;
    }

    public static CsmInclude findInclude(CsmFile csmFile, int n) {
        assert (csmFile != null);
        return (CsmInclude)CsmOffsetUtilities.findObject(csmFile.getIncludes(), null, n);
    }

    public static CsmObject findDeclaration(CsmFile csmFile, BaseDocument baseDocument, org.netbeans.modules.cnd.completion.cplusplus.utils.Token token, int n) {
        Object object;
        SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
        int[] nArray = null;
        CsmEnumerator csmEnumerator = null;
        CsmObject csmObject = CsmOffsetResolver.findObject(csmFile, n);
        if (CsmKindUtilities.isEnumerator((CsmObject)csmObject) && (object = (CsmEnumerator)csmObject).getExplicitValue() == null) {
            csmEnumerator = object;
        }
        if (csmEnumerator == null) {
            try {
                nArray = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)baseDocument, (int)n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (nArray != null && nArray.length != 3) {
                csmEnumerator = ReferencesSupport.findDeclaration(csmFile, baseDocument, token, n, CsmCompletionQuery.QueryScope.SMART_QUERY);
            }
        }
        Object object2 = csmEnumerator = csmEnumerator != null ? csmEnumerator : ReferencesSupport.findDeclaration(csmFile, baseDocument, token, n, CsmCompletionQuery.QueryScope.GLOBAL_QUERY);
        if (csmEnumerator == null) {
            object = CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                CsmReference csmReference = (CsmReference)iterator.next();
                if (csmReference.getStartOffset() > n || n > csmReference.getEndOffset()) continue;
                csmEnumerator = csmReference.getReferencedObject();
                assert (csmEnumerator != null) : "must be referenced macro" + csmReference;
            }
        }
        return csmEnumerator;
    }

    public static CsmObject findDeclaration(CsmFile csmFile, BaseDocument baseDocument, org.netbeans.modules.cnd.completion.cplusplus.utils.Token token, int n, CsmCompletionQuery.QueryScope queryScope) {
        assert (csmFile != null);
        org.netbeans.modules.cnd.completion.cplusplus.utils.Token token2 = token = token != null ? token : ReferencesSupport.getTokenByOffset(baseDocument, n);
        if (token == null) {
            return null;
        }
        CsmObject csmObject = null;
        if (token.getTokenID() == CCTokenContext.OPERATOR) {
            CsmObject csmObject2 = CsmOffsetResolver.findObject(csmFile, n);
            csmObject = csmObject2;
            if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
                CsmFunction csmFunction = null;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                    csmFunction = ((CsmFunctionDefinition)csmObject).getDeclaration();
                } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmObject)) {
                    csmFunction = ((CsmFriendFunction)csmObject).getReferencedFunction();
                }
                if (csmFunction != null) {
                    csmObject = csmFunction;
                }
            } else {
                csmObject = null;
            }
        }
        if (csmObject == null) {
            csmObject = CompletionUtilities.findItemAtCaretPos(null, baseDocument, CsmCompletionProvider.getCompletionQuery(csmFile, queryScope), n);
        }
        return csmObject;
    }

    private static org.netbeans.modules.cnd.completion.cplusplus.utils.Token getTokenByOffset(BaseDocument baseDocument, int n) {
        org.netbeans.modules.cnd.completion.cplusplus.utils.Token token = TokenUtilities.getToken((Document)baseDocument, n);
        return token;
    }

    static ReferenceImpl createReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, int n) {
        org.netbeans.modules.cnd.completion.cplusplus.utils.Token token = ReferencesSupport.getTokenByOffset(baseDocument, n);
        ReferenceImpl referenceImpl = null;
        if (ReferencesSupport.isSupportedToken(token)) {
            referenceImpl = ReferencesSupport.createReferenceImpl(csmFile, baseDocument, n, token);
        }
        return referenceImpl;
    }

    static ReferenceImpl createReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, TokenItem tokenItem) {
        org.netbeans.modules.cnd.completion.cplusplus.utils.Token token = new org.netbeans.modules.cnd.completion.cplusplus.utils.Token(tokenItem);
        ReferenceImpl referenceImpl = ReferencesSupport.createReferenceImpl(csmFile, baseDocument, tokenItem.getOffset(), token);
        return referenceImpl;
    }

    public static ReferenceImpl createReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, int n, org.netbeans.modules.cnd.completion.cplusplus.utils.Token token) {
        assert (token != null);
        assert (csmFile != null) : "null file for document " + baseDocument + " on offset " + n + " " + token;
        ReferenceImpl referenceImpl = new ReferenceImpl(csmFile, baseDocument, n, token);
        return referenceImpl;
    }

    private static boolean isSupportedToken(org.netbeans.modules.cnd.completion.cplusplus.utils.Token token) {
        return token != null && (CsmIncludeHyperlinkProvider.isSupportedToken(token) || CsmHyperlinkProvider.isSupportedToken(token));
    }

    public static CsmReferenceResolver.Scope fastCheckScope(CsmReference csmReference) {
        Parameters.notNull((CharSequence)"ref", (Object)csmReference);
        CsmObject csmObject = ReferencesSupport.getTargetIfPossible(csmReference);
        if (csmObject == null) {
            int n = ReferencesSupport.getRefOffset(csmReference);
            BaseDocument baseDocument = ReferencesSupport.getRefDocument(csmReference);
            if (baseDocument != null) {
                org.netbeans.modules.cnd.completion.cplusplus.utils.Token token = ReferencesSupport.getRefTokenIfPossible(csmReference);
                csmObject = ReferencesSupport.findDeclaration(csmReference.getContainingFile(), baseDocument, token, n, CsmCompletionQuery.QueryScope.LOCAL_QUERY);
                ReferencesSupport.setResolvedInfo(csmReference, csmObject);
            }
        }
        return ReferencesSupport.getTargetScope(csmObject);
    }

    private static CsmReferenceResolver.Scope getTargetScope(CsmObject csmObject) {
        if (csmObject == null) {
            return CsmReferenceResolver.Scope.UNKNOWN;
        }
        if (ReferencesSupport.isLocalElement(csmObject)) {
            return CsmReferenceResolver.Scope.LOCAL;
        }
        if (ReferencesSupport.isFileLocalElement(csmObject)) {
            return CsmReferenceResolver.Scope.FILE_LOCAL;
        }
        return CsmReferenceResolver.Scope.GLOBAL;
    }

    private static CsmObject getTargetIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getTarget();
        }
        return null;
    }

    private static org.netbeans.modules.cnd.completion.cplusplus.utils.Token getRefTokenIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getToken();
        }
        return null;
    }

    private static BaseDocument getRefDocument(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getDocument();
        }
        CsmFile csmFile = csmReference.getContainingFile();
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        StyledDocument styledDocument = null;
        if (cloneableEditorSupport != null) {
            styledDocument = cloneableEditorSupport.getDocument();
        }
        return styledDocument instanceof BaseDocument ? (BaseDocument)styledDocument : null;
    }

    private static int getRefOffset(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getOffset();
        }
        return (csmReference.getStartOffset() + csmReference.getEndOffset() + 1) / 2;
    }

    private static void setResolvedInfo(CsmReference csmReference, CsmObject csmObject) {
        if (csmObject != null && csmReference instanceof ReferenceImpl) {
            ((ReferenceImpl)csmReference).setTarget(csmObject);
        }
    }

    private static boolean isLocalElement(CsmObject csmObject) {
        assert (csmObject != null);
        CsmObject csmObject2 = csmObject;
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject2)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject2).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
                return true;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)csmScope)) break;
            csmObject2 = (CsmScopeElement)csmScope;
        }
        return false;
    }

    private static boolean isFileLocalElement(CsmObject csmObject) {
        assert (csmObject != null);
        if (CsmBaseUtilities.isDeclarationFromUnnamedNamespace((CsmObject)csmObject)) {
            return true;
        }
        if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
            return true;
        }
        if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            return CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObject));
        }
        return false;
    }

    static BaseDocument getDocument(CsmFile csmFile) {
        BaseDocument baseDocument = null;
        try {
            baseDocument = ReferencesSupport.getBaseDocument(((Object)csmFile.getAbsolutePath()).toString());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        return baseDocument;
    }

    static CsmReferenceKind getReferenceKind(CsmReference csmReference) {
        CsmReferenceKind csmReferenceKind = CsmReferenceKind.UNKNOWN;
        CsmObject csmObject = csmReference.getOwner();
        if (CsmKindUtilities.isType((CsmObject)csmObject) || CsmKindUtilities.isInheritance((CsmObject)csmObject)) {
            csmReferenceKind = ReferencesSupport.getReferenceUsageKind(csmReference);
        } else if (CsmKindUtilities.isInclude((CsmObject)csmObject)) {
            csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        } else {
            CsmObject csmObject2 = csmReference.getReferencedObject();
            if (csmObject2 != null) {
                CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject2, (boolean)true);
                CsmObject csmObject3 = csmObjectArray[0];
                CsmObject csmObject4 = csmObjectArray[1];
                assert (csmObject3 != null);
                csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
                if (csmObject != null) {
                    csmReferenceKind = csmObject.equals(csmObject3) ? CsmReferenceKind.DECLARATION : (csmObject.equals(csmObject4) ? CsmReferenceKind.DEFINITION : ReferencesSupport.getReferenceUsageKind(csmReference));
                }
            }
        }
        return csmReferenceKind;
    }

    static CsmReferenceKind getReferenceUsageKind(CsmReference csmReference) {
        int n;
        BaseDocument baseDocument;
        TokenSequence tokenSequence;
        CsmReferenceKind csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        if (csmReference instanceof ReferenceImpl && (tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)(baseDocument = ReferencesSupport.getRefDocument(csmReference)), (int)(n = csmReference.getStartOffset()))) != null && tokenSequence.isValid()) {
            tokenSequence.move(n);
            Token token = null;
            if (tokenSequence.movePrevious()) {
                token = tokenSequence.offsetToken();
            }
            while (token != null && "whitespace".equals(((CppTokenId)token.id()).primaryCategory())) {
                if (tokenSequence.movePrevious()) {
                    token = tokenSequence.offsetToken();
                    continue;
                }
                token = null;
            }
            if (token != null) {
                switch ((CppTokenId)token.id()) {
                    case DOT: 
                    case DOTMBR: 
                    case ARROW: 
                    case ARROWMBR: 
                    case SCOPE: {
                        csmReferenceKind = CsmReferenceKind.AFTER_DEREFERENCE_USAGE;
                    }
                }
            }
        }
        return csmReferenceKind;
    }
}

