/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.ruby.debugger.DebuggerAnnotation;
import org.netbeans.modules.ruby.debugger.Util;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.windows.TopComponent;

public final class EditorUtil {
    private static DebuggerAnnotation currentLineDA;

    private EditorUtil() {
    }

    static void markCurrent(String string, int n) {
        EditorUtil.markCurrent(EditorUtil.getLineAnnotable(string, n));
    }

    private static void markCurrent(Line line) {
        EditorUtil.unmarkCurrent();
        if (line == null) {
            return;
        }
        currentLineDA = new DebuggerAnnotation("CurrentPC", (Annotatable)line);
        EditorUtil.showLine(line, true);
    }

    static void unmarkCurrent() {
        if (currentLineDA != null) {
            currentLineDA.detach();
            currentLineDA = null;
        }
    }

    public static Line getLineAnnotable(String string, int n) {
        return EditorUtil.getLine(string, n);
    }

    public static Line getLine(String string, int n) {
        if (string == null || n < 0) {
            return null;
        }
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            Util.info("Cannot resolve \"" + string + '\"');
            return null;
        }
        LineCookie lineCookie = EditorUtil.getLineCookie(fileObject);
        assert (lineCookie != null);
        return lineCookie.getLineSet().getCurrent(n);
    }

    public static LineCookie getLineCookie(FileObject fileObject) {
        LineCookie lineCookie = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null) {
                lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Util.LOGGER.log(Level.FINE, "Cannot find DataObject for: " + fileObject, dataObjectNotFoundException.getMessage());
        }
        return lineCookie;
    }

    public static void showLine(final Line line, final boolean bl) {
        if (line == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                line.show(bl ? 3 : 2);
            }
        });
    }

    public static void showLine(Line line) {
        EditorUtil.showLine(line, false);
    }

    public static Line getCurrentLine() {
        DataObject dataObject;
        Node[] nodeArray = TopComponent.getRegistry().getCurrentNodes();
        if (nodeArray == null) {
            return null;
        }
        if (nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0];
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null && (dataObject = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            fileObject = dataObject.getPrimaryFile();
        }
        if (fileObject == null) {
            return null;
        }
        if (!Util.isRubySource(fileObject)) {
            return null;
        }
        dataObject = (LineCookie)node.getCookie(LineCookie.class);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        JEditorPane jEditorPane = EditorUtil.getEditorPane(editorCookie);
        if (jEditorPane == null) {
            return null;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return null;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        try {
            Line.Set set = dataObject.getLineSet();
            assert (set != null) : dataObject;
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private static JEditorPane getEditorPane_(EditorCookie editorCookie) {
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    private static JEditorPane getEditorPane(final EditorCookie editorCookie) {
        if (SwingUtilities.isEventDispatchThread()) {
            return EditorUtil.getEditorPane_(editorCookie);
        }
        final JEditorPane[] jEditorPaneArray = new JEditorPane[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    jEditorPaneArray[0] = EditorUtil.getEditorPane_(editorCookie);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            Util.severe(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            Util.severe(interruptedException);
            Thread.currentThread().interrupt();
        }
        return jEditorPaneArray[0];
    }
}

