/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.RubyDebuggerActionProvider;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.model.CallSite;
import org.netbeans.modules.ruby.debugger.ui.CallStackAnnotation;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class RubySession {
    private static final String RUBY_SESSION = "RubySession";
    static boolean TEST;
    private final RubyThreadInfo[] EMPTY_THREAD_INFOS = new RubyThreadInfo[0];
    private final RubyFrame[] EMPTY_FRAMES = new RubyFrame[0];
    private final RubyVariable[] EMPTY_VARIABLES = new RubyVariable[0];
    private final RubyDebuggerProxy proxy;
    private RubyDebuggerActionProvider actionProvider;
    private final FileLocator fileLocator;
    private RubyThread activeThread;
    private RubyFrame selectedFrame;
    private final DebuggerManagerListener sessionListener;
    private State state;
    File runningToFile;
    int runningToLine;

    RubySession(RubyDebuggerProxy rubyDebuggerProxy, FileLocator fileLocator) {
        this.proxy = rubyDebuggerProxy;
        this.fileLocator = fileLocator;
        this.sessionListener = new RubySessionListener();
        this.state = State.STARTING;
        this.runningToLine = -1;
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", this.sessionListener);
    }

    void setActionProvider(RubyDebuggerActionProvider rubyDebuggerActionProvider) {
        this.actionProvider = rubyDebuggerActionProvider;
    }

    RubyDebuggerActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public State getState() {
        return this.state;
    }

    void resume() {
        this.beforeProceed();
        this.activeThread.resume();
        EditorUtil.unmarkCurrent();
        this.state = State.RUNNING;
    }

    void stepInto() {
        try {
            this.beforeProceed();
            if (!this.activeThread.canStepInto()) {
                return;
            }
            this.activeThread.stepInto(this.forceNewLine());
            this.state = State.RUNNING;
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.severe("Cannot step into", rubyDebuggerException);
        }
    }

    void stepOver() {
        try {
            this.beforeProceed();
            if (!this.activeThread.canStepOver()) {
                return;
            }
            this.activeThread.stepOver(this.forceNewLine());
            this.state = State.RUNNING;
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.severe("Cannot step over", rubyDebuggerException);
        }
    }

    void stepReturn() {
        try {
            this.beforeProceed();
            this.activeThread.stepReturn();
            this.state = State.RUNNING;
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.severe("Cannot step return", rubyDebuggerException);
        }
    }

    void runToCursor() {
        int n;
        File file;
        if (TEST) {
            file = this.runningToFile;
            n = this.runningToLine;
        } else {
            assert (this.runningToFile == null) : "runningToFile is not set";
            this.beforeProceed();
            Line line = EditorUtil.getCurrentLine();
            if (line == null) {
                return;
            }
            FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
            if (fileObject == null) {
                return;
            }
            if (!Util.isRubySource(fileObject)) {
                return;
            }
            file = FileUtil.toFile((FileObject)fileObject);
            n = line.getLineNumber() + 1;
        }
        if (file != null) {
            try {
                this.runningToFile = file;
                this.runningToLine = n;
                this.activeThread.runTo(file.getAbsolutePath(), n);
                this.state = State.RUNNING;
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                Util.severe("Cannot step return", rubyDebuggerException);
            }
        }
    }

    boolean isRunningTo(File file, int n) {
        assert (file != null) : "isRunningTo is not passed null File arg";
        return file.equals(this.runningToFile) && n == this.runningToLine;
    }

    void finish(RubyDebugEventListener rubyDebugEventListener, boolean bl) {
        CallStackAnnotation.clearAnnotations();
        DebuggerManager.getDebuggerManager().removeDebuggerListener(this.sessionListener);
        this.proxy.removeRubyDebugEventListener(rubyDebugEventListener);
        if (bl) {
            this.proxy.finish(true);
        }
    }

    String getName() {
        return "localhost:" + this.proxy.getDebugTarged().getPort();
    }

    public RubyThreadInfo[] getThreadInfos() {
        try {
            return this.proxy.checkConnection() ? this.proxy.readThreadInfo() : this.EMPTY_THREAD_INFOS;
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            if (this.proxy.checkConnection()) {
                Util.LOGGER.log(Level.INFO, "Cannot read thread information", rubyDebuggerException);
            }
            return this.EMPTY_THREAD_INFOS;
        }
    }

    public RubyFrame[] getFrames() {
        try {
            return this.isSessionSuspended() ? this.activeThread.getFrames() : this.EMPTY_FRAMES;
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.severe("Cannot read frames information", rubyDebuggerException);
            return this.EMPTY_FRAMES;
        }
    }

    private RubyFrame getTopFrame() throws RubyDebuggerException {
        return this.isSessionSuspended() ? this.activeThread.getTopFrame() : null;
    }

    public void selectFrame(RubyFrame rubyFrame) {
        this.selectedFrame = rubyFrame;
    }

    private RubyFrame getSelectedFrame() {
        try {
            return this.selectedFrame == null ? this.getTopFrame() : this.selectedFrame;
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.LOGGER.log(Level.INFO, "Unable to read top stack frame", rubyDebuggerException);
            return null;
        }
    }

    public boolean isSelectedFrame(RubyFrame rubyFrame) {
        return rubyFrame.equals((Object)this.getSelectedFrame());
    }

    public RubyVariable[] getGlobalVariables() {
        try {
            return this.isSessionSuspended() ? this.proxy.readGlobalVariables() : this.EMPTY_VARIABLES;
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.LOGGER.log(Level.INFO, "Cannot read global variables information", rubyDebuggerException);
            return this.EMPTY_VARIABLES;
        }
    }

    public RubyVariable[] getVariables() {
        try {
            RubyFrame rubyFrame = this.getSelectedFrame();
            return rubyFrame == null ? this.EMPTY_VARIABLES : rubyFrame.getVariables();
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.LOGGER.log(Level.INFO, "Cannot read variables information", rubyDebuggerException);
            return this.EMPTY_VARIABLES;
        }
    }

    public RubyVariable[] getChildren(RubyVariable rubyVariable) {
        try {
            RubyValue rubyValue = rubyVariable.getValue();
            return rubyValue == null ? this.EMPTY_VARIABLES : rubyValue.getVariables();
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.severe("Cannot read variables information", rubyDebuggerException);
            return this.EMPTY_VARIABLES;
        }
    }

    public RubyVariable inspectExpression(String string) {
        try {
            RubyFrame rubyFrame = this.getSelectedFrame();
            return rubyFrame == null ? null : rubyFrame.inspectExpression(string);
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.finest("Unable to inspect expression [" + string + ']');
            return null;
        }
    }

    void suspend(RubyThread rubyThread, ContextProviderWrapper contextProviderWrapper) {
        this.state = State.STOPPED;
        this.runningToFile = null;
        this.runningToLine = -1;
        this.switchThread(rubyThread, contextProviderWrapper);
    }

    void switchThread(RubyThread rubyThread, ContextProviderWrapper contextProviderWrapper) {
        if (rubyThread.isSuspended()) {
            this.activeThread = rubyThread;
            try {
                RubyFrame rubyFrame = this.getTopFrame();
                if (rubyFrame == null) {
                    return;
                }
                EditorUtil.markCurrent(this.resolveAbsolutePath(rubyFrame.getFile()), rubyFrame.getLine() - 1);
                this.annotateCallStack(rubyThread);
                if (contextProviderWrapper != null) {
                    contextProviderWrapper.fireModelChanges();
                }
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                Util.severe("Cannot switch thread", rubyDebuggerException);
            }
        } else {
            Util.finest("Cannot switch to thread which is not suspended [" + rubyThread + "]");
        }
    }

    public void switchThread(int n, ContextProviderWrapper contextProviderWrapper) {
        RubyThread rubyThread = this.proxy.getDebugTarged().getThreadById(n);
        if (rubyThread != null) {
            this.switchThread(rubyThread, contextProviderWrapper);
        }
    }

    public boolean isActiveThread(int n) {
        return this.activeThread != null && this.activeThread.getId() == n;
    }

    public boolean isSessionSuspended() {
        return this.activeThread != null && this.activeThread.isSuspended();
    }

    public String resolveAbsolutePath(String string) {
        File file;
        if (new File(string).isAbsolute()) {
            return string;
        }
        String string2 = null;
        FileObject fileObject = this.fileLocator.find(string);
        if (fileObject != null && (file = FileUtil.toFile((FileObject)fileObject)) != null && file.isFile()) {
            string2 = file.getAbsolutePath();
        }
        if (string2 == null) {
            Util.finest("Cannot resolve absolute path for: \"" + string + '\"');
        }
        return string2;
    }

    public boolean isSuspended(RubyThreadInfo rubyThreadInfo) {
        RubyThread rubyThread = this.proxy.getDebugTarged().getThreadById(rubyThreadInfo.getId());
        if (rubyThread != null) {
            return rubyThread.isSuspended();
        }
        Util.warning("There is no thread for: " + rubyThreadInfo);
        return false;
    }

    private void annotateCallStack(RubyThread rubyThread) {
        if (TEST) {
            return;
        }
        try {
            RubyFrame[] rubyFrameArray = rubyThread.getFrames();
            assert (rubyFrameArray.length > 0) : "thread has >0 frames";
            CallSite[] callSiteArray = new CallSite[rubyFrameArray.length - 1];
            for (int i = 1; i < rubyFrameArray.length; ++i) {
                CallSite callSite;
                RubyFrame rubyFrame = rubyFrameArray[i];
                callSiteArray[i - 1] = callSite = new CallSite(this.resolveAbsolutePath(rubyFrame.getFile()), rubyFrame.getLine() - 1);
            }
            CallStackAnnotation.annotate(callSiteArray);
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            Util.LOGGER.log(Level.WARNING, "Cannot annotated current call stack", rubyDebuggerException);
        }
    }

    private void refresh() {
        if (this.isSessionSuspended()) {
            this.switchThread(this.activeThread, null);
        }
    }

    private void beforeProceed() {
        this.selectFrame(null);
        CallStackAnnotation.clearAnnotations();
    }

    private boolean forceNewLine() throws RubyDebuggerException {
        RubyFrame rubyFrame = this.activeThread.getTopFrame();
        assert (rubyFrame != null);
        String string = rubyFrame.getFile();
        File file = FileUtil.normalizeFile((File)new File(string));
        FileObject fileObject = file.isAbsolute() ? FileUtil.toFileObject((File)file) : this.fileLocator.find(string);
        return fileObject == null ? false : Util.isERBSource(fileObject);
    }

    RubyDebuggerProxy getProxy() {
        return this.proxy;
    }

    SessionProvider createSessionProvider() {
        return new SessionProvider(){

            public String getSessionName() {
                return RubySession.this.getName();
            }

            public String getLocationName() {
                return "localhost";
            }

            public String getTypeID() {
                return RubySession.RUBY_SESSION;
            }

            public Object[] getServices() {
                return new Object[0];
            }
        };
    }

    private static class RubySessionListener
    extends DebuggerManagerAdapter {
        private RubySessionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (session != null && "Ruby".equals(session.getCurrentLanguage())) {
                Util.getCurrentSession().refresh();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        STARTING,
        RUNNING,
        STOPPED;

    }
}

