/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jsp.lexer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.jsp.lexer.JspParseData;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspLexer
implements Lexer<JspTokenId> {
    private static final Logger LOGGER = Logger.getLogger(JspLexer.class.getName());
    private static final boolean LOG = Boolean.getBoolean("j2ee_lexer_debug");
    private static final int EOF = -1;
    private static final String JSP_STANDART_TAG_PREFIX = "jsp:";
    private final LexerInput input;
    private final InputAttributes inputAttributes;
    private final JspParseData jspParseData;
    private final TokenFactory<JspTokenId> tokenFactory;
    private int lexerState = 0;
    private int lexerStateBeforeEL = 0;
    private int lexerStateJspScriptlet = 0;
    private static final int INIT = 0;
    private static final int ISI_ERROR = 1;
    private static final int ISA_LT = 2;
    private static final int ISI_TAGNAME = 3;
    private static final int ISI_DIRNAME = 4;
    private static final int ISP_TAG = 5;
    private static final int ISP_DIR = 6;
    private static final int ISI_TAG_I_WS = 7;
    private static final int ISI_DIR_I_WS = 8;
    private static final int ISI_ENDTAG = 9;
    private static final int ISI_TAG_ATTR = 10;
    private static final int ISI_DIR_ATTR = 11;
    private static final int ISP_TAG_EQ = 12;
    private static final int ISP_DIR_EQ = 13;
    private static final int ISI_TAG_STRING = 14;
    private static final int ISI_DIR_STRING = 15;
    private static final int ISI_TAG_STRING_B = 16;
    private static final int ISI_DIR_STRING_B = 17;
    private static final int ISI_TAG_STRING2 = 18;
    private static final int ISI_DIR_STRING2 = 19;
    private static final int ISI_TAG_STRING2_B = 20;
    private static final int ISI_DIR_STRING2_B = 21;
    private static final int ISA_ENDSLASH = 22;
    private static final int ISA_ENDPC = 23;
    private static final int ISA_LT_PC = 24;
    private static final int ISI_JSP_COMMENT = 25;
    private static final int ISI_JSP_COMMENT_M = 26;
    private static final int ISI_JSP_COMMENT_MM = 27;
    private static final int ISI_JSP_COMMENT_MMP = 28;
    private static final int ISI_TAG_ERROR = 30;
    private static final int ISI_DIR_ERROR = 31;
    private static final int ISI_DIR_ERROR_P = 32;
    private static final int ISA_LT_PC_AT = 33;
    private static final int ISA_LT_SLASH = 34;
    private static final int ISA_LT_PC_DASH = 35;
    private static final int ISI_SCRIPTLET = 36;
    private static final int ISP_SCRIPTLET_PC = 37;
    private static final int ISA_EL_DELIM = 38;
    private static final int ISI_EL = 39;
    private static final int ISA_BS = 40;
    private static final int JAVA_SCRITPLET = 1;
    private static final int JAVA_DECLARATION = 2;
    private static final int JAVA_EXPRESSION = 3;
    private static final int JAVA_SCRITPLET_DOCUMENT = 4;
    private static final int JAVA_DECLARATION_DOCUMENT = 5;
    private static final int JAVA_EXPRESSION_DOCUMENT = 6;

    public Object state() {
        return this.lexerState + this.lexerStateBeforeEL * 1000 + this.lexerStateJspScriptlet * 1000000;
    }

    public JspLexer(LexerRestartInfo<JspTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.inputAttributes = lexerRestartInfo.inputAttributes();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        if (lexerRestartInfo.state() == null) {
            this.lexerState = 0;
            this.lexerStateBeforeEL = 0;
            this.lexerStateJspScriptlet = 0;
        } else {
            int n = (Integer)lexerRestartInfo.state();
            this.lexerStateJspScriptlet = n / 1000000;
            int n2 = n % 1000000;
            this.lexerStateBeforeEL = n2 / 1000;
            this.lexerState = n % 1000;
        }
        this.jspParseData = this.inputAttributes != null ? (JspParseData)this.inputAttributes.getValue(LanguagePath.get(JspTokenId.language()), JspParseData.class) : null;
    }

    public boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    private boolean isJspTag(CharSequence charSequence) {
        int n;
        if (this.startsWith(charSequence, JSP_STANDART_TAG_PREFIX)) {
            return true;
        }
        if (this.jspParseData != null && (n = this.indexOf(charSequence, ':')) != -1) {
            CharSequence charSequence2 = charSequence.subSequence(0, n);
            return this.jspParseData.isTagLibRegistered(((Object)charSequence2).toString());
        }
        return false;
    }

    private boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence.length() < charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private int indexOf(CharSequence charSequence, char c) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private boolean isELIgnored() {
        return this.jspParseData == null ? false : this.jspParseData.isELIgnored();
    }

    private boolean isXMLSyntax() {
        return this.jspParseData == null ? false : this.jspParseData.isXMLSyntax();
    }

    private CharSequence getPossibleTagName() {
        int n;
        int n2 = this.input.readLength();
        int n3 = 0;
        do {
            n = this.input.read();
            ++n3;
        } while ((Character.isLetter(n) || Character.isDigit(n) || n == 95 || n == 45 || n == 58 || n == 46 || n == 47) && n != -1);
        CharSequence charSequence = this.input.readText().subSequence(n2, n2 + n3 - 1);
        this.input.backup(n3);
        return charSequence;
    }

    private boolean followsJspTag() {
        return this.isJspTag(this.getPossibleTagName());
    }

    public Token<JspTokenId> nextToken() {
        block168: while (true) {
            int n;
            if ((n = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                break;
            }
            block0 : switch (this.lexerState) {
                case 0: {
                    switch (n) {
                        case 60: {
                            this.lexerState = 2;
                            break block0;
                        }
                        case 92: {
                            this.lexerState = 40;
                            break block0;
                        }
                        case 35: 
                        case 36: {
                            this.lexerStateBeforeEL = this.lexerState;
                            this.lexerState = 38;
                        }
                    }
                    break;
                }
                case 40: {
                    if (n == 92) break;
                    this.lexerState = 0;
                    break;
                }
                case 38: {
                    if (this.isELIgnored()) {
                        this.lexerState = this.lexerStateBeforeEL;
                        this.lexerStateBeforeEL = 0;
                        break;
                    }
                    switch (n) {
                        case 123: {
                            if (this.input.readLength() > 2) {
                                this.input.backup(2);
                                this.lexerState = this.lexerStateBeforeEL;
                                this.lexerStateBeforeEL = 0;
                                return this.token(JspTokenId.TEXT);
                            }
                            this.lexerState = 39;
                            break block0;
                        }
                    }
                    this.input.backup(1);
                    this.lexerState = this.lexerStateBeforeEL;
                    this.lexerStateBeforeEL = 0;
                    break;
                }
                case 39: {
                    if (n != 125) break;
                    this.lexerState = this.lexerStateBeforeEL;
                    this.lexerStateBeforeEL = 0;
                    return this.token(JspTokenId.EL);
                }
                case 2: {
                    CharSequence charSequence;
                    if (Character.isLetter(n) || n == 95) {
                        this.input.backup(1);
                        charSequence = this.getPossibleTagName();
                        if (this.isJspTag(charSequence)) {
                            if (this.input.readLength() > 1) {
                                this.input.backup(1);
                                this.lexerState = 0;
                                return this.token(JspTokenId.TEXT);
                            }
                            if ("jsp:scriptlet".equals(charSequence)) {
                                this.lexerStateJspScriptlet = 4;
                            } else if ("jsp:declaration".equals(charSequence)) {
                                this.lexerStateJspScriptlet = 5;
                            } else if ("jsp:expression".equals(charSequence)) {
                                this.lexerStateJspScriptlet = 6;
                            }
                            this.lexerState = 3;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        this.lexerState = 0;
                        break;
                    }
                    switch (n) {
                        case 47: {
                            this.lexerState = 34;
                            break block0;
                        }
                        case 37: {
                            this.lexerState = 24;
                            break block0;
                        }
                    }
                    this.lexerState = 0;
                    break;
                }
                case 34: {
                    if (Character.isLetter(n) || n == 95) {
                        this.input.backup(1);
                        if (this.followsJspTag()) {
                            if (this.input.readLength() > 2) {
                                this.input.backup(2);
                                this.lexerState = 0;
                                return this.token(JspTokenId.TEXT);
                            }
                            this.lexerState = 9;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        this.lexerState = 0;
                        break;
                    }
                    this.lexerState = 0;
                    break;
                }
                case 3: 
                case 4: {
                    if (Character.isLetter(n) || Character.isDigit(n) || n == 95 || n == 45 || n == 58 || n == 46) continue block168;
                    switch (n) {
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            break;
                        }
                        case 47: {
                            this.input.backup(1);
                            this.lexerState = this.lexerState == 3 ? 5 : 6;
                            break;
                        }
                        case 62: {
                            if (this.lexerStateJspScriptlet != 0) {
                                this.lexerState = 36;
                                break;
                            }
                            this.input.backup(1);
                            this.lexerState = this.lexerState == 3 ? 5 : 6;
                            break;
                        }
                        case 32: {
                            this.input.backup(1);
                            this.lexerState = this.lexerState == 3 ? 5 : 6;
                            break;
                        }
                        default: {
                            this.lexerState = this.lexerState == 3 ? 5 : 6;
                        }
                    }
                    return this.token(JspTokenId.TAG);
                }
                case 5: 
                case 6: {
                    if (Character.isLetter(n) || n == 95) {
                        this.lexerState = this.lexerState == 5 ? 10 : 11;
                        break;
                    }
                    switch (n) {
                        case 10: {
                            return this.token(JspTokenId.EOL);
                        }
                        case 62: {
                            if (this.lexerState == 5) {
                                this.lexerState = 0;
                                return this.token(JspTokenId.SYMBOL);
                            }
                            this.lexerState = 31;
                            break block0;
                        }
                        case 47: {
                            if (this.lexerState == 5) {
                                this.lexerState = 22;
                                break block0;
                            }
                            this.lexerState = 31;
                            break block0;
                        }
                        case 37: {
                            if (this.lexerState == 6) {
                                this.lexerState = 23;
                                break block0;
                            }
                            this.lexerState = 30;
                            break block0;
                        }
                        case 61: {
                            this.lexerState = this.lexerState == 5 ? 12 : 13;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        case 9: 
                        case 32: {
                            this.lexerState = this.lexerState == 5 ? 7 : 8;
                            break block0;
                        }
                        case 60: {
                            assert (this.input.readLength() == 1) : "There is something more than '<' char in the read text: '" + this.input.readText() + "'";
                            this.input.backup(1);
                            this.lexerState = 0;
                        }
                    }
                    this.lexerState = this.lexerState == 5 ? 30 : 31;
                    break;
                }
                case 7: 
                case 8: {
                    switch (n) {
                        case 9: 
                        case 32: {
                            break block0;
                        }
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            return this.token(JspTokenId.TAG);
                        }
                    }
                    this.lexerState = this.lexerState == 7 ? 5 : 6;
                    this.input.backup(1);
                    return this.token(JspTokenId.WHITESPACE);
                }
                case 9: {
                    if (Character.isLetter(n) || Character.isDigit(n) || n == 95 || n == 45 || n == 58) continue block168;
                    this.lexerState = 5;
                    this.input.backup(1);
                    return this.token(JspTokenId.ENDTAG);
                }
                case 10: 
                case 11: {
                    if (Character.isLetter(n) || Character.isDigit(n) || n == 95 || n == 58 || n == 45) continue block168;
                    this.lexerState = this.lexerState == 10 ? 5 : 6;
                    this.input.backup(1);
                    return this.token(JspTokenId.ATTRIBUTE);
                }
                case 12: 
                case 13: {
                    switch (n) {
                        case 10: {
                            return this.token(JspTokenId.EOL);
                        }
                        case 34: {
                            this.lexerState = this.lexerState == 12 ? 14 : 15;
                            break block0;
                        }
                        case 39: {
                            this.lexerState = this.lexerState == 12 ? 18 : 19;
                            break block0;
                        }
                        case 9: 
                        case 32: {
                            break block0;
                        }
                    }
                    this.lexerState = this.lexerState == 12 ? 5 : 6;
                    this.input.backup(this.input.readLength());
                    break;
                }
                case 14: 
                case 15: 
                case 18: 
                case 19: {
                    if (n == 34 && (this.lexerState == 14 || this.lexerState == 15)) {
                        this.lexerState = this.lexerState == 14 ? 5 : 6;
                        return this.token(JspTokenId.ATTR_VALUE);
                    }
                    if (n == 39 && (this.lexerState == 18 || this.lexerState == 19)) {
                        this.lexerState = this.lexerState == 18 ? 5 : 6;
                        return this.token(JspTokenId.ATTR_VALUE);
                    }
                    switch (n) {
                        case 92: {
                            switch (this.lexerState) {
                                case 14: {
                                    this.lexerState = 16;
                                    break block0;
                                }
                                case 15: {
                                    this.lexerState = 17;
                                    break block0;
                                }
                                case 18: {
                                    this.lexerState = 20;
                                    break block0;
                                }
                                case 19: {
                                    this.lexerState = 21;
                                }
                            }
                            break block0;
                        }
                        case 10: {
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.ATTR_VALUE);
                        }
                        case 35: 
                        case 36: {
                            if (this.input.readLength() > 1) {
                                this.input.backup(1);
                                return this.token(JspTokenId.ATTR_VALUE);
                            }
                            this.lexerStateBeforeEL = this.lexerState;
                            this.lexerState = 38;
                            break block0;
                        }
                    }
                    break;
                }
                case 16: 
                case 17: 
                case 20: 
                case 21: {
                    switch (n) {
                        case 34: 
                        case 35: 
                        case 36: 
                        case 39: 
                        case 92: {
                            break;
                        }
                        default: {
                            this.input.backup(1);
                        }
                    }
                    switch (this.lexerState) {
                        case 16: {
                            this.lexerState = 14;
                            break block0;
                        }
                        case 17: {
                            this.lexerState = 15;
                            break block0;
                        }
                        case 20: {
                            this.lexerState = 18;
                            break block0;
                        }
                        case 21: {
                            this.lexerState = 19;
                        }
                    }
                    break;
                }
                case 22: {
                    switch (n) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        case 10: {
                            this.lexerState = 30;
                            this.input.backup(1);
                            return this.token(JspTokenId.SYMBOL);
                        }
                    }
                    this.lexerState = 5;
                    this.input.backup(1);
                    return this.token(JspTokenId.SYMBOL);
                }
                case 23: {
                    switch (n) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(JspTokenId.SYMBOL);
                        }
                        case 10: {
                            this.lexerState = 31;
                            this.input.backup(1);
                            return this.token(JspTokenId.SYMBOL);
                        }
                    }
                    this.lexerState = 6;
                    this.input.backup(1);
                    return this.token(JspTokenId.SYMBOL);
                }
                case 24: {
                    switch (n) {
                        case 64: {
                            if (this.input.readLength() == 3) {
                                this.lexerState = 33;
                                return this.token(JspTokenId.SYMBOL);
                            }
                            this.input.backup(3);
                            this.lexerState = 0;
                            return this.token(JspTokenId.TEXT);
                        }
                        case 45: {
                            this.lexerState = 35;
                            break block0;
                        }
                        case 33: 
                        case 61: {
                            if (this.input.readLength() == 3) {
                                this.lexerStateJspScriptlet = n == 33 ? 2 : 3;
                                this.lexerState = 36;
                                return this.token(JspTokenId.SYMBOL2);
                            }
                            this.input.backup(3);
                            this.lexerState = 0;
                            return this.token(JspTokenId.TEXT);
                        }
                    }
                    if (this.input.readLength() == 3) {
                        this.lexerStateJspScriptlet = 1;
                        this.lexerState = 36;
                        this.input.backup(1);
                        return this.token(JspTokenId.SYMBOL2);
                    }
                    this.input.backup(3);
                    this.lexerState = 0;
                    return this.token(JspTokenId.TEXT);
                }
                case 36: {
                    CharSequence charSequence;
                    switch (n) {
                        case 37: {
                            this.lexerState = 37;
                            break block0;
                        }
                        case 60: {
                            charSequence = this.getPossibleTagName();
                            if (!"/jsp:scriptlet".equals(charSequence) && !"/jsp:declaration".equals(charSequence) && !"/jsp:expression".equals(charSequence)) break;
                            if (this.input.readLength() == 1) {
                                this.input.backup(1);
                                this.lexerState = 0;
                                break block0;
                            }
                            this.input.backup(1);
                            int n2 = this.lexerStateJspScriptlet;
                            this.lexerStateJspScriptlet = 0;
                            return this.scriptletToken(JspTokenId.SCRIPTLET, n2);
                        }
                    }
                    break;
                }
                case 37: {
                    switch (n) {
                        case 62: {
                            if (this.input.readLength() == 2) {
                                this.lexerState = 0;
                                this.lexerStateJspScriptlet = 0;
                                return this.token(JspTokenId.SYMBOL2);
                            }
                            this.input.backup(2);
                            this.lexerState = 36;
                            int n3 = this.lexerStateJspScriptlet;
                            this.lexerStateJspScriptlet = 0;
                            return this.scriptletToken(JspTokenId.SCRIPTLET, n3);
                        }
                    }
                    this.lexerState = 36;
                    break;
                }
                case 35: {
                    switch (n) {
                        case 45: {
                            if (this.input.readLength() == 4) {
                                this.lexerState = 25;
                                break;
                            }
                            this.input.backup(4);
                            this.lexerState = 0;
                            return this.token(JspTokenId.TEXT);
                        }
                        default: {
                            this.lexerState = 0;
                            return this.token(JspTokenId.TEXT);
                        }
                    }
                }
                case 25: {
                    switch (n) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.COMMENT);
                        }
                        case 45: {
                            this.lexerState = 26;
                        }
                    }
                    break;
                }
                case 26: {
                    switch (n) {
                        case 10: {
                            this.lexerState = 25;
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.COMMENT);
                        }
                        case 45: {
                            this.lexerState = 27;
                            break block0;
                        }
                    }
                    this.lexerState = 25;
                    break;
                }
                case 27: {
                    switch (n) {
                        case 10: {
                            this.lexerState = 25;
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.COMMENT);
                        }
                        case 37: {
                            this.lexerState = 28;
                            break block0;
                        }
                        case 45: {
                            this.lexerState = 27;
                            break block0;
                        }
                    }
                    this.lexerState = 25;
                    break;
                }
                case 28: {
                    switch (n) {
                        case 10: {
                            this.lexerState = 25;
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.COMMENT);
                        }
                        case 62: {
                            this.lexerState = 0;
                            return this.token(JspTokenId.COMMENT);
                        }
                    }
                    this.lexerState = 25;
                    break;
                }
                case 1: {
                    switch (n) {
                        case 10: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                        case 60: {
                            this.lexerState = 2;
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 30: {
                    switch (n) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                this.lexerState = 5;
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                        case 9: 
                        case 32: 
                        case 62: {
                            this.lexerState = 5;
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 31: {
                    switch (n) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                this.lexerState = 6;
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                        case 9: 
                        case 32: {
                            this.lexerState = 6;
                            if (this.input.readLength() <= 1) break;
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 32: {
                    switch (n) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                this.lexerState = 8;
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.ERROR);
                        }
                        case 62: {
                            this.input.backup(2);
                            this.lexerState = 8;
                            return this.token(JspTokenId.ERROR);
                        }
                    }
                    break;
                }
                case 33: {
                    if (Character.isLetter(n) || n == 95) {
                        this.lexerState = 4;
                        break;
                    }
                    switch (n) {
                        case 10: {
                            if (this.input.readLength() == 1) {
                                return this.token(JspTokenId.EOL);
                            }
                            this.input.backup(1);
                            return this.token(JspTokenId.SYMBOL);
                        }
                        case 9: 
                        case 32: {
                            break block0;
                        }
                        case 37: {
                            this.lexerState = 23;
                            break block0;
                        }
                    }
                    this.lexerState = 31;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(JspTokenId.SYMBOL);
                }
            }
        }
        this.input.backup(1);
        switch (this.lexerState) {
            case 0: 
            case 2: 
            case 34: 
            case 40: {
                if (this.input.readLength() == 0) {
                    return null;
                }
                return this.token(JspTokenId.TEXT);
            }
            case 1: 
            case 30: {
                this.lexerState = 0;
                return this.token(JspTokenId.ERROR);
            }
            case 31: 
            case 32: {
                this.lexerState = 0;
                return this.token(JspTokenId.ERROR);
            }
            case 12: 
            case 22: {
                this.lexerState = 0;
                return this.token(JspTokenId.SYMBOL);
            }
            case 13: 
            case 23: 
            case 24: 
            case 35: {
                this.lexerState = 0;
                return this.token(JspTokenId.SYMBOL);
            }
            case 3: 
            case 9: {
                this.lexerState = 0;
                return this.token(JspTokenId.TAG);
            }
            case 4: {
                this.lexerState = 0;
                return this.token(JspTokenId.TAG);
            }
            case 5: 
            case 7: {
                this.lexerState = 0;
                return this.token(JspTokenId.TAG);
            }
            case 6: 
            case 8: 
            case 33: {
                this.lexerState = 0;
                return this.token(JspTokenId.TAG);
            }
            case 10: {
                this.lexerState = 0;
                return this.token(JspTokenId.ATTRIBUTE);
            }
            case 11: {
                this.lexerState = 0;
                return this.token(JspTokenId.ATTRIBUTE);
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                this.lexerState = 0;
                return this.token(JspTokenId.ATTR_VALUE);
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                this.lexerState = 0;
                return this.token(JspTokenId.ATTR_VALUE);
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                this.lexerState = 0;
                return this.token(JspTokenId.COMMENT);
            }
            case 38: {
                this.lexerState = 0;
                return this.token(JspTokenId.TEXT);
            }
            case 39: {
                this.lexerState = 0;
                return this.token(JspTokenId.EL);
            }
            case 36: 
            case 37: {
                this.lexerState = 0;
                return this.scriptletToken(JspTokenId.SCRIPTLET, this.lexerStateJspScriptlet);
            }
        }
        return null;
    }

    private Token<JspTokenId> token(JspTokenId jspTokenId) {
        if (LOG) {
            this.checkToken(jspTokenId);
        }
        return this.tokenFactory.createToken((TokenId)jspTokenId);
    }

    private Token<JspTokenId> scriptletToken(JspTokenId jspTokenId, int n) {
        JspTokenId.JavaCodeType javaCodeType;
        if (LOG) {
            this.checkToken(jspTokenId);
        }
        switch (n) {
            case 1: 
            case 4: {
                javaCodeType = JspTokenId.JavaCodeType.SCRIPTLET;
                break;
            }
            case 2: 
            case 5: {
                javaCodeType = JspTokenId.JavaCodeType.DECLARATION;
                break;
            }
            case 3: 
            case 6: {
                javaCodeType = JspTokenId.JavaCodeType.EXPRESSION;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported scriptlet type " + this.lexerStateJspScriptlet);
            }
        }
        return this.tokenFactory.createPropertyToken((TokenId)jspTokenId, this.input.readLength(), (TokenPropertyProvider)new JspTokenPropertyProvider(javaCodeType), PartType.COMPLETE);
    }

    private void checkToken(JspTokenId jspTokenId) {
        if (this.input.readLength() == 0) {
            LOGGER.log(Level.INFO, "Found zero length token: ");
        }
        LOGGER.log(Level.INFO, "[" + this.getClass().getSimpleName() + "] token ('" + ((Object)this.input.readText()).toString() + "'; id=" + (Object)((Object)jspTokenId) + "; state=" + this.state() + ")\n");
    }

    public void release() {
    }

    private static class JspTokenPropertyProvider
    implements TokenPropertyProvider {
        private final JspTokenId.JavaCodeType scriptletType;

        JspTokenPropertyProvider(JspTokenId.JavaCodeType javaCodeType) {
            this.scriptletType = javaCodeType;
        }

        public Object getValue(Token token, Object object) {
            if ("JAVA_CODE_TYPE".equals(object)) {
                return this.scriptletType;
            }
            return null;
        }
    }
}

