/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.uml.core.support.IAssociatedProjectSourceRoots;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.ui.common.JavaSourceRootsUI;
import org.netbeans.modules.uml.project.ui.common.ReferencedJavaProjectModel;
import org.netbeans.modules.uml.project.ui.customizer.UMLProjectProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class AssociatedSourceProvider
implements IAssociatedProjectSourceRoots {
    private UMLProject umlProj;
    private UMLProjectHelper mHelper;
    private PropertyEvaluator mEval;

    public AssociatedSourceProvider(UMLProject uMLProject, UMLProjectHelper uMLProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.umlProj = uMLProject;
        this.mHelper = uMLProjectHelper;
        this.mEval = propertyEvaluator;
    }

    public boolean hasAssociatedSourceProject() {
        UMLProjectProperties uMLProjectProperties = this.umlProj.getUMLProjectProperties();
        return uMLProjectProperties.referencedJavaProjectModel.getRefStatus() == ReferencedJavaProjectModel.ReferenceStatus.REF_STATUS_UNSET;
    }

    public Project getAssociatedSourceProject() {
        if (this.hasAssociatedSourceProject()) {
            return null;
        }
        UMLProjectProperties uMLProjectProperties = this.umlProj.getUMLProjectProperties();
        Project project = uMLProjectProperties.referencedJavaProjectModel.getProject();
        if (project == null) {
            return project;
        }
        return project;
    }

    public Project getCodeGenTargetProject() {
        FileObject fileObject;
        UMLProjectProperties uMLProjectProperties = this.umlProj.getUMLProjectProperties();
        String string = uMLProjectProperties.getCodeGenFolderLocation();
        if (string == null) {
            return null;
        }
        try {
            fileObject = FileUtil.toFileObject((File)new File(new File(string).getCanonicalPath()));
        }
        catch (IOException iOException) {
            return null;
        }
        if (fileObject != null) {
            return FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return null;
    }

    public File[] getCompileDependencies() {
        File[] fileArray = null;
        Project project = this.getAssociatedSourceProject();
        if (project != null) {
            SourceGroup[] sourceGroupArray = this.getSourceGroups();
            fileArray = new File[sourceGroupArray.length];
            int n = 0;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject = sourceGroup.getRootFolder();
                fileArray[n] = FileUtil.toFile((FileObject)fileObject);
                ++n;
            }
        }
        return fileArray;
    }

    public SourceGroup[] getSourceGroups() {
        if (this.hasAssociatedSourceProject()) {
            return null;
        }
        UMLProjectProperties uMLProjectProperties = this.umlProj.getUMLProjectProperties();
        JavaSourceRootsUI.JavaSourceRootsModel javaSourceRootsModel = uMLProjectProperties.referencedJavaSourceRootsModel;
        if (javaSourceRootsModel != null) {
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            for (int i = 0; i < javaSourceRootsModel.getRowCount(); ++i) {
                Boolean bl = (Boolean)javaSourceRootsModel.getValueAt(i, 0);
                if (bl == null || !bl.booleanValue()) continue;
                SourceGroup sourceGroup = javaSourceRootsModel.getSourceGroup(i);
                arrayList.add(sourceGroup);
            }
            return arrayList.toArray(new SourceGroup[arrayList.size()]);
        }
        return new SourceGroup[0];
    }

    public String createAbsolutePath(String string) {
        String string2;
        SourceGroup sourceGroup;
        int n;
        String string3 = "";
        if (string.charAt(0) == '{' && (n = string.lastIndexOf(125)) > 0 && (sourceGroup = this.getSourceGroupByID(string2 = string.substring(1, n))) != null) {
            string3 = this.getGroupRootPath(sourceGroup) + string.substring(n + 1);
            string3 = string3.replace("\\", "/");
        }
        return string3;
    }

    public String createRelativePath(String string) {
        String string2 = "";
        String string3 = string.replace("\\", "/");
        SourceGroup sourceGroup = this.getSourceGroupForFile(string3);
        if (sourceGroup != null) {
            String string4 = this.getGroupRootPath(sourceGroup);
            String string5 = this.annotateAsIdentifier(sourceGroup.getName());
            string4 = string4.replace("\\", "/");
            string2 = string3.replace(string4, string5);
        }
        return string2;
    }

    public String getSourceRootId(String string) {
        String string2 = "";
        SourceGroup sourceGroup = this.getSourceGroupForFile(string);
        if (sourceGroup != null) {
            string2 = sourceGroup.getName();
        }
        return string2;
    }

    protected String getGroupRootPath(SourceGroup sourceGroup) {
        String string = "";
        FileObject fileObject = sourceGroup.getRootFolder();
        if (fileObject != null) {
            string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        }
        return string;
    }

    protected SourceGroup getSourceGroupForFile(String string) {
        SourceGroup[] sourceGroupArray;
        SourceGroup sourceGroup = null;
        if (string != null && string.length() > 0 && (sourceGroupArray = this.getSourceGroups()) != null) {
            for (SourceGroup sourceGroup2 : sourceGroupArray) {
                if (sourceGroup2 == null) continue;
                FileObject fileObject = sourceGroup2.getRootFolder();
                try {
                    if (fileObject.getFileSystem().findResource(string) == null) continue;
                    sourceGroup = sourceGroup2;
                    break;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Log.stackTrace((Throwable)fileStateInvalidException);
                }
            }
        }
        return sourceGroup;
    }

    protected SourceGroup getSourceGroupByID(String string) {
        SourceGroup[] sourceGroupArray;
        SourceGroup sourceGroup = null;
        if (string != null && string.length() > 0 && (sourceGroupArray = this.getSourceGroups()) != null) {
            for (SourceGroup sourceGroup2 : sourceGroupArray) {
                if (sourceGroup2 == null || !string.equals(sourceGroup2.getName())) continue;
                sourceGroup = sourceGroup2;
                break;
            }
        }
        return sourceGroup;
    }

    protected String annotateAsIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

